
// File ACCESS.BPL

// Routines to check access protection to files

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "FILEHD.BPL"

LET FINDCLASS(BUFFER) = VALOF
$( LET USER = CUPROC!PD.USERID
   LET CLASS = USER = BUFFER!FDB.OWNER -> 0, 1

   FOR I = PROTECTIONDEFINITIONS TO DISCBLOCK.SIZE BY 2 DO
      UNLESS BUFFER!I = 0 DO
         IF BUFFER!I = USER THEN CLASS := BUFFER!(I + 1)
   RESULTIS CLASS * 3
$)

AND CHECKPROTECTION(BUF, MODE) = VALOF
$( IF PRIVILEGED(FILEPRIV) RESULTIS TRUE
   $( LET CLASS = FINDCLASS(BUF)
      IF (CLASS = 0) & (MODE = MODE.CHANGEPROT) RESULTIS TRUE
      RESULTIS (((BUF!FDB.PROT) >> CLASS) & 7) GE MODE
   $)
$)

AND CREATEABILITY() = VALOF
$( IF PRIVILEGED(FILEPRIV) RESULTIS TRUE
   $( LET CLASS = FINDCLASS(DISCBUFFER1)
      RESULTIS ((DISCBUFFER1!FDB.CRPROT) >> CLASS) & 7
   $)
$)

// End of file ACCESS.BPL

