
// File CNEWPD.BPL

// Segment 1

GET "SYSHDM.BPL"
GET "STATUS.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "ERRCOD.BPL"
GET "SCBDDB.BPL"
GET "DEVCAP.BPL"

MANIFEST $(
LOGINID                 = 2              // ID number during login
LOGIN.PRIORITY          = 50             // Low priority during login
BATMODE                 = M.TWOWAY << 9  // Mode for a background stream
$)

STATIC $( SLOT = 0 $)

LET CONSTRUCTPD(STARTADDRESS, SCB, USERID) = VALOF
$( P(LV JOBTABLEMUTEX, ST.MUT)

   SLOT := -1
   FOR I = 0 TO JOBSLOTS DO
      IF JOBTABLE!I = 0 DO
      $( SLOT := I
         BREAK
      $)

   IF SLOT = -1 THEN
   $( V(LV JOBTABLEMUTEX)
      RESULTIS ERR.NJS
   $)

   $( LET S = NEWVEC(NO.OF.STREAMS)
      AND T = NEWVEC(STACK.SIZE)

      NEWPD := NEWVEC(LONG.PD)

      IF NEWPD = 0 \/ S = 0 \/ T = 0 DO
      $( FREE(NEWPD)
         FREE(S)
         FREE(T)
         V(LV JOBTABLEMUTEX)
         RESULTIS ERR.MFS
      $)

      NEWPD!PD.STREAMS, NEWPD!PD.STACK := S, T
      NEWPD!PD.USERID, NEWPD!PD.PRIO := USERID, LOGIN.PRIORITY
      NEWPD!PD.PARENT := CUPROC
      SCAN.SUB.CHAIN(CUPROC, 0, NEWPD)

      NEWPD!PD.MONSTREAM := SCB
      NEWPD!PD.JBSLOT := SLOT

      SET.UP.ENV(NEWPD, STARTADDRESS)
      RESULTIS 0
   $)
$)

AND CLEANUP(PD) BE
$( LET PARENT = PD!PD.PARENT
   AND SLOT = PD!PD.JBSLOT

   SCAN.SUB.CHAIN(PARENT, PD, PD!PD.BROTHER)
   FREE(PD!PD.STREAMS)
   FREE(PD!PD.MONSTREAM)

   UNTIL PD!PD.DAB = 0 DO
      DEASSIGNDEVICE((PD!PD.DAB)!DAB.LNAME, PD)

   FLUSH(PARENT, SLOT)

   $( LET A = PARENT!PD.CHILD
      UNTIL A = 0 DO
      $( FLUSH(A, SLOT)
         A := A!PD.BROTHER
      $)
   $)

   FREE(PD!PD.STACK)
   FREE(PD)
$)

 .

// Segment 2

GET "SYSHDM.BPL"
GET "STATUS.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "ERRCOD.BPL"
GET "SCBDDB.BPL"
GET "DEVCAP.BPL"

LET CREATEJOB(DEVNO) BE
$( LET S = NEWVEC(SCB.SIZE)
   IF S = 0 RESULTIS ERR.MFS
   $( LET R = CONSTRUCTPD(COMMAND.DECODER, S, LOGINID)
      TEST R = 0 THEN
      $( IF ASSIGNDEVICE(DNAME("TTY", DEVNO), 0, NEWPD) DO
         $( CLEANUP(NEWPD)
            V(LV JOBTABLEMUTEX)
            RESULTIS ERR.MFS
         $)

         S!SCB.DDB := (NEWPD!PD.DAB)!DAB.DDB
         S!SCB.DEVNO := DEVNO
         S!SCB.MODE := M.TWOWAY << 9
         S!SCB.READ, S!SCB.WRITE := TTYREAD, TTYWRITE
         RUNPROCESS()
      $)
      OR FREE(S)
      RESULTIS R
   $)
$)

AND BACKLOG(STREAM, USERID) = VALOF
$( LET STR = (CUPROC!PD.STREAMS) + STREAM
   LET S = !STR

   UNLESS CUPROC!PD.USERID = USERID DO
      UNLESS PRIVILEGED(BATPRIV) DO OVJOB.ERROR(2)

   IF S = 0 RESULTIS ERROR.IBS

   UNLESS (S!SCB.MODE = BATMODE) &
          ((S!SCB.DDB)!DDB.CAP & CAP.BATCH) DO
          RESULTIS ERR.IBS

   $( LET R = CONSTRUCTPD(BACKGROUND.START, S, USERID)
      IF R = 0 THEN
      $( R := -SLOT
         S!SCB.READ := BACKREAD
         !STR := 0
         NEWPD!PD.PRIV := INHPASS + TEMPORARY.PRIVILEGES
         RUNPROCESS()
      $)
      RESULTIS R
   $)
$)

AND SCAN.SUB.CHAIN(PD, VALUE, NEWVALUE) BE
$( LET A = PD + PD.CHILD
   UNTIL !A = VALUE DO A := !A + PD.BROTHER
   !A := NEWVALUE
$)

// End of file CNEWPD.BPL

