
// File COMFN1.BPL

// Monitor command functions -- part 1

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "STATUS.BPL"
GET "SYSHDG.BPL"
GET "ERRCOD.BPL"
GET "SCBDDB.BPL"

LET LOG(STREAM, CHAR) BE
$( UNLESS (CUPROC!PD.PRIV & LOGGEDIN) = 0 DO
   $( PRINT(STREAM, "Already logged in as job :N*C*L", CUSLOT)
      RETURN
   $)

   SKIP(STREAM, CHAR)
   CUPROC!PD.PRIV := TEMPORARY.PRIVILEGES
   RUNSYSPROG("LOGIN")
$)

AND CLOSER(STREAM, CHAR) BE
$( SKIP(STREAM, CHAR)
   CLOSE()
$)

AND RESETER(STREAM, CHAR) BE
$( SKIP(STREAM, CHAR)
   RESET()
$)

AND ASSIGN(STREAM, CHAR) BE
$( LET S = VEC 10
   AND NAME = READDEVICENAME(STREAM, LV CHAR)
   LET LOGNAME = CHAR = '*$' \/ CHAR = '*L' -> 0,
                          READDEVICENAME(STREAM, LV CHAR)

   SKIP(STREAM, CHAR)

   $( LET R = OVCALLER(ASSIGNDEVICE, 2, NAME, LOGNAME, CUPROC)
      UNLESS R = 0 DO
      $( COMMAND.ERROR(R)
         EXIT(0)
      $)
      PRINT(STREAM, ":S assigned*C*L", STRING(NAME, S))
   $)
$)

AND DEASSIGN(STREAM, CHAR) BE
$( LET NAME = READDEVICENAME(STREAM, LV CHAR)
   SKIP(STREAM, CHAR)
   OVERLAY.CALL(DEASSIGNDEVICE, 2, NAME, CUPROC)
$)

// End of file COMFN1.BPL

