
// File COMFN2.BPL

// Monitor command functions -- part 2

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "STATUS.BPL"
GET "SCBDDB.BPL"

LET RUNPROG(STREAM, CHAR, PROG) BE
$( SKIP(STREAM, CHAR)
   RUNSYSPROG(PROG)
$)

AND SYSTATUS(STREAM, CHAR) BE
   RUNPROG(STREAM, CHAR, "SYSTAT")

AND RUNEDITOR(STREAM, CHAR) BE
   RUNPROG(STREAM, CHAR, "EDITOR")

AND KJOB(STREAM, CHAR) BE
$( SKIP(STREAM, CHAR)
   RUNKJOB(0)
$)

AND AUTOLOGOUT() BE RUNKJOB(1)

AND BACKFAIL() BE RUNKJOB(2)

AND RUNKJOB(N) BE
$( CUPROC!PD.STATUS := ST.TRAPINH
   CUPROC!PD.PRIV := CUPROC!PD.PRIV \/ TEMPORARY.PRIVILEGES
   RUNSYSPROG("KJOB", N)
$)

AND SCANCHAIN(STREAM) = VALOF
$( LET S = VEC 10
   AND FIRST = TRUE
   AND CHAIN = SINGLEACCESSDEVICES

   UNTIL CHAIN = 0 DO
   $( UNLESS CHAIN!DDB.ASSIGN = 0 DO
      $( UNLESS FIRST DO WRITECH(STREAM, ',')
         WRITES(STREAM, STRING(CHAIN!DDB.NAME, S))
         FIRST := FALSE
      $)
      CHAIN := !CHAIN
   $)
   RESULTIS FIRST
$)

AND SHUTDOWN(STREAM, CHAR) BE
   COMMUNICATE(SYSTEM.PD, 0, -2, C.SHUTDOWN)

AND STREAM.STATUS(STREAM, CHAR) BE
$( LET STREAMVEC = CUPROC!PD.STREAM
   AND ACTIVE = TRUE

   FOR I = 0 TO NO.OF.STREAMS DO
      UNLESS STREAMVEC!I = 0 DO
      $( IF ACTIVE THEN
            PRINT(-1, "*C*LStream*TDevice*TMode*C*L*C*L")
         ACTIVE := FALSE
         STREAM.STATE(STREAMVEC!I, I)
      $)
   IF ACTIVE PRINT(-1, "*C*LNo active streams*C*L")

   PRINT(-1, "*C*LControl stream")
   STREAMSTATE(CUPROC!PD.MONSTREAM, -1)
   SKIP(STREAM, CHAR)
$)

AND STREAMSTATE(SCB, NO) BE
$( LET T = VEC 10
   AND D = SCB!SCB.DDB
   AND M = VALOF
   $( SWITCHON (SCB!SCB.MODE) >> 9 INTO
      $( CASE M.INPUT:    RESULTIS "Input"
         CASE M.OUTPUT:   RESULTIS "Output"
         CASE M.TWOWAY:   RESULTIS "Two-way"

         DEFAULT:         RESULTIS "Syserr"
      $)
   $)

   PRINT(-1, NO < 0 ->
         "*C*L:G:S*T:N  :S*C*L",
         ":N*T:S*T:N  :S*C*L",
         NO, STRING(D!DDB.NAME, T), SCB!SCB.MODE & #777, M)
$)

AND DEVICES(STREAM, CHAR) BE
$( LET CHAIN = CUPROC!PD.DAB
   AND T = VEC 10

   SKIP(STREAM, CHAR)
   IF CHAIN = 0 RETURN
   WRITES(STREAM, "*C*LDevice*TLogical*C*L")

   $( WRITES(STREAM, STRING(CHAIN!DDB.NAME, T))
      UNLESS CHAIN!DAB.LNAME = CHAIN!DAB.NAME DO
         PRINT(STREAM, "*T:S", STRING(CHAIN!DAB.LNAME, T))
      WRITES(STREAM, "*C*L")
      CHAIN := !CHAIN
   $) REPEATUNTIL CHAIN = 0
$)

AND APPLY.TO.PROCESS(STREAM, FN) BE
$( LET C = 0
   LET SLOT = READNUMBER(10, STREAM, LV C)
   SKIP(STREAM, C)
   FN(SLOT)
$)

AND REMOVER(STREAM, CHAR) BE
   APPLY.TO.PROCESS(STREAM, REMOVE)

AND SUSPENDER(STREAM, CHAR) BE
   APPLY.TO.PROCESS(STREAM, SUSPENDANDWAIT)

AND RESUMER(STREAM, CHAR) BE
   APPLY.TO.PROCESS(STREAM, RESUME)

AND CORE(STREAM, CHAR) BE
$( TEST CHAR = '*L' \/ CHAR = '*$' THEN
      PRINT(STREAM, ":NK core, Maxcore = :NK*C*L",
               GETCORE(), MAXCORE)
   OR
   $( LET NEWSIZE = READNUMBER(10, STREAM, LV CHAR)
      COMMAND.ERROR(CHANGECORE(NEWSIZE))
   $)
   SKIP(STREAM, CHAR)
$)

// End of file COMFN2.BPL

