
// File CONTRL.BPL

// Process control segment

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "STATUS.BPL"
GET "SCBDDB.BPL"

MANIFEST $( ST.SUSPEND = ST.STOPME + ST.TOPLEVEL $)

LET FINDPROCESS(SLOT) = VALOF
$( UNLESS 0 LE SLOT LE JOBSLOTS DO JOB.ERROR(13)
   $( LET A = CUPROC!PD.CHILD
      UNTIL A = 0 DO
      $( IF A!PD.JBSLOT = SLOT RESULTIS A
         A := A!PD.BROTHER
      $)
      JOB.ERROR(11)
   $)
$)

AND COMMUNICATE(RECEIVER, LINK, SENDER, TYPE, VAL1, VAL2) = VALOF
$( LOCK()
   $( LET A = RECEIVER + PD.COMM
      UNTIL !A = 0 DO A := !A
      !A := LV LINK
      UNLOCK()
      SEMAPHORE(CUPROC + PD.REPLYSEM, 0)
      CUPROC!PD.REPLY := RECEIVER
      VP(RECEIVER + PD.COMMSEM, CUPROC + PD.REPLYSEM, ST.CWT)
      RESULTIS CUPROC!PD.REPLY
   $)
$)

AND SEND.BLOCK(SLOT, VAL1, VAL2) = VALOF
$( LET PD = VALOF
   $( LET THIS.PD = (CUPROC!PD.PARENT)!PD.CHILD
      IF SLOT = -1 RESULTIS CUPROC!PD.PARENT
      UNTIL THIS.PD = 0 DO
      $( UNLESS THIS.PD = CUPROC DO
            IF THIS.PD!PD.JBSLOT = SLOT DO
               RESULTIS THIS.PD
         THIS.PD := THIS.PD!PD.BROTHER
      $)
      JOB.ERROR(14)
   $)
   RESULTIS COMMUNICATE(PD, 0, CUSLOT, C.COMM, VAL1, VAL2)
$)

AND COMMUNICATE.REPLY(RECEIVER, VALUE) BE
$( UNLESS RECEIVER!PD.REPLY = CUPROC DO JOB.ERROR(12)
   RECEIVER!PD.REPLY := VALUE
   V(RECEIVER + PD.REPLYSEM)
$)

AND REPLY(SLOT, VALUE) BE
   COMMUNICATE.REPLY(FINDPROCESS(SLOT), VALUE)

AND COPYBLOCK(B) BE
$( LOCK()
   $( LET R = CUPROC!PD.COMM
      LET S = R + 1
      CUPROC!PD.COMM := !R
      UNLOCK()
      FOR I = 0 TO 3 DO B!I := S!I
      DISPOSE(R)
   $)
$)

AND DISPOSE(B) BE
$( SWITCHON B!2 INTO
   $( CASE C.LOGIN:
      $( LOCK()
         !END.LOGIN.CHAIN := B
         END.LOGIN.CHAIN := B
         UNLOCK()
         ENDCASE
      $)

      CASE C.LOGGEDOUT:
         FREE(B)
   $)
$)

AND WAIT.BLOCK(B) BE
$( IDWP(CUPROC + PD.COMMSEM, ST.STP)
   COPYBLOCK(B)
$)

AND BLOCK.AVAILABLE(B) = VALOF
$( LET R = CP(CUPROC + PD.COMMSEM)
   IF R THEN COPYBLOCK(B)
   RESULTIS R
$)

AND STOP.PROCESS(PD, NEWSTATUS) BE
$( LOCK()
   PD!PD.STATUS := PD!PD.STATUS \/ NEWSTATUS
   PD!PD.SCOUNT := PD!PD.SCOUNT + 1
   UNLESS PD!PD.IDWSEM = 0 DO CV(PD!PD.IDWSEM)
   UNLOCK()
$)

AND STOPME() BE
$( LET A = CUPROC!PD.CHILD
   UNTIL A = 0 DO
   $( STOP.PROCESS(A, ST.STOPME)
      P(A + PD.STOP, ST.STP)
      A := A!PD.BROTHER
   $)

   TEST (CUPROC!PD.STATUS & ST.TOPLEVEL) = ST.TOPLEVEL THEN
      COMMUNICATE(CUPROC!PD.PARENT, 0, CUSLOT, C.STOPPED)
   OR VP(CUPROC + PD.STOP, CUPROC + PD.STOP, ST.STP)
$)

AND SUSPEND(SLOT) BE
   STOP.PROCESS(FINDPROCESS(SLOT), ST.SUSPEND)

AND SUSPENDANDWAIT(SLOT) BE
$( LET PD = FINDPROCESS(SLOT)
   STOP.PROCESS(PD, ST.STOPME)
   P(PD + PD.STOP, ST.STP)
$)

AND START.PROCESS(PD) BE
$( LET A = PD!PD.CHILD
   UNTIL A = 0 DO
   $( START.PROCESS(A)
      A := A!PD.BROTHER
   $)
   LOCK()
   PD!PD.STATUS := PD!PD.STATUS & NOT ST.SUSPEND
   PD!PD.SCOUNT := PD!PD.SCOUNT - 1
   IF PD!PD.SCOUNT = 0 DO V(PD + PD.STOP)
   UNLOCK()
$)

AND RESUME(SLOT) BE START.PROCESS(FINDPROCESS(SLOT))

AND REMOVE(SLOT) BE
$( SUSPENDANDWAIT(SLOT)
   REMOVE.PD(FINDPROCESS(SLOT))
$)

AND REMOVE.PD(PD) BE
$( LET A = PD!PD.CHILD

   UNTIL A = 0 DO
   $( REMOVE.PD(A)
      A := PD!PD.BROTHER
   $)

   P(LV JOBTABLEMUTEX, ST.MUT)
   JOBTABLE!(PD!PD.JBSLOT) := 0
   PROCESSES := PROCESSES - 1
   V(LV JOBTABLEMUTEX)

   $( LET STR = PD!PD.STREAMS
      AND S = PD!PD.MONSTREAM
      FOR I = 0 TO NO.OF.STREAMS DO
      $( LET SCB = STR!I
         UNLESS SCB = 0 DO
         $( [(SCB!SCB.DDB)!DDB.LOSE](SCB)
            FREE(SCB)
            STR!I := 0
         $)
      $)
      [(S!SCB.DDB)!DDB.CLOSE](S)
   $)
   OVERLAY.CALL(CLEANUP, 2, PD)
$)

AND FLUSH(PD, SLOT) BE
$( LOCK()
   $( LET R = PD + PD.COMM
      UNTIL !R = 0 DO
      $( LET C = !R
         IF C!1 = SLOT DO
         $( !R := !C
            R := !C
            P(PD + PD.COMMSEM, 0)
            DISPOSE(C)
            LOCK()
            LOOP
         $)
         R := C
      $)
   $)
   UNLOCK()
$)

// End of file CONTRL.BPL

