
// File CRTUFD.BPL

// Filing system -- function to create a UFD

GET "SYSHDM.BPL"
GET "STATUS.BPL"
GET "SYSHDG.BPL"
GET "ERRCOD.BPL"
GET "FILEHD.BPL"
GET "PDMAN.BPL"

LET CREATEUFD(USERID, QUOTA) = VALOF
$( LET R = NEWVEC(DISCBLOCK.SIZE)

   IF R = 0 DO RESULTIS 0

   $( LET S = GETBLOCK()
      AND T = GETBLOCK()
      AND NOW = TIME()

      IF S = 0 \/ T = 0 DO
      $( FREE(R)
         RESULTIS 0
      $)

      R!UFD.FILE1, R!UFD.FILE2, R!UFD.FILE3 := DIRECT1, DIRECT2, DIRECT3
      R!UFD.FDB := T
      DISC.WRITE(S, R)

      R!FDB.MARKER, R!FDB.OWNER := MARKER.UFD, USERID
      R!FDB.FILE1, R!FDB.FILE2, R!FDB.FILE3 := DIRECT1, DIRECT2, DIRECT3
      R!FDB.LENGTH := 1
      R!FDB.PROT := DEFAULT.UFDPROT
      R!FDB.CRPROT := DEFAULT.CREATEPROT

      R!FDB.START, R!FDB.END := S, S
      R!FDB.WCOUNT := DISCBLOCK.WORDS

      R!FDB.DCREATE, R!FDB.DACCESS := DATE, DATE
      R!FDB.TCREATE, R!FDB.TACCESS := NOW, NOW

      R!FDB.QUOTA := QUOTA

      DISC.WRITE(T, R)
      FREE(R)

      RESULTIS T
   $)
$)

AND KILLUFD(USERID) BE
$( UNLESS USERID = CUPROC!PD.USERID DO
      UNLESS PRIVILEGED(FILEPRIV) DO OVJOB.ERROR(2)

   P(LV DISCBUFFER1.USE, ST.CBW)
   $( LET R = SEARCHMFD(USERID)
      UNLESS R = 0 DO
      $( R!MFD.UFD = 0
         WRITE.FROM.BUFFER1(CUDIRBLK)
      $)
      V(LV DISCBUFFER1.USE)
   $)
$)

AND EXTENDMFD() = VALOF
$( LET R = GETBLOCK()
   UNLESS R = 0 DO
   $( CHAIN(ENDMFDBLK, R)

      READ.TO.BUFFER1(0)
      ENDMFDBLK, DISCBUFFER1!6 := R, R
      WRITE.FROM.BUFFER1(0)
   $)
   RESULTIS R
$)

AND FINDFREEMFDENTRY() = VALOF
$( CUDIRBLK := MFDBLK
   UNTIL CUDIRBLK = 0 DO
   $( READ.TO.BUFFER1(CUDIRBLK)
      FOR I = 0 TO DISCBLOCK.SIZE BY 4 DO
         IF DISCBUFFER1!I = 0 DO
            RESULTIS DISCBUFFER1 + I
      CUDIRBLK := MAP(CUDIRBLK)
   $)

   CUDIRBLK := EXTENDMFD()

   FOR I = 0 TO DISCBLOCK.SIZE DO DISCBUFFER1!I := 0

   RESULTIS DISCBUFFER1
$)

AND ADDNEWUSER(ADDBLOCK) = VALOF
$( LET USERID = ADDBLOCK!0
   AND QUOTA = ADDBLOCK!1
   AND PASSWD = ADDBLOCK!2
   AND PRIVILEGES = ADDBLOCK!3

   UNLESS PRIVILEGED(FILEPRIV) DO OVJOB.ERROR(2)
   P(LV DISCBUFFER1.USE, ST.CBW)

   $( LET R = SEARCHMFD(USERID)
      LET RES = VALOF
      $( TEST R = 0 THEN
         $( LET POS = FINDFREEMFDENTRY()
            IF CUDIRBLK = 0 RESULTIS ERR.DKF

            POS!0, POS!1, POS!2 := USERID, ENCODE(PASSWD), PRIVILEGES

            POS!3 := CREATEUFD(USERID, QUOTA)

            WRITE.FROM.BUFFER1(CUDIRBLK)

            RESULTIS POS!3 = 0 -> ERR.NUF, 0
         $)
         OR
            $( LET FDB = R!MFD.UFD
            UNLESS PASSWD = 0 DO
               R!MFD.PASSWD = ENCODE(PASSWD)
            R!MFD.PRIV := PRIVILEGES
            WRITE.FROM.BUFFER1(CUDIRBLK)
            UNLESS FDB = 0 DO
            $( READ.TO.BUFFER1(FDB)
               DISCBUFFER1!FDB.QUOTA := QUOTA
               DISCBUFFER1!FDB.DACCESS := DATE
               DISCBUFFER1!FDB.TACCESS := TIME()
               WRITE.FROM.BUFFER1(FDB)
            $)
            RESULTIS 0
         $)
      $)
      V(LV DISCBUFFER1.USE)
      RESULTIS RES
   $)
$)

// End of file CRTUFD.BPL

