
// File DAYTIM.BPL

// Code to set up date and time -- in overlay 1

GET "SYSHDG.BPL"
GET "PDMAN.BPL"
GET "SYSHDM.BPL"

MANIFEST $(
JANUARY   =  1;  FEBRUARY  =  2;  MARCH     =  3
APRIL     =  4;  MAY       =  5;  JUNE      =  6
JULY      =  7;  AUGUST    =  8;  SEPTEMBER =  9
OCTOBER   = 10;  NOVEMBER  = 11;  DECEMBER  = 12
$)

STATIC $(
TERM            = 0
STREAM0         = 0
DAYSINMONTH     = 31
FFACTOR         = 0
DAY             = 0
MONTH           = 0
YEAR            = 0
LEAPYEAR        = 0
READOK          = 0
$)

LET READN() = READNUMBER(10, STREAM0, LV TERM)

AND READDATE() BE
$( DAY := READN()
   IF TERM = '/' THEN
   $( MONTH := READN()
      IF TERM = '/' THEN
      $( YEAR := READN() REM 1900
         DATE := ((((YEAR - 50) << 4) + MONTH) << 5) + DAY
         LEAPYEAR := (YEAR & 3) = 0
         READOK := TRUE
      $)
   $)
$)

AND READTIME() BE
$( SEC, HOUR := 0, READN()
   IF 0 LE HOUR LE 23 & TERM = ':' DO
   $( MIN := READN()
      IF 0 LE MIN LE 59 DO READOK := TRUE
   $)
$)

AND REQUEST(S, F) BE
$( READOK := FALSE
   PRINT(STREAM0, "*C*L:S ", S)
   F()
   SKIP(STREAM0, TERM)
$) REPEATUNTIL READOK

AND READSTATE(ADDRESS, STR) BE
$( PRINT(STREAM0, "*C*L:S=", STR)
   !ADDRESS := READN()
   SKIP(STREAM0, TERM)
$)

AND SETDATEANDTIME() BE
$( STREAM0 := (CUPROC!PD.STREAMS)!0

   REQUEST("date", READDATE)
      REPEATUNTIL FINDDAYOFWEEK()

   REQUEST("time", READTIME)

   READSTATE(LV BUFFERCONSTANT, "buffers")

   READSTATE(LV MAXCORE, "cormax")
      REPEATUNTIL 0 < MAXCORE <= COREMAPSIZE

   READSTATE(LV ERROR.TRAP, "errortrap")

   IDLETIME := 0
   CLOSE.STREAM(0)
$)

AND FINDDAYOFWEEK() = VALOF
$( SWITCHON MONTH INTO
   $( CASE JANUARY:
         IF LEAPYEAR THEN FFACTOR := 6
         ENDCASE

      CASE FEBRUARY:
         DAYSINMONTH := (LEAPYEAR -> 29, 28)
         FFACTOR := (LEAPYEAR -> 2, 3)
         ENDCASE

      CASE MARCH:
         FFACTOR := 3
         ENDCASE

      CASE APRIL:
         DAYSINMONTH, FFACTOR := 30, 6
         ENDCASE

      CASE MAY:
         FFACTOR := 1
         ENDCASE

      CASE JUNE:
         DAYSINMONTH, FFACTOR := 30, 4
         ENDCASE

      CASE JULY:
         FFACTOR := 6
         ENDCASE

      CASE AUGUST:
         FFACTOR := 2
         ENDCASE

      CASE SEPTEMBER:
         DAYSINMONTH, FFACTOR := 30, 5
         ENDCASE

      CASE OCTOBER:
         ENDCASE

      CASE NOVEMBER:
         DAYSINMONTH, FFACTOR := 30, 3
         ENDCASE

      CASE DECEMBER:
         FFACTOR := 5
         ENDCASE

      DEFAULT:
         RESULTIS FALSE
   $)

   UNLESS 1 <= DAY <= DAYSINMONTH DO RESULTIS FALSE
   DAYOFWEEK := (YEAR + YEAR/4 + DAY + FFACTOR) REM 7
   RESULTIS TRUE
$)

// End of file DAYTIM.BPL

