
// File DECLIO.BPL

// Routines to declare system devices -- in overlay 1

GET "SYSHDM.BPL"
GET "SYSHDG.BPL"
GET "SCBDDB.BPL"
GET "DEVCAP.BPL"

MANIFEST $(  // Particular device capability bits
TTYBITS = CAP.INPUT + CAP.OUTPUT + CAP.MODE0 + CAP.BATCH
DSKBITS = CAP.INPUT + CAP.OUTPUT + CAP.STRUC + CAP.MODE0 +
          CAP.MODE1 + CAP.BATCH
NULLBITS= CAP.INPUT + CAP.OUTPUT + CAP.MODE0 + CAP.MODE1
CTLBITS = CAP.INPUT + CAP.OUTPUT + CAP.MODE0 + CAP.CTLDEV
$)

MANIFEST $(
SHAREABLE      = 10000
SINGLEACCESS   = 1
$)

LET IODEVICE(DDB.SIZE, DEVNAME, DEVNO, CAPABILITIES, READER, WRITER, OPEN,
             CLOSE, LOSE, ASSIGNFN, DEVDEP, ASSIGNSEM, FILEOPEN, DELETE,
             RENAME, DIRFN, OVNO, FCBCHN) BE
$( LET SIZE = DDB.SIZE -> LONG.DDB, SHORT.DDB
   AND Q = LV DDB.SIZE
   LET R = GETVEC(SIZE)
   FOR I = 1 TO SIZE DO R!I := Q!I
   SEMAPHORE(R + DDB.ASSIGN, ASSIGNSEM)

   TEST ASSIGNSEM = SHAREABLE THEN
   $( !R := SHAREABLEDEVICES
      SHAREABLEDEVICES := R
   $)
   OR
   $( !R := SINGLEACCESSDEVICES
      SINGLEACCESSDEVICES := R
   $)
$)

AND IOSYSTEM() BE
$( READ.TO.BUFFER1(1)
   FOR I = 0 TO NO.OF.OVERLAYS DO
      OVERLAY.TABLE!I := DISCBUFFER1!I

   SHAREABLEDEVICES, SINGLEACCESSDEVICES := 0, 0

   IODEVICE(FALSE, LNAME("CTL"), 0, CTLBITS, 0, 0, CTLOPEN, NULL, NULL,
            NULL, 0, SHAREABLE)

   FOR I = 0 TO NO.OF.TTYS DO
      IODEVICE(FALSE, DNAME("TTY", I), I, TTYBITS, TTYREAD, TTYWRITE, NULL,
               NULL, NULL, TTYASSIGN, NULL, SINGLEACCESS)

   IODEVICE(FALSE, LNAME("NULL"), 0, NULLBITS, EOF, NULL, NULL, NULL, NULL,
            NULL, NULL, SHAREABLE)

   IODEVICE(TRUE, LNAME("DSK"), 0, DSKBITS, DSKREAD, DSKWRITE, DSKOPEN,
            DSKCLOSE, DSKLOSE, NULL, DSKDEP, SHAREABLE, DSKFILEOPEN, DSKDELETE,
            DSKRENAME, DSKDIRFN, 3, 0)

   // Add further devices here

$)

AND GETVEC(S) = VALOF
$( LET R = NEWVEC(S - 1)
   IF R = 0 DO SYSTEM.ERROR(2)
   RESULTIS R - 1
$)

// End of file DECLIO.BPL

