
// File DIAG.BPL

// Diagnostic routines -- PDP-10 specific

GET "SYSHDG.BPL"
GET "SYSHDM.BPL"

GLOBAL $( S: 137 $)   // Same as OPERATORS.CONSOLE

LET DIAGNOSIS() BE
$( LET C = 0
   AND ADDR = 0

   PRINT(S, "*C*LPD at :8, stack at :8*C*L", CUPROC, !#16)

   $( READCH(S, LV C)
      SWITCHON C INTO
      $( DEFAULT:  PRINT(S, "?*C*L")
                   LOOP

         CASE 'Q': RETURN

         CASE '+': ADDR := ADDR + 1
                   PRVAL(ADDR)
                   LOOP

         CASE '-': ADDR := ADDR - 1
                   PRVAL(ADDR)
                   LOOP

         CASE '0': CASE '1': CASE '2': CASE '3': CASE '4':
         CASE '5': CASE '6': CASE '7':
                   ADDR := 0
                   WHILE '0' LE C LE '7' DO
                   $( ADDR := ADDR * 8 + C - '0'
                      READCH(S, LV C)
                   $)
                   PRVAL(ADDR)
                   LOOP

         CASE '*L': CASE '*C': CASE '*$':
         CASE '*T': CASE '*S':
                   LOOP
      $)
   $) REPEAT
$)

AND PRVAL(ADD) BE PRINT(S, "*T*T:8*C*L", !ADD)

// End of file DIAG.BPL

