
// File DKSRCH.BPL

// Filing system -- search routines

// Segment 1

GET "MDCNST.BPL"
GET "STATUS.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "SCBDDB.BPL"
GET "FILEHD.BPL"
GET "ERRCOD.BPL"

LET SEARCHMFD(USERID) = VALOF
$( CUDIRBLK := MFDBLK
   UNTIL CUDIRBLK = 0 DO
   $( READ.TO.BUFFER1(CUDIRBLK)
      FOR I = 0 TO DISCBLOCK.SIZE BY 4 DO
         IF DISCBUFFER!I = USERID DO
            RESULTIS DISCBUFFER1 + I
      CUDIRBLK := MAP(CUDIRBLK)
   $)
   RESULTIS 0
$)

AND MATCHFILES(FILEA, FILEB) = VALOF
$( FOR I = 0 TO 2 DO
      UNLESS FILEA!I = FILEB!I RESULTIS FALSE
   RESULTIS TRUE
$)

AND SEARCHFCBCHAIN(DDB, FRB, REPLY) = VALOF
$( P(LV ALTERFCBCHAIN, ST.MUT)
   $( LET FCB = DDB!DDB.FCBCHN
      AND OWNER = FRB!FRB.OWNER
      AND FOUND = FALSE

      UNTIL FCB = 0 DO
      $( IF FCB!FCB.OWNER = OWNER DO
            IF MATCHFILES(FCB + FCB.FILE1, FRB + FRB.FILE1) DO
            $( UNLESS FCB!FCB.USE & DELETED DO FOUND := TRUE
               BREAK
            $)
         FCB := !FCB
      $)

      UNLESS FOUND DO V(LV ALTERFCBCHAIN)
      !REPLY := FOUND -> FCB, 0
      RESULTIS FOUND
   $)
$)

 .

// Segment 2

GET "MDCNST.BPL"
GET "STATUS.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "SCBDDB.BPL"
GET "FILEHD.BPL"
GET "ERRCOD.BPL"

LET SEARCHUFD(FRB, REPLY, CREATE) = VALOF
$( LET USER = FRB!FRB.OWNER
   AND UFDBLK = CUPROC!PD.UFD
   AND FOUND = FALSE
   LET RES = VALOF
   $( P(LV DISCBUFFER1.USE, ST.CBW)
      IF (CUPROC!PD.USERID NE USER) \/ UFDBLK = 0 DO
      $( LET R = SEARCHMFD(USER)
         IF R = 0 DO RESULTIS ERR.NME
         UFDBLK := R!MFD.UFD
      $)

      IF UFDBLK = 0 RESULTIS ERR.NME

      READ.TO.BUFFER1(UFDBLK)
      DISCBUFFER1!FDB.DACCESS, DISCBUFFER1!FDB.TACCESS := DATE, TIME()
      WRITE.FROM.BUFFER1(UFDBLK)
      CUDIRBLK := DISCBUFFER1!FDB.START
      UNLESS CREATE = 0 DO !CREATE := CREATEABILITY()

      UNTIL CUDIRBLK = 0 DO
      $( READ.TO.BUFFER1(CUDIRBLK)
         FOR I = 0 TO DISCBLOCK.SIZE BY 4 DO
            UNLESS DISCBUFFER1!(I + UFD.FDB) = 0 DO
               IF MATCHFILES(DISCBUFFER1 + I, FRB + FRB.FILE1) DO
               $( FOUND := TRUE
                  RESULTIS DISCBUFFER1 + I
               $)
         CUDIRBLK := MAP(CUDIRBLK)
      $)
      RESULTIS ERR.FNF
   $)

   UNLESS FOUND DO V(LV DISCBUFFER1.USE)
   !REPLY := RES
   RESULTIS FOUND
$)

// End of file DKSRCH.BPL

