
// File DKVER1.BPL

// Disc verification routines (1) -- free chain checking

GET "MDCNST.BPL"
GET "SYSHDG.BPL"
GET "FILEHD.BPL"

GLOBAL $( ERROR.STREAM : 137 $)  // Same as OPERATORS.CONSOLE

LET SETBIT(N) BE
$( LET OFFSET = N/BITSPERWORD
   AND BITPOSITION = 1 << (N REM BITSPERWORD)
   BITMAP1!OFFSET := BITMAP1!OFFSET \/ BITPOSITION
$)

AND FINDBIT(N) = VALOF
$( LET OFFSET = N/BITSPERWORD
   AND BITPOSITION = 1 << (N REM BITSPERWORD)
   RESULTIS BITMAP1!OFFSET & BITPOSITION
$)

AND VERIFYFAIL(S) BE
$( PRINT(ERROR.STREAM, "?:S*C*L", S)
   SYSTEM.ERROR(9)
$)

AND VERIFYMESSAGE(S) BE PRINT(ERROR.STREAM, "%:S*C*L", S)

AND RECREATEFREECHAIN(MFDSIZE) BE
$( READ.TO.BUFFER1(0)
   DISCBUFFER!6, DISCBUFFER!7 := ENDMFDBLK, MFDSIZE
   WRITE.FROM.BUFFER1(0)

   $( LET MAXUSERBLOCK = !DISCBUFFER1
      AND MAPSIZE = DISCBUFFER1!2
      AND MAPBASE = DISCBUFFER1!1
      AND CBLOCK = 0
      AND SIZE = 0

      !DISCMAP := 0

      FOR I = 2 TO MAXUSERBLOCK DO
         UNLESS FINDBIT(I) DO
         $( DISCMAP!CBLOCK := I
            CBLOCK := I
            SIZE := SIZE + 1
         $)
      DISCMAP!CBLOCK := 0
      DISCMAP!1 := CBLOCK

      FOR I = 0 TO MAPSIZE - 1 DO
         DISC.WRITE(MAPBASE + I, DISCMAP + I * DISCBLOCK.WORDS)

      SIZE := SIZE - FREECHAINSIZE
      UNLESS SIZE = 0 DO
         PRINT(ERROR.STREAM, "*C*L%:N blocks recovered*C*L", SIZE)

      FREE(BITMAP1)
      FREE(DISCMAP)
   $)
$)

AND VERIFYFREECHAIN() BE
$( LET MESS1 = "Free chain tail bn wrong"
   AND MESS2 = "Illegal bn on free chain"
   AND MESS3 = "Free chain is circular"
   AND MESS4 = "Free chain tail bn not end of chain"

   READ.TO.BUFFER1(0)

   $( LET MAXUSERBLOCK = !DISCBUFFER1
      AND MAPBASE = DISCBUFFER1!1
      AND MAPSIZE = DISCBUFFER1!2

      IF MAPBASE < MAXUSERBLOCK DO
         VERIFYFAIL("Map start bn illegal")

      MAPSIZE := DISCBUFFER1!2
      MFDBLK, ENDMFDBLK := DISCBUFFER1!5, DISCBUFFER1!6

      BITMAP1 := NEWVEC(MAXUSERBLOCK/BITSPERWORD + 1)
      DISCMAP := NEWVEC(MAPSIZE * DISCBLOCK.WORDS)

      FOR I = 0 TO MAPSIZE - 1 DO
         DISC.READ(MAPBASE + I, DISCMAP + I * DISCBLOCK.WORDS)

      $( LET SBLOCK = !DISCMAP
         AND EBLOCK = DISCMAP!1

         FREECHAINSIZE := 1

         UNTIL SBLOCK = EBLOCK DO
         $( IF SBLOCK = 0 DO
            $( VERIFYMESSAGE(MESS1)
               BREAK
            $)

            UNLESS 2 LE SBLOCK LE MAXUSERBLOCK DO
            $( VERIFYMESSAGE(MESS2)
               BREAK
            $)

            IF FINDBIT(SBLOCK) DO
            $( VERIFYMESSAGE(MESS3)
               BREAK
            $)

            SETBIT(SBLOCK)
            FREECHAINSIZE := FREECHAINSIZE + 1
            SBLOCK := DISCMAP!SBLOCK
         $)

         UNLESS DISCMAP!EBLOCK = 0 DO
            VERIFYMESSAGE(MESS4)
      $)
   $)
$)

// End of file DKVER1.BPL

