
// File DSKMAP.BPL

// Filing system -- disc map manipulation routines

GET "MDCNST.BPL"
GET "SYSHDG.BPL"
GET "STATUS.BPL"

STATIC $(
ALTERED         = FALSE
CURRENT.BLOCK   = 1
MAX.BLOCKS      = 0
$)

STATIC $(
START.BLOCK     = 0
END.BLOCK       = 0
MAP.BASE        = 0
$)

LET INITIALISEDISC() BE
$( READ.TO.BUFFER1(0)

   MAP.BASE := DISCBUFFER1!1
   MAX.BLOCKS := DISCBUFFER1!0

   MFDBLK, ENDMFDBLK := DISCBUFFER1!5, DISCBUFFER1!6
   SWAPBASE := DISCBUFFER1!9

   LOADMAPBLOCK(0)
   START.BLOCK, END.BLOCK := MAP.AREA!0, MAP.AREA!1
$)

AND LOADMAPBLOCK(BLOCK) BE
$( LET B = MAP.BASE + BLOCK/DISCBLOCK.WORDS
   UNLESS B = CURRENT.BLOCK DO
   $( OUTMAP()
      DISC.READ(B, MAP.AREA)
      ALTERED, CURRENT.BLOCK := FALSE, B
   $)
$)

AND MAP(BLOCK) = VALOF
$( LET OFFSET = BLOCK REM DISCBLOCK.WORDS
   LET R = VALOF
   $( P(LV MAP.USE, ST.DMW)
      LOADMAPBLOCK(BLOCK)
      RESULTIS MAP.AREA!OFFSET
   $)
   V(LV MAP.USE)
   RESULTIS R
$)

AND GETBLOCK() = VALOF
$( IF START.BLOCK = 0 RESULTIS 0
   P(LV MAP.USE, ST.DMW)

   $( LET OFFSET = START.BLOCK REM DISCBLOCK.WORDS
      AND R = START.BLOCK
      LOADMAPBLOCK(START.BLOCK)
      START.BLOCK := MAP.AREA!OFFSET
      MAP.AREA!OFFSET, ALTERED := 0, TRUE
      LOADMAPBLOCK(0)
      !MAP.AREA, ALTERED := START.BLOCK, TRUE
      IF START.BLOCK = 0 DO
         END.BLOCK, MAP.AREA!1 := 0, 0

      V(LV MAP.USE)

      UNLESS 2 LE R LE MAX.BLOCKS DO SYSTEM.ERROR(5)

      RESULTIS R
   $)
$)

AND CHAIN(BLOCK, NEWBLOCK) BE
$( LET OFFSET = BLOCK REM DISCBLOCK.WORDS

   P(LV MAP.USE, ST.DMW)
   LOADMAPBLOCK(BLOCK)
   MAP.AREA!OFFSET, ALTERED := NEWBLOCK, TRUE

   V(LV MAP.USE)
$)

AND RETURNCHAIN(HEAD, TAIL) = VALOF
$( UNLESS HEAD = 0 DO
   $( UNLESS MAP(TAIL) = 0 DO
         RESULTIS FALSE

      P(LV MAP.USE, ST.DMW)
      $( LET OFFSET = END.BLOCK REM DISCBLOCK.WORDS

         LOADMAPBLOCK(END.BLOCK)
         MAP.AREA!OFFSET, ALTERED := HEAD, TRUE
         LOADMAPBLOCK(1)
         END.BLOCK := TAIL
         MAP.AREA!1 := TAIL
         ALTERED := TRUE
      $)
      V(LV MAP.USE)
   $)
   RESULTIS TRUE
$)

AND OUTMAP() BE
   IF ALTERED DO DISC.WRITE(CURRENT.BLOCK, MAP.AREA)

// End of file DSKMAP.BPL

