
// File DSKOPN.BPL

// Filing system -- disc open routines

GET "SYSHDM.BPL"
GET "ERRCOD.BPL"
GET "SYSHDG.BPL"
GET "SCBDDB.BPL"
GET "FILEHD.BPL"

LET KILL.SCB(SCB, N) BE
$( LET D = SCB!SCB.DDB
   AND I = SCB!SCB.FCBIN
   AND O = SCB!SCB.FCBOUT

   UNLESS I = 0 DO DSKLOSEREAD(I, D)
   UNLESS O = 0 DO DSKLOSEWRITE(I, D)

   FREEBUFFERS(SCB!SCB.INPUT)
   FREEBUFFERS(SCB!SCB.OUTPUT)
   FREE(SCB)

   ERROR.REPLY(N)
$)

AND FREEBUFFERS(B) BE
$( UNLESS B = 0 DO
   $( LET THISBUF = B
      $( LET NEXTBUFFER = THISBUF!BUF.NEXT
         FREE(THISBUF)
         THISBUF := NEXTBUFFER
      $) REPEATUNTIL (THISBUF = B) \/ (THISBUF = 0)
   $)
$)

AND GETBUFFERS(SCB, SIZE) = VALOF
$( LET FIRST = NEWVEC(SIZE)

   IF FIRST = 0 THEN KILL.SCB(SCB, ERR.MFS)

   $( LET A = FIRST
      FOR I = 2 TO BUFFERCONSTANT DO
      $( LET B = NEWVEC(SIZE)
         IF B = 0 DO
         $( UNLESS FIRST!BUF.NEXT = 0 DO
               FREEBUFFERS(FIRST!BUF.NEXT)
            A := FIRST
            BREAK
         $)
         A!BUF.NEXT := B
         A := B
      $)
      A!BUF.NEXT := FIRST
   $)
   RESULTIS FIRST
$)

AND DSKOPEN(SCB, DMODE, TMODE) BE
$( TEST DMODE = 2 THEN
      SWITCHON TMODE INTO
      $( CASE M.OUTPUT:
         CASE M.TWOWAY:
            SCB!SCB.WRITE := DSKBLOCKWRITE
            IF TMODE = M.OUTPUT RETURN

         CASE M.INPUT:
            SCB!SCB.READ := DSKBLOCKREAD
            SCB!SCB.INPUT := (SCB!SCB.FCBIN)!FCB.START
      $)
   OR
   $( LET BUF = GETBUFFERS(SCB, DISCBUFFER.SIZE)
      LET FIRST = BUF

      SWITCHON TMODE INTO
      $( CASE M.OUTPUT:
         CASE M.TWOWAY:
            SCB!SCB.OUTPUT := BUF
            $( SETUPOUTPUTBUFFER(BUF, DMODE, DISCBLOCK.WORDS)
               BUF := BUF!BUF.NEXT   // *** check
            $) REPEATUNTIL BUF = FIRST

            IF TMODE = M.OUTPUT RETURN

            BUF := GETBUFFERS(SCB, DISCBUFFER.SIZE)

         CASE M.INPUT:
            SCB!SCB.INPUT := BUF
            BUF!BUF.DDEP := (SCB!SCB.FCBIN)!FCB.START
      $)
   $)
$)

// End of file DSKOPN.BPL

