
// File ERRFN.BPL

// Error reporting functions

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "ERRCOD.BPL"

GLOBAL $( LEVEL: 31; LONGJUMP: 32 $)

LET SYSTEM.ERROR(N) BE
$( PRINT(OPERATORS.CONSOLE, "*C*L?:N*T:#*C*L", N, CUPROC)
   OVERLAY.CALL(DIAGNOSIS, 8)
   FINISH
$)

AND JOB.ERROR(N) BE
$( PRINT(-1, "?*C*L?Error :N in job :N*C*L", N, CUSLOT)
   IF CUSLOT < 0 DO SYSTEM.ERROR(100)
   IF N = ERROR.TRAP DO OVERLAY.CALL(DIAGNOSIS, 8)
   EXIT(0)
$)

AND OVJOB.ERROR(N) BE
$( OVEXIT()
   JOB.ERROR(N)
$)

AND COMMAND.ERROR(N) BE
$( LET R = VALOF
   $( SWITCHON N INTO
      $( CASE 0:
            RETURN
         CASE ERR.DNF:
            RESULTIS "No such device"
         CASE ERR.MFS:
            RESULTIS "No free space left"
         CASE ERR.DIU:
            RESULTIS "Device in use"
         CASE ERR.PRV:
            RESULTIS "No privileges"
         CASE ERR.NLI:
            RESULTIS "Login please"
         CASE ERR.CON:
            RESULTIS "Can*'t continue"
         CASE ERR.TBG:
            RESULTIS "Core request too large"
         CASE ERR.AMB:
            RESULTIS "Ambiguous"

         DEFAULT:
            RESULTIS "See error list"
      $)
   $)
   PRINT(-1, "?(:N) :S*C*L", N, R)
$)

AND ERROR.REPLY(N) BE
$( CUPROC!PD.ERRCOD := N
   LONGJUMP(CUPROC!PD.ERRSTK, CUPROC!PD.ERRLAB)
$)

AND CALLER(FN, A, B, C) = VALOF
$( TRAPCHECK()
   CUPROC!PD.ERRSTK := LEVEL()
   CUPROC!PD.ERRLAB := ERRORETURN
   $( LET R = FN(A, B, C)
      TRAPCHECK()
      RESULTIS R
   $)

ERRORETURN:
   TRAPCHECK()

   RESULTIS CUPROC!PD.ERRCOD
$)

AND OVCALLER(FN, OV, A, B, C) = VALOF
$( TRAPCHECK()
   CUPROC!PD.ERRSTK := LEVEL()
   CUPROC!PD.ERRLAB := OVERRORETURN
   $( LET R = OVERLAY.CALL(FN, OV, A, B, C)
      TRAPCHECK()
      RESULTIS R
   $)

OVERRORETURN:
   OVEXIT()
   TRAPCHECK()

   RESULTIS CUPROC!PD.ERRCOD
$)

AND FAIL(N, SCB, A, B, C, D, E) BE
$( LET SEM = LV A
   FREE(SCB)
   UNTIL !SEM = 0 DO
   $( V(!SEM)
      SEM := SEM + 1
   $)
   V(LV DIRECTORY.MUTEX)
   ERROR.REPLY(N)
$)

AND OVFAIL(N, SCB, A, B, C, D, E) BE
$( OVEXIT()
   FAIL(N, SCB, A, B, C, D, E)
$)

// End of file ERRFN.BPL

