
// File FILEHD.BPL

// Header file for filing system

MANIFEST $(  // MFD accessors
MFD.USERID      = 0     // User identification code
MFD.PASSWD      = 1     // User's password
MFD.PRIV        = 2     // User's privilege bits
MFD.UFD         = 3     // Block no of UFD's file definition block
$)

MANIFEST $(  // UFD accessors
UFD.FILE1       = 0     // First part of file title
UFD.FILE2       = 1     // Second part of file title
UFD.FILE3       = 2     // Third part of file title
UFD.FDB         = 3     // Block no of file's definition block
$)

MANIFEST $(  // File definition block accessors
FDB.MARKER      = 0     // Type of definition block
FDB.OWNER       = 1     // File owner identification
FDB.FILE1       = 2     // First part of file title
FDB.FILE2       = 3     // Second part of file title
FDB.FILE3       = 4     // Third part of file title
FDB.PROT        = 5     // Protection code
FDB.LENGTH      = 6     // Length of file in blocks
FDB.START       = 7     // Start block number
FDB.END         = 8     // End block number
FDB.WCOUNT      = 9     // Word count in last block
FDB.DCREATE     = 10    // Date of creation
FDB.TCREATE     = 11    // Time of creation
FDB.DACCESS     = 12    // Date of last access
FDB.TACCESS     = 13    // Time of last access
FDB.STATUS      = 14    // File status bits
FDB.DSAVE       = 15    // Date of last file save
FDB.TSAVE       = 16    // Time of last file save
FDB.WHERE       = 17    // Where file is saved
FDB.QUOTA       = 18    // If UFD - logged out quota
FDB.CRPROT      = 19    // If UFD - protection code

FDB.ENTRYSIZE   = 19

PROTECTIONDEFINITIONS = 32
$)

MANIFEST $(  // File status bit definitions
FST.ARCH        = #1    // Set if file to be archived
FST.ARCHDEL     = #2    // Set if file to be deleted after archiving
FST.ERROR       = #4    // Error has been detected by disc verification
$)

MANIFEST $(  // File control block accessors
FCB.OWNER       = 1     // File owner identification
FCB.FILE1       = 2     // First part of file title
FCB.FILE2       = 3     // Second part of file title
FCB.FILE3       = 4     // Third part of file title
FCB.PROT        = 5     // Protection code
FCB.LENGTH      = 6     // Length (in blocks)
FCB.START       = 7     // Start block number
FCB.END         = 8     // End block number
FCB.WCOUNT      = 9     // Word count in last block
FCB.FDB         = 10    // File definition block no
FCB.USE         = 11    // Use count/status

FCB.SIZE        = 11
$)

MANIFEST $(  // File request block accessors
FRB.OWNER       = 0     // File owner identification
FRB.FILE1       = 1     // First part of file title
FRB.FILE2       = 2     // Second part of file title
FRB.FILE3       = 3     // Third part of file title
FRB.PROT        = 4     // Protection code

FRB.SIZE        = 4
$)

MANIFEST $(  // File definition block markers
MARKER.UFD      = #1000 // Indicates file is a UFD
MARKER.FILE     = #2000 // Indicates file is a user file
MARKER.SAVE     = #10000// Indicates file is not on disc
$)

MANIFEST $(  // File control block status bits
SINGLEACCESS    = #40000// File is only available on a single stream
WRITEACCESS     = #20000// File is being written
DELETED         = #10000// File has been deleted
READACCESS      = #60000// Masked to zero for read access
READERS         = #7777 // Mask for use count
$)

MANIFEST $(  // Protection check values
MODE.LOAD       = 1     // Load a file and run it
MODE.READ       = 2     // Read a file
MODE.DIRREAD    = 3     // Read file's directory entry
MODE.SUPERSEDE  = 4     // Overwrite an existing file
MODE.DELETE     = 5     // Delete a file
MODE.RENAME     = 6     // Rename a file
MODE.CHANGEPROT = 7     // Change file's protection
$)

MANIFEST $(  // Buffer header accessors
BUF.NEXT        = 0     // Pointer to next buffer
BUF.SEM         = 1     // Pointer to wait semaphore
BUF.DDEP        = 2     // Device dependent value
BUF.ECNT        = 3     // Entry count
BUF.PTR         = 4     // Pointer into buffer
BUF.DATA        = 5     // First data word in buffer
$)

// End of file FILEHD.BPL

