
// File IOUMFN.BPL

// I/O subsystem -- user mode functions

GET "SYSHDM.BPL"
GET "ERRCOD.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "SCBDDB.BPL"
GET "DEVCAP.BPL"

LET FINDDEVICE(DEV) = VALOF
$( LET A = CUPROC!PD.DAB
   UNTIL A = 0 DO
   $( IF A!DAB.LNAME = DEV \/ A!DAB.NAME = DEV DO
         RESULTIS A!DAB.DDB
      A := !A 
   $)

   A := SHAREABLEDEVICES
   UNTIL A = 0 DO
   $( IF A!DDB.NAME = DEV RESULTIS A
      A := !A
   $)
   ERROR.REPLY(ERR.DNF)
$)

AND OPEN.STREAM(STREAM, DMODE, TMODE, DEVBLOCK) = VALOF
$( LET STREAMVEC = CUPROC!PD.STREAMS

   UNLESS 0 LE DMODE LE 2 DO ERROR.REPLY(ERR.IDM)

   UNLESS 0 LE STREAM LE NO.OF.STREAMS DO
      ERROR.REPLY(ERR.ISN)

   UNLESS STREAMVEC!STREAM = 0 DO CLOSE.STREAM(STREAM)

   $( LET D = FINDDEVICE(!DEVBLOCK)
      UNLESS (((D!DDB.CAP >> 9) & #3) & TMODE) = TMODE DO
         ERROR.REPLY(ERR.WRD)

      IF (((D!DDB.CAP) >> DMODE) & 1) = 0 DO
         ERROR.REPLY(ERR.DNA)

      $( LET S = NEWVEC(SCB.SIZE)
         IF S = 0 ERROR.REPLY(ERR.MFS)

         S!SCB.READ := D!DDB.READ
         S!SCB.WRITE := D!DDB.WRITE
         S!SCB.DDB := D
         S!SCB.DEVNO := D!DDB.DEVNO

         IF (D!DDB.CAP & CAP.STRUC) NE 0 DO
         $( LET R = D!DDB.OPENFILES
            R(S, D, DMODE, TMODE, DEVBLOCK)
         $)

         [D!DDB.OPEN](S, DMODE, TMODE)

         S!SCB.MODE := (TMODE << 9) + DMODE

         SWITCHON TMODE INTO
         $( CASE M.INPUT:  S!SCB.WRITE := WRONG.DIRECTION
                           ENDCASE
            CASE M.OUTPUT: S!SCB.READ := WRONG.DIRECTION
         $)
         STREAMVEC!STREAM := S
      $)
   $)
   RESULTIS 0
$)

AND OPEN.INPUT.STREAM(STREAM, MODE, DEVBLOCK) =
   OPEN.STREAM(STREAM, MODE, M.INPUT, DEVBLOCK)

AND OPEN.OUTPUT.STREAM(STREAM, MODE, DEVBLOCK) =
   OPEN.STREAM(STREAM, MODE, M.OUTPUT, DEVBLOCK)

AND OPEN.IO.STREAM(STREAM, MODE, DEVBLOCK) =
   OPEN.STREAM(STREAM, MODE, M.TWOWAY, DEVBLOCK)

AND KILL.STREAM(STREAM, ROUTINE) BE
$( UNLESS 0 LE STREAM LE NO.OF.STREAMS DO JOB.ERROR(5)

   $( LET STREAMVEC = (CUPROC!PD.STREAMS) + STREAM
      LET S = !STREAMVEC
      UNLESS S = 0 DO
      $( [(S!SCB.DDB)!ROUTINE](S)
         FREE(S)
         !STREAMVEC := 0
      $)
   $)
$)

AND CLOSE.STREAM(STREAM) BE KILL.STREAM(STREAM, DDB.CLOSE)

AND LOSE.STREAM(STREAM) BE KILL.STREAM(STREAM, DDB.LOSE)

AND SCAN.STREAMS(ROUTINE) BE
   FOR I = 0 TO NO.OF.STREAMS DO
      KILL.STREAM(I, ROUTINE)

AND RESET() BE SCAN.STREAMS(DDB.LOSE)

AND CLOSE() BE SCAN.STREAMS(DDB.CLOSE)

AND FINDSTREAM(STREAM) = VALOF
$( UNLESS 0 LE STREAM LE NO.OF.STREAMS DO JOB.ERROR(5)
   $( LET S = (CUPROC!PD.STREAMS)!STREAM
      IF S = 0 DO JOB.ERROR(1)
      RESULTIS S
   $)
$)

AND READ.FROM.STREAM(STREAM, ADDRESS) = VALOF
$( LET S = FINDSTREAM(STREAM)
   RESULTIS [S!SCB.READ](S, ADDRESS)
$)

AND WRITE.TO.STREAM(STREAM, VALUE) BE
$( LET S = FINDSTREAM(STREAM)
   [S!SCB.WRITE](S, VALUE)
$)

AND DEVDEPFUNCTION(DEVBLOCK) = VALOF
$( LET D = FINDDEVICE(!DEVBLOCK)
   RESULTIS [D!DDB.DEVDEP](D, DEVBLOCK)
$)

AND NULL() = 0

AND EOF() = STR.EOF

AND WRONG.DIRECTION() BE JOB.ERROR(8)

AND CTLOPEN(SCB, DMODE, TMODE) BE
$( LET S = CUPROC!PD.MONSTREAM
   FOR I = SCB.DEVNO TO SCB.FCBOUT DO SCB!I := S!I
$)

// End of file IOUMFN.BPL

