
// File LKPENT.BPL

// Filing system -- lookup/enter files

GET "SYSHDG.BPL"
GET "STATUS.BPL"
GET "ERRCOD.BPL"
GET "SCBDDB.BPL"
GET "FILEHD.BPL"

STATIC $( FDBBLK = 0 $)

LET DSKLOOKUP(SCB, DDB, FRB) BE
$( LET REPLY = 0
   P(LV DIRECTORY.MUTEX, ST.MUT)

   TEST SEARCHFCBCHAIN(DDB, FRB, LV REPLY) THEN
   $( UNLESS (REPLY!FCB.USE & READACCESS) = 0 DO
         OVFAIL(ERR.FBW, SCB, LV ALTERFCBCHAIN, 0)
      P(LV DISCBUFFER1.USE, ST.CBW)
      READ.TO.BUFFER1(REPLY!FCB.FDB)
      UNLESS CHECKPROTECTION(DISCBUFFER1, MODE.READ) DO
         OVFAIL(ERR.PRF, SCB, LV ALTERFCBCHAIN, LV DISCBUFFER1.USE, 0)
   $)
   OR
   $( LET R = 0
      UNLESS SEARCHUFD(FRB, LV R, 0) DO OVFAIL(R, SCB, 0)
      FDBBLK := R!UFD.FDB
      READ.TO.BUFFER1(FDBBLK)
      IF DISCBUFFER1!FDB.MARKER = MARKER.SAVE DO
         OVFAIL(ERR.NOD, SCB, LV DISCBUFFER1.USE, 0)

      UNLESS CHECKPROTECTION(DISCBUFFER1, MODE.READ) DO
         OVFAIL(ERR.PRF, SCB, LV DISCBUFFER1.USE, 0)

      REPLY := FCBFROMFDB(FRB, DDB)
   $)
   V(LV DISCBUFFER1.USE)
   REPLY!FCB.USE := REPLY!FCB.USE + 1
   SCB!SCB.FCBIN := REPLY

   V(LV ALTERFCBCHAIN)
   V(LV DIRECTORY.MUTEX)
$)

AND DSKENTER(SCB, DDB, FRB) BE
$( LET REPLY = 0
   AND CREATE = 0

   P(LV DIRECTORY.MUTEX, ST.MUT)
   FDBBLK := 0

   TEST SEARCHFCBCHAIN(DDB, FRB, LV REPLY) THEN
   $( UNLESS (REPLY!FCB.USE & READACCESS) = 0 DO
         OVFAIL(ERR.FBW, SCB, LV ALTERFCBCHAIN, 0)

      FDBBLK := REPLY!FCB.FDB

      V(LV ALTERFCBCHAIN)
      P(LV DISCBUFFER1.USE, ST.CBW)

   $)
   OR TEST SEARCHUFD(FRB, LV REPLY, LV CREATE) THEN
      FDBBLK := REPLY!UFD.FDB
   OR TEST REPLY = ERR.FNF THEN
      P(LV DISCBUFFER1.USE, ST.CBW)
   OR OVFAIL(REPLY, SCB, 0)

   TEST FDBBLK = 0 THEN
      UNLESS CREATE DO
         OVFAIL(ERR.CRF, SCB, LV DISCBUFFER1.USE, 0)
   OR
   $( READ.TO.BUFFER1(FDBBLK)
      IF DISCBUFFER1!FDB.MARKER = MARKER.UFD DO
         OVFAIL(ERR.CEU, SCB, LV DISCBUFFER1.USE, 0)

      UNLESS CHECKPROTECTION(DISCBUFFER1, MODE.SUPERSEDE) DO
         OVFAIL(ERR.PRF, SCB, LV DISCBUFFER1.USE, 0)
   $)

   V(LV DISCBUFFER1.USE)

   $( LET R = GETBLOCK()

      IF R = 0 DO OVFAIL(ERR.DKF, SCB, 0)

      REPLY := CREATEFCB(FRB, DDB)
      REPLY!FCB.USE := WRITEACCESS
      REPLY!FCB.FDB := R
      SCB!SCB.FCBOUT := REPLY

      V(LV ALTERFCBCHAIN)
      V(LV DIRECTORY.MUTEX)
   $)
$)

AND FCBFROMFDB(FRB, DDB) = VALOF
$( LET R = CREATEFCB(FRB, DDB)

   R!FCB.FDB := FDBBLK
   R!FCB.LENGTH := DISCBUFFER1!FDB.LENGTH
   R!FCB.START := DISCBUFFER1!FDB.START
   R!FCB.END := DISCBUFFER1!FDB.END
   R!FCB.WCOUNT := DISCBUFFER1!FDB.WCOUNT

   RESULTIS R
$)

// End of file LKPENT.BPL

