
// File PDMAN.BPL

// Manifest constants for accessing process descriptors

MANIFEST $(  // Process descriptor block accessors
PD.USERID       = 1     // User identifier
PD.PRIO         = 2     // Process priority
PD.STATUS       = 3     // Process status bits
PD.STREAMS      = 4     // Pointer to the stream vector
PD.MONSTREAM    = 5     // Monitor control SCB
PD.DAB          = 6     // Device assignment block chain
PD.UFD          = 7     // Block no of UFD's file definition block
PD.STACK        = 8     // Points to user's run-time stack
PD.RTIME        = 9     // Process run time (in ticks)
PD.JBSLOT       = 10    // Process job slot number
PD.PRIV         = 11    // Process privilege bits
PD.DSKTRAN      = 12    // No of disc transfers
PD.ERRSTK       = 13    // Error stack level
PD.ERRCOD       = 14    // Error code
PD.REPLY        = 14    // Communication reply word
PD.ERRLAB       = 15    // Error return label
PD.STOP         = 16    // Stop semaphore
PD.SCOUNT       = 17    // Stop count
PD.COMM         = 18    // Communication chain header
PD.COMMSEM      = 19    // Communication available semaphore
PD.CHILD        = 20    // Points to first sub-process
PD.BROTHER      = 21    // Ptr to process with same parent
PD.PARENT       = 22    // Pointer to parent process
PD.IDWSEM       = 23    // Ptr to indefinite wait semaphore
PD.REPLYSEM     = 24    // Reply wait semaphore
PD.START        = 25    // Start address of current program

PD.TOP          = 12    // Highest entry user may access
$)

// End of file PDMAN.BPL

