
// File SAVRUN.BPL

// Routines for saving and running core images (machine independent)

GET "SYSHDM.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"

LET SAVEANDRUN(STREAM, STREAMFN, FN, ERRORSTRING) BE
$( LET DEVICE = DEFAULT.DEVICE
   AND USERID = 0
   AND FILE1 = 0
   AND FILE2 = 0
   AND FILE3 = 0
   AND PROT = 0
   LET R = GETFILE(STREAM, LV DEVICE)

   IF R < 0 THEN
   $( SKIP(STREAM, -R)
      WRITES(STREAM, "*C*L?File title error*C*L")
      EXIT(3)
   $)

   $( LET DEFAULT.CORE = (R = '*C' \/ R = '*L' \/ R = '*$') -> 0,
         READNUMBER(10, STREAM, LV R)

      SKIP(STREAM, R)
      R := CALLER(STREAMFN, 0, SAVEANDRUNMODE, LV DEVICE)
      UNLESS R = 0 DO
      $( PRINT(STREAM, "?:S error :N, :F*C*L", ERRORSTRING, R, LV FILE1)
         EXIT(3)
      $)

      FN(DEFAULT.CORE)

      CLOSE.STREAM(0)
   $)
$)

AND SAVE(STREAM, CHAR) BE
   SAVEANDRUN(STREAM, OPEN.OUTPUT.STREAM, SAVEIMAGE, "Enter")

AND RUN(STREAM, CHAR) BE
$( SAVEANDRUN(STREAM, OPEN.INPUT.STREAM, RUNIMAGE, "Lookup")
   ENTER()
$)

AND RUNSYSPROG(NAME, ARG1, ARG2, ARG3) BE
$( LET DEVICE = SYSTEM.DEVICE
   AND USERID = SYSTEMID
   AND FILE1 = SYSFILENAME(NAME)
   AND FILE2 = RUNFILE2
   AND FILE3 = RUNFILE3
   AND PROT = 0

   LET R = CALLER(OPEN.INPUT.STREAM, 0, SAVEANDRUNMODE, LV DEVICE)

   UNLESS R = 0 DO
   $( PRINT(-1, "?Lookup error :N, :F*C*L", R, LV FILE1)
      RETURN
   $)

   RUNIMAGE(0)
   CLOSE.STREAM(0)
   ENTER(ARG1, ARG2, ARG3)
$)

// End of file SAVRUN.BPL

