
// File SIORTN.BPL

// Streamed I/O routines

// Segment 1

GET "SYSHDM.BPL"
GET "STATUS.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "SCBDDB.BPL"

GLOBAL $( UNPACKSTRING: 67 $)

LET WRITES(STREAM, S) BE
$( LET U = VEC 64
   UNPACKSTRING(S, U)
   FOR I = U + 1 TO U + !U DO WRITECH(STREAM, !I)
$)

AND WRITEN(STREAM, N) BE
$( IF N < 0 DO
   $( IF N = -N DO
      $( WRITES(STREAM, "-32768")
         RETURN
      $)
      WRITECH(STREAM, '-')
      N := -N
   $)
   WRITEPN(STREAM, N)
$)

AND WRITEPN(STREAM, N) BE
$( IF N > 9 DO WRITEPN(STREAM, N/10)
   WRITECH(STREAM, N REM 10 + '0')
$)

AND WRITEOCT(STREAM, N, P) BE
$( IF P > 1 DO WRITEOCT(STREAM, N >> 3, P - 1)
   WRITECH(STREAM, (N & #7) + '0')
$)

AND READNUMBER(BASE, STREAM, TERM) = VALOF
$( LET HIGH = '0' - 1 + BASE
   AND SUM = 0
   AND C = 0

   READCH(STREAM, LV C)
   WHILE '0' LE C LE HIGH DO
   $( SUM := SUM * BASE + C - '0'
      READCH(STREAM, LV C)
   $)

   !TERM := C
   RESULTIS SUM
$)

 .

// Segment 2

GET "SYSHDM.BPL"
GET "STATUS.BPL"
GET "PDMAN.BPL"
GET "SYSHDG.BPL"
GET "SCBDDB.BPL"

/*
        PRINT routine
        Formatted output to a stream
        1st parameter is stream
        2nd parameter is format string
        Subsequent parameters are printed according to the format
        requested. Possible formats are:-

        C       - print as a character
        S       - print as a string
        I or N  - print as a left justified, signed decimal number
        8       - print as a left justified, unsigned octal number
        #       - print as 12 octal digits
        G       - skip this parameter
        D       - print the date
        T       - print the time
        V       - print the system version
        F       - print as a file title (parameter is a pointer to a 3 word
                  file description). Implementation dependent.
*/

MANIFEST $( WARN = ':' $)

LET PRINTV(S, N, W, I) BE
$( UNTIL N = 0 DO
   $( LET C = !W
      TEST C = WARN THEN
      $( SWITCHON 1!W INTO
         $( DEFAULT:
               WRITECH(S, WARN)

            CASE WARN:
               WRITECH(S, 1!W)
               ENDCASE

            CASE 'C':
               WRITECH(S, !I)
               I := I + 1
               ENDCASE

            CASE 'S':
               WRITES(S, !I)
               I := I + 1
               ENDCASE

            CASE 'F':
               WRITEFILE(S, !I)
               I := I + 1
               ENDCASE

            CASE 'D':
               PRINTDATE(S)
               ENDCASE

            CASE 'T':
               PRINTTIME(S)
               ENDCASE

            CASE 'V':
               WRITES(S, "pops V")
               WRITE8(S, SYSVER)
               WRITECH(S, '/')
               WRITECH(S, EDIT)
               ENDCASE

            CASE 'I':
            CASE 'N':
               WRITEN(S, !I)

            CASE 'G':
               I := I + 1
               ENDCASE

            CASE '8':
               WRITE8(S, !I)
               I := I + 1
               ENDCASE

            CASE '#':
               WRITEOCT(S, !I, 12)
               I := I + 1
               ENDCASE
         $)
         N, W := N - 2, W + 2
      $)
      OR
      $( WRITECH(S, C)
         N, W := N - 1, W + 1
      $)
   $)
$)

AND PRINT(STREAM, FT, A, B, C, D, E, F, G, H, I, J, K, L, M,
                      N, O, P, Q, R, S, T, U, V, W, X, Y, Z) BE
$( LET FF = (TABLE 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

   IF 0 LE STREAM LE NO.OF.STREAMS DO
   $( STREAM := (CUPROC!PD.STREAMS)!STREAM
      IF STREAM = 0 JOB.ERROR(1)
      IF STREAM!SCB.WRITE = WRONG.DIRECTION DO
         JOB.ERROR(8)
   $)

   IF STREAM = -1 THEN STREAM := CUPROC!PD.MONSTREAM

   P(LV PRINT.MUTEX, ST.MUT)
   UNPACKSTRING(FT, FF)
   PRINTV(STREAM, !FF, FF + 1, LV A)
   V(LV PRINT.MUTEX)
$)

AND PRINTDATE(STREAM) BE
$( LET DAY = DATE & #37
   AND MONTH = (DATE >> 5) & #17
   AND YEAR = (DATE >> 9) + 50
   LET R = LV DAY

   WRITES(STREAM, VALOF
   $( SWITCHON DAYOFWEEK INTO
      $( CASE 0:  RESULTIS "Sun"
         CASE 1:  RESULTIS "Mon"
         CASE 2:  RESULTIS "Tue"
         CASE 3:  RESULTIS "Wed"
         CASE 4:  RESULTIS "Thu"
         CASE 5:  RESULTIS "Fri"
         CASE 6:  RESULTIS "Sat"
      $)
   $) )

   FOR I = 0 TO 2 DO
   $( WRITEPN(STREAM, R!I)
      UNLESS I = 2 DO WRITECH(STREAM, '/')
   $)
$)

AND PRINTTIME(STREAM) BE
$( WRITEPN(STREAM, HOUR)
   WRITECH(STREAM, ':')
   WRITEPN(STREAM, MIN)
$)

AND WRITE8(STREAM, N) BE
$( LET M = N >> 3
   UNLESS M = 0 DO WRITE8(STREAM, M)
   WRITECH(STREAM, (N & #7) + '0')
$)

/*
        Use of streams

Stream -1 means use the monitor control stream pointed to by
PD.MONSTREAM in the PD.

A stream number between 0 and NO.OF.STREAMS inclusive means use
the appropriately numbered process stream.

*/

// End of file SIORTN.BPL

