
// File STRTUP.BPL

// Start-up code

GET "PDMAN.BPL"
GET "SYSHDM.BPL"
GET "SYSHDG.BPL"
GET "SCBDDB.BPL"

GLOBAL $( START: 1 $)   // It all starts here

MANIFEST $(
SYSTEMID        = 1
SYSTEM.PRIORITY = 5000
MMANGR.PRIORITY = 1
$)

MANIFEST $(
PROCESS.DATA.AREA = SHORT.PD + STACK.SIZE + 1
$)

LET INIT.SEMAPHORES() BE
$( SEMAPHORE(LV SPACEWAIT, 1)
   SEMAPHORE(LV JOBTABLEMUTEX, 1)
   SEMAPHORE(LV MAP.USE, 1)
   SEMAPHORE(LV ALTERFCBCHAIN, 1)
   SEMAPHORE(LV DISCBUFFER1.USE, 1)
   SEMAPHORE(LV DIRECTORY.MUTEX, 1)
   SEMAPHORE(LV PRINT.MUTEX, 1)
   SEMAPHORE(LV OVERLAY.PENDING, 1)
   SEMAPHORE(LV USE.OVERLAY, 1)
   SEMAPHORE(LV USERS.MUTEX, 1)
   SEMAPHORE(LV MMANGR.WAIT, 0)
$)

AND CREATE.SYSTEM.PROCESS(PD, START.ADDRESS, PRIORITY, JOBNUMBER,
                             STREAMVEC) = VALOF
$( FOR I = 0 TO SHORT.PD DO PD!I := 0
   UNLESS STREAMVEC = 0 DO
      FOR I = 0 TO NO.OF.STREAMS DO STREAMVEC!I := 0

   PD!PD.USERID := SYSTEMID
   PD!PD.PRIO := PRIORITY
   PD!PD.STACK := PD + SHORT.PD + 1
   PD!PD.JBSLOT := JOBNUMBER
   PD!PD.MONSTREAM := OPERATORS.CONSOLE
   PD!PD.STREAMS := STREAMVEC

   SET.UP.ENV(PD, START.ADDRESS)
   RESULTIS PD
$)

START:
$( LET A = VEC FREE.SPACE.SIZE
   AND B = VEC SCB.SIZE
   AND C = VEC NO.OF.COMMANDS
   AND D = VEC NO.OF.COMMANDS
   AND F = VEC JOBSLOTS
   AND G = VEC NO.OF.OVERLAYS
   AND H = VEC DISCBLOCK.SIZE
   AND I = VEC DISCBLOCK.SIZE
   AND J = VEC PROCESS.DATA.AREA
   AND K = VEC NO.OF.STREAMS
   AND L = VEC PROCESS.DATA.AREA

   INITIALISE(A)
   INIT.SEMAPHORES()

   B!SCB.DEVNO, B!SCB.READ, B!SCB.WRITE :=
      CONSOLE, TTYREAD, TTYWRITE
   OPERATORS.CONSOLE := B

   COMMAND.VECTOR, COMMAND.FUNCTION := C, D

   FOR I = 0 TO JOBSLOTS DO F!I := 0
   JOBTABLE := F
   SLOTS := JOBSLOTS

   OVERLAY.TABLE := G
   DISCBUFFER1 := H
   MAP.AREA := I

   MDINIT()
   INIT.PERIPHERALS()

   SYSTEM.PD := CREATE.SYSTEM.PROCESS(J, SYSTEM.START, SYSTEM.PRIORITY, -1, K)
   MMANGR.PD := CREATE.SYSTEM.PROCESS(L, MMANGR, MMANGR.PRIORITY, -2, 0)

   J!0 := L
   SCHEDQ, ESCHEDQ := J, L

   RUNSYSTEM()
$)

// End of file STRTUP.BPL

