
// File SYSHDG.BPL

// System header for globals

GLOBAL $(
ERROR.TRAP      : 38    // Enter diagnostics if this job error occurs
$)

GLOBAL $(  // System table - entries must be contiguous
SLOTS           : 39    // No of job slots in system
CUPROC          : 40    // Points to current PD
CUSLOT          : 41    // Slot no of current process
SCHEDQ          : 42    // Q of processes awaiting scheduling
ESCHEDQ         : 43    // End of this q
LOGIN.CHAIN     : 44    // Chain of login request blocks
END.LOGIN.CHAIN : 45    // End of this chain
JOBTABLE        : 46    // Table of user PDs
SHAREABLEDEVICES: 47    // Chain of all sharable DDBs
SINGLEACCESSDEVICES: 48 // Chain of all single user DDBs
DATE            : 49    // Holds date
SEC             : 50
MIN             : 51
HOUR            : 52    // Hold time
IDLETIME        : 53    // System idle time
DAYOFWEEK       : 54
PROCESSES       : 55    // Count of active user processes
MAXCORE         : 56    // Maximum core request that can be made
CORESIZE        : 57    // Sizes of user core images
PROTECT.TIMES   : 58    // In-core protect times for users
CONTEXT.CHANGES : 59    // Number of times scheduler is invoked
$)

MANIFEST $( SYS.TABLE.SIZE = 20 $)


GLOBAL $(  // Machine-dependent m/c routines, etc.
IDWP            : 100   // Indefinite wait 'P' operation
AUTOLOGOUT      : 101   // Automatic logout function
LOCK            : 104   // Disables breaks
UNLOCK          : 105   // Enables breaks
LOADGO          : 106   // Loads a process environment and enters it
SET.UP.ENV      : 107   // Initialises a process environment
SEMAPHORE       : 108   // Initialises a semaphore
MDINIT          : 109   // Machine-dependent initialisation
DISC.IO         : 110   // Disc I/O routine
IDLE            : 111   // System idle loop
P               : 112   // Dijkstra's primitives
V               : 113
CP              : 114
CV              : 115
VP              : 116
SHUTOFF         : 117    // Closes down I/O subsystem
RESOURCE        : 118   // Resource allocation function
ACTIVE.TTYS     : 119   // Number of active ttys
TRAPCHECK       : 120   // Checks for tty trap
KILL            : 121   // Forces a process to be killed
$)

GLOBAL $(  // Free space administration
INITIALISE      : 122   // Initialises the free space vector
NEWVEC          : 123   // Allocates an area of storage
FREE            : 124   // Returns an area of storage
$)

GLOBAL $(
ENCODE          : 125   // Password encoding routine
$)

GLOBAL $(  // User I/O functions
OPEN.INPUT.STREAM: 126  // Opens an input stream
OPEN.OUTPUT.STREAM: 127 // Opens an output stream
OPEN.IO.STREAM  : 128   // Opens a 2-way stream
CLOSE.STREAM    : 129   // Closes a stream
LOSE.STREAM     : 130   // Loses a stream
RESET           : 131   // Resets all streams
DELETE          : 132   // Deletes a file
RENAME          : 133   // Renames a file
CLOSE           : 134   // Closes all open I/O streams
READ.FROM.STREAM: 135   // General stream input function
WRITE.TO.STREAM : 136   // General stream output function
OPERATORS.CONSOLE:137   // Special stream for system errors
DEVDEPFUNCTION  : 138   // Device dependent function
WRONG.DIRECTION : 139   // I/O in wrong direction
FINDDEVICE      : 140   // Searches device chains
$)

GLOBAL $(  // Monitor I/O functions
WRITES          : 141   // Output a string
READNUMBER      : 142   // Reads integer in a given base
WRITECH         : 143   // Outputs a character
READCH          : 144   // Inputs a character
PRINT           : 145   // Formatted output routine
$)

GLOBAL $(
PRIVILEGED      : 146   // Checks process privileges
$)

GLOBAL $(  // Teletype I/O routines
TTYASSIGN       : 147   // Assigns a tty
TTYREAD         : 148   // Tty character input routine
TTYWRITE        : 149   // Tty character output routine
$)

GLOBAL $(  // System initialisation routines
IOSYSTEM        : 150   // Sets up I/O system data structure
HEADERS         : 151   // Types header message on all ttys
FINDCOMMAND     : 152   // Command search function (overlaid)
COMMANDS        : 153   // Declares monitor commands
COMMAND.VECTOR  : 154   // Vector of packed monitor commands
COMMAND.FUNCTION: 155   // Vector of command functions
CALLER          : 156   // Calls functions with error exits
OVCALLER        : 157   // Same but with overlaid functions
SKIP            : 160   // Skips input stream to end of line
$)

GLOBAL $(  // Routines for creating new processes
CREATEJOB       : 161   // Creates an on-line user job
CLEANUP         : 163   // Cleans up data structure on process deletion
$)

GLOBAL $(  // The null function, etc.
NULL            : 164
EOF             : 165   // Always returns an end-of-file
// ** out of sequence
CTLOPEN         : 162   // Opens a stream to device 'CTL'
$)

GLOBAL $(  // Global labels
COMMAND.DECODER : 166   // Reads commands from job control stream
SYSTEM.START    : 167   // Start address of system process
ERRORETURN      : 168   // Error return from a system call
$)

GLOBAL $(  // Error functions
ERROR.REPLY     : 169   // System call error function
SYSTEM.ERROR    : 170   // Irrecoverable error
JOB.ERROR       : 171   // User job error
DIAGNOSIS       : 172   // Diagnostic error trap
FAIL            : 173   // Filing system failure routine
COMMAND.ERROR   : 174   // Reports monitor command errors
$)

GLOBAL $(  // Global semaphores
SPACEWAIT       : 175   // Free space chain mutex
PRINT.MUTEX     : 176   // Mutex about print function
MMANGR.WAIT     : 177   // In-core protect time expiry wait semaphore
JOBTABLEMUTEX   : 178   // Mutex about job table updates
DIRECTORY.MUTEX : 179   // Mutex about directory accesses
$)

GLOBAL $(  // Machine-dependent BCPL functions
DNAME           : 180   // Returns a device name
LNAME           : 181   // Returns a device logical name
PACKCOMMAND     : 182   // Packs up a command from an unpacked string
STRING          : 183   // Converts a device name to a BCPL string
INIT.PERIPHERALS: 184   // Initialises peripherals
READCOMMAND     : 186   // Reads a command from user's tty
READDEVICENAME  : 187   // Reads a device name from user's tty
SETDATEANDTIME  : 188   // Sets up date and time
TIME            : 189   // Returns time in some format
$)

GLOBAL $(  // User functions
LOGOUT          : 190   // Removes process from system
PROCESSINFORMATION:191  // Returns data from PD
LOGIN           : 192   // Produces clean PD for new user
EXIT            : 193   // Exit from user process
ASSIGNDEVICE    : 195   // Obtains an I/O device
DEASSIGNDEVICE  : 196   // Returns an I/O device
SUMMARY         : 198   // Provides system statistics
SYSTEM.PD       : 199   // Points to system PD
MMANGR.PD       : 200   // Points to memory manager PD
$)

GLOBAL $(  // Monitor command functions
SYSTATUS        : 201   // Outputs current system status
RESOURCES       : 202   // Outputs current free device list
SHUTDOWN        : 203   // Closes system down
STREAM.STATUS   : 204   // Outputs status of user streams
KJOB            : 205   // Logs user off system
LOG             : 206   // Runs login program
SYSTEST         : 207   // System test function
RUNSYSPROG      : 208   // Runs a system program
CLOSER          : 209   // Closes all open streams
ASSIGN          : 210   // Gets an I/O device
DEASSIGN        : 211   // Releases an I/O device
DEVICES         : 212   // Lists users assigned devices
RESETER         : 213   // Loses all open streams
REMOVER         : 214   // Removes a process from the system
SUSPENDER       : 215   // Suspends a process
RESUMER         : 216   // Resumes a suspended process
CORE            : 217   // Change/give core allocation
SAVE            : 218   // Saves a user's core image
RUN             : 219   // Runs a previously saved core image
RUNEDITOR       : 220   // Runs the editor program
$)

GLOBAL $(  // The filing system
KILLUFD         : 229   // Removes a UFD (leaves files on disc)
DISCBUFFER1     : 230   // Disc core buffer
READ.TO.BUFFER1 : 231   // Reads a block to disc buffer 1
MAP.AREA        : 232   // Core buffer for reading disc map
DISCBUFFER1.USE : 233   // Mutex semaphore about buffer 1
WRITE.FROM.BUFFER1:234  // Writes a block from disc buffer 1
MAP.USE         : 235   // Mutex semaphore about map area
INITIALISEDISC  : 236   // Function to initialise disc
MAP             : 237   // Finds next block in a chain
GETBLOCK        : 238   // Gets a block from the free chain
CHAIN           : 239   // Appends a block to the chain
RETURNCHAIN     : 240   // Returns a chain to free space
CREATEUFD       : 241   // Creates a blank UFD
OUTMAP          : 242   // Outputs current disc map block
SEARCHMFD       : 243   // Searches MFD for a given user
SEARCHFCBCHAIN  : 244   // Searches file control block chain
SEARCHUFD       : 245   // Searches a UFD for given file
CUDIRBLK        : 246   // Current block in directory search
CHECKPROTECTION : 247   // Checks file access protection
MFDBLK          : 248   // Start block of MFD
ENDMFDBLK       : 249   // End block of MFD
EXTENDMFD       : 250   // Lengthens MFD by one block
ALTERFCBCHAIN   : 251   // Mutex semaphore about FCB chains
ADDNEWUSER      : 252   // Creates new MFD entries
UPDATEFRB       : 253   // Fills in FRB entries
CREATEFCB       : 254   // Creates FCB and places on chain
KILLFCB         : 255   // Deletes an FCB from chain
CREATEABILITY   : 256   // Checks ability to create a file
MATCHFILES      : 257   // Compares two file names (3 word blocks)
READDIRECTORYENTRY:258  // Gets information about a file
DSKCLOSEREAD    : 259   // Closes an input file
DSKLOSEREAD     : 260   // Loses an input file
DSKCLOSEWRITE   : 261   // Closes an output file
DSKLOSEWRITE    : 262   // Loses an output file
DISC.READ       : 263   // Routine to read a block and wait
DISC.WRITE      : 264   // Routine to write a block and wait
FINDUFDENTRY    : 265   // Searches UFD for update entries
$)

GLOBAL $(  // Disc functions
DODISCIO        : 266   // Basic disc I/O routine
OVDSKDEP        : 267   // Overlaid part of disc device dependent function
DSKFILEOPEN     : 268   // Opens disc files
DSKDEP          : 269   // Disc device dependent function
DSKREAD         : 270   // Read function
DSKWRITE        : 271   // Write function
DSKOPEN         : 272   // Open function
DSKCLOSE        : 273   // Close stream to disc
DSKLOSE         : 274   // Lose disc stream
DSKLOOKUP       : 275   // Open input file
DSKENTER        : 276   // Open file for output
DSKINOUT        : 277   // Open files for input and output
DSKDELETE       : 278   // Delete a file
DSKRENAME       : 279   // Rename a file
DSKDIRFN        : 280   // Get directory entry for file
DISC.READ.REQUEST:281   // Enters read rq in disc chain
DISC.WRITE.REQUEST:282  // Enters write rq in disc chain
EXTENDFILE      : 283   // Extends a file by one block
FREEBUFFERS     : 284   // Frees a buffer ring
DSKBLOCKREAD    : 285   // Block read routine
DSKBLOCKWRITE   : 286   // Block write routine
$)

GLOBAL $(  // General I/O routines
BUFFERCONSTANT  : 292   // Number of buffers in a ring
SETUPOUTPUTBUFFER:295   // Initialises buffer pointers, etc.
WAIT            : 296   // Waits for a transfer to finish
SETUPINPUTBUFFER: 297   // Initialises buffer pointers, etc.
GETBYTE         : 298   // Gets a value from a buffer
PUTBYTE         : 299   // Puts a value in a buffer
WORDSUSED       : 300   // Returns words used in a buffer
$)

GLOBAL $(  // Main system function
RUNSYSTEM       : 310   // Schedules processes and runs them
RUNPROCESS      : 314   // Enters a new process on the schedule wait q
$)

GLOBAL $(  // Overlay functions
OVERLAY.CALL    : 315   // Calls a routine in an overlay
OVERLAY.TABLE   : 316   // Table of overlay block numbers
OVERLAY.AREA    : 317   // Ptr to the overlay transient area
OVERLAY.PENDING : 318   // Semaphores controlling...
USE.OVERLAY     : 319   // ...the overlays
USERS.MUTEX     : 320
OVEXIT          : 321   // Exits correctly from an overlay
OVJOB.ERROR     : 322   // Job error called from an overlay
OVFAIL          : 323   // Overlayed failure routine
$)

GLOBAL $(  // Extra functions for background sub-system
BACKFAIL        : 329   // Background fail routine
BACKLOG         : 330   // Logs in a background job
BACKGROUND.START: 331   // Special start-up routine for background job
BACKREAD        : 332   // Read routine for background jobs
NEWPD           : 333   // Points to newly created PD
$)

GLOBAL $(  // Further BCPL machine-dependent functions
ENTER           : 334   // Enters a user mode program
WRITEFILE       : 335   // Output a file title
GETFILE         : 336   // Reads a file spec to a vector
MONITOR.CALL    : 337   // Function applied on an extracode
SAVEIMAGE       : 338   // Actually saves core image
// ** out of sequence
SYSFILENAME     : 324   // Maps a string to a filespec
$)

GLOBAL $(  // Process control functions
STOPME          : 340   // Suspends calling process
COMMUNICATE     : 341   // Basic inter-process communication routine
SEND.BLOCK      : 342   // Sends data block to user process
REPLY           : 343   // Sends a reply
BLOCK.AVAILABLE : 344   // Checks if data block available
WAIT.BLOCK      : 345   // Waits for a data block
COMMUNICATE.REPLY:346   // Sends a reply to a user process
SUSPEND         : 347   // Suspends a process (to all levels)
RESUME          : 348   // Resumes suspended process
REMOVE          : 349   // Removes a process from the system (to all levels)
SUSPENDANDWAIT  : 351   // Suspends a process and waits for completion
FLUSH           : 352   // Removes messages belonging to deleted process
$)

GLOBAL $(  // Disc verification checks
VERIFYFREECHAIN : 360   // Checks free chain is correct
VERIFYMFD       : 361   // Checks all files are correct
BITMAP1         : 362   // Holds free chain bitmap
DISCMAP         : 363   // Holds disc block map
FREECHAINSIZE   : 364   // Initial size of free chain
RECREATEFREECHAIN:365   // Re-creates the free chain
$)

GLOBAL $(  // Memory management routines
MMANGR          : 370   // Start address of memory manager
MOVECOREBLOCKS  : 371   // Re-shuffler's block move routine
SWAPBASE        : 372   // Start block of swap area
GETCORE         : 373   // Finds current core allocation
CHANGECORE      : 374   // Changes core allocation
ACCESSCOREIMAGE : 376   // Requests loding of user's core image
RELINQUISH      : 377   // Frees use of core image
GETWORD         : 378   // Gets value from user's core image
PLANT           : 379   // Puts word in user's core image
MAPADDRESS      : 380   // Returns absolute core address from relative user address
ZEROCORE        : 381   // Clears core
$)

GLOBAL $(  // Even more BCPL machine-dependent functions
ALPHA           : 390
PACK            : 391
RNO             : 392
$)

// End of file SYSHDG.BPL

