
// File a68k5.b

// Assembler for Motorola MC68000 - segment 5

// UKC version - R.D. Eager   MCMLXXXVIII


GET "libhdr"

GET "a68k.h"


LET sizefield( size )  =  VALOF
$(
    SWITCHON  size  INTO
    $(
        CASE ts.long     : RESULTIS  #B10
        CASE ts.word     : RESULTIS  #B01
        CASE ts.byte     : RESULTIS  #B00
        CASE ts.none     : RESULTIS  sizefield( ts.default )

        CASE ts.short    : complain(86 )
        DEFAULT          : complain(0 )
    $)
$)



AND eafield()  =  VALOF
$(
//  Look at the effective address  represented by op.ea, etc.
//  and return the 6 bit representation of it.

    SWITCHON  op.ea  INTO
    $(
        CASE am.Dr           : RESULTIS #B000000  +  exp
        CASE am.Ar           : RESULTIS #B001000  +  exp
        CASE am.Ar.ind       : RESULTIS #B010000  +  exp
        CASE am.Ar.pi        : RESULTIS #B011000  +  exp
        CASE am.Ar.pd        : RESULTIS #B100000  +  exp
        CASE am.abs16        : RESULTIS #B111000
        CASE am.abs32        : RESULTIS #B111001
        CASE am.PC.disp      : RESULTIS #B111010
        CASE am.PC.index     : RESULTIS #B111011

//      CASE am.imm3         :
//      CASE am.imm16        :
//      CASE am.imm32        :
        DEFAULT              : RESULTIS #B111100

        CASE am.Ar.disp      : RESULTIS #B101000  +  registers!p.ptr1
        CASE am.Ar.index     : RESULTIS #B110000  +  registers!p.ptr0!p.ptr1
    $)
$)



AND genea()  BE
$(
    LET bs  =  0

    SWITCHON  op.ea  INTO
    $(
        CASE am.Ar           : IF  instr.size = ts.byte  THEN  complain(29 )
        CASE am.Dr           :
        CASE am.Ar.ind       :
        CASE am.Ar.pi        :
        CASE am.Ar.pd        : 

                               RETURN


        CASE am.Ar.disp      : //  registers  ->  (Ar, regnum, rsize)

                               TEST  pass1  THEN  codeword( 0 )
                               ELSE

                               TEST  registers!p.ptr0 = s.Ar  THEN
                                   TEST  registers!p.ptr2 = ts.none
                                         THEN  codeword( exp )
                                         ELSE  complain(81 )

                               ELSE  complain(134 )

                               ENDCASE


        CASE am.Ar.index     : //  registers  ->  ((Ar, rnum, rsize), (Ir, rnum, rsize ))

                               TEST  pass1  THEN  codeword( 0 )
                               ELSE
                               $(
                                   LET Ar  =  registers!p.ptr0
                                   LET Ir  =  registers!p.ptr1
                                   LET It  =  Ir!p.ptr0
                                   LET In  =  Ir!p.ptr1
                                   LET Is  =  Ir!p.ptr2

                                   LET l   =  Is = ts.long  ->  1,
                                              Is = ts.word  ->  0,
                                              Is = ts.none  ->  0,
                                                                complain(87 )

                                   LET r   =  It = s.Ar     ->  1,  0

                                   UNLESS  -128 <= exp <= +127  DO  complain(72 )

                                   TEST  Ar!p.ptr2 = ts.none
                                         THEN  codeword( (r  << 15)    |
                                                         (In << 12)    |
                                                         (l  << 11)    |
                                                         (exp & #XFF)  )

                                   ELSE  complain(81 )
                               $)

                               ENDCASE


        CASE am.abs32        : IF  pass2  &  externalref  THEN
                                   addexternalref( externalsymb, location + codewords*2  )

                               codeword( exp >> 16    )

        CASE am.abs16        : codeword( exp & #XFFFF )

                               ENDCASE


        CASE am.PC.disp      : //  The current program counter and the expression
                               //  MUST be of the same data type.

                               TEST  pass1  THEN  codeword( 0 )
                               ELSE
                               $(
                                   LET pc  =  location + (codewords * 2)
                                   LET o   =  exp - pc

                                   UNLESS  (locmode = s.abs  &  absolute( exptype ))  |
                                           (locmode = s.rel  &  relocatable( exptype ))  DO

                                           complain(88 )

                                   UNLESS  -32768 <= o <= +32767  DO  complain(177 )

                                   codeword( o & #XFFFF )
                               $)

                               ENDCASE


        CASE am.PC.index     : TEST  pass1  THEN  codeword( 0 )
                               ELSE
                               $(
                                   LET Ir  =  registers
                                   LET It  =  Ir!p.ptr0
                                   LET In  =  Ir!p.ptr1
                                   LET Is  =  Ir!p.ptr2

                                   LET l   =  Is = ts.long  ->  1,
                                              Is = ts.word  ->  0,
                                              Is = ts.none  ->  0,
                                                                complain(87 )

                                   LET r   =  It = s.Ar     ->  1,  0

                                   UNLESS  (locmode = s.abs  &  absolute( exptype ))  |
                                           (locmode = s.rel  &  relocatable( exptype ))  DO

                                           complain(88 )

                                   exp  :=  exp - (location + 2)

                                   UNLESS  -128 <= exp <= +127  DO  complain(72 )

                                   codeword(  (r  <<  15)    |
                                              (In << 12)     |
                                              (l  <<  11)    |
                                              (exp & #XFF)   )
                               $)

                               ENDCASE


//      CASE am.imm16        :
//      CASE am.imm32        :
        DEFAULT              : //  Immediate data.  The size is given
                               //  by "instr.size"

                               bs  :=  bytesize( instr.size )

                               IF  bs = 4  &  (pass2 & externalref)  THEN
                                   addexternalref( externalsymb, location + codewords*2 )

                               IF    bs = 4  THEN  codeword( exp >> 16 )
                               TEST  bs = 1  THEN  codeword( exp & #XFF )
                                             ELSE  codeword( exp & #XFFFF )
    $)
$)



AND addexternalref( symbol, address )  BE  IF  pass2  THEN
$(
    LET s  =  extrnsymbols

    UNTIL  s = 0  DO
    $(
        TEST  s!e.symbol = symbol  THEN
        $(
            LET refsr   =  s!e.refsr
            LET refsa   =  s!e.refsa
            LET countr  =  s!e.countr
            LET counta  =  s!e.counta

            TEST  locmode = s.abs  THEN
            $(
                //  Update the absolute list.

                s!e.refsa   :=  heap2( refsa, address )
                s!e.counta  :=  counta + 1
            $)
            ELSE
            $(
                //  Update the relocatable list

                s!e.refsr   :=  heap2( refsr, address )
                s!e.countr  :=  countr + 1
            $)

            RETURN
        $)

        ELSE  s  :=  s!e.link
    $)

    complain(0 )
$)



AND codeword( word )  BE
$(
    codewords  :=  codewords + 1

    stackvalue( s.abs16, 2, word, no, 0 )
$)




AND stackvalue( dtype, dsize, dvalue, dext, dsymb )  BE
$(
    LET offset  =  nitems * cb.size

    codebuff!(offset + cb.dtype)   :=  dtype
    codebuff!(offset + cb.dsize)   :=  dsize
    codebuff!(offset + cb.dvalue)  :=  dvalue
    codebuff!(offset + cb.dext)    :=  dext
    codebuff!(offset + cb.dsymb)   :=  dsymb

    nitems                         :=  nitems + 1

    IF  nitems > codesize  THEN  error( 178 )
$)



AND clearbuffer()  BE
    FOR  i = 0  TO  maxllen-1  DO  outbuff % i  :=  '*S'



AND swapoperands()  BE
$(
    LET t1  =  op.ea
    LET t2  =  exptype
    LET t3  =  exp
    LET t4  =  registers
    LET t5  =  externalref
    LET t6  =  externalsymb

    op.ea             :=  op1.ea
    exptype           :=  op1.exptype
    exp               :=  op1.exp
    registers         :=  op1.registers
    externalref       :=  op1.externalref
    externalsymb      :=  op1.externalsymb

    op1.ea            :=  t1
    op1.exptype       :=  t2
    op1.exp           :=  t3
    op1.registers     :=  t4
    op1.externalref   :=  t5
    op1.externalsymb  :=  t6
$)





AND setloc( newloc )  BE
$(
    UNLESS  (newloc & addressmask) = 0  DO  complain(138)

    IF  newloc > maxloc  THEN  maxloc  :=  newloc
    IF  newloc < minloc  THEN  minloc  :=  newloc

    location  :=  newloc
$)



AND changemode( newmode )  BE
$(
    UNLESS  locmode = newmode  DO
    $(
        TEST  locmode = s.abs  THEN
        $(
            absmin      :=  minloc
            absmax      :=  maxloc
            absloc      :=  location
            absrp16     :=  relp16
            absrp32     :=  relp32
            minloc      :=  relmin
            maxloc      :=  relmax
            location    :=  relloc
            codevec     :=  relvec
            relocvec16  :=  relrvec16
            relocvec32  :=  relrvec32
            relp16      :=  relrp16
            relp32      :=  relrp32
        $)
        ELSE
        $(
            relmin      :=  minloc
            relmax      :=  maxloc
            relloc      :=  location
            relrp16     :=  relp16
            relrp32     :=  relp32
            minloc      :=  absmin
            maxloc      :=  absmax
            location    :=  absloc
            codevec     :=  absvec
            relocvec16  :=  absrvec16
            relocvec32  :=  absrvec32
            relp16      :=  absrp16
            relp32      :=  absrp32
        $)
    $)

    locmode  :=  newmode
$)



AND triposmodule()  BE
$(
//  Output the object module.

    LET o     =  output()
    LET eabs  =  countextrnsymbols( e.counta )
    LET erel  =  countextrnsymbols( e.countr )

    selectoutput( codestream )

    //  First output the Relocatable section...
    //  Buffered in units of 4 bytes.

    UNLESS  relmax = 0  DO
    $(
        LET r  =  relmax/bytesper68000word

        systemword( t.hunk )
        writeword( r )
        writewords( relvec, r )
    $)

    // If it has any 16 bit relocation information, this next

    UNLESS  relrp16 = 0   DO
    $(
        systemword( t.reloc16 )
        writeword( relrp16 )
        writewordvec( relrvec16, relrp16 )
    $)

    //  Now the 32 bit relocation info

    UNLESS  relrp32 = 0  DO
    $(
        systemword( t.reloc32 )
        writeword( relrp32 )
        writewordvec( relrvec32, relrp32 )
    $)


    //  We must now put out the external references in the relocatable
    //  section, and the internal definitions of both sections.


    UNLESS  entrysymbols = 0  &  erel = 0  DO
    $(
        LET ptr  =  entrysymbols

        systemword( t.ext )

        UNTIL  ptr = 0  DO
        $(
            LET symbol  =  ptr!e.symbol
            LET type    =  symbol!st.type  &  st.type.mask
            LET value   =  symbol!st.value
            LET name    =  symbol+st.name
            LET l       =  name % 0
            LET length  =  l > maxextlength  ->  maxextlength, l
            LET size    =  maxextlength = 7  ->  2, 4
            LET buff    =  VEC 16/bytesperword

            buff % 0  :=  relocatable( type )  ->  ext.defrel, ext.defabs

            FOR  i = 1  TO  length  DO
                 buff % i  :=  ascii.value( name % i )

            FOR  i = length + 1  TO  maxextlength  DO
                 buff % i  :=  ascii.value( '*S' )

            writewords( buff, size )
            writeword( value )

            ptr  :=  ptr!e.link
        $)

        //  Now do the external references.

        ptr  :=  extrnsymbols

        UNTIL  ptr = 0  DO
        $(
            LET symbol  =  ptr!e.symbol
            LET refs    =  ptr!e.refsr
            LET count   =  ptr!e.countr
            LET name    =  symbol+st.name
            LET l       =  name % 0
            LET length  =  l > maxextlength  ->  maxextlength, l
            LET size    =  maxextlength = 7  ->  2, 4
            LET buff    =  VEC 16/bytesperword

            UNLESS  count = 0  DO
            $(
                buff % 0  :=  ext.ref

                FOR  i = 1  TO  length  DO
                     buff % i  :=  ascii.value( name % i )

                FOR  i = length + 1  TO  maxextlength  DO
                     buff % i  :=  ascii.value( '*S' )

                writewords( buff, size )
                writeword( count )

                FOR  i = 1  TO  count  DO
                $(
                    writeword( refs!r.address )

                    refs  :=  refs!r.link
                $)
            $)

            ptr  :=  ptr!e.link
        $)

        systemword( 0 )
    $)

    //  Now the absolute section - very much the same as before.

    UNLESS  absmax = 0  DO
    $(
        LET a  =  (absmax - absmin)/bytesper68000word

        systemword( t.abshunk )
        writeword( absmin/bytesper68000word )
        writeword( a )
        writewords( absvec + absmin/bytesperword, a )
    $)

    // If it has any 16 bit relocation information, this next

    UNLESS  absrp16 = 0   DO
    $(
        systemword( t.absrel16 )
        writeword( absrp16 )
        writewordvec( absrvec16, absrp16 )
    $)

    //  Now the 32 bit relocation info

    UNLESS  absrp32 = 0  DO
    $(
        systemword( t.absrel32 )
        writeword( absrp32 )
        writewordvec( absrvec32, absrp32 )
    $)

    //  Now the external references for the absolute section.

    UNLESS  eabs = 0  DO
    $(
        LET ptr  =  extrnsymbols

        systemword( t.ext )

        UNTIL  ptr = 0  DO
        $(
            LET symbol  =  ptr!e.symbol
            LET refs    =  ptr!e.refsa
            LET count   =  ptr!e.counta
            LET name    =  symbol+st.name
            LET l       =  name % 0
            LET length  =  l > maxextlength  ->  maxextlength, l
            LET size    =  maxextlength = 7  ->  2, 4
            LET buff    =  VEC 16/bytesperword

            UNLESS  count = 0  DO
            $(
                buff % 0  :=  ext.ref

                FOR  i = 1  TO  length  DO
                     buff % i  :=  ascii.value( name % i )

                FOR  i = length + 1  TO  maxextlength  DO
                     buff % i  :=  ascii.value( '*S' )

                writewords( buff, size )
                writeword( count )

                FOR  i = 1  TO  count  DO
                $(
                    writeword( refs!r.address )

                    refs  :=  refs!r.link
                $)
            $)

            ptr  :=  ptr!e.link
        $)

        systemword( 0 )
    $)

    systemword( t.end )

    newline()

    selectoutput(o)
$)



AND countextrnsymbols( offset )  =  VALOF
$(
    LET count  =  0
    LET ptr    =  extrnsymbols

    UNTIL  ptr = 0  DO
    $(
        count  :=  count + ptr!offset
        ptr    :=  ptr!e.link
    $)

    RESULTIS  count
$)



AND systemword( word )  BE
$(
    writef( "*N*N%X8", word )
    totalwords  :=  0
$)


AND writewords( wordvec, words )  BE
    FOR  i = 0  TO  words-1  DO  writeword( wordvec!i )


AND writewordvec( wordvec, words )  BE
    FOR  i = 0  TO  words-1  DO  writeword( wordvec!i )


AND writeword( word )  BE
$(
    IF  totalwords REM 8  =  0  THEN  newline()
    writef( "%X8  ", word )
    totalwords  :=  totalwords + 1
$)



AND motorolamodule()  BE
$(
// Output a Motorola type Object Module.  The specification of this module
// does not allow for relocation, and so, if the user has compiled relocatable
// code, this is an error.

    LET o  =  output()

    UNLESS  relmax = 0  &  relrp16 = 0  &  relrp32 = 0  DO
    $(
        selectoutput( sysout )
        writes( "MOTOROLA module cannot handle Relocatable code*N" )
        selectoutput( o )

        RETURN
    $)

    UNLESS  extrnsymbols = 0  &  entrysymbols = 0  DO
    $(
        selectoutput( sysout )
        writes( "MOTOROLA module cannot handle External Symbols*N" )
        selectoutput( o )

        RETURN
    $)

    selectoutput( codestream )

    // Output the dummy sign-on record required by some loaders

    writes("S004000000FB*N")

    $(  //  Loop to write out the records of the module.

        LET cs  =  0
        AND notallzeros = ?

        FOR  addr = absmin  TO  absmax-1  BY  32  DO
        $(
            LET left    =  absmax - addr
            LET nbytes  =  left > 32  ->  32, left
            LET length  =  4 + nbytes

            notallzeros := /* FALSE */ TRUE

            FOR i = addr to addr + nbytes - 1 DO
               IF absvec%i NE 0 THEN notallzeros := TRUE

            IF notallzeros THEN
            $( cs  :=  length + ((addr)       & #XFF) + 
                                ((addr >> 8)  & #XFF) +
                                ((addr >> 16) & #XFF)

               writes("S2"); writhex(length, 2); writhex(addr, 6)

               FOR  i = addr  TO  addr + nbytes - 1  DO
               $(
                   LET byte  =  absvec % i

                   cs  :=  cs + byte

                   writhex(byte, 2)
               $)

               writhex(NOT cs, 2)
               newline()
            $)
        $)

        length := 4
        cs    :=  length + ((entry.point)       & #XFF) + 
                           ((entry.point >> 8)  & #XFF) +
                           ((entry.point >> 16) & #XFF)

        writes("S8"); writhex(length, 2); writhex(entry.point, 6)
        writhex(NOT cs, 2)
        newline()
    $)

    UNLESS  absrp16 = 0  &  absrp32 = 0  DO
    $(
        selectoutput( sysout )
        writes( "MOTOROLA module cannot deal with Relocation within code*N" )
    $)

    selectoutput( o )
$)



AND intelhexmodule()  BE
$(
//  Output an INTEL standard HEX module.  This will work with both
//  absolute and relocatable code, provided that there are no 32-bit
//  relocatable values involved.  Unfortunately, it is not possible to mix
//  Relocatable and Absolute code in this module format, and so if both have
//  been produced, this is also an error.

    LET o  =  output()

    UNLESS  relmax = 0  NEQV  absmax = 0  DO
    $(
        selectoutput( sysout )

        UNLESS  relmax = 0  &  absmax = 0  DO
            writes( "INTEL HEX module cannot deal with mixed Absolute and *
                    *Relocatable code*N" )

        selectoutput( o )

        RETURN
    $)

    UNLESS  relrp32 = 0  &  absrp32 = 0  DO
    $(
        selectoutput( sysout )
        writes( "INTEL HEX module cannot deal with 32-bit relocation*N" )
        selectoutput( o )

        RETURN
    $)

    UNLESS  extrnsymbols = 0  &  entrysymbols = 0  DO
    $(
        selectoutput( sysout )
        writes( "INTEL HEX module cannot handle External symbols*N" )
        selectoutput( o )

        RETURN
    $)

    $(  //  Loop to write the records of the INTEL format.

        LET absm   =  relmax = 0

        LET base   =  absm  ->  absmin, 0
        LET size   =  absm  ->  (absmax - absmin), relmax

        LET top    =  base + size

        LET bvec   =  absm  ->  absvec,    relvec
        LET rvec   =  absm  ->  absrvec16, relrvec16
        LET rvecp  =  absm  ->  absrp16,   relrp16

        selectoutput( codestream )

        writes( absm -> "$      0500FE*N", "$      0501FD*N" )

        FOR  addr = base  TO  top-1  BY  32  DO
        $(
            LET left    =  top - addr
            LET nbytes  =  left > 32  ->  32, left

            LET lbyte   =  (addr)       &  #XFF
            LET hbyte   =  (addr >> 8)  &  #XFF

            LET cs      =  nbytes + lbyte + hbyte

            UNLESS  wordsized( addr )  DO
            $(
                selectoutput( sysout )
                writes( "INTEL HEX module cannot handle 24-bit addresses*N" )
                selectoutput( o )
                RETURN
            $)

            wrch(':')
            writhex(nbytes, 2); writhex(hbyte, 2); writhex(lbyte, 2)
            writes("00")

            FOR  i = addr  TO  addr + nbytes - 1  DO
            $(
                LET byte  =  bvec % i

                cs  :=  cs + byte

                writhex( byte, 2 )
            $)

            writhex(-cs, 2)
            newline()
        $)

        //  Now the relocation information.

        FOR  i = 0  TO  rvecp-1  BY  16  DO
        $(
            LET nwords  =  rvecp - i
            LET nbytes  =  (nwords > 16  ->  16, nwords) * 2
            LET cs      =  nbytes + 4

            wrch('$')
            writhex(nbytes, 2)
            writes("000004")

            FOR  j = 0  TO  nbytes/2 - 1  DO
            $(
                LET reladdr  =  rvec!j
                LET lbyte    =  (reladdr)       &  #XFF
                LET hbyte    =  (reladdr >> 8)  &  #XFF

                UNLESS  wordsized( reladdr )  DO
                $(
                    selectoutput( sysout )
                    writes( "INTEL HEX module cannot handle 24-bit relocation *
                            *addresses" )
                    selectoutput( o )
                    RETURN
                $)

                writhex( hbyte, 2 )
                writhex( lbyte, 2 )

                cs  :=  cs + hbyte + lbyte
            $)

            writhex(-cs, 2)
            newline()

            rvec  :=  rvec + nbytes/2
        $)

        writes( ":00000001FF*N" )
    $)

    selectoutput( o )
$)


AND writhex(n, p) BE
/* Special version of 'writehex' which ensures upper case output. */
$( LET m = n &#17
   IF p > 1 DO writhex(n >> 4, p - 1)
   wrch(m + (m < 10 -> '0', 'A' - 10))
$)

// End of file a68k5.b

