
// SECTION "EF10"   // Last modified 88-12-05

/*  The routines in this section are concerned with the interface
to the operating system. They are grouped  according  to  purpose
and within each group are listed in alphabetic order.  */
// NEEDS. "CHKFILE" // Needed by MTS.

GET "ef0.h"

GET "syshdr.h"

STATIC
{ byte_count        = ?     // for byte counts of files
  byte_count_excess = ?     // needed for 16 bit machines
  current_prefix    = FALSE // for remembering prompt
  work_hw_block     = -1    // highest checked block in workfile
}

LET start_ef10(n) BE
/* This is the last in a chain of starts.  */
{ // writes("<>start_ef10:*N")
  fix_attention()
  view_half := sys_mts -> 18,
               sys_470 -> 18,
               sys_rdos -> 11,
               sys_emas -> 10,
               sys_cpm -> 10,
               sys_tripos -> 10,
               sys_unix1 -> 10,
               sys_vms -> 10,
               sys_unix32 -> 10,
                             8     // (screen size-1)/2
  TEST sys_mts LOGOR sys_470 THEN
  { console_in_stream := findinputunit("GUSER")
    selectinput(console_in_stream)
    console_out_stream := findoutputunit("SERCOM")
    selectoutput(console_out_stream) }
  ELSE
    console_in_stream, console_out_stream := input(), output()
  IF sys_unix1 THEN
  { selectoutput(journal)
    endwrite()
    selectoutput(console_out_stream)
  }
  IF init_statics_ THEN
  { current_prefix := FALSE  // Initialise prompt handling
    IF sys_cpm THEN work_hw_block := -1 }
  IF sys_unix32 THEN
  { set_shell(); input_pending_ := FALSE; qmatch := xqmatch }
  IF sys_vms THEN
  { qmatch := xqmatch; vms_init() }
  check_system(n, computer, 10) }

/* --------------------device support ---------------------------
     The  following  group  is  concerned  with device support or
with character encoding.  */

LET accept_delete(i) = VALOF
/* For those  systems  in  which  the  device  support  does  not
properly  treat  the  delete  symbol,  the  following  may  be  a
satisfactory way to deal with it.  Note  that  the  line  pointer
must  be  set  back  two  places  because  of  the  loop  in
'got_text()'.  */
TEST sys_mts \/ sys_470 \/ sys_emas \/ sys_tripos \/
     sys_unix1 \/ sys_unix32 \/ sys_tripos \/
     sys_vms THEN RESULTIS i ELSE
{1 TEST i > 1 THEN
   { writes(sys_aos -> "*X19*S*X19", "*X08*S*X08")
     RESULTIS (i-2) }
   ELSE RESULTIS (i - 1) }1

AND accept_tab(i) = VALOF
/* This is provided for  those  operating  systems  whose  device
support routines do not properly treat the tab symbol.  */
TEST sys_mts \/ sys_470 \/ sys_emas \/ sys_tripos \/
     sys_unix1 \/ sys_unix32 \/ sys_cpm \/
     sys_vms THEN RESULTIS i ELSE
TEST sys_aos THEN { line%i := '*T'; RESULTIS i } ELSE
{1 LET i_tab = ((i+2) / 3) * 3
   IF i_tab > line_bsz THEN i_tab := line_bsz
   FOR j = i TO i_tab DO { line%j := '*S'; wrch('*S')  }
   RESULTIS i_tab  }1

AND bell() BE
/* This is called by 'read_file' and  'write_file'  to  ring  the
bell when the action has concluded.  */
{1 // trace("bell:")
   IF sys_emas THEN e.changecontext()
   TEST sys_mts LOGOR sys_470 THEN RETURN ELSE wrch(7) }1

AND digit_value(check_) = VALOF    // local to EF10
/* Yields the hexadecimal (or octal) value of  the  character  in
'cur_char'.   If  it  is  not  a valid digit, then -1 is yielded,
unless 'check_' is  true,  in  which  case  it  gives  a  warning
message.  */
{1 // trace("digit_value: check_=%N", check_)
   TEST hex_ THEN
   {T LET digit_ = ('0' <= cur_char <= '9')
      LET char = upper_case(cur_char)
      IF digit_ LOGOR ('A' <= char <= 'F') THEN
        RESULTIS
          digit_ -> (char - '0'), (char + 10 - 'A') }T
   ELSE IF ('0'<=char<='7') THEN RESULTIS (char - '0')
   IF check_ THEN warn(m_value)
   RESULTIS -1 }1

AND dump(c) BE
/*  Write the character 'c' lucidly, i.e., if it is not printable
then a '#' followed by the EBCDIC (or ASCII) value.  It tests for
printability by consulting a bit  map  of  printable  characters.
See EF17 for a program to produce a bitmap.  */
TEST ~ menu_pl THEN RETURN ELSE
{1 // trace("dump: c=%N", c)
   { LET index, bit = (c >> 4) LOGAND #XF, 1 << (c LOGAND #XF)
     LET word = index !
     (TABLE #X0000, #X0000, #XFFFF, #XFFFF,
            #XFFFF, #XFFFF, #XFFFF, #X7FFF,
            #X0000, #X0000, #X0000, #X0000,
            #X0000, #X0000, #X0000, #X0000)
   TEST ((word LOGAND bit) ~= 0) THEN
     { IF c = '#' THEN wrch('#'); wrch(c) }
   ELSE
   { wrch('#')
     TEST hex_ THEN writehex(c, 2) ELSE writeoct(c, 3) } }1

AND internal_code() = VALOF
/*  Yields  the  hexadecimal  or octal value following a '#' in a
pattern or replacement.  #N or #n means newline.  */
{1 LET n, c = digit_value(FALSE), cur_char
   get_ch()
   IF n = -1 THEN
   { IF c = 'N' LOGOR c = 'n' RESULTIS '*N'
     RESULTIS c
   }
   n := (n << (hex_ -> 4, 3)) + digit_value(TRUE)
   get_ch()
   TEST hex_ THEN RESULTIS n
   ELSE
   { n := (n << 3) + digit_value(TRUE)
     get_ch(); RESULTIS n }  }1

AND recover_eof() BE
/*  This is called to recover from accidental use of end of file,
particularly on MTS.  */
  TEST sys_mts LOGOR sys_470 THEN
  { endread()   //  close the console (probably)
    selectinput(findinput("**SOURCE**"))
    warn(m_end) }
  ELSE TEST sys_emas THEN
  { TEST foreground THEN
    { endread()   // Clear EOF flag
      warn(m_end)
    }
    ELSE contingency(65,-1,0)
                  // Force fatal error, saving the edit
  }
  ELSE TEST sys_vms THEN
  { TEST interactive THEN
    { endread()   // Clear EOF flag
      warn(m_end)
    }
    ELSE stop(chef_endoffile)
  }
  ELSE TEST sys_unix1 \/ sys_unix32 \/ sys_cpm THEN
    warn(m_end)
  ELSE RETURN

/* -------------------system communication ---------------------
     The   following  group  of  procedures  are  concerned  with
communication with the host operating system.  */

AND check_interrupt() BE
/* Test for attention interrupt.  If it  occurs  then  clean  the
flagged  lines,  by calling 'recover', to ensure the integrity of
the data.  */
{1 // trace("check_interrupt:")
   IF sys_mts \/ sys_470 \/ sys_unix \/
   sys_aos \/ sys_rdos \/ sys_unix1 \/ sys_vms THEN
   IF attentionpending THEN
   { recover()
     attentionpending := FALSE
     warn(m_attn) }
   IF sys_emas \/ sys_unix32 THEN
      IF attentionpending THEN
      { recover()
        reset_attention()
        warn(m_attn)
      }
   IF sys_tripos THEN
      IF testflags(1) THEN warn(m_attn)
   IF sys_fmgr THEN
   {H IF call(@sys_ifbrk, 0) THEN recover()
      warn(m_attn)  }H }1

AND do_sys_call() BE
/*  If  the  operand  of  QS is elided, then return to the system
without unloading the editor; otherwise interpret the operand  as
a system command.  */
TEST ~ menu_qs THEN RETURN ELSE
{1 // trace("do_sys_call:")
   TEST tmp_name%0 = 0
   THEN sys_return() ELSE sys_command(tmp_name) }1

AND fix_attention() BE
/*  Tell  the system that attention breaks will be trapped by the
editor.  */
{1 // writes("<>fix_attention:*N")
   IF sys_mts LOGOR
      sys_470 LOGOR
      sys_unix LOGOR
      sys_rdos THEN
   { catchattention(TRUE); attentionpending := FALSE }
   IF sys_emas THEN catchattention()
   IF sys_unix32 THEN catchattention()
   IF sys_vms THEN catchattention(TRUE)
   IF sys_tripos THEN testflags(1)
   IF sys_aos THEN catchattention(TRUE)
   IF sys_cpm THEN RETURN
   IF sys_fmgr THEN RETURN }1

AND get_param(p1, p2, p3) BE
/* The parameter from the system run command is considered as the
name of the file to be edited.  This name is copied to 'tmp_name'
which is later copied  to  'file_name'. Some  versions  accept  a
second  parameter, which is either the name of a command file, or
a command line. */
{1 // writef("<>get_param: p1=|%S| p2=|%S| p3=|%S|*N",p1,p2,p3)
   tmp_name%0 := 0
   IF sys_rdos THEN
   {rdos LET i = input()
     LET switches = VEC 28
     LET n = findinput(get_ust(0)=1 -> "FCOM.CM", "COM.CM")
     get_arg(n,tmp_name,switches)
     tmp_name%0, cmd_line%0 := 0, 0
     IF get_arg(n,tmp_name,switches) THEN
       IF get_arg(n,cmd_line+1,switches) THEN
       { cmd_line%0 := cmd_line%2 + 2
         cmd_line%1, cmd_line%2 := 'X', 'F' }
     selectinput(n); endread()
     selectinput(i) }rdos
   IF sys_aos THEN
   {AOS LET switches = VEC 31
        IF comarg(tmp_name, switches) = 0 THEN
        SWITCHON comarg(tmp_name, switches) INTO
        { CASE endstreamch: tmp_name%0 := 0
          CASE 0: RETURN }; warn(m_syntax) }AOS
   IF sys_mts LOGOR sys_470 THEN
   {m LET p_len = p1%0
      LET par1_len = p_len
      LET par2_len = 0
      cmd_line%0 := 0
      FOR i = 1 TO p_len DO
        IF p1%i = '*S' THEN
        { par1_len := i-1; par2_len := p_len-par1_len-1; BREAK }
      copy_bytes(par1_len,p1,1,tmp_name,1)
      tmp_name%0 := par1_len
      copy_bytes(par2_len,p1,par1_len+2,cmd_line,1)
      IF par2_len > 0 THEN cmd_line%0 := par2_len  }m
   IF sys_emas THEN
   {e LET p_len = p1%0
      LET par1_len = p_len
      LET par2_len = 0
      cmd_line%0 := 0
      FOR i = 1 TO p_len DO
        IF p1%i = ',' THEN
        { par1_len := i-1; par2_len := p_len-par1_len-1; BREAK }
      copy_bytes(par1_len,p1,1,tmp_name,1)
      tmp_name%0 := par1_len
      copy_bytes(par2_len,p1,par1_len+2,cmd_line,1)
      IF par2_len > 0 THEN cmd_line%0 := par2_len; emas_init() }e
   IF sys_tripos THEN
   { LET v = VEC maxstrlength/bytesperword
     IF rdargs("file,cmdline",v,maxstrlength/bytesperword) =
          0 THEN { writes("Bad args*N"); postlude(); stop(20) }
     copy_string(v!0,tmp_name)
     TEST v!1 NE 0 THEN copy_string(v!1,cmd_line)
     ELSE cmd_line%0 := 0
   }
   IF sys_cpm THEN
   {C LET p_len = p1%0
      LET par1_len = p_len
      AND par2_len = 0
      AND skip_ = TRUE
      AND spcount = 0
      cmd_line%0 := 0
      FOR i = 1 TO p_len DO
      { LET c = p1%i
        IF skip_ & (c = '*S') THEN { spcount := spcount+1; LOOP }
        skip_ := FALSE
        IF c = '*S' THEN
        { par1_len := i-1-spcount
          par2_len := p_len-par1_len-1-spcount; BREAK } }
        IF par2_len = 0 THEN par1_len := par1_len - spcount
        copy_bytes(par1_len,p1,spcount+1,tmp_name,1)
        tmp_name%0 := par1_len
        copy_bytes(par2_len,p1,par1_len+2+spcount,cmd_line,1)
        IF par2_len > 0 THEN cmd_line%0 := par2_len }C
   IF sys_vms THEN
   {V LET p_len = p1%0
      LET par1_len = p_len
      AND par2_len = 0
      AND skip_ = TRUE
      AND spcount = 0
      cmd_line%0 := 0
      FOR i = 1 TO p_len DO
      { LET c = p1%i
        IF skip_ & (c = '*S') THEN { spcount := spcount+1; LOOP }
        skip_ := FALSE
        IF c = '*S' THEN
        { par1_len := i-1-spcount
          par2_len := p_len-par1_len-1-spcount; BREAK } }
        IF par2_len = 0 THEN par1_len := par1_len - spcount
        copy_bytes(par1_len,p1,spcount+1,tmp_name,1)
        tmp_name%0 := par1_len
        copy_bytes(par2_len,p1,par1_len+2+spcount,cmd_line,1)
        IF par2_len > 0 THEN cmd_line%0 := par2_len }V
   IF sys_unix THEN
     IF p2 > 1 THEN   // At least one arg
       makebcplstring(p3!1,tmp_name)
   IF sys_unix1 THEN
   { IF p1 > 0 THEN   // At least one arg
        copy_string(p2!1, tmp_name)
   }
   IF sys_unix32 THEN
   {u32
     IF argc > 2 THEN
     { writes("Arg count*N"); postlude(); stop(255) }
     cmd_line%0 := 0
     IF argc > 0 THEN
     { LET p = argv!1
       UNLESS p%0 = 1 & p%1 = '-' DO
         copy_string(argv!1,tmp_name) }
     IF argc > 1 THEN copy_string(argv!2,cmd_line) }u32
   IF sys_fmgr THEN next_param(tmp_name) }1

AND signal(a,b) = VALOF
/* This is needed with UNIX only.  */
TEST sys_unix THEN
  RESULTIS unix(2, sys_signal, a, b)
ELSE TEST sys_unix32 THEN
  RESULTIS signal32(a, b)
ELSE RESULTIS 0

AND sys_command(s) BE
/*  Issue the system command, which is the string 's', and return
immediately to CHEF.  */
TEST ~ menu_qs THEN RETURN ELSE
{1 IF sys_aos THEN
   { LET ipc_hdr = TABLE 0, 0, 0, 0, 0, 0, 0
     LET len = tmp_name%0
     ipc_hdr!5, ipc_hdr!6 := (len+2)>>1, tmp_name
     tmp_name%0, tmp_name%(len+1) := '*S', 0
     changephase(":CLI.PR", phase.swap, ipc_hdr) }
   IF sys_rdos THEN
   {2 FOR i = 1 TO s%0 DO s%i := upper_case(s%i)
      copy_bytes(4,";POP",1,s,1+s%0)
      s%0 := s%0 + 4
      command(s) }2
   IF sys_mts LOGOR sys_470 THEN command(s)
   IF sys_emas THEN e.command(s)
   IF sys_unix32 THEN
   { LET n = fork()
     LET status = 0
     TEST n = 0 THEN
     { LET v = VEC 3
       v!0 := shell_name
       v!1 := "-c"
       v!2 := s
       v!3 := 0
       execve(shell_path, v, envp)
       FINISH
     }
     ELSE
     { LET i = signal(2, 1); wait(@status); signal(2, i) }
   }
   IF sys_vms THEN spawn_process(s, 0)
   IF sys_unix LOGOR sys_unix1 THEN
   {D LET n = fork()
      LET status = 0
      TEST n = 0 THEN
      { execl(shell_path, "sh", "-c", s, 0); FINISH }
      ELSE
      { LET i = signal(2,1); wait(@status); signal(2,i) } }D }1

AND sys_return() BE
/* This returns temporarily to the system without  unloading  the
editor, so that CHEF may be restarted. */
TEST ~ menu_qs THEN RETURN ELSE
{1 IF sys_aos THEN changephase(":CLI.PR", phase.swap, -1)
   IF sys_mts LOGOR sys_470 THEN system()
   IF sys_rdos THEN command("")
   IF sys_emas THEN warn(m_syntax)
   IF sys_unix32 THEN
   { LET n = fork()
     LET status = 0
     TEST n = 0 THEN
     { LET v = VEC 2
       v!0 := shell_name
       v!1 := "-i"
       v!2 := 0
       execve(shell_path, v, envp)
       FINISH
     }
     ELSE
     { LET i = signal(2, 1); wait(@status); signal(2, i) }
   }
   IF sys_vms THEN spawn_process("", 0)
   IF sys_unix LOGOR sys_unix1 THEN
   {D LET n = fork()
      LET status = 0
      TEST n = 0 THEN
      { execl("/bin/sh", "-", 0); FINISH }
      ELSE
      { LET i = signal(2,1); wait(@status); signal(2,i) } }D }1

/* --------------------- optimization ---------------------------
     The  following  procedures  are written independently of the
operating system, but they might well be written as direct  calls
to the system, thereby speeding them up.  */

AND copy_bytes(l, s1, o1, s2, o2) BE
/*  Copies  the  'l'  bytes  from  's1' at offset 'o1' to 's2' at
offset 'o2'.  */
{1 // trace("copy_bytes:")
   TEST sys_unix32 \/ sys_vms THEN
     IF l GE 0 THEN move(l,s1*bytesperword+o1,s2*bytesperword+o2)
   ELSE TEST sys_cpm THEN
     IF l > 0 THEN move(l,(s1<<1)+o1,(s2<<1)+o2)
   ELSE
     FOR i = 0 TO l-1  DO s2%(o2+i) := s1%(o1+i) }1

AND copy_cells(length, source, destination) BE
/* This copies 'length' cells.
   It is only used when stacking and unstacking the workspace. */
TEST ~ menu_new THEN RETURN ELSE
{1 // trace("copy_cells:")
   FOR i = 0 TO length-1 DO destination ! i := source ! i }1

AND copy_string(s, d) BE
/* Copies the string s to the string d.  */
{1 // trace("copy_string:")
   FOR i = 0 TO s%0 DO d%i := s%i }1

AND eq_str(s1, s2) = VALOF
/* Yield true if the strings 's1' and 's2' are  equal;  otherwise
yield false */
{1 FOR i = 0 TO s1%0 DO UNLESS s1%i = s2%i THEN RESULTIS FALSE
   RESULTIS TRUE }1

AND make_unix_string(s1,s2) BE
/* Shifts characters left one from 's1' to 's2' and places a null
character after the last one.  This is used by UNIX only.  */
TEST ~ sys_unix THEN RETURN ELSE
 { copy_bytes(s1%0, s1, 1, s2, 0); s2%(s1%0) := 0 }

/* ------------------- file manipulation ------------------------
     The  following  group  of procedures are concerned with file
manipulation.  */

AND create_file(name, sec, type) = VALOF
/*  This is called by 'write_out' in EF7 to create an output file
when necessary.  */
{1 // trace("create_file: %S", name)
 { LET s = ?
   IF sys_aos THEN { delete(name); s := find_out_file(name) }
   IF sys_mts LOGOR sys_470 THEN
   { LET cml = "$EMPTY                           "
     copy_bytes(name%0, name, 1, cml, 8)  ; cml%0 := name%0 + 7
     command(cml)
     s := find_out_file(name) }
   IF sys_emas THEN
   { s := e.checkfile(name)
     TEST s > 0 THEN s := -s ELSE
     s := findoutput(s = 0 -> name, e.tempfile)
     IF s < 0 THEN
     { e.last_failure := s
       copy_string(name,e.last_name)
     }
   }
   IF sys_tripos THEN s := findoutput(name)
   IF sys_cpm THEN s := findoutput(name)
   IF sys_unix THEN s := find_out_file(name)
   IF sys_unix1 THEN s := find_out_file(name)
   IF sys_unix32 THEN s := createoutput(name)
   IF sys_vms THEN s := findoutput(name)
   IF sys_fmgr THEN s := createoutput(name, sec, type)
   IF sys_rdos THEN s := findoutput(name)
   UNLESS valid_stream(s) THEN warn(m_access)
   RESULTIS s }1

AND end_work_file() BE
/* Close and destroy the work file.  */
{1 LET f = name_of_work_file()
   TEST sys_vms THEN RETURN
   OR { selectoutput(work_out_stream); endwrite() }
   UNLESS sys_aos \/ sys_rdos \/ sys_emas THEN
   { selectinput(work_in_stream); endread() }
   IF sys_mts \/ sys_470 THEN
   { LET s = "$DESTROY                "
     copy_bytes(f%0, f, 1, s, 10); s%0 := 9 + f%0
     command(s) }
   IF sys_unix THEN
   { LET s = "                        "
     make_unix_string(f, s)
     unix(1, sys_unlink, s<<1)  }
   IF sys_unix1 THEN deletefile(f)
   IF sys_unix32 THEN deletefile(f)
   IF sys_tripos THEN deleteobj(f)
   IF sys_cpm THEN deletefile(f)
   IF sys_emas THEN deletefile(f)
   IF sys_aos THEN delete(f)
   IF sys_rdos THEN destroy(f) }1

AND file_access(file_name) = VALOF
/* Yield a value which is the access mode for 'file_name', if
possible, otherwise 0.  */
{1 // trace("file_access: %S", file_name)
   TEST sys_mts LOGOR sys_470 THEN
   {2 LET v = VEC name_csz AND f_l = file_name%0
      FOR i = 1 TO f_l DO v%(i-1) := file_name%i
      v%f_l := '*S'
    { LET gr0 = call(symbol("CHKFILE"), v<<2)
      SWITCHON returncode INTO
      {S CASE 0: CASE 12: RESULTIS gr0
         DEFAULT: RESULTIS 0 }S }2
   ELSE TEST sys_unix1 THEN RESULTIS access(file_name)
   ELSE RESULTIS 0 }1

AND find_in_file(name) = VALOF
/* The file 'name' is first checked to see that it is readable.
If it is then the stream is yielded.  If not then a non-negative
value is yielded from which the access mode can be obtained.  */
{1 LET access_mode = file_access(name)
   IF ~ sys_emas & ~ sys_unix1 & ~sys_tripos &
      ~sys_unix32 & ~sys_vms & ~sys_cpm THEN
      UNLESS readable(access_mode) THEN RESULTIS - access_mode
   TEST sys_emas THEN
   { LET s = findinput(name)
     IF s < 0 THEN
     { e.last_failure := s
       copy_string(name,e.last_name)
     }
     RESULTIS s
   }
   ELSE RESULTIS findinput(name)
}1

AND find_out_file(name) = VALOF
/* The file 'name' is first checked to see that it is writeable.
If it is then the stream is yielded.  If not then a non-negative
value is yielded from which the access mode can be obtained.  */
TEST sys_emas \/ sys_tripos \/ sys_cpm \/ sys_unix32 \/
     sys_vms THEN RESULTIS 0
ELSE
{1 LET access_mode = file_access(name)
   UNLESS writeable(access_mode) THEN RESULTIS - access_mode
   RESULTIS findoutput(name) }1

AND find_stream(name, find) = VALOF
/* Open the file 'name'.  The parameter 'find' is either 'findinput'
or 'findoutput'. */
{1 // writef("find_stream: name=%S*N", name)
   TEST sys_emas \/ sys_aos THEN RESULTIS 0
   ELSE
   {2 LET stream = find(name, 0)
      IF sys_unix THEN RESULTIS stream
      UNLESS valid_stream(stream) THEN err("file %S", name)
      IF sys_mts \/ sys_470 THEN make_indexed(stream)
      RESULTIS stream }2 }1

AND find_work_file() BE
/* Open  the  work file.  */
{1 // writef("<>find_work_file:*N")
 { LET w_f = name_of_work_file()
   TEST sys_aos THEN
   { delete(w_f)
     work_out_stream := open(w_f, io.blockreadwrite) }
   ELSE TEST sys_fmgr THEN
   { work_out_stream := findoutput(w_f, 0)
     UNLESS valid_stream(work_out_stream) THEN
       //                      (name, security, type, size)
       work_out_stream := createoutput(w_f, 0, 1, 800) }
   ELSE TEST sys_emas THEN
   { LET conad = chef.outfile(w_f)
     IF conad = 0 THEN err("file %S", w_f)
     work_base := conad
     work_out_stream := 0 }
   ELSE
     work_out_stream := find_stream(w_f, findoutput)
   UNLESS valid_stream(work_out_stream) THEN err("file %S", w_f)
   IF sys_cpm THEN 0%work_out_stream := #xe0    // Allow input too
   IF sys_vms THEN work_base := get_workspace()
   IF ~sys_vms THEN
   { work_in_stream :=
     (sys_aos \/
      sys_rdos \/
      sys_emas \/
      sys_vms \/
      sys_cpm) -> work_out_stream, find_stream(w_f, findinput) } }1

AND make_indexed(s) BE
/* Set the file associated with the stream 's' to to be  accessed
by line number.  */
{1 // trace("make_indexed:")
   TEST sys_mts LOGOR sys_470 THEN
     s ! modbits :=
       (s ! modbits LOGOR indexedbit) LOGAND ~ sequentialbit
   ELSE RETURN }1

AND make_sequential(s) BE
/*  Set  the  file  associated with the stream 's' to be accessed
sequentially.  */
{1 // trace("make_sequential:")
   TEST sys_mts LOGOR sys_470 THEN
     s ! modbits :=
       (s ! modbits LOGOR sequentialbit) LOGAND ~ indexedbit
   ELSE RETURN }1

AND no_out_trim_or_control(s) BE
/* Set the file associated with the stream 's' so that  there  is
no trimming of trailing blanks or insertion of control characters
on output.  */
  TEST sys_mts LOGOR sys_470 THEN
  { selectoutput(s); outcontrol(FALSE); no_trim(s) }
  ELSE RETURN

AND no_trim(s) BE
/*  Set  the file associated with the stream 's' so that there is
no trimming of trailing blanks.  */
  TEST sys_mts LOGOR sys_470 THEN
    s ! modbits := (s ! modbits LOGAND ~ trimbit) LOGOR ntrimbit
  ELSE RETURN

AND readable(a) =
/* Yield true if the access mode 'a' is 'read'.   */
  sys_mts LOGOR sys_470 -> (a /\ 1) = 1, TRUE

AND set_file_position(s, n) BE
/*  Set  the  file associated with the stream 's' to the position
'n'. Note that for 'sys_mts', 'sys_470', 'sys_fmgr' and 'sys_vms'
it is a line position, otherwise a byte position.  */
{1 // trace("set_file_position: n=%N", n)
   IF sys_aos THEN
   { LET pos = VEC 1 AND err = 0
     pos ! 0, pos ! 1 := 0, n
     err := setposition(s, pos)
     IF err < 0 THEN stop(err) }
   IF sys_mts LOGOR sys_470 THEN s ! linenumber := n * 1000
   IF sys_fmgr THEN
   {HP LET ir = 1
       call(@sys_posnt, 4, s ! dcb, @hperr, @n, @ir)
       IF hperr < 0 THEN err("Set s=%n, n=%n", s, n) }HP
   IF sys_rdos THEN set_pos(s, n)
   IF sys_emas \/ sys_vms THEN
   { let i = input()
     selectinput(s)
     seek(n)
     selectinput(i)
   }
   IF sys_cpm THEN seek(s,n)
   IF sys_unix1 THEN seek(s,n)
   IF sys_unix32 THEN u32seek(s,n)
   IF sys_unix THEN seek(s, n, 0) }1

AND valid_stream(s) =
/* We must allow for the vagaries of different systems.  */
  (sys_unix \/ sys_rdos) -> (s ~= -1),
  sys_aos \/ sys_emas \/ sys_unix1 -> (s >= 0),
  sys_unix32 \/ sys_tripos \/ sys_cpm \/ sys_vms -> s NE 0,
  (s > 0)

AND writeable(a) =
/* Yield true if the access mode 'a' is 'write'.  */
  sys_mts LOGOR sys_470 -> (a /\ 6) > 0, TRUE

/* ---------------------- local options -------------------------
     The following group of procedures are  concerned  with  some
local choice that may be made.  */

AND chef_parameters() =
/* Some character sets may be different */
  sys_mts LOGOR sys_470 -> "CLRTFVP@$:/|", "CLRTFVP^$:/\"

AND echo_string() =
/* The initialization of control +.  */
  sys_mts LOGOR sys_470 -> "V",
  sys_rdos -> "V",
  sys_unix -> "V", "p"

AND name_of_msg_file() =
   sys_aos -> "EF11.TX",
   sys_mts LOGOR sys_470 -> "JLP1:EF11",
   sys_unix -> "/u/peck/ef11",
   sys_unix1 -> "/usr/lab/rde/chef/ef11a",
   sys_emas -> "SUBSYS.CHEF_EF11A",
   sys_cpm -> "**:CHEF.HLP",
   sys_unix32 -> "/usr/lib/chef.help",
   sys_tripos -> "SYS:info.chef-ef11a",
   sys_vms -> "PUBTXT:CHEFHELP.TXT",
   "EF11 "

AND name_of_work_file() = VALOF
{1 LET s = sys_aos -> uniquename("?%%%.EF.WRK.TMP"),
           sys_mts LOGOR sys_470 -> "-CHEF.WRK",
           sys_emas -> "T#CHEFWRK",
           sys_cpm -> "CHEFWORK.$$$",
           sys_unix1 -> "chef.work",
           sys_unix32 -> VALOF
             { LET name = TABLE 0,0,0,0
               AND pid = getpid()
               copy_string("/tmp/chefxxxxxx",name)
               FOR i = 15 TO 10 BY -1 DO
               { name%i := pid REM 10 + '0'
                 pid := pid/10 } RESULTIS name } ,
           sys_tripos -> "SYS:T.chef-workfile",
           sys_vms -> "",
           sys_unix -> "chef.work", "Z$EW$$ "
   IF sys_fmgr THEN s%6 := hp_unit + '0'
   RESULTIS s }1

AND show_prefix(prefix_) = VALOF
{ LET changed_ = FALSE
  IF prefix_ NE current_prefix THEN
  { changed_ := TRUE; current_prefix := prefix_ }
  TEST sys_emas LOGOR sys_unix32 THEN
  { IF changed_ THEN prompt(prefix_ -> ">", "*C")
    RESULTIS 1 }
  ELSE TEST sys_vms THEN
  { IF changed_ THEN prompt(prefix_ -> ">", "")
    RESULTIS prefix_ -> 1, 0 }
  ELSE TEST NOT prefix_ THEN RESULTIS 0 ELSE
  TEST sys_aos THEN { writes("=>"); RESULTIS 2 } ELSE
  TEST sys_mts LOGOR sys_470 LOGOR sys_tripos THEN
  { writes(">*E"); RESULTIS 1 } ELSE
  TEST sys_unix THEN
  { LET c='>'; write(1, @c, 1);RESULTIS 1 } ELSE
  TEST sys_unix1 THEN { writes(">*V"); RESULTIS 2 } ELSE
  TEST sys_fmgr THEN { writes(">_*N"); RESULTIS 0 } ELSE
  TEST sys_rdos THEN { wrch('>'); flush(); RESULTIS 1 } ELSE
  TEST sys_prime THEN { wrch('>'); RESULTIS 1 } ELSE
  TEST sys_cpm THEN { wrch('>'); RESULTIS 1 } ELSE
  { writes(">*N"); RESULTIS 1 } }

/* ---------------------- block transfer ------------------------
     The  following  group of procedures  is concerned with block
transfer.  */

AND check_blocks(b1,b2) BE
/*  Check  that  blocks  'b1'  to  'b2'  in  the  workfile can be
accessed, after extending the workfile if  possible. This  cannot
be  done  by  'save_block',  since  by  that time there is useful
information which must be stored in that block, and until this is
stored the editor cannot access other blocks in order to save the
work so far. */
{1 // trace("check_blocks: %N %N",b1,b2)
TEST sys_emas THEN
{E FOR b = b1 TO b2 DO
   { WHILE b GE e.work_size THEN
       UNLESS e.expand_workfile() DO warn(m_over)
   }
}E
ELSE TEST sys_cpm \/ sys_unix32 THEN
{CU IF sys_unix32 THEN IF b2 > max_file_block THEN warn(m_over)
  FOR b = b2 TO b1 BY -1 DO
  { IF b > work_hw_block THEN
    { LET cur_out_stream = output()
      selectoutput(work_out_stream)
      { LET ec = wrblock(sys_cpm->@b<<1,0,b)
        selectoutput(cur_out_stream)
        IF sys_cpm THEN IF ec = 0 THEN warn(m_over)
        IF sys_unix32 THEN IF ec < 0 THEN warn(m_over)
      }
      work_hw_block := b
    }
  }
}CU
ELSE TEST sys_vms THEN
{V IF b2 > work_hw_block THEN
   { FOR b = work_hw_block + 1 TO b2 DO
     { IF b*block_bsz GE work_size THEN warn(m_over)
       work_hw_block := b } }V
ELSE RETURN }1

AND restore_block(buffer, b) BE
/* Read block number 'b' to 'buffer'.   Note  that  'b+1'  avoids
trouble with those (curious) systems that have files with no line
zero.  */ {1 // trace("restore_block: b=%N", b)
 TEST sys_emas THEN
   move(block_bsz,work_base+b*block_bsz,buffer*bytesperword)
 ELSE
 TEST sys_vms THEN
 {V move(block_bsz,work_base+b*block_bsz,buffer*bytesperword) }V
 ELSE
 { LET cur_in_stream = input()
   UNLESS sys_aos THEN selectinput(work_in_stream)
   IF sys_aos THEN
   { LET err = blockread(work_in_stream, buffer, b, 1)
     IF err < 0 THEN
       UNLESS err = ~#30 THEN stop(err) }
   IF sys_rdos THEN
   { set_pos(work_in_stream, b * block_bsz)
     readrec(buffer, block_bsz)  }
   IF sys_unix LOGOR sys_unix1 THEN
   { seek(work_in_stream, b, 3)
     read(work_in_stream, buffer, block_bsz) }
   IF sys_unix32 THEN
   { u32seek(work_in_stream,b*block_bsz)
     rdblock(buffer,block_bsz) }
   IF sys_cpm THEN rdblock(buffer,b)
   IF sys_mts LOGOR sys_470 LOGOR sys_fmgr THEN
   { LET b1 = b + 1
     set_file_position(work_in_stream, b1)
     // Note that 'readrec' uses 'b1' on hp but not on ibm.
     readrec(buffer, block_bsz, b1)  }
   UNLESS sys_aos THEN selectinput(cur_in_stream) }1

AND save_block(buffer, b) BE
/* Write 'buffer' to block number 'b' in the  work  file.    Note
that  'b+1'  avoids  record  number  0, which is awkward for some
systems.  */
{1 // trace("save_block: b=%N buffer=%S", b, buffer)
 TEST sys_emas THEN
   move(block_bsz,buffer*bytesperword,work_base+b*block_bsz)
 ELSE
 TEST sys_vms THEN
   move(block_bsz,buffer*bytesperword,work_base+b*block_bsz)
 ELSE
 { LET cur_out_stream = output()
   UNLESS sys_aos THEN selectoutput(work_out_stream)
   IF sys_aos THEN
   { LET err = blockwrite(work_out_stream, buffer, b, 1)
     IF err < 0 THEN stop(err) }
   IF sys_rdos THEN
   { set_pos(work_out_stream, b * block_bsz)
     writerec(buffer, block_bsz)  }
   IF sys_unix THEN
   { seek(work_out_stream, b, 3)
     write(work_out_stream, buffer, block_bsz) }
   IF sys_unix32 THEN
   { u32seek(work_out_stream,b*block_bsz)
     wrblock(buffer,block_bsz) }
   IF sys_cpm THEN wrblock(buffer,b)
   IF sys_mts LOGOR sys_470 LOGOR sys_fmgr THEN
   { LET b1 = b + 1
     set_file_position(work_out_stream, b1)
     // Note that writerec uses b1 on the hp but not on ibm.
     writerec(buffer, block_bsz, b1) }
   UNLESS sys_aos THEN selectoutput(cur_out_stream) }1

/* ------------------- byte counting --------------------------
     The following four routines look after  a  double  precision
byte count for large files on 16 bit machines.  */

AND reset_byte_count() BE
/* Set the byte count to zero.  */
{1 byte_count := 0
   UNLESS sys_mts LOGOR sys_470 LOGOR
          sys_emas LOGOR sys_unix32 LOGOR sys_vms THEN
     byte_count_excess := 0
}1

AND add_byte_count(n) BE
/* Add 'n' to the byte count.   */
{1 byte_count := byte_count + n
   UNLESS sys_mts LOGOR sys_470 LOGOR
          sys_emas LOGOR sys_unix32 LOGOR sys_vms THEN
   { IF byte_count > 9999 THEN
     byte_count_excess, byte_count :=
       byte_count_excess + 1, byte_count - 10000 }1

AND print_byte_count() BE
/* Print the double precision number. */
{1 IF xf_state_ RETURN
   UNLESS sys_mts LOGOR sys_470 LOGOR
          sys_emas LOGOR sys_unix32 LOGOR sys_vms THEN
     IF byte_count_excess > 0 THEN
     { TEST sys_unix LOGOR sys_unix1 LOGOR
            sys_rdos LOGOR sys_tripos LOGOR sys_cpm THEN
       { writen(byte_count_excess); wrz(byte_count, 4)
         newline() }
       ELSE writef("%N%Z4*N", byte_count_excess, byte_count)
     RETURN }
   writef("%N*N", byte_count)  }1

AND wrz(n, d) BE
TEST ~ sys_unix & ~ sys_unix1 & ~ sys_cpm &
     ~ sys_rdos & ~ sys_tripos THEN RETURN ELSE
{ IF d > 1 THEN wrz(n/10, d-1)
  wrch(n REM 10 + '0') }

