
// SECTION "EF6"  // Last modified 87-01-29

/*  This  section  contains  those procedures which are concerned
with the manipulation of the work-space.  A line is saved in  the
record-place  and  its  position (in grabs) from the beginning of
the record-place is saved in the pointer-place.   Blocks  of  the
record-place  which  are not needed are saved in the record-store
and, when required, are swapped in and out.  The same applies  to
the  pointer-place  and  a backup copy is kept for the purpose of
the undo operator.  This section is written in a manner such that
other sections need have no knowledge of how lines are stored  in
the work-space.  The only exported procedures are:

                  clear_all_flags
                  copy_lines
                  move_windows
                  do_z
                  empty_work_space
                  fetch_grab
                  fetch_line
                  flag_the_line
                  make_space
                  stack_work_space
                  store_line
                  unstack_work_space
                  was_flagged                */

GET "ef0.h"

GET "syshdr.h"

MANIFEST
{ blk_n     = -1 //  selector for block number of window
  written   = -2 //  selector, true when window written on
  stride    = 8  //  for interleaving work-space and window store
  stride_m2 = stride - 2
  grab_bsz_m1 = grab_bsz - 1      // for convenience
                             }

STATIC
{ controls          = ?     // vector for grabs of controls
  cur_window        = ?     // file block number of
                            // current window
  first_grab_base   = ?     // grab base for first workspace
  grab_base         = ?     // grab base for current workspace
  line_base         = 0     // line base for current workspace
  max_grab          = 0     // grab beyond last used
  old_window        = 0     // file block number of old window
  swap_place        = ?     // block buffer for text
  text_max          = 0     // file block number of largest
                            // text block
  window_max        = 0     // file block number of largest
                            // window
  echo_cache        = ?     // cache for short contents of
                            // control '+'
  echo_cache_valid_ = FALSE // indicates if contents of
                            // 'echo_cache' are up to date
  echo_line         = ?     // pseudo line number of control '+'
}

LET start_ef6(n) BE
{1 // writes("<>start_ef6:*N")
 { find_work_file()
   no_out_trim_or_control(work_out_stream)
   no_trim(work_in_stream)
   swap_place := work_space + 2
   cur_window := swap_place + block_csz + 2
   blk_n ! swap_place, written ! swap_place := 2, FALSE
   w_space := 0
   IF init_statics_ THEN text_max, max_grab := 0, 0
   IF init_statics_ LOGAND menu_new THEN line_base := 0
   IF menu_control LOGAND init_statics_ THEN
      echo_cache_valid_ := FALSE
   old_window := cur_window + block_csz + 2
   written ! cur_window, written ! old_window := FALSE, FALSE
   blk_n ! cur_window, blk_n ! old_window := 0, -1
   window_max := -1
   check_system(n, computer, 6); start_ef7(n)
   IF menu_control THEN
   { controls :=
       old_window+block_csz
     set_up_control() }
   first_grab_base, grab_base := max_grab, max_grab }1

AND clear_all_flags(i) BE
/*   Used   by  'warn'  to  clean  up  the  data  base  after  an
interrupt. */
TEST ~ menu_x THEN RETURN ELSE
  FOR i = 1 TO last_line DO
  {1 LET grb = fetch_grab(i)
     IF grb < 0 THEN store_grab(i, -grb) }1

AND copy_lines(from_line, to_line, n) BE
/*  This  shifts  'n'  grabs from 'from_line' to 'to_line' in the
seek-place.  */
{1 // trace("copy_lines: from=%N to=%N", from_line, to_line)
 { LET step = from_line < to_line -> -1, +1
   AND n1 = n - 1
   IF step < 0 THEN
   { from_line := from_line + n1; to_line := to_line + n1  }
   FOR i = 1 TO n DO
   {F store_grab(to_line, fetch_grab(from_line))
      from_line := from_line + step
      to_line := to_line + step  }F  }1

AND do_z() BE
/*   Prints   data   storage   information  of  interest  to  the
implementer. */
TEST ~ menu_z THEN RETURN ELSE
{1 writef("file: %S*N", file_name)
   writes("pattern: "); display_pat()
   writef("   [%S]*N",pat%(pat%0)=sentinel -> "simple","complex")
   writef("last line: %N, max ptr: %N*N", last_line, max_grab)
   writes("   line      pointer     tag      length*N")
   FOR i = l_line1 TO l_line2 DO
   {2 check_interrupt()
      fetch_line(i)
    { LET len = line%0
      writef("%I7 %IC      %C %IA*N", i, fetch_grab(i),
        (menu_t -> cur_tag=null -> '*S',cur_tag,'*S'),len) }2 }1

AND empty_work_space() BE
{1 // trace("empty_work_space:
     // max_grab=%N grab_base=%N",max_grab,grab_base)
   IF sys_emas THEN e.reset_recall()
   max_grab := grab_base }1

AND fetch_grab(i)  = VALOF
/* Fetch the grab of the i-th line.  */
{1 // trace("fetch_grab: i=%N", i)
   RESULTIS grab_ad(i, FALSE) ! 0 }1

AND fetch_line(i) = VALOF
/*  This  reads  the  'i'th  line from the work-space into 'line'
yielding the number of characters read.  It retrieves the current
tag from the end of the line and yields the length  of  the  line
(plus one for newline).  */
{1 // trace("fetch_line: i=%N", i)
  IF menu_control THEN
  {C IF i = echo_line LOGAND echo_cache_valid_ THEN
     { IF menu_t THEN cur_tag := null
       copy_string(@echo_cache,line); RESULTIS line%0+1 }
  }C
  { LET grb = fetch_grab(i)
    fetch_record(ABS grb)
  { LET len = 1 + line%0
    IF menu_t THEN cur_tag :=
       menu_control -> ((i < 0) -> null, line%len), line%len
    RESULTIS len }1

AND fetch_record(grb) BE         // local to EF6
/* This gets into 'line' the record whose grab  position  in  the
work-space is 'grb'.  */
{1 // trace("fetch_record: grb=%N", grb)
 { LET block, block_off =
     grb / block_gsz, (grb REM block_gsz)*grab_bsz
   LET line_off, remainder = 0, block_bsz - block_off
   load_text(block)
 { LET len = 2 + swap_place%block_off           // allow for tag
   {R IF remainder > len THEN remainder := len
      copy_bytes(remainder,swap_place,block_off,line,line_off)
      len := len - remainder
      UNLESS len > 0 THEN BREAK
      line_off := line_off + remainder
      block := block + 1
      block_off, remainder := 0, block_bsz
      load_text(block) }R
   REPEAT }1

AND flag_the_line(i) BE
/* The  line  is flagged by complementing the grab.  This is used
by 'flagged_lines' of EF4.  */
TEST ~ menu_x THEN RETURN ELSE
  store_grab(i, - fetch_grab(i))

AND grab_ad(i, store_) = VALOF
/*  Yield the address of a cell containing the grab of the 'i'-th
line.  If 'store_' is true  then  the  window  was  written.  The
virtual block number of the window block is mapped onto the block
numbers of the store file and the correct block is swapped in, if
necessary.  */
{1 // trace("grab_ad: i=%N store_=%N",  i, store_)
   IF menu_control THEN IF i < 0 THEN RESULTIS (controls - i)
   IF menu_new THEN i := i + line_base
   { LET fb, offset = (i/ block_csz)*stride, i REM block_csz
     load_window(fb)
     IF store_ THEN written ! cur_window := TRUE
     RESULTIS (cur_window + offset) } }1

AND load_text(block) BE
/* This translates 'block' to the file-block-number and uses this
to call 'swap_block'.  */
{1 // trace("load_text: block=%N", block)
 { LET fb = (block / stride_m2) * stride +
     block REM stride_m2 + 2
   text_max := swap_block(fb, swap_place, text_max) }1

AND load_window(fb) BE
/*  The window corresponding to file block number 'fb' is loaded,
if it is not already there.  In every case, however, this  window
is now renamed as the current window, 'cur_window'.  */
{1 // trace("load_window: fb=%N", fb)
   UNLESS fb = blk_n ! cur_window THEN
   {N LET w = old_window
      window_max := swap_block(fb, w, window_max)
      old_window := cur_window; cur_window := w }N }1

AND make_space(make_) BE
/*  If  'make_'  is  true,  then  move  up  all  the cells of the
pointer-place from 'cur_line' to 'last_line' to make room for new
lines in the work-space.  The variable 'w_space' is  set  to  the
number  of  new  lines  that  can  be inserted and 'last_line' is
modified.  If 'make_' is false, then 'w_space' grabs are  deleted
starting   at   'cur_line+1'  and  the  variables  'w_space'  and
'last_line' are corrected.  */
{1 // trace("make_space: cur_line=%N make_=%N", cur_line, make_)
   TEST make_ THEN
   { IF last_line + block_csz > file_lsz THEN warn(m_over)
     UNLESS cur_line > last_line THEN
       move_windows(cur_line, last_line, w_enlarge)
     last_line := last_line + block_csz
     w_space := block_csz  }
   ELSE
   { copy_lines(cur_line + w_space + 1, cur_line + 1,
       last_line - cur_line - w_space)
     last_line := last_line - w_space
     w_space := 0 } }1

AND move_windows(l1, l2, how) BE
/* If 'how' is 'w_backup', a backup copy of all grabs  from  'l1'
to 'l2'  is  saved  for  possible  use  by  undo.    If  'how' is
'w-restore', then those grabs are restored for undo.  If 'how' is
'w_enlarge',  the  grabs are moved up by 'block_csz' (one window)
of lines to make room for new lines.  */
{1 // trace("move_windows: l1=%N l2=%N, how=%N", l1, l2, how)
   IF menu_new THEN l1, l2 := l1 + line_base, l2 + line_base
 { LET fb1, fb2 = (l1/block_csz)*stride, (l2/block_csz)*stride
   AND restore_ = (how = w_restore)
   AND offset = (how = w_backup) -> 1, stride
   UNLESS restore_ DO check_blocks(fb1+offset,fb2+offset)
   FOR fb = fb2 TO fb1 BY -stride DO
   {F load_window(restore_ -> fb+1, fb)
      TEST restore_ THEN
      { blk_n ! cur_window, written ! cur_window := fb, TRUE }
      ELSE
      {N LET new_fb = fb + offset
         IF new_fb = blk_n ! old_window THEN
           blk_n ! old_window, written ! old_window := -1, FALSE
         save_block(cur_window, new_fb)
         IF new_fb>window_max THEN window_max := new_fb }N }F }1

AND set_up_control() BE                  // local to EF6
/* This allows the maximum possible space for each  control  line
and sets its value to be harmless.  */
TEST menu_control THEN
{1 // trace("set_up_control:")
   line%0, line%1, line%2 := 3, '#', '%'
   FOR i = 1 TO control_lsz DO
   { store_grab(-i, max_grab)
     max_grab := max_grab + line_gsz
     line%3 := control_chars%i; store_line(-i) }
   copy_string(echo_string(), line)
   echo_line := -char_number('+',control_chars)
   store_line(echo_line) }1
ELSE RETURN

AND stack_work_space() BE
TEST menu_new THEN
{1 // trace("stack_work_space:")
   line_base := line_base + last_line
   line ! 1, line ! 2, line ! 3, line ! 4 :=
      grab_base, altered_, cur_line, last_line
   /* copy 'pat' and 'file_name'  */
   copy_cells(pattern_csz+name_csz+2, pat, line+5)
   line%0 := line_bsz
   grab_base := store_new_record() + line_gsz
   IF sys_emas THEN e.reset_recall()  }1
ELSE RETURN

AND store_grab(i, g) BE        // local to EF6
/* Store the grab 'g' of the 'i'-th line in the work-space.  */
{1 // trace("store_grab: i=%N, g=%N", i, g)
   grab_ad(i, TRUE) ! 0 := g }1

AND store_line(i) = VALOF
/*  This  writes  'line'  to  the  i-th  line  of the work-space,
yielding the number of characters (plus one for new line).   Note
that unless the line is a control the tag is put at the end.  */
{1 // trace("store_line: i=%N", i)
 { LET len = 1 + line%0
   TEST i > 0 THEN
   { IF w_space > 0 THEN w_space := w_space - 1
     IF menu_t THEN line%len := cur_tag
     store_grab(i, store_new_record()) }
   ELSE IF menu_control THEN
   { store_record(fetch_grab(i))
     IF i = echo_line THEN
       TEST len <= cell_bsz THEN    // put in cache
       { copy_string(line,@echo_cache)
         echo_cache_valid_ := TRUE
       } ELSE echo_cache_valid_ := FALSE }
   RESULTIS len }1

AND store_new_record() = VALOF           // local to EF6
/*  This puts 'line' to the end of the store-place and yields the
grab position at which it is stored.  */
{1 // trace("store_new_record: max_grab=%N", max_grab)
 { LET grb = max_grab AND len = 2 + line%0      // allow for tag
   max_grab := max_grab+(len+grab_bsz_m1)/grab_bsz   // in grabs
   IF max_grab < grb THEN                       // cell overflow
   { max_grab := grb; warn(m_over) }
   store_record(grb)
   RESULTIS grb }1

AND store_record(grb) BE              // local to EF6
/*  This  puts  'line'  into the store-space at the grab position
'grb'. */
{1 // trace("store_record: grb=%N", grb)
 { LET block, block_off =
     grb / block_gsz, (grb REM block_gsz)*grab_bsz
   LET line_off, remainder = 0, block_bsz - block_off
   LET len = 2 + line%0
   {R load_text(block)
      IF remainder > len THEN remainder := len
      copy_bytes(remainder,line,line_off,swap_place,block_off)
      written ! swap_place := TRUE
      len := len - remainder
      UNLESS len > 0 THEN BREAK
      line_off := line_off + remainder
      block := block + 1
      block_off, remainder := 0, block_bsz }R
   REPEAT }1

AND swap_block(fb, buffer, fb_max) = VALOF
/* Get the 'block' into 'swap_place'; this includes  writing  the
old block, if 'block_written_' is true. If the required block has
never  been  written,  it  need not be read now; however, on some
systems it may be advisable to check that  it  will  be  possible
eventually to write it back.  */
{1 // trace("swap_block: fb=%N fb_max=%N", fb, fb_max)
 { LET cb = blk_n ! buffer
   UNLESS cb = fb THEN
   {2 IF written ! buffer THEN
      {3 save_block(buffer, cb)
         IF cb > fb_max THEN fb_max := cb
         written ! buffer := FALSE }3
      TEST fb <= fb_max THEN restore_block(buffer, fb)
      ELSE check_blocks(fb,fb)
      blk_n ! buffer := fb }2
   RESULTIS fb_max }1

AND unstack_work_space() = VALOF
TEST ~ menu_new THEN RESULTIS FALSE ELSE
{1 // trace("unstack_work_space:")
   IF grab_base <= first_grab_base THEN RESULTIS FALSE
   empty_work_space(); fetch_record(grab_base - line_gsz)
   grab_base, altered_, cur_line, last_line :=
      line ! 1, line ! 2, line ! 3, line ! 4
   /* copy 'pat' and 'file_name'  */
   copy_cells(pattern_csz+name_csz+2, line+5, pat)
   line_base := line_base - last_line; RESULTIS TRUE  }1

AND was_flagged(i) = VALOF
/* If the line was  flagged,  then  unflag  it  and  yield  true;
otherwise, yield false.  */
{1 // trace("was_flagged: i=%N", i)
 { LET grb = fetch_grab(i)
   IF grb < 0 THEN { store_grab(i, - grb); RESULTIS TRUE }
   RESULTIS FALSE }1

.

