
// SECTION "EF8" // Last modified 82-05-09

/*  This section contains those routines which are concerned with
the undo operator U.  If 'menu_u' is  false,  then  this  section
will yield little code.

     The commands are classified with respect to U as follows:

      willing:     A, C, D, F, I, J, M, R, T
      neutral:     H, L, P, QS, S, V, W, Z, ?
      unwilling:   E, K, N, Q, U, X.

  Willing operators can be undone; unwilling operators cannot be.
If  a  willing  operator  is  followed  by  a  sequence  of other
operators followed by U, then that willing operator can be undone
provided that all  the  other  operators  of  that  sequence  are
neutral,  e.g.,  .,$D;1,$P;U  is a valid use of U.  Note that the
operator B (unavailable to the user) restores the set of pointers
from their backup copies.  If B has  the  modifier  I,  then  the
pointers  are first expanded to make room for the new ones.  Note
that the command "Bx"  will  cause  a  warning,  with  associated
message "The operators E, N, Q, U and X, and changes to controls,
cannot  be  undone".   Except for 'start_ef8', the procedures are
listed in alphabetic order.  */

GET "ef0.h"

STATIC
{  old_l1  = ?    // for saving 'l_line1'
   old_l2  = ?    // for saving 'l_line2'
   old_r1  = ?    // for saving 'r_line1'
   old_r2  = ?    // for saving 'r_line2'
   t_i     = ? }  // character pointer to 'trail_line'.

LET start_ef8(n) BE
{1 // writes("<>start_ef8:*N")
   IF menu_u THEN { undo_state_ := FALSE; trail_line%0 := 0 }
   check_system(n, computer, 8); start_ef9(n) }1

LET do_b() BE
/* If the modifier is I, then this first expands the cells within
the pointer-place between  'l_line1'  and  'l_line2'.    Then  it
restores the pointers of that range from the backup copies.  */
TEST ~ menu_u THEN RETURN ELSE
 {1 // trace("do_b:")
    IF modifier = 'I' THEN expand(l_line1, l_range)
    move_windows(l_line1, l_line2, w_restore)
    UNLESS l_line2 < 0 THEN cur_line := l_line2 }1

AND do_u() BE
/* This first echoes the undoing command from 'trail_line' to the
console, then executes that command.  */
TEST ~ menu_u THEN RETURN ELSE
{1 // trace("do_u:")
  { LET save_cmd = VEC line_csz
    IF trail_line%0 = 0 THEN warn(m_no_undo)
    writes(trail_line); newline()
    copy_string(cmd_line,save_cmd)
    undo_state_ := TRUE; cmd(trail_line,FALSE)
    undo_state_ := FALSE
    IF save_cmd%0 NE 0 THEN cmd(save_cmd,TRUE) }1

AND post_trail(op,mdf) BE
/* This is called after the operator , 'op', has been interpreted
in  order  to  set  the  'trail_line'  to contain the appropriate
undoing command. */
TEST ~ menu_u THEN RETURN ELSE
 {1 // trace("post_trail: op = %C",op)
    IF undo_state_ LOGOR
      char_number(op, "HLPSVWZ?") > 0 LOGOR op = null THEN RETURN
    TEST op = 'X' LOGOR op = 'Y' THEN
       IF mdf = 'A' LOGOR mdf = 'C' THEN RETURN
    ELSE
    { IF menu_x THEN IF x_state_ THEN RETURN
      IF menu_xf THEN IF xf_state_ THEN RETURN }
    IF op = 'Q' LOGAND modifier = 'S' THEN RETURN
    IF op = 'R' LOGAND modifier = 'Z' THEN
       op, modifier := 'C', null
    t_i := 0
  { LET downward_ = old_l2 < old_r1 /* left range below right */
    LET l1 = downward_ -> old_r2 - (op = 'C' -> l_range, 0),
                            old_r1 - 1
    LET r1 = downward_ -> old_l1, old_l1 - r_range /*  + , .  */
    LET r2 = downward_ -> old_l1 + r_range, old_l1 /*  . , -  */
    SWITCHON op INTO
    {S CASE 'I':
         TEST modifier = 'D' LOGAND
             (menu_control -> r_got ~= control, TRUE) THEN
           /* l1IDr1,r1  */
           wr_trail("%NID%N+,%N", l1, r1, r2)
         ELSE /* l1I; l1IFx; l1Ir1,r2; l1I@a */
         TEST old_l1 = cur_line THEN
         { trail_line%0 := 0; RETURN }
         ELSE wr_trail("%N,%ND", 1+old_l1, cur_line);     ENDCASE
       CASE 'C':
         IF modifier = 'D' LOGAND
           (menu_control -> r_got ~= control, TRUE) THEN
           /* l1,l2CDr1,r2; @aCDr1 */
           TEST (menu_control -> l_got = control, FALSE) THEN
             /* @aCDr1 */
           { wr_trail("%N,%NBI", old_r1, old_r2);      ENDCASE }
           ELSE /* l1,l2CDr1,r2 */
           {2 wr_trail("%NID%N,%N-;%N,%NBI;V",
                l1, r1, r2, old_l1, old_l2);          ENDCASE }2
         /* l1,l2C; l1,l2IFx; l1,l2Cr1,r2; l1,l2C@a; l1,l2CD@a */
         /* @aC;  @aCD@b; @aC@b; @aCr1  */
         /* l1,l2C; l1,l2CFx; l1,l2Cr1,r2; l1,l2C@a; l1,l2CD@a */
         /* These cases now fall through.  */
       CASE 'F': /* l1F */
       CASE 'M': /* l1,l2M; l1,l2MC.. */
       CASE 'J': /* l1,l2J.. */
         IF (menu_control -> l_got = control, FALSE) THEN ENDCASE
         UNLESS cur_line < old_l1 THEN  /* Last line problem */
           wr_trail("%N,%ND;", old_l1, cur_line)
         wr_trail("%N,%NBI;V", old_l1, old_l2);           ENDCASE
       CASE 'D': /* l1,l2D; @AD */
         UNLESS (menu_control -> l_got = control, FALSE) THEN
           wr_trail("%N,%NBI", old_l1, old_l2);           ENDCASE
       CASE 'A': /* l1,l2A; @AA */
       CASE 'R': CASE 'T': /* l1,l2R..; l1,l2T..; @AR..; @aT.. */
         UNLESS (menu_control -> l_got = control, FALSE) THEN
           wr_trail("%N,%NB", old_l1, old_l2) }S
    IF t_i = 0 THEN wr_trail("Bad luck!")
    trail_line%0 := t_i }1

AND pre_trail() BE
/*  This  is  called  before a command is interpreted in order to
save the information appropriate for undoing it.  The  values  of
'l_line1',  'l_line2',  'r_line1 and 'r_line2' must be remembered
and those operators (C, D, J, M, R and  T)  which  abandon  lines
must  ensure  that  their  pointers are first saved in the backup
file.  */
TEST ~ menu_u THEN RETURN ELSE
{1 // trace("pre_trail: op = %C, cur_op = %C",op,cur_operator)
   IF undo_state_ THEN RETURN
   IF menu_xf THEN IF xf_state_ THEN RETURN
   old_l1, old_l2 := l_line1, l_line2
   old_r1, old_r2 := r_line1, r_line2
   IF char_number(cur_operator, "ACDFJMRT") > 0 THEN
      move_windows(l_line1, l_line2, w_backup) }1

AND wr_trail(fmt, a, b, c, d, e) BE
/* Writes to 'trail_line'.  */
TEST ~ menu_u THEN RETURN ELSE
{1 LET wrch0 = wrch; wrch := wrch_tr
   writef(fmt, a, b, c, d, e)
   wrch := wrch0 }1

AND wrch_tr(c) BE
/* Temporary replacement for 'wrch' in 'wr_trail'.  */
TEST ~ menu_u THEN RETURN ELSE
{1 t_i := t_i + 1; trail_line%t_i := c }1

.

