
// SECTION "EF2"  // Last modified 83-10-18
/* The procedures in this section are concerned with getting  the
elements  of  a command from the command line, with the expansion
of macros, and  with  analysis  of  the  location  portion  of  a
command.  Except  for  'start_ef2'  the  procedures are listed in
alphabetic order.  */

GET "CHEF_EF0"

STATIC
{  c_i            = ?      // command line index
   escaped_       = ?      // true for an even number of '#'s.
   line1          = ?      // temporaries for
   line2          = ?      //     'get_location'
   putback_char   = ? }    // for backup on reading

LET start_ef2(n) BE
{1 // writes("<>start_ef2:*N")
   IF menu_ovl THEN get_overlay(o_syntax)
   check_system(n, computer, 2); start_ef3(n) }1

LET accept_char(c) = VALOF
/* Yields true if 'cur_char' is 'c'  and  advances  to  the  next
character of  the  command line.  Otherwise yields false and does
not advance.  */
{1 // trace("accept_char:")
   TEST cur_char = c THEN { get_ch(); RESULTIS TRUE  }
   ELSE RESULTIS FALSE  }1

AND char_number(c, s) = VALOF
/*  Yields the  index  of  'c' in the string 's', if it is there;
otherwise, yields zero.  */
{1 // trace("char_number: c=%C s=%S*N", c, s)
   FOR i = 1 TO s%0 DO IF c = s%i THEN RESULTIS i ; RESULTIS 0 }1

AND cmd(s,save_) BE
/*  Fetches the string 's' and executes the commands it contains.
The last command is terminated by '*N', all others  by  ';'.   If
'save_'  is true, the new command string 's' must be preserved in
'old_cmd' before command analysis, in case a syntax error  is  to
be corrected with an XA command.  */
{1 // trace("cmd:")
 { LET last_saved = VEC menu_xc -> line_csz, 0
   IF menu_ovl THEN get_overlay(o_syntax)
   IF menu_xc THEN IF save_ THEN
   { copy_string(old_cmd,last_saved)
     copy_string(s,old_cmd) }
   set_cmd_line(s)
   concat_state_ := menu_x -> x_state_, FALSE
   verify_ := FALSE
   {R get_ch()
      check_interrupt()
      get_left_lines()
      get_operator()
      get_operand()
      IF menu_xc THEN IF save_ THEN
      { UNLESS save_cmd() THEN
           copy_string(last_saved,old_cmd)
        save_ := FALSE }
    { LET len = cmd_line%0 - c_i + 1        // flush this command
      copy_bytes(len, cmd_line, c_i, cmd_line, 1)
      cmd_line%0 := len; c_i := 1
      interpret()   }R
   REPEATUNTIL cur_char = '*N'  }1

AND cmd_char() =
/* Yields the next character from the command line, or '*N'. */
  (c_i > cmd_line%0) -> '*N', cmd_line%c_i

AND do_k() BE
/* Kills  the  current  command line if the line specified by the
location has a zero length.   If there is a line specified on the
right, its content becomes the new command line.  */
{1 fetch_line(l_line1)
   IF line%0 NE 0 THEN RETURN
   UNLESS r_got = 0 THEN fetch_line(r_line1)
   set_cmd_line(line)  }1

AND expand_macro() BE
/* Expands a possible macro call at 'c_i' in 'cmd_line' which  we
know is '%'. If the macro character is '%', the insert comes from
the  console  (or  execute file) and, if it is 'A' to 'Z', from a
control line. If there is no valid macro call, nothing  is  done.
Macro  expansion  continues,  to  a  maximum  depth  of 5, if the
replacement string has '%' as its first character, i.e., if there
is apparently no progress.  */
TEST ~ menu_macro THEN RETURN ELSE
{1 // trace("expand_macro:")
   FOR i = 1 TO 5 DO
   {F LET control_name = cmd_line%(c_i + 1)
      TEST control_name = '%' THEN
        UNLESS got_text(FALSE, FALSE) DO recover_eof()
      ELSE
      { LET c_l = - uc_char_number(control_name,control_chars)
        TEST c_l < 0 THEN fetch_line(c_l) ELSE RETURN  }
    { LET insert_bsz = line%0 AND save_bsz = cmd_line%0 - c_i - 1
      IF insert_bsz = 3 & line%1 = '#' & line%2 = '%' &
         'a' <= control_name <= 'z' &
          line%3 = control_name - ('a' - 'A') THEN
         line%3 := control_name
                       // For users who don't know about controls
      cmd_line%0  := cmd_line%0 + insert_bsz - 2
      IF cmd_line%0 > line_bsz THEN warn(m_new_too_long)
      copy_bytes(save_bsz, cmd_line, c_i+2, line, 1+insert_bsz)
      copy_bytes(insert_bsz+save_bsz, line, 1, cmd_line, c_i)
      UNLESS cmd_line%c_i = '%' THEN RETURN  }F
   warn(m_recursion)  }1

AND get_ch() BE
/*  Sets  'cur_char' to the next character from the command line.
If the character delivered is '*N' or ';', then 'terminated_'  is
set true.    The  routine  invokes  a possible macro expansion on
finding a '%' character, unless inhibited by  an  odd  number  of
'#'.  */
{1 // trace("get_ch:")
   TEST putback_char = null THEN
   {N cur_char := cmd_char()
      IF cur_char = '%' LOGAND ~escaped_ THEN
      { expand_macro(); cur_char := cmd_char()  }
      c_i := c_i + 1
      IF ~escaped_ LOGAND cur_char = '#' THEN
        IF cmd_char() = '%' THEN
        { cur_char := '%'; c_i := c_i + 1  }
      escaped_ := (cur_char = '#') -> ~escaped_, FALSE  }N
   ELSE { cur_char := putback_char; putback_char := null }
   terminated_ := (cur_char = '*N') LOGOR (cur_char = ';')  }1

AND get_finder() = VALOF
/* This yields -1, if there is no finder; otherwise it  yields  a
non-negative  value according to the usual rules of an arithmetic
combination of terms using '+' or '-', but modified as follows:
   i) if no term precedes a leading '+' or '-', then an elided
       '.' is assumed,
   ii) if no term follows a '+' or '-', then an elided '1' is
       assumed.                                              */
{1 // trace("get_finder:")
 { LET n = get_term(-1)
   IF n < 0 THEN
     SWITCHON cur_char INTO
     {S1 DEFAULT: RESULTIS n
         CASE '+': CASE '-': n := cur_line   }S1       // rule i
   {R LET c = cur_char; get_ch()
      SWITCHON c INTO
      {S2 CASE '+': n := n + get_term(1); ENDCASE      // rule ii
          CASE '-': n := n - get_term(1); ENDCASE      // rule ii
          DEFAULT: unget_ch(c)
            TEST n >= 0 THEN RESULTIS n
            ELSE warn(m_finder)  }S2  }R  REPEAT  }1

AND get_int() = VALOF
/*  This  yields  the value of the decimal integer in the command
line whose first character is in 'cur_char'.  */
{1 // trace("get_int:")
 { LET n = 0
   WHILE '0' <= cur_char <= '9' DO
   {R n := 10 * n + cur_char - '0'; get_ch() }R
   RESULTIS n }1

AND get_left_lines() BE
/* Sets 'l_got', l_line1' and 'l_line2' according to the  control
or workspace lines specified on the left of a command.  */
{1 l_got := get_location()
   l_line1, l_line2 := line1, line2  }1

AND get_location() = VALOF
/*  The  line  specifier  part of a command may specify a control
(form '@A') or it may consist of zero or more "finders"  possibly
separated by  ','  or  ':'.   The function first checks whether a
control has been specified and, if  so,  sets  both  'line1'  and
'line2'  to  the  control  line  number  and  returns  the  value
'control'. If no control is specified, the function sets  'line1'
and  'line2'  in  accordance with the range specified and returns
the value of 0, 1 or 2 to indicate the number of lines specified.
The rules are:-
   i) if there is no finder or punctuation, the function yields
      0 and both 'line1' and 'line2' are set to the value of
      'cur_line'.
  ii) if there is one finder only, then the function yields the
      value 1, and both 'line1' and 'line2' are set to the
      value of that finder.
 iii) the presence of two or more finders, or any occurrence
      of ',' or ':' forces a range to be specified and the
      function returns the value 2. Two finders forming a
      range may be juxtaposed without punctuation if the
      result is not ambiguous.
  iv) the limits of a range are given by the values of the last
      two finders, either or both of which may be elided.
   v) if one or both of the last two finders in a range is elided
      then the defaults are 1 and 'last_line' respectively.
  vi) if ':' occurs, 'cur_line' is set to the value of the finder
      immediately preceding the last  ':' (default 1).   */
{1 // trace("get_location:")
   next_sig_char()
   IF menu_control THEN
     IF cur_char = '@' THEN
     {C get_ch()
        line1 := - uc_char_number(cur_char,control_chars)
        TEST line1 < 0 THEN
        { line2 := line1; get_ch(); RESULTIS control }
        ELSE warn(m_control)  }C
 { LET finder = get_finder()
   AND need1_ = FALSE
   LET n_got = (finder >= 0) -> 1, 0
   line1, line2 := -1, finder
   {R SWITCHON cur_char INTO
      {S CASE ':':
            cur_line := (finder >= 0) -> finder, 1 // rules iv, v
         CASE ',': get_ch()
            n_got := n_got + 1; need1_ := TRUE }S  // rule iii
      finder := get_finder()
      TEST (finder >= 0) LOGOR need1_ THEN
      { line1 := line2; line2 := finder            // rule iii
        need1_ := FALSE; n_got := n_got + 1  }
      ELSE BREAK  }R REPEAT
   IF n_got > 2 THEN n_got := 2
   SWITCHON n_got INTO
   {S CASE 0: line2 := cur_line                    // rule i
      CASE 1: line1 := line2;         ENDCASE      // rules i, ii
      CASE 2: IF line1 < 0 THEN line1 := 1
        IF line2 < 0 THEN line2 := last_line  }S   // rule v
   RESULTIS n_got  }1

AND get_right_lines() BE
/* Sets 'r_got', 'r_line1' and 'r_line2' according to the control
or workspace lines specified on the right of a command.  */
{1 r_got := get_location()
   r_line1, r_line2 := line1, line2  }1

AND get_term(def) = VALOF
/*  This  yields  the value (a line number) of the next term of a
finder, if any; otherwise  it  yields  the  value  of  'def'  (as
default).  A term is either '.' (value 'cur_line'), or '$' (value
'last_line'),  or an unsigned integer, or a pattern, e.g., /abc/,
whose value is the number of a line matching  it,  or  a  tagger,
e.g., 'a, whose value is the number of a line so tagged.  */
{1 // trace("get_term: def=%N", def)
 { LET negated_ = accept_char('~')
   LET c = cur_char; get_ch()
   IF accept_pat_or_tag(c) THEN RESULTIS scan_file(c, negated_)
   IF negated_ THEN warn(m_syntax)
   SWITCHON c INTO
   {s CASE '.': RESULTIS cur_line
      CASE '$': RESULTIS last_line
      DEFAULT: unget_ch(c)
         RESULTIS ('0' <= c <= '9') -> get_int(), def  }1

AND next_sig_char() BE
/*  If  'cur_char'  is  a  blank,  advances to the next non-blank
character of the command line */
{1 // trace("next_sig_char:")
   WHILE cur_char = '*S' DO get_ch()  }1

AND save_cmd() = VALOF
/* Returns true if the command that has just been analysed is one
that should be saved for a possible XA or XC command.  For others
it returns false.  */
TEST ~ menu_xc THEN RESULTIS FALSE ELSE
{1 SWITCHON cur_operator INTO
   {S CASE 'Y':
         IF modifier = 'F' THEN RESULTIS TRUE
      CASE 'H': CASE 'L': CASE 'U':
      CASE '?': CASE null:        RESULTIS FALSE
      DEFAULT:                    RESULTIS TRUE  }S }1

AND set_cmd_line(s) BE
/* Stores the string  's'  in  'cmd_line'  and  makes  ready  for
execution of the command string.  */
{1 // trace("set_cmd_line:")
 { LET len = s%0 + 1
   copy_string(s, cmd_line)
   cmd_line%0, cmd_line%len := len, '*N'
   c_i := 1; putback_char := null
   escaped_ := FALSE  }1

AND uc_char_number(c, s) =
/* This converts 'c' to upper case, if it is a letter, and yields
its index  in  the string 's', if present.  If it is not present,
the function yields 0.    This  function  is  used  in  syntactic
analysis of the command line.  */
  char_number(upper_case(c), s)

AND unget_ch(c) BE
/*  This  backs up by one character and restores the value of 'c'
to  'cur_char'.   It  also  sets  the  value  'terminated_',   if
appropriate.  */
{1 // trace("unget_ch:")
   putback_char := cur_char; cur_char := c
   terminated_ := (cur_char = '*N') LOGOR (cur_char = ';')  }1

AND upper_case(c) =
/* This is called by 'get_operator' to allow for operators to  be
in either  upper  or  lower  case.  Lower case is then changed to
upper case.  */
    ('a' <= c <= 'z') -> (c + ('A' - 'a')), c

.


