
// SECTION "EF4"  // Last modified 83-10-20

/* The procedures in this section deal with the interpretation of
common  commands.  Other commands are dealt with in EF7b.  Except
for 'start_ef4', the procedures are listed in  alphabetic  order.
*/

GET "CHEF_EF0"

LET start_ef4(n) BE
{ // writes("<>start_ef4:*N")
  IF menu_ovl THEN get_overlay(o_screen)
  check_system(n, computer, 4); start_ef4a(n)
  IF menu_ovl THEN get_overlay(o_syntax) }

AND delete_lines(l1, l2, r) BE
/* Deletes the lines of the work-space from 'l1' to 'l2'.  */
{1 UNLESS l2 = last_line THEN
     copy_lines(1+l2, l1, last_line-l2)
   last_line := last_line - r }1

AND do_c() BE
/* Change  lines  in the given range (default .).  If the operand
is elided, then the new lines come from  the  console.    If  the
modifier  is  'D',  they  come from the work-space and the source
region is deleted after the operation.  If the modifier  is  'F',
the lines  come from the named file.  Set the current line to the
last line inserted.  */
{1 // trace("do_c:")
   TEST menu_control -> l_got = control, FALSE THEN
   {C TEST modifier = null THEN   // control line
        UNLESS got_text(FALSE,FALSE) DO recover_eof()
      ELSE fetch_line(r_line1)
      store_line(l_line1)
      IF modifier = 'D' THEN
         TEST menu_control -> r_got = control, FALSE THEN
         { line%0 := 0; store_line(r_line1)  }
         ELSE delete_lines(r_line1, r_line1, 1)  }C
   ELSE
   {W l_line1 := l_line1 - 1; do_i()               // workspace
    { LET insert_size = cur_line - l_line1
      l_line1 := l_line1 + 1 + insert_size
      l_line2 := l_line2 + insert_size
      delete_lines(l_line1, l_line2, l_range)
      cur_line := l_line1 - 1 }W }1

AND do_d() BE
/* Delete the lines in the given range (default .)  and  set  the
current  line to the next line beyond the deletion, if it exists,
otherwise to the last line.  */
{1 // trace("do_d:")
   TEST menu_control -> (l_got = control), FALSE THEN
   { line%0 := 0; store_line(l_line1) }
   ELSE
   {W delete_lines(l_line1, l_line2, l_range)
      cur_line :=
        (l_line1 <= last_line) -> l_line1, last_line }W }1

AND do_f() BE
/*  Folds the line specified by 'l_line1' at a point specified by
the user, creating a new workspace line.  If the modifier  is  C,
then the leading blanks are removed from the second new line.  If
the  operand  is  a  string,  then that string is prefixed to the
second new line.  The existing line is first displayed  to  guide
the  user,  who  positions the cursor at the character that is to
start the new line.  */
TEST ~ menu_fm LOGOR menu_screen THEN RETURN ELSE
{1 LET str = VEC line_csz
   fetch_line(l_line1); copy_string(line, str)
   cur_line := l_line1
   UNLESS got_template(0, str) THEN RETURN
 { LET head = line%0
   IF head > str%0 THEN extend_str(str, head)
 { LET tail = str%0 - head
   LET pfx  = new_string%0
   copy_bytes(head, str, 1, line, 1); line%0 := head
   store_line(l_line1)
   l_line2 := l_line1 + 1; cur_line := l_line2
   IF menu_t THEN cur_tag := null
   IF modifier = 'C' THEN
     FOR i = head+1 TO str%0 DO
       TEST str%i = '*S' THEN
       { tail := tail - 1; head := head + 1 } ELSE BREAK
   IF pfx + tail > line_bsz THEN warn(m_text_too_long)
   copy_string(new_string, line)
   copy_bytes(tail, str, head+1, line, pfx+1); line%0 := tail+pfx
   expand(cur_line, 1); store_line(cur_line) }1

AND do_i() BE
/* Insert new lines into the work-space after 'l_line1'  and  set
'cur_line' to  the last line inserted.  The operands on the right
are the same as for the 'C' operator.  */
{1 // trace("do_i:")
   SWITCHON modifier INTO
   {S CASE 'F':
        TEST no_name_ THEN warn(m_name) ELSE read_file(tmp_name)
                                                    ENDCASE
      CASE 'R': CASE 'D':
        TEST menu_control -> r_got = control, FALSE THEN
        {C cur_line := l_line1 + 1
           expand(cur_line, 1)
           fetch_line(r_line1)
           store_line(cur_line)
           IF modifier = 'D' THEN
           { line%0 := 0; store_line(r_line1) } }C
        ELSE
        { LET p = 1 + l_line1
          expand(p, r_range)
          IF l_line1 < r_line1 THEN
          { r_line1 := r_line1 + r_range
            r_line2 := r_line2 + r_range }
          copy_lines(r_line1, p, r_range)
          cur_line := l_line1 + r_range
          IF modifier = 'D' THEN
          { delete_lines(r_line1, r_line2, r_range)
            IF r_line2 <= l_line1 THEN
              cur_line := cur_line - r_range } }
                                                   ENDCASE
      CASE null: insert_lines(TRUE) }S }1

AND do_n() BE
/*  Stack the current workspace and start a new one. The value of
'tmp_name' sets the name of the current file, which  is  read  if
its name is not null.  */
TEST ~menu_new THEN RETURN ELSE
{1 // trace("do_n:")
   stack_work_space(); init_work_space(FALSE)  }1

AND do_null() BE
/* If the command is on a line of its own, the null  operator  is
treated  as  'P', except that the current line is advanced by one
if the  location  is  elided.     When   several   commands   are
concatenated, a null operator causes 'cur_line' to be set without
printing  if  the location is in the work-space, but a control is
printed.  */
{1 // trace("do_null:")
   IF menu_control -> l_got = control, FALSE THEN
     { do_p(); RETURN }
   TEST concat_state_ LOGOR (last_line = 0) THEN
     cur_line := l_line2
   ELSE
   {NC IF l_got = 0 THEN
      { IF l_line1 = last_line THEN l_line1, l_line2 := 0, 0
        l_line1 := l_line1 + 1; l_line2 := l_line2 + 1  }
      do_p()   }NC }1

AND do_p() BE
/* Print the lines of the given range (default .).  */
{1 // trace("do_p:")
   IF modifier = 'N' THEN
     UNLESS menu_control -> l_got = control, FALSE THEN
     { writen(l_line1)
       IF l_got = 2 THEN writef(",%N", l_line2)
       newline(); RETURN }
 { LET file_ = FALSE
   LET out_mode = VALOF
     SWITCHON modifier INTO
     {S CASE null: RESULTIS text_only
        CASE 'A': RESULTIS text_numbered
        CASE 'L': IF menu_pl THEN RESULTIS text_lucid
        CASE 'M': IF menu_pm THEN RESULTIS match_positions
        CASE 'F': IF no_name_ THEN warn(m_name)
           file_ := TRUE; RESULTIS text_counted
        CASE 'C': RESULTIS byte_count_only  }S
   write_out(out_mode, file_)
   UNLESS l_line2 < 0 THEN cur_line := l_line2  }1

AND do_r() BE
/* For each line in the given range (default  .)  substitute  the
new text for the pattern matched.  If the modifier is 'A' or 'I',
then  do  this  for all occurrences on the line, rather than just
the first.  If the modifier is 'I', ask the user to confirm  each
substitution  before  it  is  made. If  the  modifier is a number
(stored as a negative modifier), substitute for  the  appropriate
occurrence  of  the  pattern,  otherwise substitute for the first
occurrence.  */
{1 // trace("do_r:")
   { LET interactive_ = menu_ri -> (modifier = 'I'), FALSE
     AND occurrence = 1
     IF menu_rn THEN
        IF modifier < 0 THEN occurrence := -modifier
     substitute(modifier = 'A' LOGOR interactive_,
            (menu_ri -> interactive_, FALSE), occurrence) } }1

AND do_v() BE
/* If there is no  modifier,  display  the  lines  in  the  range
l_line1-view_half  to  l_line1+view_half  and  set  'cur_line' to
'l_line1'.  If the modifier is 'P' (Previous), set 'cur_line'  to
'l_line1'    and    display    the    lines    in    the    range
'l_line1-2*view_half' to  'l_line1'.   If  the  modifier  is  'N'
(Next), set 'cur_line' to 'l_line1+2*view_half+1' and display the
lines in the the range 'l_line1+1' to 'cur_line'.  */ 
{1 LET low, high = ?, ?
   cur_line := l_line1
   SWITCHON modifier INTO
   { CASE null: low, high := l_line1-view_half, l_line1+view_half
                ENDCASE
     CASE 'P':  low, high := l_line1-2*view_half, l_line1
                ENDCASE
     CASE 'N':  low, high := l_line1+1, l_line1+2*view_half+1
                cur_line := (high > last_line) -> last_line, high
                ENDCASE
   }
   l_line1 := (low < 1) -> 1, low
   l_line2 := (high > last_line) -> last_line, high
   write_out(text_view, FALSE) }1

AND do_x() BE
/*  Execute  the remainder of the command line repeatedly for all
lines of the region matching the specified pattern  ('x_state'  =
'/' or  '\')  or  tagger  ('x_state'  =  '''  or '"').  Execution
proceeds forwards in  terms  of  line  number  for  '/'  or  ''',
backwards for '\' or '"'.  */
TEST ~ menu_x THEN RETURN ELSE
{1 // trace("do_x:")
 { LET count = flagged_lines()
   AND step = (scan_char='/' LOGOR scan_char='*'') -> +1, -1
   LET this_line = (step>0 -> l_line1, l_line2) - step
   LET cmd_string = VEC line_csz
   copy_string(cmd_line, cmd_string)
   FOR i = 1 TO count DO
   {FOR_i
     LET remainder = last_line    // for safety
     check_interrupt()
     {R this_line := this_line + step
        UNLESS 1 <= this_line <= last_line THEN
          this_line := (step=+1) -> 1, last_line
        IF was_flagged(this_line) THEN
        {T cur_line := this_line; cmd(cmd_string,FALSE)
           BREAK  }T         // break from the }R repeat
        remainder := remainder - 1       // perhaps deletion
        IF remainder < 0 THEN GOTO out }R
     REPEAT }FOR_i
   out: x_state_ := FALSE }1

AND do_xc() BE
/* Re-executes the last stored command.  */
TEST ~ menu_xc THEN RETURN ELSE
{1 // trace("do_xc:")
   IF xc_state_ THEN warn(m_exec)
   xc_state_ := TRUE
   cmd(old_cmd,FALSE)
   xc_state_ := FALSE }1

AND do_xf() BE
/* Opens the file specified by the right operand and executes the
commands in it.  */
TEST ~ menu_xf THEN RETURN ELSE
{1 // trace("do_xf:")
   IF no_name_ THEN warn(m_name)
 { LET exec_stream = find_in_file(tmp_name, 0)
   AND cur_in_stream = input()
   AND save_cmd = VEC line_csz
   copy_string(cmd_line,save_cmd)
   UNLESS valid_stream(exec_stream) THEN warn(m_access)
   selectinput(exec_stream); xf_state_ := TRUE
   WHILE got_text(FALSE, FALSE) DO cmd(line,FALSE)
   xf_state_ := FALSE; endread()
   selectinput(cur_in_stream)
   IF save_cmd%0 NE 0 THEN cmd(save_cmd,TRUE)  }1

AND expand(index, size) BE
/* Expand the line pointers starting at 'index' and  then  moving
all forward by 'size' cells.  Then correct 'last_line'.  */
{1 // trace("expand: index=%N size=%N", index, size)
   IF last_line + size > file_lsz THEN warn(m_over)
   copy_lines(index, index+size, last_line-index+1)
   last_line := last_line + size }1

AND extend_str(str,len) BE
/* Extends the string 'str' to a length 'len' by adding blanks if
necessary. */
TEST ~ menu_a LOGAND ~ menu_fm THEN RETURN ELSE
{1 FOR i = str%0 + 1 TO len DO str%i := '*S'
   str%0 := len  }1

AND flagged_lines() = VALOF
/*  Flag  the  lines  to  be considered with the operator X, i,e,
those that match the pattern or tagger.    Yield  the  number  of
lines so flagged.  */
TEST ~ menu_x THEN RESULTIS 0 ELSE
{1 // trace("flagged_lines:")
 { LET count = 0
   FOR i = l_line1 TO l_line2 DO
   {D fetch_line(i); check_interrupt()
      { LET found_ = VALOF
        SWITCHON scan_char INTO
        {S CASE '*'': CASE accent_grave:
             IF menu_t THEN RESULTIS cur_tag = test_tag
           DEFAULT: RESULTIS scan_line(l_margin) > 0 }S
        IF found_ NEQV absence_ THEN
        { flag_the_line(i); count := count + 1 } }D
   IF count <= 0 THEN warn(m_not_found)
   RESULTIS count }1

AND insert_lines(dot_stop_) BE
/*  Insert  text after 'l_line1', stopping at a dot stop line, if
'dot_stop_' is true, otherwise at an end of file.  Set 'cur_line'
to the last line inserted.  */
{1 // trace("insert_lines:")
   reset_byte_count()
   cur_line := l_line1
   WHILE got_text(FALSE, dot_stop_) DO
   { cur_line := cur_line + 1
     IF w_space = 0 THEN make_space(TRUE)
     add_byte_count(store_line(cur_line)) }
   IF w_space > 0 THEN make_space(FALSE)
   IF cur_line = 0 THEN verify_ := FALSE }1

AND interpret() BE
/* Interpret the operator in 'cur_operator'.  */
{1 /* trace("interpret:")
     UNLESS eq_str(file_name, "") THEN {
   writef(" l_got=%N l_line1=%N l_line2=%N l_range=%N*N",
            l_got,   l_line1,   l_line2,   l_range)
   writef(" r_got=%N r_line1=%N r_line2=%N r_range=%N*N",
            r_got,   r_line1,   r_line2,   r_range)
   writef(" cur_line=%N cur_tag=%C cur_operator=%C(%N),*
         * modifier=%C*N",cur_line,cur_tag,cur_operator,
         cur_operator,modifier)
   writes("pattern="); display_pat()
   writef(" new_string=/%S/*N", new_string)
   writef(" altered_=%N xf_state_=%N*N", altered_, xf_state_)  }
*/
 { LET op, mdf = cur_operator, menu_u -> modifier, ?
   IF menu_u THEN pre_trail()
   SWITCHON cur_operator INTO
   {S CASE 'A': IF menu_a THEN
                { IF menu_ovl THEN get_overlay(o_screen)
                  do_a(); ENDCASE }
      CASE 'B': IF menu_u THEN do_b(); ENDCASE
      CASE 'C': do_c(); ENDCASE
      CASE 'D': do_d(); ENDCASE
      CASE 'E': IF menu_ovl THEN get_overlay(o_extra)
                do_e(); ENDCASE
      CASE 'F': IF menu_fm LOGAND ~ menu_screen THEN
                  { do_f(); ENDCASE }
      CASE 'H': IF menu_ovl THEN get_overlay(o_extra)
                  do_h(); ENDCASE
      CASE 'I': do_i(); ENDCASE
      CASE 'J': IF menu_j THEN
                { IF menu_ovl THEN get_overlay(o_justify)
                  do_j(); ENDCASE }
      CASE 'K': do_k(); ENDCASE
      CASE 'L': IF menu_ovl THEN get_overlay(o_extra)
                do_l(); ENDCASE
      CASE 'M': IF menu_fm THEN
                { IF menu_ovl THEN get_overlay(o_extra)
                  do_m(); ENDCASE }
      CASE 'N': IF menu_new THEN do_n(); ENDCASE
      CASE 'P': do_p(); ENDCASE
      CASE 'Q': IF menu_ovl THEN get_overlay(o_extra)
                do_q(); ENDCASE
      CASE 'R': do_r(); ENDCASE
      CASE 'S': IF menu_control THEN
                { IF menu_ovl THEN get_overlay(o_extra)
                  do_s(); ENDCASE }
      CASE 'T': IF menu_t THEN
                { IF menu_ovl THEN get_overlay(o_extra)
                  do_t(); ENDCASE }
      CASE 'U': IF menu_u THEN do_u(); ENDCASE
      CASE 'V': do_v(); ENDCASE
      CASE 'W': IF menu_ovl THEN get_overlay(o_extra)
                do_w(); ENDCASE
      CASE 'X': IF menu_x THEN do_x(); ENDCASE
      CASE 'Y': IF menu_xc LOGOR menu_xf THEN
        SWITCHON modifier INTO
      {T CASE 'A': IF menu_xa THEN
                   { LET do_it_ = do_xa()
                     UNLESS do_it_ ENDCASE }
         CASE 'C': IF menu_xc THEN do_xc(); ENDCASE
         CASE 'F': IF menu_xf THEN do_xf()  }T
                        ENDCASE
      CASE 'Z': IF menu_z THEN do_z(); ENDCASE
      CASE null: do_null(); ENDCASE
      CASE '?': do_query() }S
   IF menu_u THEN post_trail(op,mdf)
   IF verify_ LOGAND verify_on_ THEN
     UNLESS last_line = 0 LOGOR
            (menu_control -> l_got = control, FALSE) THEN
       TEST menu_control THEN
       { fetch_line(-char_number('+', control_chars))
         cmd(line,FALSE) }
       ELSE cmd(echo_string(),FALSE)  }1

.

