
// SECTION "EF7"  // Last modified 83-10-20

/*  The  routines  in  this  section are concerned with output of
lines of text to files or devices.  Except for 'start_ef7', these
are listed in alphabetic order.  */

GET "CHEF_EF0"

GET "GO_SYSHDR"

LET start_ef7(n) BE
{1 // writes("<>start_ef7:*N")
   warn_code := '0'
   check_system(n, computer, 7); start_ef7a(n)
   IF menu_screen THEN
     IF screen_name = 0 THEN screen_name := gt_screen_name() }1

AND out_line(lno, out_mode) BE
/* Send the string 'line' to  the  current  output  stream.    If
'lno>0', then precede the text with a line number and the tag, if
any.     */
{1 // trace("out_line: lno=%N out_mode=%N*N", lno, out_mode)
   LET pos = ~ menu_pm -> 1,
      (modifier = 'M') -> scan_line(l_margin,pat), 1
   AND n = 0
   IF lno > 0 LOGAND pos > 0 THEN out_lno(lno,out_mode)
   SWITCHON out_mode INTO
   {S CASE byte_count_only:                       ENDCASE
      CASE match_positions: IF menu_pm THEN
        WHILE pos > 0 DO
        {W n := n + 1; writef("%N ",pos)
           IF n = 20 THEN
           { newline(); out_lno(lno,out_mode); n := 0 }
           TEST len_match = 0 THEN BREAK
           ELSE pos := scan_line(pos+len_match,pat) }W
                                                  ENDCASE
      DEFAULT: n := sys_emas \/ sys_unix32 -> 0, 1
        TEST sys_emas \/ sys_unix32 THEN
        { LET ec = sys_emas -> 0, 1
          TEST menu_pl THEN
             TEST out_mode = text_lucid THEN
             { FOR i = 1 to line%0 DO dump(line%i)
               n := 1
             }
             ELSE
               ec := writerec(line)
          ELSE ec := writerec(line)
          IF sys_emas THEN IF ec < 0 THEN warn(m_access)
          IF sys_unix32 THEN IF ec = 0 THEN warn(m_write)
        }
        ELSE TEST sys_cpm \/ sys_vms THEN
        {C FOR i = 1 TO line%0 DO
           {F LET ch, ec = line%i, 1
              TEST menu_pl THEN
                TEST out_mode = text_lucid THEN dump(ch)
                ELSE ec := wrch(ch)
              ELSE ec := wrch(ch)
              IF ec = 0 THEN warn(m_write) }F }C
        ELSE
        { FOR i = 1 TO line%0 DO
          {F LET ch = line%i
             TEST menu_pl THEN
               TEST out_mode = text_lucid THEN dump(ch)
               ELSE wrch(ch)
             ELSE wrch(ch) }F } }S
   IF n > 0 THEN newline() }1

AND out_lines(out_mode) BE
/*  Send  the  lines  of  the range 'l_line1' to 'l_line2' to the
currently selected output stream.  If 'lno_' is true, then  print
the line number and the tag, if any.  For  the  other  parameters
see 'out_line'. */
{1 // trace("out_lines: out_mode=%N*N", out_mode)
   LET numbered_ = (out_mode = text_view) LOGOR
     (menu_pm -> ((out_mode = text_numbered) LOGOR
                (out_mode = match_positions)),
                (out_mode = text_numbered))
   reset_byte_count()
   FOR i = l_line1 TO l_line2 DO
   {F check_interrupt(); fetch_line(i)
      add_byte_count(1 + line%0)
      out_line((numbered_ -> i, 0), out_mode) }F }1

AND out_lno(lno,out_mode) BE
/*  Send  the  line  number  and  the tag, if any, to the current
output stream.  If 'out_mode' =  'text_view',  flag  the  current
line with '*'. */
{1 // trace("out_lno: lno=%N out_mode=%N*N", lno, out_mode)
   writed(lno, number_bsz)
   wrch(out_mode=text_view LOGAND lno=cur_line -> '**', ' ')
   TEST menu_t THEN wrch(cur_tag = null -> '*S', cur_tag)
   ELSE wrch('*S')
   wrch(margin_symbol) }1

AND write_out(out_mode, file_) BE
/* Write out the lines in the range 'l_line1' to 'l_line2'.   The
values of 'out_mode' are:-
  text_counted     (text and byte count)
  text_only
  text_lucid       (unprintable characters in octal or hex)
  text_numbered    (text with line numbers)
  text_view        (windowed, line numbers, 'cur_line' marker)
  byte_count_only
  match_positions
If  'file_'  is  true,  output  is  to  a  file, otherwise to the
console.  */
{1 // trace("write_out: out_mode=%N, file_=%N", out_mode, file_)
 { LET count_out_ = file_ LOGOR (out_mode = byte_count_only)
   IF file_ THEN
   { LET stream = create_file(tmp_name, 0, 3)
     selectoutput(stream); no_out_trim_or_control(stream)  }
   out_lines(out_mode)
   IF file_ THEN
   { endwrite()
     IF sys_emas THEN e.movefile(tmp_name)
     selectoutput(console_out_stream); bell() }
   IF count_out_ THEN print_byte_count() }1

 .

