
// SECTION "EF7a"   // Last modified 83-10-20

MANIFEST { captest_ = FALSE }
STATIC { logfile = ? }

/*  This  section  handles  the reading from the keyboard and the
writing on the screen for both screen and template editing.
    In screen mode, at the lowest  level,  any  character  (byte)
read from the keyboard is yielded by the function 'gchar' and any
character written to the screen is put there by 'pchar'.
    At  the  next  level, reading from the keyboard is handled by
'get_terminal', which yields a token.  If the value of the  token
is  less  than  256,  then  it  is  printable,  otherwise it is a
"terminal capability", e.g., cap_kl  (cursor_left).   Writing  to
the screen is handled by 'put_terminal' using the same tokens.
    The  intention  is  that 'pchar' and 'gchar' will depend upon
the operating system and will be  called  by  'get_terminal'  and
'put_terminal'   only.    The   procedures   'put_terminal'   and
'get_terminal' use tables read from the message  file  to  decide
how to handle a particular terminal.
    Above this level there is the function 'terminal_action' that
handles  all  movement  within  a  line.  Any attempt to move the
cursor away from the line in  which  it  rests  will  cause  this
function to complete its elaboration and yield a value giving the
reason  for  the exit, e.g., cap_kd (cursor_down), cap_ku (cursor
up), cap_cr (carriage return) etc.  */

GET "CHEF_EF0"

GET "GO_SYSHDR"
MANIFEST
{ rb_ch            = ascii_ ->
                     (sys_prime -> #O377, #O177), null
  end_state        = #B01   // End of a listening string
  end_choice       = #B10   // No more characters to choose from
  /* Constants used for screen-mode editing.  */
  cap_print        = 512 +1 // Printable character
  step_size        =   8 }  // Tab steps

STATIC {
  pvec   = ?
  svec   = ? } // for capability tables

LET start_ef7a(n) BE
{1 // writes("<>start_ef7a*N")
   UNLESS captest_ DO
     check_system(n, computer, 71)
   IF menu_screen THEN
   {2 pvec := caps_vec; svec := caps_vec + pvec_csz
//      screen_name := sys_msdos -> ('v'<<8) + '9',
//                                  0   // no name
      cursor_x, screen_shift := 0, 0
      impotent_ := FALSE
      insert_mode_, in_screen_ := FALSE, FALSE }2
logfile := findoutput("LOG")
      UNLESS captest_ DO start_ef7b(n) }1

AND display_legend() BE
/* Display the legend at the top of the screen, possibly using
reverse video or underlining or whatever.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 // trace("display_legend")
   put_terminal(cap_ho)
   put_terminal(cap_so)
   pchars(legend,1,legend%0)
// put_terminal(cap_lg)   // Pity it doesn't work
   put_terminal(cap_se) }1

AND display_one(from_i, to_i, cp) BE
/*  In  screen-mode,  display  characters from 'line' starting at
'from_i' up to 'to_i'.  We must be careful to send no  more  than
the  screen  line  can  hold.   If 'cp' is positive, then display
blanks only.  Note  that  if  'screen_shift'  is  positive,  then
values need adjustment.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 LET right_i = screen_shift + screen_cols
// IF from_i < screen_shift THEN from_i := screen_shift
// Correction by RSH 82-20-31
   IF from_i <= screen_shift THEN from_i := screen_shift + 1
   IF to_i > right_i THEN to_i := right_i
   TEST cp > 0 THEN
      FOR i = from_i TO to_i DO put_terminal('*S')
   ELSE pchars(line,from_i,to_i) }1

AND dot_stop_line() = VALOF
/*  This  yields  true if 'line' has only one non-blank character
which is a dot, '.', in position one.  */
{1 // trace("dot_stop_line:")
   IF line%0 > 0 LOGAND line%1 = '.' THEN
   {2 FOR i = 2 TO line%0 DO
        UNLESS line%i = '*S' THEN RESULTIS FALSE
      RESULTIS TRUE }2
   RESULTIS FALSE  }1

AND erase_legend() BE
/* Erase the legend when terminating screen mode.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 put_terminal(cap_ho)
   put_terminal(cap_ce); refresh(cap_ce) }1

AND gchar() = VALOF
/*  In  screen  mode,  read one character from the keyboard.  The
echoing to the screen is done, if necessary,  in  'put_terminal'.
This function is called only by 'get_terminal' */
TEST ~ menu_screen THEN RESULTIS 0 ELSE
TEST sys_unix THEN
{ LET c = 0
  read(input(), @c, 1)
  RESULTIS c } ELSE
TEST sys_emas THEN
{ LET c = rdch() & #x7f
  AND o = output()
  selectoutput(logfile)
  TEST (0 <= c <= 31) LOGOR (c = 127) THEN writef("%X2*N", c) ELSE writef("%C*N", c)
  selectoutput(o)
  RESULTIS c
}
ELSE
TEST sys_msdos THEN RESULTIS msdosgchar() ELSE
TEST sys_rdos THEN
{1  rcall(sys.gchar); RESULTIS ac0 }1
ELSE RESULTIS 'Q'

AND get_capability(c, p) = VALOF
/*  A  recursive  routine  that  looks  at  the character 'c' and
compares it with state 'p' in the  automaton  to  determine  what
particular  sequence is being received.  The value yielded is the
internal code of the capability string recognized.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 // trace("get_capability: c=%C(%N) p=%N*N", c, c, p)
   TEST c = g1vec%p THEN // Expected character ?
   {2 LET state = g2vec%p /\ end_state
      LET g3 = g3vec%p
      TEST state = end_state THEN RESULTIS g3 ELSE
      RESULTIS get_capability(gchar(), g3) }2
   ELSE
   {2 LET choice = g2vec%p /\ end_choice
      TEST choice = end_choice THEN RESULTIS cap_k0 - 256
      ELSE RESULTIS get_capability(c, p+1) }2 }1

AND get_terminal() = VALOF
/*  In  screen  mode,  reads a character or special code sequence
from the terminal and yields the corresponding token.   Printable
characters  are identified and cause the yield of that character,
otherwise it is some other terminal capability which  results  in
the yield of a number greater than 256.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 LET c = gchar()
   TEST '*S' <= c < rb_ch THEN
   { put_terminal(c); RESULTIS c }
   ELSE
   { LET cap = 256 + get_capability(c, 0)
     put_terminal(cap)
     RESULTIS cap } }1

AND got_text(pfx_, dot_stop_) = VALOF
TEST menu_screen & ~ sys_emas THEN
/*  In  screen mode on most machines, reads a line of text either
from the terminal or from a file.  If input is from the terminal,
the input is prompted with a '>' if  'pfx_'  is  true.   Terminal
input  is  terminated by RETURN, by any key that moves the cursor
off the line being typed, or by special keys such as INSERT LINE,
DELETE LINE and so on.  When input is from a file,  the  line  is
terminated  by  either  '*N'  or  by  end  of file.  The function
normally returns true at the end of a line.  In the case of  file
input,  it  returns  false if end of file is encountered straight
away.  In all cases the function returns false if 'dot_stop_'  is
true  and  the  line  contains  nothing  but  a  '.' in the first
position.  */
{1 // trace("got_text:")
 { LET ii = input()
   check_interrupt()
   IF menu_t THEN cur_tag := null
   TEST ii = console_in_stream THEN
   {T TEST pfx_ THEN
      { LET len = prefix_length(prefix_on_ /\ pfx_)
        FOR i = 1 TO len DO line%i := '*S'
        line%0 := len }
      ELSE line%0 := 0
      cursor_x := line%0 + 1
      UNLESS (terminal_action(FALSE,0,FALSE)=cap_cr) THEN
      /* There should be a warn(wrong_action) here  */
        RESULTIS FALSE }T
//    IF terminal_action(FALSE, 0, FALSE) = cap_k0 THEN
//      RESULTIS FALSE }T
   ELSE
   {F LET i, c = 1, rdch()
      IF c = endstreamch THEN RESULTIS FALSE
      WHILE c ~= '*N' LOGAND c ~= endstreamch DO
      {W IF i > line_bsz THEN warn(m_input_too_long)
         line%i := c; i := i + 1; c := rdch() }W
      line%0 := i-1 }F
   RESULTIS dot_stop_ -> ~ dot_stop_line(), TRUE }1
ELSE
/* When not in screen mode, or on machines which operate best  in
line mode except when actually screen editing, if 'pfx_' is true,
then  console  input  is  prompted  with  a '>' character (unless
prefix_on_ is false). The routine  reads  a  line  of  text  into
'line',  yielding  false  if  end  of  file is encountered or (if
'dot_stop_' is true) a dot stop line is encountered. (A dot  stop
line has only one non-blank character, a '.' in position 1.) */
{1 // trace("got_text:")
   check_interrupt()
   IF input() = console_in_stream THEN
     prefix_length(prefix_on_ LOGAND pfx_)
   IF menu_t THEN cur_tag := null
   TEST sys_emas THEN
   { LET c = readrec(line, line_bsz)
     IF c < 0 THEN
     { IF c = -154 THEN warn(m_input_too_long)
       line%0 := 0
       RESULTIS FALSE } }
   ELSE TEST sys_unix32 THEN
   { LET c = readrec(line,line_bsz)
     IF c = 0 & result2 = 100 THEN warn(m_input_too_long)
     IF c < 0 THEN
     { line%0 := 0
       RESULTIS FALSE
     }
   }
   ELSE
   { LET i, c, console_ = 1, rdch(), (input() = console_in_stream)
     UNTIL c = '*N' DO
     {U IF c = endstreamch THEN { line%0 := 0; RESULTIS FALSE }
        line%i := c
        IF console_ THEN SWITCHON c INTO
        {S CASE delete_symbol: i := accept_delete(i); ENDCASE
           CASE tab_symbol:    i := accept_tab(i) }S
        i := i + 1
        IF i > line_bsz THEN warn(m_input_too_long)
        c := rdch() }U
     line%0 := i - 1 }
   RESULTIS dot_stop_ -> ~ dot_stop_line(), TRUE }1

AND is_letter(c) = ('a'<=c<='z')\/('A'<=c<='Z')

AND pchar(c) BE
/* In screen mode, puts the character 'c' on the screen.  */
  TEST ~ menu_screen THEN RETURN ELSE
  TEST sys_unix THEN
  { write(output(), @c, 1) } ELSE
  TEST sys_emas THEN e.pchars((@c<<2)+3,1) ELSE
  TEST sys_msdos THEN msdospchar(c) ELSE
  TEST sys_rdos THEN
  rcall(sys.pchar, c)
  ELSE RETURN

AND pchars(line,from_i,to_i) BE
/*  In  screen mode, puts the characters from 'line', starting at
'from_i' and ending at 'to_i', to the screen.   On  some  systems
this  may  be implemented more efficiently than repeated calls to
'pchar'. */
TEST ~ menu_screen THEN RETURN ELSE
{1 // trace("pchars:")
  TEST sys_emas THEN
    e.pchars((line<<2)+from_i,to_i-from_i+1)
  ELSE
  FOR i = from_i TO to_i DO pchar(line%i) }1

AND put_cap(cap) BE
/*  The  parameter 'cap' is the capability.  This routine behaves
in a way similar to 'writef'.  For a  full  explanation  see  the
descriptions of the TERMCAP file in UNIX.  One or more characters
may be sent to the screen.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 LET p = pvec%(cap-256)             // Index into svec
   LET top = p + svec%p               // Index of last char
   LET f = pchar                      // Default output format
   LET xy_ = FALSE                    // x before y
   LET x, y = cursor_x-1, cursor_y-1  // Zero origin
   LET n = y                          // The coordinate
   IF p = 0 THEN RETURN               // Undefined cap
   IF top = p THEN impotent_ := TRUE
   FOR pp = p+1 TO top DO
   {f LET ch = svec%pp
      TEST ch = '%' THEN
      {t pp := pp + 1; ch := svec%pp
         SWITCHON ch INTO
         {s DEFAULT: err("pt_ch %C", ch)
            CASE '>': IF n > svec%(pp+1) THEN n := n + svec%(pp+2)
              pp := pp + 2;                      LOOP
            CASE 'n': n := n NEQV #140;          LOOP
            CASE 'i': n := n + 1; x, y := x + 1, y + 1
                                                 LOOP
            CASE 'B': n := 16*(n/10)+(n REM 10); LOOP
            CASE 'D': n := n-2*(n REM 16);       LOOP
            CASE 'r': xy_ := TRUE; n := x;       LOOP
            CASE 'd': f := ptd;                  ENDCASE
            CASE '+': pp := pp + 1; n := n + svec%pp
            CASE '.':                            ENDCASE
            CASE '%': pchar('%');                LOOP
            CASE '2': f := pt2;                  ENDCASE }s
         f(n)
         n := xy_ -> y, x }t
      ELSE pchar(ch) }f }1

AND ptd(n) BE
/* Put 'n' in decimal digits.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 IF n >= 10 THEN ptd(n/10)
   pchar(n REM 10 + '0') }1

AND pt2(n) BE
/* Put 'n' as two decimal digits.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 pchar(n/10 + '0'); pchar(n REM 10 + '0') }1

AND put_terminal(cap) BE
/*  If  'cap'  is  less then 256, then this is a simple printable
character; otherwise, it is a screen capability that may  involve
sending  a  control  string.  If so this is handled by 'put_cap'.
*/
TEST ~ menu_screen THEN RETURN ELSE
{1 // trace("put_terminal: cap=%N", cap)
   IF cap < 256 THEN { pchar(cap); RETURN }
   SWITCHON cap INTO
   {2 CASE cap_k1: CASE cap_k2: CASE cap_k3:
      CASE cap_k4: CASE cap_k5: CASE cap_k0:
      CASE cap_rb:                                   ENDCASE
      CASE legend_on: display_legend();              ENDCASE
      CASE legend_off: erase_legend();               ENDCASE
      DEFAULT: put_cap(cap) }2 }1

AND refresh(cap) BE
/* This refreshes one line for those screens  that  are  impotent
with  respect  to  'dc',  'ic'  and  'ce'.  Note a duplication of
'cap_ce' with 'simulate' in EF4a because of overlay  problems  on
small machines.  */
TEST ~ menu_screen THEN RETURN ELSE
TEST captest_ THEN RETURN ELSE
TEST sys_rdos THEN RETURN ELSE
{1 TEST NOT impotent_ THEN RETURN ELSE impotent_ := FALSE
   SWITCHON cap INTO
   {s CASE cap_ce: // clear to the end
        display_one(cursor_x, screen_cols, 1);  ENDCASE
      CASE cap_ic: // Insert character
      CASE cap_dc: // Delete character
        display_one(cursor_x + screen_shift, line%0, 0)
        put_terminal('*S');                     ENDCASE }s
   put_terminal(cap_cm) }1

AND skip_word(right_, lno, line_fetched_) = VALOF
/*  Yields  0  if  the  next  word is in the same line, otherwise
yields 'left_fault', 'right_fault', 'left_edge', 'right_edge'  as
appropriate.  */
{1 LET len = line%0 - screen_shift
   LET one_step = right_ -> +1, -1
   IF len > screen_cols THEN len := screen_cols
   UNLESS right_ THEN IF cursor_x = 1 THEN
     GOTO check_edge                   // RESULTIS FALSE
   {r cursor_x := cursor_x + one_step
      UNLESS 1 <= cursor_x <= len THEN
        GOTO check_edge                // RESULTIS FALSE
    { LET c = line%(cursor_x+screen_shift)
      UNLESS is_letter(c) = right_ THEN BREAK }r
   REPEAT
   {r cursor_x := cursor_x + one_step
      UNLESS 0 <= cursor_x <= len THEN
        GOTO check_edge                //  RESULTIS FALSE
    { LET p = cursor_x+screen_shift
      LET c = p=0 -> 0, line%(p)
      IF is_letter(c) = right_ THEN
      { UNLESS right_ THEN cursor_x := cursor_x + 1; BREAK } }r
   REPEAT
   put_terminal(cap_cm)
   RESULTIS 0
  check_edge:
   IF line_fetched_ THEN store_line(lno)
   TEST right_ THEN
     TEST cursor_x >= screen_cols THEN RESULTIS right_edge
     ELSE RESULTIS right_fault
   ELSE
     RESULTIS (screen_shift > 0) -> left_edge, left_fault }1
// RESULTIS TRUE }1

AND terminal_action(fetch_, lno, credit_) = VALOF
/* In screen  mode,  edits  the  content  of  'line'  by  calling
'get_terminal' repeatedly and applying the editing token yielded.
If  'fetch_'  is true, the line specified by 'lno' must be loaded
as soon as an edit requiring modification of the  line's  content
is  encountered.   If  'credit_'  is  true, the line has not been
stored in the work-space and certain editing actions then require
that it be actualized.  A credit line can  only  exist  when  the
work-space is being edited, when 'fetch_' is also true.
    The  token 'right_fault' is yielded on an attempt to move the
cursor two positions beyond the line end.  The token 'left_fault'
is yielded on an attempt to move the cursor left at the beginning
of a line.  The token 'left_edge' ('right_edge') is yielded on an
attempt to move the cursor right at the right edge of the  screen
(left at the left edge of the screen).
    Other editing tokens cause the function to exit, yielding the
value  of  the  token.   If the function has fetched the original
line, the edited contents of  'line'  are  restored  before  exit
except  in  the  case  of  the  token  'cap_k1'  (renew) which is
intended to cause restoration of the unedited line.  */
TEST ~ menu_screen THEN RETURN ELSE
{1 LET line_fetched_ = FALSE
   IF credit_ THEN line%0 := 0
   {R LET cur_ch = '*S'
      LET cap = get_terminal()
      IF captest_ THEN
        cur_cap := cap // Used only for testing this routine
      IF cap < 256 THEN { cur_ch := cap; cap := cap_print }
      {W LET pos = ?
         /* Catch the out-of-line movement and prepare for in-line */
         SWITCHON cap INTO
         {S1
           CASE cap_ei: insert_mode_ := FALSE;      ENDCASE
           CASE cap_im: insert_mode_ := TRUE;       ENDCASE
           CASE cap_k1: /* Renew */                 RESULTIS cap
           CASE cap_cr: put_terminal(cap_do)
           CASE cap_k5: /* Inject */
           CASE cap_dl:
             IF credit_ THEN
             { expand(lno, 1); line_fetched_ := TRUE }
           CASE cap_k2: /* Merge */
           CASE cap_al:
             IF in_screen_ THEN altered_ := TRUE
           /* Those remaining here do not alter the work.  */
           CASE cap_ku: CASE cap_kd:
           CASE cap_k3: /* Mark */
           CASE cap_k4: /* Save */
           CASE cap_k0: // CASE left_fault:
             IF line_fetched_ THEN store_line(lno); RESULTIS cap
           /*  Now for those that alter the line.  */
           CASE cap_print:
           CASE cap_ic: CASE cap_dc: CASE cap_rb:
             IF in_screen_ THEN altered_ := TRUE
             pos := cursor_x + screen_shift
             IF credit_ THEN
             { expand(lno, 1);
               credit_, line_fetched_ := FALSE, TRUE }
           CASE cap_wl: CASE cap_wr:
           CASE cap_kl: CASE cap_kr: CASE cap_kb:
             IF fetch_ LOGAND (NOT line_fetched_) THEN
             { fetch_line(lno); line_fetched_ := TRUE } }S1
         /* Execute the in-line capability  */
         SWITCHON cap INTO
         {S2
           CASE cap_wl: CASE cap_wr:
           { LET state = skip_word(cap=cap_wr, lno, line_fetched_)
             TEST state = 0 THEN                           ENDCASE
             ELSE                                RESULTIS state }
           CASE cap_kl: CASE cap_kb:
             TEST cursor_x = 1 THEN
             { IF line_fetched_ THEN store_line(lno)
               RESULTIS (screen_shift > 0) -> left_edge,left_fault }
             ELSE cursor_x := cursor_x - 1;           ENDCASE
           CASE cap_kr: TEST cursor_x >= screen_cols THEN
             { IF line_fetched_ THEN store_line(lno)
               RESULTIS right_edge }
             ELSE TEST fetch_ LOGAND
               (cursor_x + screen_shift > line%0) THEN
             { IF line_fetched_ THEN store_line(lno)
                                         RESULTIS right_fault }
             ELSE cursor_x := cursor_x + 1            ENDCASE
           CASE cap_ic:  cur_ch := '*S'
           CASE cap_print:
             TEST cursor_x >= screen_cols THEN
             { IF line_fetched_ THEN store_line(lno)
               RESULTIS right_edge }
             ELSE
             IF insert_mode_ \/ (cap = cap_ic) THEN
             { IF (line%0 + 1 > line_bsz) THEN warn(m_text_too_long)
               FOR j = line%0 TO pos BY -1 DO line%(j + 1) := line%j
               IF line%0 >= pos THEN line%0 := line%0 + 1 }
             UNLESS cap=cap_ic THEN cursor_x := cursor_x + 1
//           IF cursor_x > screen_cols-5 THEN bell()
             IF pos > line_bsz THEN warn(m_text_too_long)
             IF pos > line%0 THEN extend_str(line, pos)
             line%pos := cur_ch;
             IF cap=cap_ic THEN refresh(cap_ic);      ENDCASE
           CASE cap_dc: IF (pos <= line%0) THEN
           { copy_bytes(line%0 - pos, line, pos+1, line, pos)
             line%0 := line%0 - 1;  refresh(cap_dc) };ENDCASE
           CASE cap_rb: IF cursor_x > 1 THEN
           { put_terminal(cap_kl); cursor_x := cursor_x - 1
             IF (pos = 1+line%0) THEN
             { line%0 := pos - 2
               put_terminal('*S'); put_terminal(cap_kl) } } }S2 }W }R
REPEATUNTIL captest_ }1

.

