
// SECTION "EF7b"   // Last modified 83-10-25

/*  This  section handles the less commonly used commands, and is
separate for the convenience of overlays.  For this  purpose,  it
is the 'o_extra' section.  */

GET "CHEF_EF0"

GET "GO_SYSHDR"

LET start_ef7b(n) BE
{1 // writes("<>start_ef7b*N")
   check_system(n, computer, 72); start_ef8(n) }1

AND do_e() BE
/* Empty the workspace. The value of 'tmp_name' sets the name  of
the current file, which is read if its name is not null.  */
{1 // trace("do_e:")
   IF altered_ LOGAND ~ tried_once_ THEN guard_file()
   empty_work_space(); init_work_space(TRUE)  }1

AND do_h() BE
/*  Print the help message associated with the first character of
the operand, default '0'.  */
{1 // trace("do_h:")
   put_msg(no_name_ -> '0', tmp_name%1) }1

AND do_l() BE
/* This loads the various  system  parameters  according  to  the
modifier given. */
{1 // trace("do_l:")
   SWITCHON modifier INTO
   {S CASE 'F': copy_string(tmp_name, file_name);   ENDCASE
      CASE 'L': TEST menu_j THEN
      {J TEST 1 <= r_line1 <= r_verge THEN
         { l_verge := r_line1;              ENDCASE }
         ELSE warn(m_combination) }J ELSE warn(m_na)
      CASE 'P': prefix_on_ := ~ prefix_on_;         RETURN
      CASE 'R': TEST menu_j THEN
      {J TEST l_verge <= r_line1 <= line_bsz THEN
         { r_verge := r_line1;              ENDCASE }
          ELSE warn(m_combination) }J ELSE warn(m_na)
      CASE 'T': TEST menu_j THEN
      {J TEST 1 <= r_line1 <= r_verge - l_verge + 1 THEN
         { threshold := r_line1;            ENDCASE }
         ELSE warn(m_combination) }J ELSE warn(m_na)
      CASE 'V': verify_on_ := ~ verify_on_;         ENDCASE
      CASE carat_symbol:
        UNLESS 1<= r_line1 <=r_margin THEN warn(m_combination)
        l_margin := r_line1;                        ENDCASE
      CASE '$':
        UNLESS l_margin <= r_line1 <= line_bsz THEN
                        warn(m_combination)
        r_margin := r_line1;                        ENDCASE }S
    do_query() }1

AND do_m() BE
/*  Merge  the  lines  in  the  given  range  (default .) and set
'cur_line' to the merged line. If  'new_string'  is  non-null,  a
copy  of  it  is  inserted  at each join. If the modifier is 'C',
intervening spaces and tabs are removed. All tags are cleared. */
TEST ~ menu_fm THEN RETURN ELSE
{1 // trace("do_m:")
  { LET mbuf = VEC line_csz AND llen, blen, first = ?, ?, ?
    AND nlen = new_string%0
    mbuf%0 := 0
    FOR i = l_line1 to l_line2 DO
    { fetch_line(i)
      llen := line%0; first := 1; blen := mbuf%0
      IF i = l_line2 THEN nlen := 0
      IF modifier = 'C' THEN
      { IF i NE l_line2 THEN
          FOR j = llen TO 1 BY -1 DO
          { IF '*T' NE line%j NE '*S' BREAK; llen := j-1 }
        IF i NE l_line1 THEN
        { FOR j = 1 to llen DO
          { IF '*T' NE line%j NE '*S' BREAK; first := j+1 }
          llen := llen-first+1
        }
      }
      IF llen + blen + nlen > line_bsz THEN warn(m_text_too_long)
      copy_bytes(llen, line, first, mbuf, blen + 1)
      IF nlen NE 0 THEN
         copy_bytes(nlen, new_string, 1, mbuf, blen + llen + 1)
      mbuf%0 := llen + blen + nlen
    }
    copy_string(mbuf, line)
    IF menu_t THEN cur_tag := null
    store_line(l_line1)
    UNLESS l_line1 = l_line2 DO
       delete_lines(l_line1+1, l_line2, l_range-1)
    cur_line := l_line1 } }1

AND do_q() BE
/* With modifier S, this causes a temporary exit to the operating
system. Otherwise  it  unstacks  the  current workspace (modifier
null) or all workspaces (modifier Q).  */ 
{1 IF menu_qs THEN
     IF modifier = 'S' THEN { do_sys_call(); RETURN  }
   IF altered_ LOGAND ~ tried_once_ THEN guard_file()
   WHILE unstack_work_space() DO
   { writef("file: %S*N", file_name)
     IF modifier = null THEN RETURN
     IF altered_ LOGAND ~ tried_once_ THEN guard_file() }
   TEST menu_dynamic THEN transfer(quit) ELSE
   longjump(lvl, quit) }1

AND do_query() BE
/* When the operand is null, print the warning message associated
with  'warn_code'. Otherwise  print  information corresponding to
the command modifier.  */ 
{1 SWITCHON modifier INTO
   {S CASE 'F': writef("file: %S", file_name);    ENDCASE
      CASE 'T': TEST menu_j THEN
        { writef("T%N", threshold);               ENDCASE }
        ELSE warn(m_na)
      CASE 'L': TEST menu_j THEN
        { writef("L%N", l_verge);                 ENDCASE }
        ELSE warn(m_na)
      CASE 'P': writes(prefix_on_ -> "On", "Off");ENDCASE
      CASE 'R': IF menu_j THEN
        { writef("R%N", r_verge);                 ENDCASE }
      CASE ':': TEST menu_j THEN
        { writef(":%C", centre_symbol);           ENDCASE }
        ELSE warn(m_na)
      CASE 'V': writes(verify_on_ -> "On", "Off");ENDCASE
      CASE carat_symbol: writef("%C%N", carat_symbol, l_margin)
                                                  ENDCASE
      CASE '$': writef("$%N", r_margin);          ENDCASE
      CASE 'C': writes(no_case_ -> "On", "Off");  ENDCASE
      CASE '/': CASE under_symbol: display_pat(); ENDCASE
      DEFAULT: put_msg(warn_code)
         warn_code := m_told;                     RETURN
   }S
   newline()
}1

AND do_s() BE
/* Segment the specified line using 'pat' and store the  segments
in control  lines.   If the modifier is 'A' then the segments are
defined by all occurrences of 'pat' rather than just  the  first.
*/
TEST ~ menu_control THEN RETURN ELSE
  split_line(l_line1, modifier = 'A')

AND do_t() BE
/* Mark the lines in the given range (default .) with the operand
(which is a character).  Set the current line to the last line so
marked.  */
TEST ~ menu_t THEN RETURN ELSE
{1 // trace("do_t:")
   FOR i = l_line1 TO l_line2 DO
   { fetch_line(i); cur_tag := tag_char
     store_line(i); check_interrupt() }
   cur_line := l_line2 }1

AND do_w() BE
/*  Write  the  entire  workspace  to  the  file   specified   in
'tmp_name'. */
{1 // trace("do_w:")
   IF no_name_ THEN warn(m_name)
   l_line1, l_line2 := 1, last_line
   write_out(text_counted, TRUE)
   altered_ := FALSE  }1

AND get_msg_directory() = VALOF
/* The message file may have been opened by EF4A, which will have
set the first cell of 'msg_table' to 1 (it was initialised to  -1
in EF1).  Otherwise, the file is now opened if possible.  If this
cannot  be  done, the first cell of 'msg_table' is set to -2. The
editor then fails 'soft' rather than crashing.   If  the  message
file  is  now  open,  the directory is read and the first cell of
'msg_table' is set to 0 to indicate that  the  directory  is  now
installed.
The format of the message file
directory is:

   The above is a directory for this file. Its format is:
   d
   t1|n1 t2|n2 ... 00|n0
   k
   e1, e2, ... ek
   c1 m1 ... cz mz _
   where d is the size of the directory
         ti is the i-th terminal name
         ni is the size of the i-th capability table
         k is the number of error messages
         ei is the size of the i-th error message
         mi is the size of the help message associated with
            the character ci.
   Sizes are in grabs or lines.

The program MDIR may be used to produce a directory.
This  function  yields  TRUE  if  the  message  file  was  opened
successfully; otherwise it yields FALSE.  */
{1 LET m_f = name_of_msg_file()
   IF msg_table!0 = -1 THEN   // open not yet attempted
     msg_in_stream := find_in_file(m_f, msg_pswd)
   UNLESS valid_stream(msg_in_stream) THEN
   { msg_table!0 := -2   // mark file not available
     RETURN }
 { LET in = input(); selectinput(msg_in_stream)
   set_file_position(msg_in_stream, 0)
 { LET n = readn()
   LET k = ?
   LET c1, c2, c3 = ?, '*S', rdch()
   {r c1, c2, c3 := c2, c3, rdch() REPEATUNTIL c3 = '|'
      n := n + readn() }r       // add table size
   REPEATUNTIL c1 = '0' = c2
   k := readn()   // number of error messages
   FOR j = 1 TO k DO { msg_table ! j := n; n := n + readn() }
   help_table ! 0, warn_code := n, '0'
 { LET c = ? AND i = 0
   {R c := rdch() REPEATWHILE c = '*S' LOGOR c = '*N'
      IF c = '_' THEN { alpha%0 := i; BREAK }
      i := i + 1; alpha%i , help_table ! i := c, n
      n := n + readn() }R   REPEAT
   IF sys_mts LOGOR sys_470 THEN rewind()
   msg_table!0 := 0; selectinput(in) }1

AND guard_file() BE
/* If the file has been altered, then warn the user.  */
 {1 tried_once_ := TRUE
    writef("file: %S*N", file_name)
    warn(m_quit) }1

AND postlude() BE
/* Close all files and destroy the work file.  */
{1 // trace("postlude:")
   IF msg_table ! 0 GE 0 THEN
   { selectinput(msg_in_stream); endread() }
   end_work_file() }1

AND put_msg(n) BE
/*  Print the message corresponding to 'n'.  If n < 0, then it is
an error message, otherwise  it  is  a  help  message.   Printing
continues until a dot-stop line is encountered.  */
{1 // trace("put_msg: n=%N", n)
   IF msg_table!0 = -1 \/ msg_table!0 = 1 THEN
     get_msg_directory()
                                        // not yet open
   IF msg_table!0 = -2 THEN  // message file could not be opened
   { LET cur_out_stream = output()
     selectoutput(console_out_stream)
     writes("Help/message file not available.*N")
     selectoutput(cur_out_stream); RETURN }
   IF menu_screen THEN
     IF upper_case(n) = 'A' THEN n := '='
   n := (n < 0) -> msg_table!(-n),
                   help_table!uc_char_number(n,alpha)
 { LET cur_in_stream = input()
   selectinput(msg_in_stream)
   make_indexed(msg_in_stream);set_file_position(msg_in_stream,n)
   WHILE got_text(FALSE, TRUE) DO
   {R make_sequential(msg_in_stream)
      out_line(0, text_only)
      check_interrupt() }R
   selectinput(cur_in_stream) }1

AND read_file(name) BE
/*  Read  the  file 'name' into the work space.  */
{1 // trace("read_file: name=%S", name)
 { LET n = find_in_file(name, 0)
   AND cur_in_stream = input()
   UNLESS valid_stream(n) THEN warn(m_access)
   selectinput(n)
   insert_lines(FALSE); bell()
   endread()
   selectinput(cur_in_stream)
   print_byte_count() }1

 .

