
SECTION "C#MAIN"  // Last altered 83-10-25

/*  This  section should be loaded together with EF10.  We assume
here that MCAP has placed in the  file  'captab'  the  capability
table  pair  for a particular terminal.  We assume also that this
pair of tables has been inserted in the  message  file  and  that
that   file's   directory  has  been  modified  to  reflect  this
inclusion.  This  utility  reads  the  capability  table  in  the
message  file  and  prints it in readable form for the purpose of
checking that it appears to be correct and that CHEF will be able
to read it.  */

GET "CHEF_EF0"

MANIFEST
{ escape_ch  = #O033
  cap_print  = 256
  rb_ch      = ascii_ -> 127, 255
  end_state  = #B01
  end_choice = #B10 }

STATIC {
  pvec           = ?
  svec           = ?
  svec_p         = ?
  gvec_t         = ?
  msg_file_open_ = FALSE
  auto_margins_  = FALSE
  nm_tab         = ? }

LET start() BE
{1 LET v1 = VEC caps_vec_csz; caps_vec := v1
 { LET v2 = VEC cap_sz; nm_tab := v2
 { LET s = VEC 6
 { LET ii = input() AND oo = output()
 { LET v3 = VEC 1; msg_table := v3
 { LET v4 = VEC 64; line := v4; line%0 := 4
 { LET v5 = VEC 80/cell_bsz; legend := v5
   {r writef("Enter two-character terminal identifier*N")
      IF sys_emas \/ sys_unix32 \/ sys_cpm \/ sys_vms THEN
        prompt("? ")
      { LET len = 0
        { LET ch = rdch()
          IF ch = '*N' THEN { s%0 := len; BREAK }
          len := len + 1
          s%len := ch
        } REPEAT
      }
   }r REPEATUNTIL s%0 = 2     // Insist !
   screen_name := (s%1<<8) \/ s%2
   mk_acaps()
   get_captab()
   IF sys_rdos THEN selectoutput(findoutput("o"))
   writef(" Capability tables for screen %C%C*N*N",
             screen_name>>8, screen_name)
   pr_const()
   writes("*N The speaking strings*N*N")
   pr_pvecs()
   writes(" The listening vector*N*N")
   pr_gvecs()
   writes(" The listening tree*N*N")
   pr_g(0, 0)
   IF sys_rdos THEN selectoutput(oo)
   writes("Done*N") }1

AND acap(s, t) BE
/*  Insert  the  capability  's'  into the vector 'nm_tab' as two
characters per call.  */
   nm_tab!(t-256) := (s%1<<8) + s%2

AND err(s) BE
{1 writes(s); newline(); FINISH }1

AND get_captab() BE
/* Get the name of the terminal and using this seek and then read
its capability table in the message file.  This is done by  first
consulting the message file directory.  */
TEST NOT menu_screen THEN RETURN ELSE
{1 LET ii = input()
   // report("get_captab:*N")
   UNLESS msg_file_open_ DO
   { msg_in_stream := findinput(name_of_msg_file())
     UNLESS valid_stream(msg_in_stream) THEN err("message file?") }
   msg_file_open_ := TRUE
   selectinput(msg_in_stream)
   set_file_position(msg_in_stream, 0)
   seek_cap(screen_name)
   rd_captab()
   no_cap_al_ := svec%(pvec%(cap_al-256)) = 0
   selectinput(ii) }1

AND indent(n) BE
/* Used for indented version of the listening tree.  */
  FOR i = 1 TO 3*n DO wrch('*S')

AND mk_acaps() BE
/* Make up the vector 'nm_tab'.   These are the ones that CHEF
is interested in.  */
{ // report("mk_acaps:")
  acap("al", cap_al)
  acap("al", cap_al)
  acap("ce", cap_ce)
  acap("cl", cap_cl)
  acap("cm", cap_cm)
  acap("co", cap_co)
  acap("cr", cap_cr)
  acap("dc", cap_dc)
  acap("dl", cap_dl)
  acap("do", cap_do)
  acap("ei", cap_ei)
  acap("ho", cap_ho)
  acap("ic", cap_ic)
  acap("im", cap_im)
  acap("is", cap_is)
  acap("k0", cap_k0)
  acap("k1", cap_k1)
  acap("k2", cap_k2)
  acap("k3", cap_k3)
  acap("k4", cap_k4)
  acap("k5", cap_k5)
  acap("kb", cap_kb)
  acap("kd", cap_kd)
  acap("ke", cap_ke)
  acap("kl", cap_kl)
  acap("kr", cap_kr)
  acap("ks", cap_ks)
  acap("ku", cap_ku)
  acap("lg", cap_lg)
  acap("li", cap_li)
  acap("rb", cap_rb)
  acap("se", cap_se)
  acap("so", cap_so)
  acap("wl", cap_wl)
  acap("wr", cap_wr) }

AND pr_c(c) BE
/* Write the character using \E for escape and ^ for control.  */
  TEST c = escape_ch THEN writes("\E") ELSE
  TEST c = rb_ch THEN writes("RB") ELSE
  TEST c < '*S' THEN
    writef("%C%C", '^', c+64)
  ELSE { wrch('*S'); wrch(c) }

AND pr_s(p) BE
/* Print one capability string starting at 'p' in 'svec' using
the readable format given by 'pr_c'.  */
{1 LET len = svec%p
   FOR j = p+1 TO p + len DO
   { LET c = svec%j;
     IF (j-p) REM 8 = 7 THEN writes("*N    ")
     pr_c(c); writef("(%X2)", c) }
   newline() }1

AND pr_const() BE
/* Give the legend and the size of the screen.  */
{1 writef(" legend=*'%S*'*N*N", legend)
   writef(" rows=%N columns=%N*N", screen_rows, screen_cols)
   writef(" auto margins=%S*N", auto_margins_ -> "Yes", "No") }1

AND pr_pvecs() BE
/*  This writes out the terminal capabilities in readable form so
that we can see whether they have been read correctly.  */
{1 FOR i = 1 TO cap_sz DO
   {2 LET p = pvec%i
      UNLESS p = 0 THEN
      { writef(" %S:", scap(i)); pr_s(p) } }2
   newline() }1

AND pr_g(p, n) BE
/*  Print  the  recognition tree starting at index 'p' in 'g.vec'
and using indentation 'n'.  */
{1 LET g1, g2, g3 = g1vec%p, g2vec%p, g3vec%p
   TEST (g2 LOGAND end_state) = end_state THEN
   { wrch('*S'); pr_c(g1); writef(" %S*N", scap(g3)) }
   ELSE
   { wrch('*S'); pr_c(g1); pr_g(g3, n+1) }
   UNLESS (g2 LOGAND end_choice) = end_choice THEN
   { indent(n); pr_g(p+1, n) } }1

AND pr_gvecs() BE
/*  This displays the 'gvec's in the form of a table, starting at
0, with entries of the form {g1,g2,g3}.  The entry  'g1'  is  the
character,  'g2'  is  'end_choice' \/ 'end_state' indicating that
there are no more characters to choose from or that we have  come
to  the  end  of a capability string.  The entry 'g3' is either a
pointer  to  the  next  character  in  a  capability  string  (if
'end_state'  is  false)  or  is the internal code of a capability
(cp) if 'end_state' is true. */
{1 // writef("*N Getvec dump*N*N")
   FOR i = 0 TO gvec_t-1 DO
   { LET g1, g2, g3 = g1vec%i, g2vec%i, g3vec%i
     LET state = (g2 /\ end_state) = end_state -> '?','-'
     LET choice = (g2/\end_choice) = end_choice -> '\', '-'
     IF i REM 8 = 0 THEN writef("%I2: ", i)
     writes(" <")
     pr_c(g1)
     writef(",%C%C,", choice, state)
     TEST (state='?') THEN writef("%S", scap(g3))
     ELSE writen(g3); wrch('>')
     IF i REM 8 = 7 THEN newline() }
   writes("*N*N") }1

AND report(f, a, b, c) BE
{1 LET oo = output()
// selectoutput(console_out_stream)
   writef(f, a, b, c); newline()
   selectoutput(oo) }1

AND rd_captab() BE
/* Read the capability table and store it in memory.  */
{1 LET c = rdch()
   // report("rd_captab")
   pvec := caps_vec; svec := caps_vec + pvec_csz
   FOR i = 0 TO cap_sz DO pvec%i := 0
   UNTIL (c='|')\/(c=endstreamch) DO c := rdch()
   IF c = endstreamch THEN err("4a:3")
   UNTIL c = '*N' DO c := rdch()
   svec_p := 1
   // Now read the capability strings
   {2 LET cp = readn()
      UNLESS terminator = ':' THEN err("4a:4")
      IF cp = 0 THEN BREAK
    { LET len = readn()
      SWITCHON cp+256 INTO // Not all to 'svec'
      {S DEFAULT: pvec%cp := svec_p; store_c(len);
           FOR i = 1 TO len DO store_c(readn()); ENDCASE
         CASE cap_li: screen_rows := readn(); ENDCASE
         CASE cap_co: screen_cols := readn(); ENDCASE
         CASE cap_am: auto_margins_ := readn() NE 0; ENDCASE
         CASE cap_lg: FOR i = 1 TO len DO legend%i := readn()
           legend%0 := len }S }2
   REPEAT
   // Now read the automaton triples
 { LET used_csz = pvec_csz + (svec_p + cell_bsz)/cell_bsz
   LET gvec_csz = (caps_vec_csz - used_csz)/(3*cell_bsz)
   g1vec := caps_vec + used_csz
   g2vec := g1vec + gvec_csz; g3vec := g2vec + gvec_csz
   gvec_t := 0
   {2 LET g1, g2, g3 = readn(), readn(), readn()
      IF g1+g2+g3 = 0 THEN BREAK
      IF gvec_t > (gvec_csz*cell_bsz) THEN err("4a:5")
      g1vec%gvec_t, g2vec%gvec_t, g3vec%gvec_t := g1, g2, g3
      gvec_t := gvec_t + 1 }2
   REPEAT  }1

AND seek_cap(name) BE
/*  Assume that we are positioned at the beginning of the message
file directory.  Now position it at the beginning of the terminal
capability table corresponding to 'name'.  */
{1 // report("seek_cap")
 { LET n = readn() AND cur_name = ?
   LET c1, c2, c3 = ?, '*S', rdch()
   {r c1, c2, c3 := c2, c3, rdch()
      REPEATUNTIL (c3 = '|') \/ (c3 = endstreamch)
      IF c3 = endstreamch THEN err("cap tables?")
      cur_name := (c1<<8) + c2
      IF cur_name = name THEN BREAK
      IF cur_name = ('0'<<8) + '0' THEN
        err("Screen name?")
      n := n + readn() }r
   REPEAT
   UNTIL rdch() = '*N' DO LOOP
   make_indexed(msg_in_stream)
   IF sys_unix THEN selectinput(msg_in_stream)
   set_file_position(msg_in_stream, n)
   /* rdch(); unrdch(); */ make_sequential(msg_in_stream) }1

AND scap(cp) = VALOF
/* Yield a string of two characters.    We rely on the fact that
tables are static.  */
{1 LET s = (TABLE 0, 0)
   s%0 := 2
   s%1, s%2 := (nm_tab!cp)>>8, nm_tab!cp
   RESULTIS s }1

AND store_c(ch) BE
/* Put 'c' into 'svec' and update the pointer.  */
{1 IF svec_p > svec_bsz THEN err("svec_mx")
   svec%svec_p := ch; svec_p := svec_p + 1 }1

// Needed by ef10
AND check_system(a,b,c) BE RETURN

AND warn() BE RETURN

AND get_ch() = 0

.

