
// File iosys.b

// I/O support routines for CHEF editor on UNIX

// Copyright R.D. Eager   University of Kent   MCMLXXXIII


SECTION "_bcplios"

GET "ef0.h"

GET "syshdr.h"

// Function to find an SCB

LET io.findscb(strp) = VALOF
$( LET p = sv.scbchain

   IF sv.curin = strp RESULTIS strp
   IF sv.curout = strp RESULTIS strp
   WHILE p NE 0 DO
   $( IF p = strp RESULTIS strp
      p := scb_link::p
   $)

   RESULTIS 0   // Not found
$)

// Function to set up SCB and buffer for a standard UNIX stream

AND io.finduio(fd, direction) = VALOF
$( LET scb = getvec(scb_size - 1)
   AND ttyflag = uisatty(fd) = 1 -> f_tty, f_none
   LET bufsize = ttyflag -> bs_tty, bs_file
   AND buf = ?

   result2 := e.nomem

   IF scb = 0 RESULTIS 0   // Failed to find space for SCB

   buf := getvec((bufsize + bytesperword - 1)/bytesperword - 1)
   IF buf = 0 THEN
   $( freevec(scb)
      RESULTIS 0   // Failed to find space for buffer
   $)

   scb_read::scb    := (direction & dir_read) NE 0 -> ttyflag -> io.ttyread, io.stdread, io.wrongdir
   scb_write::scb   := (direction & dir_write) NE 0 -> ttyflag -> io.ttywrite, io.stdwrite, io.wrongdir
   scb_close::scb   := io.stdclose
   scb_flags::scb   := f_unix \/ ttyflag
   scb_fd::scb      := fd
   scb_dir::scb     := direction
   scb_bufsize::scb := bufsize
   scb_bufadd::scb  := buf
   scb_cursor::scb  := 0
   scb_count::scb   := 0
   scb_lastch::scb  := '*N'   // Pseudo zeroth character
   scb_blkread::scb := (direction & dir_read) NE 0 -> io.blkread, io.wrongdir
   scb_blkwrite::scb:= (direction & dir_write) NE 0 -> io.blkwrite, io.wrongdir
   scb_recread::scb := (direction & dir_read) NE 0 -> io.recread, io.wrongdir
   scb_recwrite::scb:= (direction & dir_write) NE 0 -> io.recwrite, io.wrongdir

   RESULTIS scb
$)

// Function to provide "record" (line-at-a-time) input from a standard UNIX stream

AND io.recread(s, ad, max) = VALOF
$( LET rtn = (scb_flags::s & f_tty) NE 0 -> io.ttyread, io.stdread

   FOR i = 1 TO max DO
   $( LET c = rtn(s)

      IF c <= 0 THEN
         TEST i = 1 THEN RESULTIS c
         OR c := '*N'

      IF c = '*N' THEN
      $( ad%0 := i - 1
         RESULTIS 1
      $)

      ad%i := c
   $)

   ad%0 := line_bsz
   result2 := 100
   RESULTIS 0
$)

// Function to provide "record" (line-at-a-time) output to a standard UNIX stream

AND io.recwrite(s, buf, st, len) = VALOF
$( TEST (scb_flags::s) & f_tty NE 0 THEN
   $( FOR i = st TO len DO io.ttywrite(s, buf%i)
      RESULTIS io.ttywrite(s, '*N')
   $)
   OR
   $( LET p = scb_cursor::s
      AND res = ?

      IF p + len > scb_bufsize::s THEN
      $( LET partlen = scb_bufsize::s - p

         res := io.recwrite(s, buf, st, partlen)
         st := st + partlen
         len := len - partlen
      $)

      move(len, (buf << 2) + st, (scb_bufadd::s << 2) + p)
      p := p + len
      scb_cursor::s := p

      IF p GE scb_bufsize::s THEN
      $( LET res = write(scb_fd::s, scb_bufadd::s << 2, p)

         result2 := e.ok

         IF res NE p THEN
         $( result2 := berrno()
            IF result2 = e.intr THEN   // Re-try interrupted system call
            $( result2 := e.ok   // Reset
               LOOP
            $)
            RESULTIS 0
         $)
         p := 0
         BREAK
      $) REPEAT
      scb_cursor::s := p
      RESULTIS 1
      RESULTIS io.stdwrite(s, '*N')
   $)
$)

// Function to provide input from a standard UNIX stream

AND io.stdread(s) = VALOF
$( LET p = scb_cursor::s

   IF p GE scb_count::s THEN
   $( LET res = read(scb_fd::s, scb_bufadd::s << 2, scb_bufsize::s)

      result2 := e.ok

      IF res LE 0 THEN
      $( IF res < 0 THEN result2 := berrno()
         IF result2 = e.intr THEN   // Re-try interrupted system call
         $( result2 := e.ok   // Reset
            LOOP
         $)
         RESULTIS res = 0 -> endstreamch, 0
      $)

      scb_count::s := res   // Number of bytes read
      scb_cursor::s, p := 0, 0
      BREAK
   $) REPEAT

   $( LET ch = (scb_bufadd::s)%p

      scb_lastch::s := ch
      scb_cursor::s := p + 1

      IF ch = 0 LOOP   // Ignore nulls
      RESULTIS ch
   $)
$) REPEAT

// Function to provide input from a standard UNIX terminal stream

AND io.ttyread(s) = VALOF
$( LET res = ?

   IF scb_cursor::s GE scb_count::s THEN   // Input buffer is empty
   $( IF sv.prompt%0 > 0 THEN              // There is a non-null prompt
      $( IF sv.ttyfd = 255 THEN            // There is no terminal file descriptor - get one
         $( LET v = VEC 2

            bcstr("/dev/tty", v)           // Convert to C-style string
            res := open(v << 2, 1)         // Try to open for writing
            IF res GE 0 THEN sv.ttyfd := res
         $)
         res := write(sv.ttyfd, (sv.prompt << 2) + 1, sv.prompt%0)   // Type the prompt
            REPEATWHILE res < 0 & berrno() = e.intr
      $)
   $)

   input_pending_ := TRUE
   $( LET res = io.stdread(s)   // Do the actual input

      input_pending_ := FALSE
      RESULTIS res
   $)
$)

// Function to provide output to a standard UNIX stream

AND io.stdwrite(s, ch) = VALOF
$( LET p = scb_cursor::s

   (scb_bufadd::s)%p := ch
   p := p + 1

   // Flush buffer if it is full

   IF p GE scb_bufsize::s THEN
   $( LET res = write(scb_fd::s, scb_bufadd::s << 2, p)

      result2 := e.ok

      IF res NE p THEN
      $( result2 := berrno()
         IF result2 = e.intr THEN   // Re-try interrupted system call
         $( result2 := e.ok   // Reset
            LOOP
         $)
         RESULTIS 0
      $)
      p := 0
      BREAK
   $) REPEAT
   scb_cursor::s := p
   RESULTIS 1
$)

// Function to provide output to a standard UNIX terminal stream

AND io.ttywrite(s, ch) = VALOF
$( LET p = scb_cursor::s

   (scb_bufadd::s)%p := ch
   p := p + 1

   // Flush buffer if it is full, or terminator seen

   IF ch = '*N' \/ p GE scb_bufsize::s THEN
   $( LET res = write(scb_fd::s, scb_bufadd::s << 2, p)

      result2 := e.ok

      IF res NE p THEN
      $( result2 := berrno()
         IF result2 = e.intr THEN   // Re-try interrupted system call
         $( result2 := e.ok   // Reset
            LOOP
         $)
         RESULTIS 0
      $)
      p := 0
      BREAK
   $) REPEAT
   scb_cursor::s := p
   RESULTIS 1
$)

// Function to close a standard UNIX stream

AND io.stdclose(s) = VALOF
$( LET dir = scb_dir::s
   AND res = ?

   // Flush output buffer if necessary

   IF (dir & dir_write) NE 0 THEN
   $( IF scb_cursor::s NE 0 THEN
         write(scb_fd::s, scb_bufadd::s << 2, scb_cursor::s)
      scb_cursor::s := 0
   $)

   IF s = journal THEN   // Never closed
   $( sv.curout := s   // Retain the SCB, while removing from chain
      RESULTIS 1
   $)

   res := uclose(scb_fd::s)
   freevec(scb_bufadd::s)
   freevec(s)

   IF res < 0 THEN
   $( result2 := berrno()
      RESULTIS 0
   $)

   RESULTIS 1
$)

// Function to provide block input from a standard UNIX stream

AND io.blkread(s, b, l) = VALOF
$( LET res = read(scb_fd::s, b << 2, l)

   result2 := e.ok

   IF res LE 0 THEN
   $( result2 := res = 0 -> endstreamch, berrno()
      IF result2 = e.intr THEN   // Re-try interrupted system call
      $( result2 := e.ok   // Reset
         LOOP
      $)
      RESULTIS -1
   $)
   RESULTIS res   // Number of bytes read
$) REPEAT

// Function to provide block output to a standard UNIX stream

AND io.blkwrite(s, b, l) = VALOF
$( LET res = write(scb_fd::s, b << 2, l)

   result2 := e.ok

   IF res NE l THEN
   $( result2 := berrno()
      IF result2 = e.intr THEN   // Re-try interrupted system call
      $( result2 := e.ok   // Reset
         LOOP
      $)
      RESULTIS -1
   $)
   RESULTIS 0
$) REPEAT

// Function used for 'wrong-direction' entries in SCB

AND io.wrongdir() = VALOF
$( result2 := e.badf
   RESULTIS 0
$)

// End of file iosys.b

