
// File syshdr.h

// System-dependent definitions for CHEF on DEC VAX-11 under UNIX

// Copyright R.D. Eager   University of Kent   MCMLXXXIV


GET "libhdr"

MANIFEST {   // System specific constants

/***********************************************************************
******/                 max_file_block = 511                     /******
***********************************************************************/

}

MANIFEST {
sv.base    = -30   // Base of system vector
}

GLOBAL {   // System vector
bcplinit    : sv.base+00   // Initialisation code
sv.tracep   : sv.base+01   // Trace pointer
sv.traceb   : sv.base+02   // Base of trace buffer (byte address)
sv.tbsize   : sv.base+03   // Size of trace buffer
sv.scbchain : sv.base+04   // Head of deselected SCB chain
sv.curin    : sv.base+05   // Currently selected input stream
sv.curout   : sv.base+06   // Currently selected output stream
sv.errflag  : sv.base+07   // Internal error flag
sv.writefn  : sv.base+08   // Internal debugging routine
sv.writeval : sv.base+09   // Internal debugging routine
sv.highcode : sv.base+10   // Byte address of end of text segment
io.finduio  : sv.base+11   // I/O support routine
sv.nfentry  : sv.base+12   // Internal debugging routine
sv.isfun    : sv.base+13   // Internal debugging routine
sv.stchain  : sv.base+14   // Head of STATIC name chain
sv.prompt   : sv.base+15   // Pointer to current prompt string
io.findscb  : sv.base+16   // Internal I/O routine
io.stdread  : sv.base+17   // Internal I/O routine
io.stdwrite : sv.base+18   // Internal I/O routine
io.stdclose : sv.base+19   // Internal I/O routine
io.wrongdir : sv.base+20   // Internal I/O routine
sv.ttyfd    : sv.base+21   // File descriptor for output to controlling terminal (255 if not set)
io.blkread  : sv.base+22   // Internal I/O routine
io.blkwrite : sv.base+23   // Internal I/O routine
}

EXTERNAL {   // System calls
access      : "_access"
chmod       : "_chmod"
uclose      : "_close"
creat       : "_creat"
uexecve     : "_execve"
exit        : "__exit"
ufork       : "_fork"
getpid      : "_getpid"
uisatty     : "_isatty"
link        : "_link"
lseek       : "_lseek"
open        : "_open"
read        : "_read"
sbrk        : "_sbrk"
signal32    : "_signal"
stat        : "_stat"
unlink      : "_unlink"
uvfork      : "_vfork"
uwait       : "_wait"
write       : "_write"
}

EXTERNAL {   // Machine code support routines
berrno      : "_berrno"
}

MANIFEST {   // Error codes
e.ok       = 0     // Success
e.intr     = 4     // Interrupted system call
e.badf     = 9     // Bad file number
e.nomem    = 12    // Not enough memory
e.acces    = 13    // Permission denied
e.mfile    = 24    // Too many open files
}

// Layout of a structure from 'stat'

MANIFEST {
st_dev       = SLCT 32:00:00
st_ino       = SLCT 32:00:01
st_mode      = SLCT 16:00:02
st_nlink     = SLCT 16:16:02
st_uid       = SLCT 16:00:03
st_gid       = SLCT 16:16:03
st_rdev      = SLCT 16:00:04
st_size      = SLCT 32:00:05
st_atime     = SLCT 32:00:06
st_spare1    = SLCT 32:00:07
st_mtime     = SLCT 32:00:08
st_spare2    = SLCT 32:00:09
st_ctime     = SLCT 32:00:10
st_spare3    = SLCT 32:00:11
st_blksize   = SLCT 32:00:12
st_blocks    = SLCT 32:00:13
st_spare4    = SLCT 32:00:14

st_csz       = 16
}

// Layout of a stream control block (SCB)

MANIFEST {
scb_link      = SLCT 32:00:00   // Chain link
scb_read      = SLCT 32:00:01   // Read routine
scb_write     = SLCT 32:00:02   // Write routine
scb_close     = SLCT 32:00:03   // Close routine
scb_flags     = SLCT 32:00:04   // Flag bits
scb_fd        = SLCT 08:24:05   // File descriptor (if UNIX stream)
scb_dir       = SLCT 08:16:05   // I/O direction flags
scb_bufsize   = SLCT 16:00:05   // Size of buffer
scb_bufadd    = SLCT 32:00:06   // Address of buffer
scb_cursor    = SLCT 32:00:07   // Buffer pointer
scb_count     = SLCT 16:16:08   // Count of items in buffer
scb_lastch    = SLCT 08:08:08   // Copy of last character read from stream
scb_sread     = SLCT 32:00:09   // Used to save read routine during UNRDCH
scb_blkread   = SLCT 32:00:10   // Block read routine
scb_blkwrite  = SLCT 32:00:11   // Block write routine
scb_recread   = SLCT 32:00:12   // Record read routine
scb_recwrite  = SLCT 32:00:13   // Record write routine

scb_size      = 14              // Size of SCB in longwords
}

// Miscellaneous stream flags

MANIFEST {
f_none        = 0               // No flags
f_unix        = 1               // Stream is a UNIX I/O stream
f_tty         = 2               // Stream is associated with a terminal
f_unread      = 4               // Stream is in 'unread' state
}

// Stream direction flags

MANIFEST {
dir_read      = 1               // Stream can be read from
dir_write     = 2               // Stream can be written to
}

// Buffer sizes (in bytes)

MANIFEST {
bs_tty        = 100             // Terminal stream
bs_file       = 1024            // File stream
}

MANIFEST {
bitsperbyte = bitsperword/bytesperword
}

global {
attentionpending  : 100
catchattention    : 101
createoutput      : 102
input_pending_    : 103
last_signal       : 104
readrec           : 105
reset_attention   : 106
set_shell         : 107
shell_name        : 108
shell_path        : 109
u32seek           : 110
writerec          : 111
xqmatch           : 112
}

// End of file syshdr.h

