
// File system.b

// System dependent routines for CHEF on DEC VAX-11 under UNIX

// Copyright R.D. Eager   University of Kent   MCMLXXXIV

GET "ef0.h"

GET "syshdr.h"

STATIC { old_contingency = ? }

LET catchattention() BE
/*  Arrange that the program catches signals for hangup, quit and
interrupt, passing them to the routine 'my_contingency'.  */
{ old_contingency := contingency 
  contingency := my_contingency
  catchsignals(#B0000000000001110000000001110, TRUE) 
  attentionpending := FALSE
}
  
AND check_environment(s, ptr) = VALOF
/*  Checks  the environment for the name 's'; if found, the value
associated with the name is copied to the vector 'ptr'.  */
{ LET p, l = 0, s%0

  WHILE envp!p NE 0 DO
  { LET e = envp!p

    IF e%0 < l + 1 THEN               // Cannot match - too short
    { p := p + 1; LOOP }

    FOR i = 1 TO l DO
    { UNLESS s%i = e%i BREAK            // Failed to match
      IF i NE l LOOP
      l := l + 1
      UNLESS e%l = '=' BREAK            // Keyword too long

      // Item found - extract value

      p := e%0 - l                      // Length of value
      ptr%0 := p
      FOR i = 1 TO p DO ptr%i := e%(i+l)
      RETURN
    }
    p := p + 1                 // Move to next environment string
  }
}

AND createoutput(name) = VALOF
/* Creates and opens an output  file.   If  the  file  cannot  be
accessed  because there is no write permission, the user is given
the option of changing the file access  mode,  then  opening  the
file  and  changing  the access mode back again.  Otherwise, this
function behaves the same as 'findoutput'.  */
{ LET cname = VEC name_csz
  AND statvec = VEC st_csz - 1
  AND old_mode = ?
  AND s = findoutput(name)

  IF s NE 0 RESULTIS s   // File was opened OK

  IF result2 NE e.acces RESULTIS 0   // Some error other than permission

  bcstr(name, cname)   // Form C-style filename
  s := stat(cname << 2, statvec << 2)
  old_mode := st_mode::statvec
  IF s = -1 \/ (old_mode & #o200) NE 0 RESULTIS 0   // Some further problem

  writes("Read-only file; sure?*N")
  UNLESS got_text(FALSE, FALSE) &
         line%0 NE 0 & upper_case(line%1) = 'Y' RESULTIS 0

  s := chmod(cname << 2,old_mode \/ #o200)
  IF s NE 0 RESULTIS 0
  s := findoutput(name)   // Try it again
  chmod(cname << 2,old_mode)
  RESULTIS s
}

AND my_contingency(signo, code, sigcontext, p) BE
/* Control is passed to this routine when a signal is caught.  */
{ IF signo = 1 & input_pending_ THEN   // Hangup
  { recover()   // Clean up the database, and exit immediately
    save_files()
    postlude()
    stop(255)
  }
  TEST signo = 1 \/ signo = 2 \/ signo = 3 \/ signo = 15 THEN
  { attentionpending := TRUE
    catchsignals(#B01110000000001110, TRUE) 
    last_signal := signo
  }
  OR
  { selectoutput(journal)
    old_contingency(signo, code, sigcontext, p)
  }
}

AND next_name(name) BE
/*  On  first  call,  add the suffix 'A' to 'name'; on subsequent
calls, increment that suffix.  */
{ STATIC { first_ = TRUE }

   IF first_ THEN                      // Add suffix for next file
   { LET l = name%0 + 1
     name%0 := l
     name%l := 'A' - 1
     first_ := FALSE
   }
   { LET l = name%0                    // Increment suffix
     name%l := name%l + 1
   }
}

AND readrec(ad, l) = VALOF
/* Reads a record into the area  starting  at  'ad',  as  a  BCPL
string.  The maximum length of the string is given by 'l'.  */
{ IF sv.curin = 0 THEN   // No input selected
  { result2 := e.badf
    RESULTIS -1
  }

  RESULTIS (scb_recread::sv.curin)(sv.curin, ad, l)
}

AND reset_attention() BE
$( attentionpending := FALSE
   IF last_signal NE 1 RETURN   // All except hangup

   save_files()
   postlude()
   stop(255)
$)

AND save_files() BE
/*  This  routine  is  entered  after  a  hangup  signal has been
received.  It attempts to write out one  file  for  each  of  the
edits  currently  active  (there  may  be  more than one if the N
command has been used).  The program then exits.  */
{ LET name = VEC name_csz

  copy_string("chef.hup", name)      // Base filename for output

  { LET strp = ?

    { strp := findinput(name)      // Make sure it doesn't exist
      IF strp = 0 BREAK
      selectinput(strp)
      endread()
      next_name(name)            // Try another name
    } REPEAT

    strp := findoutput(name)
    IF strp = 0 BREAK      // No point in continuing
    l_line1, l_line2 := 1, last_line
    selectoutput(strp)
    out_lines(text_only)
    endwrite()

    next_name(name)
  } REPEATWHILE unstack_work_space()

  selectoutput(sysout)
}

AND set_shell() BE
/* Read the environment to discover the name of the shell  to  be
used by the 'qs' command.  */
{ shell_path := TABLE 0,0,0,0,0,0,0,0
  shell_name := TABLE 0,0,0,0

  copy_string("/bin/csh", shell_path)   // Default shell

  check_environment("SHELL", shell_path)

  FOR i = shell_path%0 TO 1 BY -1 DO
  { IF shell_path%i = '/' \/ i = 1 THEN
    { shell_name%0 := shell_path%0 - i
      copy_bytes(shell_name%0, shell_path, i+1, shell_name, 1)
      BREAK
    }
  }
}

AND u32seek(s, p) BE
/*  Seeks  on stream 's' to position 'p'.  Note that on output we
are always on a block boundary.  */
{ LET block_no = p/bs_file
  AND cursor = p REM bs_file

  lseek(scb_fd::s, block_no*bs_file, 0)
  scb_count::s := 0
  IF cursor > 0 THEN
  { LET res = read(scb_fd::s, scb_bufadd::s<<2, scb_bufsize::s)
    result2 := e.ok
    IF res LE 0 THEN
    { IF res < 0 THEN result2 := berrno()
      IF result2 = e.intr THEN
      { result2 := e.ok; LOOP }
      IF res = 0 THEN err("seek")
    }
    scb_count::s := res
    BREAK
  } REPEAT
  scb_cursor::s := cursor
}

AND writerec(ad) = VALOF
/*  Writes  a  record  from  'ad', which is in the form of a BCPL
string.  A newline is added.  */
{ IF sv.curout = 0 THEN   // No output selected
  { result2 := e.badf
    RESULTIS -1
  }

  RESULTIS (scb_recwrite::sv.curout)(sv.curout, ad, 1, ad%0)
}

// End of file system.b

