$!
$! File: MAKE_CHEFHELP.COM
$!
$! DCL procedure to convert the normal CHEF help file to a format suitable
$! for random access.
$!
$ setup:
$!
$	fdlfile = "CHEFHELP.FDL"
$	helpfile = "CHEFHELP.TXT"
$	newhelp = "NEWHELP.TXT"
$	on control_y then goto exit
$!
$ create_fdl_file:
$!
$	create 'fdlfile'
TITLE	"CHEF help file"

IDENT	"25-JAN-1987 22:35:11   VAX-11 FDL Editor"

RECORD
	CARRIAGE_CONTROL	carriage_return
	FORMAT			fixed
	SIZE			80

ACCESS
	GET			yes
$!
$ convert_file:
$!
$	convert/fdl='fdlfile'/pad=%x20 'helpfile' 'newhelp'
$	write sys$output "New help file generated in 'newhelp'
$!
$ exit:
$!
$	if f$search("''fdlfile'") .nes. "" then -
		delete/nolog 'fdlfile';*
$	exit
$!
$! End of file: MAKE_CHEFHELP.COM
$!
