
// File system.b

// System dependent routines for CHEF on DEC VAX under VAX/VMS

// Copyright R.D. Eager   University of Kent   MCMLXXXVIII

GET "ef0.h"
GET "syshdr.h"

STATIC {   // Local storage
last_error          = ?   // Code for last filing error
last_filename       = ?   // Pointer to filename for last open operation attempted
last_operation      = ?   // Last file open operation attempted
real_findinput      = ?   // Holds copy of system 'findinput'
real_findoutput     = ?   // Holds copy of system 'findoutput'
real_put_msg        = ?   // Holds copy of CHEF 'put_msg'
real_warn           = ?   // Holds copy of CHEF 'warn'
}

MANIFEST {   // I/O operation codes
op.none             = 0   // No previous operation
op.openin           = 1   // Last operation was 'findinput'
op.openout          = 2   // Last operation was 'findoutput'
}

LET vms_init() BE
{ real_findinput, real_findoutput := findinput, findoutput
  findinput, findoutput := chef_findinput, chef_findoutput

  real_warn,real_put_msg := warn, put_msg
  warn, put_msg := vms_warn, vms_put_msg

  last_error, last_operation := 0, op.none

  last_filename := getvec(name_csz)
  IF last_filename = 0 THEN
  { message(FALSE, chef_insvirmem)
    stop(1)
  }
}

AND chef_findinput(s) = VALOF
{ last_operation := op.openin

  copy_string(s, last_filename)

  { LET strp = real_findinput(s)

    IF strp NE 0 THEN
    { LET i = input()

      selectinput(strp)
      settrim(TRUE)
      selectinput(i)
    }
    RESULTIS strp
  }
}

AND chef_findoutput(s) = VALOF
{ LET l = s%0

  last_operation := op.openout

  copy_string(s, last_filename)

  TEST l > 2 & s%(l-1) = '/' & upper_case(s%l) = 'A' THEN
  { LET newname = VEC name_csz

    copy_string(s, newname)
    newname%0 := l - 2   // Lose the /A switch

    RESULTIS findappend(newname)
  }
  ELSE
    RESULTIS real_findoutput(s)
}

AND get_workspace() = VALOF
{ LET ad = getvec(work_size)

  IF ad = 0 THEN
  { message(FALSE, chef_insvirmem)
    stop(1)
  }

  RESULTIS ad*bytesperword
}

AND vms_warn(n) BE
{ IF n = m_access THEN last_error := result2

  real_warn(n)
}

AND vms_put_msg(n) BE
{ LET second_ = FALSE
  TEST n = m_access & last_error NE 0 THEN
  { FOR i = 1 TO last_filename%0 DO
      last_filename%i := upper_case(last_filename%i)

    SWITCHON last_operation INTO
    { CASE op.openin :  message(FALSE, chef_openin, last_filename << 2)
                        second_ := TRUE
                        ENDCASE
      CASE op.openout:  message(FALSE, chef_openout, last_filename << 2)
                        second_ := TRUE
      CASE op.none   :  ENDCASE
    }

    message(second_, last_error, 0)
    last_error, last_operation := 0, op.none
  }
  ELSE real_put_msg(n)
}

AND message(second_, n, a, b, c) BE
/* Obtains the message specified by 'n', and outputs it with specified
parameters. */
{ LET m = getmessage(n, 0)
  AND v = VEC maxstrlength/bytesperword
  AND args = VEC 2
  AND o = output()

  /* If 'second_' is TRUE, the message is not the first one of a sequence.
  In this case, we change the first character of the message. */

  IF second_ & m%0 > 0 & m%1 = '%' THEN m%1 := '-'

  /* Put arguments into ascending address order */

  args!0 := a
  args!1 := b
  args!2 := c

  selectoutput(journal)
  IF a NE 0 THEN
  { faostring(m, v, args)
     m := v
  }
  writes(m); newline()

  selectoutput(o)
}

// End of file system.b

