
GET "LIBHDR"

MANIFEST $(
mark=2;
ISSUE=2;
SUBISSUE='A';                                     // !!!!!!!!!!!!!!!!!!!!
NIL=0
MAXCOMMANDS=200                                   // MAX COMMANDS INCLUDING
                                                  // MACRO EXPANSION.

            
C.CODE=0; C.LIM=1; C.TEXT=2; C.REPNO=3; C.FLAGS=4; C.SIZE=5
  
STAR=5000;
max_no=MAXINT                                     // max repetition.
CLINEMAX=MAXCOMMANDS*C.SIZE;
MACROMAX=4;
MDEFMAX=80;                                       // NO. OF CHARS/ MACRO DEF
FSPECMAX=40
CNESTDEPTH=4
screen_width=80
screen_height = 24
cmd_max = 132
 
// notation:
// _csz  =  size in cells
// _bsz  =  size in bytes
// _gsz  =  size in grabs
// _lsz  =  size in lines
// _psz  =  size in pages

page_size = 256
//
// Note: block_gsz*grab_bsz gives the transfer size used to read/write
//       workfile blocks.

block_gsz = 256
grab_bsz  = 8
line_bsz  = 248
line_csz  = line_bsz/bytesperword
line_gsz  = (line_bsz+2+grab_bsz-1)/grab_bsz
block_bsz = block_gsz*grab_bsz
block_csz = block_bsz/bytesperword
null      = 0
file_lsz  = maxint
m_over    = 1
m_input_too_long = 2
 
case_flip = 0
case_upper = 1
case_lower = 2
CR.CODE = #X8D
LF.CODE = #X0A
FF.CODE = #X0C
HOME.CODE = #X8B
FWD.CODE = #X09
DEOL.CODE=#X93
BELL.CODE=#X87
COORD.CODE=#X0F
ESC.CODE=#X1B
highlight.on.code = #X05
highlight.off.code = #X06
inv.on.code        = #X4C
inv.off.code       = #X4D
flash.on.code      = #X46
flash.off.code     = #X47
half.on.code       = #X58
half.off.code      = #X59
under.on.code      = #X4F
under.off.code     = #X40
graphic.code=#X95
blob.code=#X7F
close_run = 0
exit_run = 1
abort_run = 2

// bit positions for 'flag' word in commands.

bit_ignore = 0
bit_invert = 1
bit_tag    = 2

// and associated mask values

sbit_ignore = 1 << bit_ignore
sbit_invert = 1 << bit_invert
sbit_tag    = 1 << bit_tag
// set global bases

gvb = global.base
gpb = gvb+70
E1_gpb = gpb
E2_gpb = E1_gpb+10
E3_gpb = E2_gpb+10
E4_gpb = E3_gpb+15
E5_gpb = E4_gpb+5
E6_gpb = E5_gpb+30
E7_gpb = E6_gpb+10
P_gpb = E7_gpb+10
sfo.base = P_gpb+2

// and the various segments

seg.main = 1
seg.rare = 7
$)

GLOBAL $(
outstream:      gvb
toptr:          gvb+1
WITHSTREAM:     gvb+2
CUE:            gvb+3
CONDCODE:       gvb+4
MONFLAG:        gvb+5
PARS.LEVEL:     gvb+6
PARS.RETURN:    gvb+7
PROMPTING:      gvb+8
HORIZ.START:    gvb+9
logstream:      gvb+10
INPLACE:        gvb+11
RETAIN:         gvb+12
PROFORMA:       gvb+13
cmd_pos:        gvb+14
cmd_line:       gvb+15
macroptr:       gvb+16
mspos:          gvb+17
macrostack:     gvb+18
macrodef:       gvb+19
type:           gvb+20
chain:          gvb+21
cptr:           gvb+22
tptr:           gvb+23
num:            gvb+24
sym:            gvb+25
code:           gvb+26
searchlim:      gvb+27
text:           gvb+28
repno:          gvb+29
validlast:      gvb+30
work_stream:    gvb+31
cmd_type:       gvb+32
work_space:     gvb+33
w_space:        gvb+34
last_line:      gvb+35
line:           gvb+36
cur_tag:        gvb+37
cur_line:       gvb+38
fromstream:     gvb+39
tostream:       gvb+40
flags:          gvb+41
stop_level:     gvb+42
stop_lab:       gvb+43
recover_lab:    gvb+44
page_buffs:     gvb+45
file_in_stream: gvb+46
file_out_stream:gvb+47
sin:            gvb+48
fromptr:        gvb+49
ml:             gvb+50
cursor:         gvb+51
altered:        gvb+52
cur_len:        gvb+53
monind:         gvb+54
printed:        gvb+55
sin_stream:     gvb+56
so_stream:      gvb+57
sys_line:       gvb+58
undo_stack:     gvb+59
uc_terminal:    gvb+60
quote_pos:      gvb+61
quote_text:     gvb+62
tag_pos:        gvb+63
tag_text:       gvb+64

// procedures in E1 module

PARSELINE:      E1_gpb
stop_prog:      E1_gpb+1
recover:        E1_gpb+2

// procedures in E2

start_e2:       E2_gpb
execute:        E2_gpb+1
monitorline:    E2_gpb+2
close_down:     E2_gpb+3
set_line:       E2_gpb+4
shuffle:        E2_gpb+5
break_line:     E2_gpb+6
write_file:     E2_gpb+7
undo:           E2_gpb+8
check_for_interrupt: E2_gpb+9
  
// procedures in E3 module

start_e3:       E3_gpb
fetch_line:     E3_gpb+1
make_space:     E3_gpb+2
move_windows:   E3_gpb+3
store_line:     E3_gpb+4
copy_lines:     E3_gpb+5
work_stats:     E3_gpb+6
fetch_grab:     E3_gpb+7
store_grab:     E3_gpb+8
fetch_max_grab: E3_gpb+9
restore_max_grab:E3_gpb+10

// procedures in E4 module

find_args:      E4_gpb
open_output:    E4_gpb+1
close_streams:  E4_gpb+2
set_defaults:   E4_gpb+3

// procedures in PROFORMA module

init_proforma:  P_gpb
get_arg:        P_gpb+1

// procedures in E5 module

get_line:       E5_gpb
copy_bytes:     E5_gpb+1
warn:           E5_gpb+2
copy_cells:     E5_gpb+3
check_blocks:   E5_gpb+4
restore_block:  E5_gpb+5
save_block:     E5_gpb+6
reset_byte_count: E5_gpb+7
add_byte_count: E5_gpb+8
print_byte_count: E5_gpb+9
readpackedline: E5_gpb+10
copy_and_unpack:E5_gpb+11
copy_and_pack:  E5_gpb+12
readunpackedline: E5_gpb+13
filing_error:   E5_gpb+14
null_stream:    E5_gpb+15
getfilename:    E5_gpb+16
WriteUnpackedLine: E5_gpb+17
report:         E5_gpb+18
yes_reply:      E5_gpb+19
print_fs_err:   E5_gpb+20
vdu_stream:     E5_gpb+21
sys_return:     E5_gpb+22
sys_command:    E5_gpb+23
print_filespec: E5_gpb+24
copy_string:    E5_gpb+25
enable_interrupt: E5_gpb+26
interrupt_arrived: E5_gpb+27
disable_interrupt: E5_gpb+28

// procedures in E6 module

start_e6:       E6_gpb
connect_sin:    E6_gpb+1
switch_sin:     E6_gpb+2
fetch_sin_line: E6_gpb+3
connect_so:     E6_gpb+4
do_a:           E6_gpb+5
do_n:           E6_gpb+6
value_n:        E6_gpb+7

// procedures in E7 module.

undo_changes:   E7_gpb
reset_trail:    E7_gpb+1
log_del:        E7_gpb+2
log_cha:        E7_gpb+3
log_ins:        E7_gpb+4
log_pos:        E7_gpb+5
$)

EXTERNAL $(

// procedures in E1 module

PARSELINE:      seg.main
stop_prog:      seg.main
recover:        seg.main

// procedures in E2

start_e2:       seg.main
execute:        seg.main
monitorline:    seg.main
close_down:     seg.main
set_line:       seg.main
shuffle:        seg.main
break_line:     seg.main
write_file:     seg.main
undo:           seg.main
check_for_interrupt: seg.main

// procedures in E3

start_e3:       seg.main
fetch_line:     seg.main
make_space:     seg.main
move_windows:   seg.main
store_line:     seg.main
copy_lines:     seg.main
work_stats:     seg.main
fetch_grab:     seg.main
store_grab:     seg.main
fetch_max_grab: seg.main
restore_max_grab: seg.main

// procedures in E4

find_args:      seg.rare
open_output:    seg.rare
close_streams:  seg.rare
set_defaults:   seg.rare

// procedures in PROFORMA module

init_proforma:  seg.rare
get_arg:        seg.rare

// procedures in E5

get_line:       seg.main
copy_bytes:     seg.main
warn:           seg.main
copy_cells:     seg.main
check_blocks:   seg.main
restore_block:  seg.main
save_block:     seg.main
reset_byte_count: seg.main
add_byte_count: seg.main
print_byte_count: seg.main
readpackedline: seg.main
copy_and_unpack:seg.main
copy_and_pack:  seg.main
readunpackedline: seg.main
filing_error:   seg.main
null_stream:    seg.main
getfilename:    seg.main
WriteUnpackedLine: seg.main
report:         seg.main
yes_reply:      seg.main
print_fs_err:   seg.main
vdu_stream:     seg.main
sys_return:     seg.main
sys_command:    seg.main
print_filespec: seg.main
copy_string:    seg.main
enable_interrupt: seg.main
interrupt_arrived: seg.main
disable_interrupt: seg.main

// procedures in E6

start_e6:       seg.rare
connect_sin:    seg.rare
switch_sin:     seg.rare
fetch_sin_line: seg.rare
connect_so:     seg.rare
do_a:           seg.rare
do_n:           seg.rare
value_n:        seg.rare

// procedures in E7

undo_changes:   seg.main
reset_trail:    seg.main
log_del:        seg.main
log_cha:        seg.main
log_ins:        seg.main
log_pos:        seg.main

// Module PROFORMA

init_proforma = SEG.RARE
get_arg = SEG.RARE
$)
