
SECTION "E2"

GET ".ECCE-HDR"
GET ".SFO-HDR/3/S"

MANIFEST { 
screen_width_m3 = screen_width-3
}

STATIC {
endline=0;
codefield=0; searchlim=0; textfield=0; repfield=0;
exec.level=0; exec.exit=0
ignore=0; invert=0
}

LET start_e2() BE
{1 start_e3()
   sin := FALSE
   cur_len:=0
   ml := 0
   cur_tag:=null
   last_line:=0
   horiz.start:=0
   altered := FALSE
   quote_pos := -1
   quote_text!0 := 0
   monind, printed := FALSE, FALSE
   read_file(fromstream,1)
   fromstream := errorvalue  // since no longer exists (closed).
   set_line(1)
   reset_trail()     // reset undo trail.
   set_default_vdu()
}1
 
AND set_default_vdu() BE
{1 wrch(highlight.on.code)
   wrch(esc.code); wrch(inv.off.code)
   wrch(esc.code); wrch(flash.off.code)
   wrch(esc.code); wrch(half.off.code)
   wrch(esc.code); wrch('**'); wrch(under.off.code)
   wrch(highlight.off.code)
   forceout()
}1
 
AND check_for_interrupt() BE
   IF interrupt_arrived() THEN 
   {  report("******%CCommand cancelled*N", bell.code)
      recover()
   }
 
AND undo(n) = VALOF
{1 LET r = ?

   IF altered THEN
   {  // If the line has been altered, the policy is to reinstate the
      // orignal copy although this may be several changes old.
      cur_len := fetch_line(cur_line, line) - 1
      altered := FALSE
   }
   r := undo_changes(n)
   quote_pos := -1
   cur_len := cur_line > last_line -> 0, fetch_line(cur_line, line)-1
   monitorline(TRUE)
   RESULTIS r
}1
 
AND set_altered() BE
   altered, quote_pos := TRUE, -1

AND shuffle(amount) BE
/*  If amount +ve then insert gaps after cursor.
    If amount negative then delete chars after cursor.
*/
{1   LET dest=line+amount

     IF amount=0 THEN RETURN                      // nothing to do
     set_altered()
     
     TEST amount<0 THEN
     {    
          FOR i=cursor-amount TO cur_len-1
          DO dest!i:=line!i
     }
     ELSE
     {    
          FOR i=cur_len-1 TO cursor BY -1
          DO dest!i:=line!i
     }
     cur_len+:=amount
}1

 
AND print(ptr) BE
{1 LET total=0
   LET endmatch=cursor+(ml=0 -> 1, ml)
   LET is_tab(ch) = \(#X7E>=ch>='*S')

   {  LET ch=line!ptr

      IF ptr=cursor THEN UNLESS ptr=0 & ml=0 DO 
      {  wrch(esc.code)
         wrch(inv.on.code) 
      }
      IF ptr>=cur_len THEN 
      {  IF cursor>=cur_len THEN
            wrch('*S')
         BREAK
      }
      total+:=1
      IF total > screen_width_m3 THEN
      {  wrch(blob.code)
         BREAK
      }
      IF is_tab(ch) THEN wrch(graphic.code)
      wrch(ch)
      ptr+:=1
      IF ptr=endmatch THEN 
      {  wrch(esc.code)
         wrch(inv.off.code) 
      }
   } REPEAT
   wrch(esc.code)
   wrch(inv.off.code)
   newline()
}1

AND printline(half_intensity) BE 
{1   wrch(highlight.on.code)
     wrch(esc.code); wrch(half_intensity -> half.on.code, half.off.code)
     TEST cur_line>last_line THEN writes("**** End *****N")
     ELSE 
     {  LET len=cursor
        LET startpos=(horiz.start=0 ->
                         (len+ml<screen_width_m3 -> 0, 
                            (len>screen_width_m3 -> screen_width_m3, len)),
                               horiz.start) 

        TEST startpos=0 THEN
        IF cue\=0 THEN wrch('*S')
        ELSE wrch(blob.code)
        print(startpos)
     }
     printed := TRUE
     wrch(esc.code); wrch(half.off.code)
     wrch(highlight.off.code)
}1

AND monitorline(force) BE
/* If parameter 'force' is true then monitor regardless of the values of
   'printed' or 'monind'.
*/
{1
     IF printed & \force THEN RETURN 
     UNLESS cur_line>last_line DO
     { 
        IF monflag>'M' THEN RETURN                   // quiet mode
        IF monflag='M' & \monind & \force THEN RETURN
     }
     // either monitor or full so print line
     printline(FALSE)
     monind:=FALSE
}1

AND copycontext() BE
{1   
     LET from = textfield-1
     LET dest = line+cursor

     FOR i=0 TO textfield!0-1 DO dest!i:=from!-i
}1

AND match_string(string, context) = VALOF
{1   // nOTE: cONTEXT STORED IN REVERSE ORDER, STRING ASSUMED
     // TO BE AT LEAST AS LONG AS CONTEXT LENGTH.
     LET len=context!0

     string+:=line
     context-:=1
     TEST uc_terminal THEN
     {  // ignore case of characters during comparisons.
        FOR i = 0 TO len-1 DO
           UNLESS alter_case(string!i, case_upper) = 
                  alter_case(context!-i, case_upper) RESULTIS FALSE
     }
     ELSE
     {
        FOR i=0 TO len-1 DO
             UNLESS string!i = context!-i
             DO RESULTIS FALSE
     }
     ml:=len
     RESULTIS TRUE
}1

AND matchplus() = VALOF
{1   LET len=textfield!0 
     LET string = (ml = len &
                   match_string(cursor, textfield) &
                   code \= 'D') -> cursor+1, cursor

     IF cur_line>last_line | len = 0 THEN RESULTIS FALSE 

     {    UNTIL (cur_len-string)<len DO
          { 
               IF match_string(string, textfield) THEN
               { TEST codefield='U' 
                 THEN shuffle(cursor-string) 
                 ELSE cursor:=string 
                 RESULTIS TRUE 
               } 
               string:=string+1
          }
          searchlim:=searchlim-1
          IF searchlim=0 THEN RESULTIS FALSE
          TEST codefield='U' THEN
          {    cur_len:=cursor       // delete all after cursor
               set_altered()
               UNLESS join_line() DO 
               // Cannot join since line would be too long. The course of
               // action adopted is to move to the next line so splitting
               // the line in two - the user may then join them if required
               // after suitably adjuting the lengths.
               UNLESS set_line(cur_line+1) RESULTIS FALSE
          }
          ELSE UNLESS set_line(cur_line+1) DO RESULTIS FALSE
          string:=0
     } REPEAT
}1

AND matchneg() = VALOF
{1   LET len=textfield!0 
     LET string = ( ml = len &
                    match_string(cursor, textfield) ) -> cursor-1, cursor

     IF len = 0 RESULTIS FALSE
     IF cur_len-cursor<len THEN string:=cur_len-len
     {    IF len<=cur_len THEN
          {    
               {    IF match_string(string, textfield) THEN
                    { cursor:=string 
                      RESULTIS TRUE 
                    } 
                    string:=string-1
               } REPEATUNTIL string<0
          }
          searchlim:=searchlim-1
          IF searchlim=0 THEN RESULTIS FALSE
          UNLESS set_line(cur_line-1) DO RESULTIS FALSE 
          string:=cur_len-len
     } REPEAT
}1

AND delete_lines(start_line, n) BE
/* Delete 'n' lines starting at 'start_line'.
*/
{1 LET after_line=start_line+n
   // Must call 'copy_lines' even if no cells to copy (the situation
   // when deleting the last line in the file) so as to keep the undo
   // trail up to date.
   copy_lines(after_line, start_line, last_line-after_line+1)
   last_line-:=n
   monind := TRUE
   ml := 0
   IF start_line <= cur_line <= after_line
   THEN altered := FALSE  // mustn't write line back if being deleted!
}1

AND read_lines(before_line) BE 
/* Insert lines read from "file_in_stream' before 'before_line'
   until end of file is encountered.
*/
{1 reset_byte_count()
   cur_line:=before_line
   {  cur_len := ReadUnpackedLine(line, line_bsz)
      IF cur_len = errorvalue BREAK
      IF w_space=0 THEN make_space(TRUE)
      add_byte_count(store_line(cur_line, cur_len, line))
      cur_line +:= 1
   }  REPEAT
   IF w_space > 0 THEN make_space(FALSE)
}1

AND read_file(stream, after_line) BE
/* Open a stream to the specified file 'file' and read it after 'after-line'.
*/
{1 file_in_stream := stream
   read_lines(after_line)
   close(stream)
   file_in_stream := 0
   print_byte_count()
}1
 
AND write_lines(start, fin) = VALOF
{1 LET v = VEC line_bsz+3

   reset_byte_count()
   FOR i=start TO fin DO
   {  LET len = fetch_line(i, v+2)
      LET r = WriteUnpackedLine(len-1, v+2)
      
      IF r = errorvalue RESULTIS E4failcode
      add_byte_count(len)
   }
   RESULTIS 0
}1

AND write_file(stream, start, fin) = VALOF
{1 LET r = ?
   file_out_stream := stream   // select stream for WriteUnpackedLine.
   r := write_lines(start, fin)
   UNLESS r = 0 DO filing_error(stream, E4failcode)
   file_out_stream := 0
   RESULTIS r
}1

AND close_down(opt) = VALOF
{1 LET r = 0

   connect_sin(0, 0)   // disconnect secondary input stream
   connect_so(0, 0)    // & secondary output .
 
   TEST opt=abort_run
   THEN close_streams(FALSE)
   ELSE
   {  IF opt=exit_run THEN inplace, toptr := FALSE, nil
      IF altered THEN store_line(cur_line, cur_len, line)
      open_output()
      r := write_file(tostream, 1, last_line)
      close(tostream)
      IF r = 0 THEN 
      {  print_byte_count() 
         close_streams(TRUE)
      }
   }
   RESULTIS r
}1
 
AND alter_case(ch, mode) = VALOF
/* If 'ch' is alphabetic then alter case according to mode:
      Case_flip (0) = flip case
      Case_upper (1) = force upper case
      Case_lower (2) = force lower case.
*/
{1 TEST ('A'<=ch<='Z') | ('a'<=ch<='z') THEN
   {  RESULTIS mode=case_flip -> ch NEQV #X0020,
               mode=case_upper -> ch & #X005F, ch | #X0020
   }
   ELSE RESULTIS ch
}1
 
AND insert_context() BE
/* Make room for the required text (held in textfield) and copy
   it into 'line' at 'cursor'. 'Cursor' is updated to point after
   the inserted text.
*/
{1 LET l = textfield!0
   LET s = textfield-1
   
   shuffle(l)
 { LET insert_pt = line+cursor
   FOR i=0 TO l-1 DO insert_pt!i:=s!-i

   cursor+:=l
}1
 
AND break_line(n) = VALOF
{1 TEST cur_line > last_line | cursor=0 THEN 
   FOR i=0 TO n-1 DO
   {  IF w_space=0 THEN make_space(TRUE) 
      store_line(cur_line, 0) 
      cur_line+:=1
   }
   ELSE
   {  LET remainder = cur_len-cursor
      LET text = cursor+line

      make_space(TRUE)
      store_line(cur_line, cursor, line)
      cur_line+:=1
      FOR i=0 TO n-2 DO
      {  store_line(cur_line,0) 
         cur_line+:=1
         IF w_space=0 THEN make_space(TRUE)
      }
      copy_cells(remainder, text, line)
      cur_len:=remainder
      set_altered()       // since just stored it above.
   }
   IF w_space > 0 THEN make_space(FALSE)
   cursor:=0
   RESULTIS n
}1
 
AND join_line() = VALOF
{1 IF cur_line > last_line RESULTIS 0
   TEST cur_line = last_line
   THEN set_line(cur_line+1)
   ELSE
   {  LET len=fetch_line(cur_line+1, line+cur_len)-1
      IF cur_len+len > line_csz RESULTIS FALSE
      cursor:=cur_len      // set cursor to position of 'join'.
      cur_len+:=len
      delete_lines(cur_line+1, 1)
      set_altered()
   }
   RESULTIS 1
}1

AND left_char(n) = VALOF
{1 LET actual = n>cursor -> cursor, n

   cursor-:=actual
   RESULTIS actual
}1

AND set_line(n) = VALOF
/* Fetch line number 'n' and make if the current line provided that 'n' is
  in the range 1-'last_line'.
*/
{1 LET here = cur_line
   cur_line := n<1 -> 1, (n>last_line+1 -> last_line+1, n) 

   IF altered THEN
   {  store_line(here, cur_len, line)
      altered := FALSE
   }
   UNLESS cur_line = here DO
   {  ml := 0
      monind := TRUE
   }
   quote_pos := -1
   cur_len:=cur_line > last_line -> 0,
               (sin -> fetch_sin_line(cur_line, line),
                       fetch_line(cur_line, line)) - 1
   cursor:=0
   check_for_interrupt()
   RESULTIS n=cur_line
}1

AND match_tag() = VALOF
{1   LET string = cur_tag = textfield & cursor = tag_pos ->
                      cursor+1, cursor

     IF cur_line>last_line THEN RESULTIS FALSE 

     {    IF cur_tag = textfield & string <= tag_pos THEN
          {  TEST codefield = 'U'
             THEN shuffle(cursor - tag_pos)
             ELSE cursor := tag_pos
             ml := 0
             RESULTIS TRUE
          }
          searchlim:=searchlim-1
          IF searchlim=0 THEN RESULTIS FALSE
          TEST codefield='U' THEN
          {    cur_len:=cursor       // delete all after cursor
               set_altered()
               UNLESS join_line() DO 
               // Cannot join since line would be too long. The course of
               // action adopted is to move to the next line so splitting
               // the line in two - the user may then join them if required
               // after suitably adjuting the lengths.
               UNLESS set_line(cur_line+1) RESULTIS FALSE
          }
          ELSE UNLESS set_line(cur_line+1) DO RESULTIS FALSE
          string:=0
     } REPEAT
}1

AND match_tag_minus() = VALOF
{1   LET string = cur_tag = textfield & cursor = tag_pos ->
                    cursor-1, cursor

     {  IF cur_tag = textfield & string >= tag_pos THEN
        {  cursor := tag_pos
           ml := 0
           RESULTIS TRUE
        }
         
        searchlim:=searchlim-1
        IF searchlim=0 THEN RESULTIS FALSE
        UNLESS set_line(cur_line-1) DO RESULTIS FALSE 
        string:=cur_len
     } REPEAT
}1

AND change_tag(tag) = VALOF
{1 cur_tag := tag
   tag_pos := cursor
   set_altered()
   RESULTIS 1
}1

AND delete_tag() = VALOF
{1 UNLESS cur_tag = textfield RESULTIS 0
   change_tag(null)
}1
 
AND right_char(n) = VALOF
{1 LET actual=n>cur_len-cursor -> cur_len-cursor, n

   cursor+:=actual
   RESULTIS actual
}1
 
AND do_b() = VALOF
{1 break_line(repfield)
   RESULTIS repfield
}1
 
AND do_c_plus() = VALOF
{1 IF cursor >= cur_len RESULTIS FALSE
   line!cursor:=alter_case(line!cursor, case_flip)
   set_altered()
   ml := 0
   cursor+:=1
   RESULTIS 1
}1

AND do_c_minus() = VALOF
{1 UNLESS left_char(1)=1 RESULTIS FALSE
   line!cursor:=alter_case(line!cursor, case_flip)
   set_altered()
   ml := 0
   RESULTIS 1
}1

AND do_d() = VALOF
{1 IF matchplus() THEN 
   {  shuffle(-ml) 
      ml:=0 
      RESULTIS 1
   } 
   RESULTIS 0 
}1

AND do_e_plus() = VALOF
{1 LET actual=repfield>cur_len-cursor -> cur_len-cursor, repfield

   IF actual=0 RESULTIS FALSE
   shuffle(-actual)
   ml:=0
   RESULTIS actual
}1

AND do_e_minus() = VALOF
{1 LET actual=left_char(repfield)

   shuffle(-actual)
   RESULTIS actual
}1
 
AND do_g() = VALOF
{1 LET v = VEC line_bsz
   LET len = ?
   LET actual = 0

   disable_interrupt()  // must disable since we may require to input
                        // from same device.
   cue := ":"
   WHILE actual < repfield DO
   {  len := get_line(v, line_bsz)
      IF len = errorvalue |
         (v!1 = ':' & len = 1) THEN
      {  actual := 0
         BREAK
      }
      IF w_space=0 THEN make_space(TRUE)
      store_line(cur_line, len, v+1)
      actual +:= 1
      cur_line+:=1
   }
   IF w_space > 0 THEN make_space(FALSE)
   cue := ">"
   enable_interrupt()
   RESULTIS actual
}1
 
AND do_h() = VALOF
/* Display 'repfield' number of lines either side of the current line
   leaving the current line unchanged. If 'repfield' is either too large
   for the screen or outside the limits of the file then the display
   amount is suitably truncated.
*/
{1 MANIFEST { max = (screen_height-2)/2 }
   LET n = repfield > max -> max, repfield
   LET save_ln, save_ml, save_fp = cur_line, ml, cursor
   LET first_line = cur_line - n < 1 -> 1, cur_line - n
   LET end_line = cur_line + n > (last_line+1) -> last_line+1, cur_line+n

   set_line(first_line)
   {  IF cur_line = save_ln THEN
      {  cursor, ml := save_fp, save_ml 
         printline(FALSE)
         BREAK
      }
      printline(TRUE)
      set_line(cur_line+1)
   } REPEAT

   WHILE cur_line < end_line DO
   {  set_line(cur_line+1)
      printline(TRUE)
   }

   set_line(save_ln)
   ml, cursor := save_ml, save_fp
   RESULTIS repfield
}1
 
AND do_i() = VALOF
{1 IF cur_line>last_line | 
      cur_len+textfield!0 > line_csz 
   THEN RESULTIS 0 
   insert_context() 
   ml:=0 
   RESULTIS 1
}1

AND do_j() = VALOF
{1 UNLESS join_line()=1 RESULTIS 0
   ml:=0
   RESULTIS 1
}1
 
AND do_k() = VALOF
{1 LET actual = cur_line+repfield > last_line+1 -> last_line+1-cur_line, repfield

   IF actual=0 RESULTIS 0
   delete_lines(cur_line, actual)
   set_line(cur_line)
   RESULTIS actual
}1

AND do_k_minus() = VALOF
{1 LET actual = repfield < cur_line -> repfield, cur_line-1

   IF actual = 0 RESULTIS 0
   delete_lines(cur_line-actual, actual)
   cur_line -:= actual
   RESULTIS actual
}1
 
AND do_l() = VALOF
{1 LET r=left_char(repfield) 
   
   IF r=0 RESULTIS 0
   ml:=0
   RESULTIS r
}1
 

AND do_m_plus() = VALOF
{1 LET r = set_line(cur_line+repfield) 

   RESULTIS r -> repfield, 0
}1
 
AND do_m_minus() = VALOF
{1 LET r=set_line(cur_line-repfield)

   RESULTIS r -> repfield, 0
}1

AND do_o() = VALOF
{1 LET l = textfield!0
      
   IF cursor+l > line_csz RESULTIS 0
   shuffle( -(l+cursor > cur_len -> cur_len-cursor, l))
   insert_context()
   ml := 0
   RESULTIS 1
}1
 
AND do_quote() = VALOF
{1 TEST quote_pos < 0 THEN 
   {  quote_pos := cursor 
      quote_text!0 := 0
   }
   ELSE
   {  LET qp = quote_pos
      LET len = 0
      LET start = ?

      quote_pos := -1
      
      TEST cursor > qp THEN
         start, len := qp, cursor - qp
      ELSE IF cursor < qp THEN       
         start, len := cursor, qp - cursor

      start := start + line - 1
      quote_text!0 := len
     
     FOR i=1 TO len DO
        quote_text!-i := start!i
   }
   RESULTIS 1
}1
 
AND do_r() = VALOF
{1 LET r = right_char(repfield) 

   IF r=0 RESULTIS 0
   ml:=0
   RESULTIS r
}1
 
AND do_s() = VALOF
{1 IF cur_line>last_line | 
      cur_len+textfield!0>line_csz | 
      ml=0 
   THEN RESULTIS 0
   shuffle(-ml) 
   insert_context() 
   ml:=0 
   RESULTIS 1 
}1

AND do_t() = VALOF
{1 UNLESS matchplus() RESULTIS 0
   cursor+:=ml 
   ml:=0 
   RESULTIS 1
}1

AND verify_greater(string, context) = VALOF
{1 LET len = context!0

   string +:= line
   context -:= 1
   
   FOR i=0 TO len-1 DO
      UNLESS context!-i > string!i RESULTIS 0
   
   RESULTIS 1
}1
 
AND verify_tag() = VALOF
{1 ml := 0
   RESULTIS (cur_line <= last_line &
            cur_tag = textfield &
            tag_pos = cursor) -> 1, 0
}1
 
AND do_v() = VALOF
{1 IF cur_line>last_line | 
      textfield!0 > cur_len-cursor |
      ~match_string(cursor, textfield) THEN
   {  ml:=0
      RESULTIS 0
   }
   RESULTIS 1 
}1

AND dosimplecommand(command) = VALOF
{1   printed:=FALSE 
   { LET actual = VALOF SWITCHON command INTO 
     {    CASE '*'':
             RESULTIS do_quote()

          CASE 'A':
             RESULTIS do_a(repfield)

          CASE 'B': 
             IF sin RESULTIS 0
             RESULTIS do_b()
          
          CASE 'C':
             IF sin RESULTIS 0
             RESULTIS do_c_plus()
          
          CASE -'C':
             IF sin RESULTIS 0
             RESULTIS do_c_minus()

          CASE 'D':
             IF sin RESULTIS 0
             RESULTIS tag_text -> delete_tag(), do_d() 
          
          CASE 'E':
             IF sin RESULTIS 0
             RESULTIS do_e_plus()

          CASE -'E':
             IF sin RESULTIS 0
             RESULTIS do_e_minus()
 
          CASE 'F':
             RESULTIS (tag_text -> match_tag,matchplus)() -> 1, 0

          CASE -'F':
             RESULTIS (tag_text -> match_tag_minus, matchneg)() -> 1, 0 
 
          CASE 'G':
             IF sin RESULTIS 0
             RESULTIS do_g()

          CASE 'H':
             RESULTIS do_h()

          CASE 'I':
             IF sin RESULTIS 0
             RESULTIS tag_text -> change_tag(textfield), do_i() 

          CASE 'J':
             IF sin RESULTIS 0
             RESULTIS do_j()

          CASE 'K':
             IF sin RESULTIS 0
             RESULTIS do_k()
 
          CASE -'K':
             IF sin RESULTIS 0
             RESULTIS do_k_minus()

          CASE 'L':
             RESULTIS do_l()

          CASE 'M':
             RESULTIS do_m_plus()

          CASE -'M':
             RESULTIS do_m_minus()

          CASE 'N':
             RESULTIS do_n()

          CASE 'O':
             RESULTIS tag_text -> change_tag(textfield), do_o() 

          CASE 'P':
             printline(FALSE)
             RESULTIS repfield=1 -> 1, (set_line(cur_line+1) -> 1, 0) 

          CASE 'R':
             RESULTIS do_r()
 
          CASE 'S':
             IF sin RESULTIS 0
             RESULTIS tag_text -> change_tag(textfield), do_s()

           CASE 'T':
             RESULTIS do_t()

           CASE 'U':
             IF sin RESULTIS 0
             RESULTIS (tag_text -> match_tag, matchplus)() -> 1, 0

           CASE 'V':
              RESULTIS (tag_text -> verify_tag, do_v)()

          CASE -'V':
             RESULTIS verify_greater(cursor, textfield)

          DEFAULT: RESULTIS FALSE
     } 
     repfield-:=actual
     RESULTIS actual\=0
}1

AND execute(commands) = VALOF
{1   LET ok = ?
     LET failptr, cptr = 0, commands
     exec.level, exec.exit:= level(), retpoint
     log_pos(cur_line, cursor, ml)    // for undo code.
     enable_interrupt()
     UNTIL cptr!c.code=0 DO
     { 
          codefield, textfield:=cptr!c.code, cptr!c.text
          repfield, searchlim:= cptr!c.repno, cptr!c.lim
          tag_text := (cptr!c.flags & sbit_tag) \= 0
          invert:=(cptr!c.flags & sbit_invert) \= 0
          ignore:=(cptr!c.flags & sbit_ignore) \= 0
          // Note: 'ignore' set (by E1) if either ignore (*) or
          //       invert (\) specified in command.

          IF textfield < 0 THEN textfield := quote_text

          SWITCHON codefield INTO
          {  CASE 'X':                            // '('
                textfield!c.repno:=repfield
                endCASE

             CASE 'Z':                            // ')'
                IF invert THEN GOTO skiponfail  // invert success
                repfield-:=1
                IF repfield=0 THEN ENDCASE
                check_for_interrupt()
                cptr!c.repno:=repfield
                cptr:=textfield
                endCASE

             CASE 'Y':                            // ','
                cptr:=textfield                   // skip to next command
                LOOP
             default:
             {    
                searchlim:=cptr!c.lim              // spec says we give same
                                                   // searchspace to each rep
                                                   // e.g f2/t/2 eqv (f2/t/)2
                ok:=dosimplecommand(codefield)
                TEST ok THEN
                   UNLESS invert LOOP       // repeat command.
                ELSE IF ignore BREAK        // carry on from next command.
                // Command failed - skip to end or an ignore fail condition.
skiponfail:
                {    failptr:=cptr
                     {    cptr:=cptr+c.size
                          WHILE cptr!c.code='X' DO
                             cptr:=cptr!c.text+c.size // skip to ')' on
                                                      // finding  a '('
                          codefield:=cptr!c.code
                          repfield:=cptr!c.repno
                          ignore:=(cptr!c.flags & sbit_ignore) \= 0

                          IF codefield=0 THEN
                          {  disable_interrupt()
                             RESULTIS failptr 
                          }
                     } REPEATUNTIL codefield='Y' |
                                    (codefield='Z' & ignore)
                     BREAK                         // continue with next com
                }
             } REPEATUNTIL repfield=0
          } 
          cptr+:=c.size
     }
retpoint:
     disable_interrupt()
     RESULTIS 0
}1

