// Program to check that a lexicon is still in lexicon order

$<PDPRSX
NEEDS "IOERROR"

GET "LIBHDR"
GET "SPEHDR"
$>PDPRSX

$<CAP1
GET "LIBHDR"
GET ".progs.spehdr"
$>CAP1

LET START() BE
$(
$<PDPRSX
    LET filename = VEC 100
    LET cml      = FINDCML("CLX")
    LET lexname  = "LEXICON"
$>PDPRSX

$<CAP1
    LET filename  = GETSLOT()
$>CAP1

    LET word1 = VEC wordsperword + 2
    LET word2 = VEC wordsperword + 2
    LET word3 = VEC wordsperword
    LET word4 = VEC wordsperword

    LET t     = ?
    LET wcount  = 1

    word1 := word1 + 2
    word2 := word2 + 2
    word1!-1, word1!-2 := FALSE, word3
    word2!-1, word2!-2 := FALSE, word4

$<PDPRSX
    Selectinput( cml )
    readstring( filename, '*N' )
    ENDREAD()
    IF filename%0=0 THEN filename := lexname
    mylexstr := Findinput( filename )

    IF mylexstr<0 THEN Writef("Cannot open Lexicon - ") <>
		 Writef(IOerror(mylexstr),mylexstr,filename)  <>
	         FINISH
$>PDPRSX

$<CAP1
    mylexstr :=FINDINPUT("1|LEXICON|.lexicon")
    IF mylexstr=0 THEN
    $(
	LET lex.err = FAULT(ERRORCODE)
	WRITEF("*NCannot open lexicon - %S*N",lex.err)
	FINISH
    $)
    MOVECAP( K.N0 , filename )		// Keep filename
    SELECTOUTPUT(MSTREAM)

    UNLESS EXTRAITEMS() DO		// Warn about rubbish on cammand line
    $(
	LET o = OUTPUT()
	LET s = GETSLOT()
	MOVECAP( K.N0 , s )
	SELECTOUTPUT(MSTREAM)
	WRITEF("*N******Warning - unrecognized items on command line - %S*N",s)
	FREESLOT( s )
	UNLESS o = 0 DO SELECTOUTPUT( o )
    $)
$>CAP1

    Selectinput(mylexstr)
    readmylexword( word1 )

    $(
	LET cmp = ?
	readmylexword( word2 )
	IF word2%0 = 0 THEN BREAK

	wcount := wcount + 1
	cmp := comparestring(word2, word1)

        TEST cmp<0
             THEN Writef("*'%S*' occurs (erroneously) after *'%S*'*N",
			   word2,			     word1)
             ELSE IF cmp=0
		     THEN Writef("*'%S*' occurs twice*N",word1)

	t     := word1
	word1 := word2
	word2 := t
    $) REPEAT

    Writef("There are %N words in %S*N",wcount,filename)
$)
