//	count.bcp
//	word counting program

NEEDS "IOERROR"

GET "LIBHDR"

LET start () BE
$(
	LET commandstream = findparm ()
	LET filename = VEC 256/bytesperword
	LET itsalldone = false
	selectinput (commandstream)
	$(
		LET stream = ?
		readstring (filename, '/')
		itsalldone := terminator = endstreamch
		IF filename%0 = 0 THEN
			LOOP
		stream := findinput (filename)
		TEST stream >= 0 THEN
		$(
			selectinput (stream)
			wordcount (filename)
			endread ()
			selectinput (commandstream)
		$)
		OR
			message (ioerror (stream), stream, filename)
	$)  REPEATUNTIL itsalldone
$)

AND wordcount (filename) BE
$(
	LET wc, lc = 0, 0
	LET inword = false

	$(
		terminator := rdch ()
		SWITCHON terminator INTO
		$(cases
		CASE '*N':
		CASE '*P':
			lc := lc + 1
		CASE '*S':
		CASE '*T':
			IF inword THEN
			$(
				wc := wc + 1
				inword := false
			$)
			ENDCASE
		DEFAULT:
			inword := true
			ENDCASE
		$)cases
	$)  REPEATUNTIL terminator = endstreamch

	message ("%S contains %N word%S in %N line%S", filename,
		wc, plural (wc), lc, plural (lc))
$)

AND plural (n) = n = 1 -> "", "s"

AND message (f, a, b, c, d, e) BE
$(
	writes ("COUNT -- ")
	writef (f, a, b, c, d, e)
$)


