// Program to expand a compressed lexicon

$<PDPRSX
NEEDS "IOERROR"
GET "LIBHDR"
GET "SPEHDR"
$>PDPRSX

$<CAP1
GET "LIBHDR"
GET ".progs.spehdr"
$>CAP1

LET START() BE
$(
    LET t     = ?
    LET word1 = VEC wordsperword + 2
    LET word3 = VEC wordsperword


$<PDPRSX
    syslexstr    := Findinput( "LEXICON" )
    newlexstr   := Findoutput( "LEXICON" )

	IF syslexstr<0 THEN Writef("Cannot open Lexicon - ") <>
		     Writef(IOerror(syslexstr),syslexstr,"LEXICON") <>
		     FINISH
$>PDPRSX

$<CAP1
    LET using.anon.file,s = ?,?
    LET slot = GETSLOT()

    LET fatal.error.exit( in.err ) BE		// Error exit routine
    $(
	LET io.err = FAULT(ERRORCODE)
	SELECTOUTPUT(MSTREAM)
	WRITEF("*NFATAL ERROR - Cannot open %S file - %S*N", in.err -> "input", "output", io.err )
	FINISH
    $)

    syslexstr := FINDINPUT( "1|FROM|.lexicon" )	// Input file open
    IF syslexstr = 0 THEN fatal.error.exit( TRUE )
    MOVECAP( K.N0 , slot )			// Save filename just syslexstr case

    newlexstr := FINDOUTPUT( "2|TO|/A" )	// Output file open
    IF newlexstr = 0 THEN fatal.error.exit( FALSE )
    using.anon.file := EQSTRING( K.N0 , "/A" )

    UNLESS EXTRAITEMS() DO			// Warn about rubbish on command line
    $(
	LET o = OUTPUT()
	LET s = GETSLOT()
	MOVECAP( K.N0 , s )
	SELECTOUTPUT(MSTREAM)
	WRITEF("*N******Warning - unrecognized items on command line - %S*N",s)
	FREESLOT( s )
	UNLESS o = 0 DO SELECTOUTPUT( o )
    $)
$>CAP1

    word1 := word1 + 2
    word1!-1, word1!-2 := FALSE, word3
    linelength := MAXLINELENGTH

    Selectinput( syslexstr )
    Selectoutput( newlexstr )

    $(
	Readsysword( word1 )
	IF word1%0 = 0 THEN BREAK
	Writemylexword( word1 )
    $) REPEAT

$<CAP1
    s := GETSLOT()				// just in case
    SELECTINPUT( syslexstr )			// Close files
    ENDREAD()
    SELECTOUTPUT( newlexstr )
    ENDWRITE()
    IF using.anon.file THEN			// Rename if used anon o/p
    $(
	LET rc = ?
	MOVECAP( K.N0 , s )
	rc := PRESERVE( s , slot , DEFAULT.SEG.AM )
	IF rc < 0 THEN
	$(
	    SELECTOUTPUT( MSTREAM )
	    WRITEF("*NCannot update lexicon - %S*N",FAULT(rc))
	$)
    $)
    FREESLOT( s )
    FREESLOT( slot )
$>CAP1

$)
