// Program to edit a lexicon
//	Prompts with words from the lexicon
//	Responses - Q (quit)
//		  - Y: yes leave this
//		  - N: no remove this
//		  - S word: skip through accepting words up and including
//				'word'

$<PDPRSX
NEEDS "IOERROR"
GET "LIBHDR"
GET "SPEHDR"
$>PDPRSX

$<CAP1
GET "LIBHDR"
GET ".progs.spehdr"
$>CAP1

LET START() BE
$(
    LET word1 = VEC wordsperword + 2
    LET word2 = VEC wordsperword + 2
    LET word3 = VEC wordsperword
    LET word4 = VEC wordsperword

    LET t     = ?

$<PDPRSX
    mylexstr    := Findinput( "LEXICON" )
    newlexstr   := Findoutput( "LEXICON" )

	IF mylexstr<0 THEN Writef("Cannot open Lexicon - ") <>
		     Writef(IOerror(mylexstr),mylexstr,"LEXICON") <>
		     FINISH
$>PDPRSX

$<CAP1
    LET sysin = ?
    LET using.anon.file,s = ?,?
    LET slot = GETSLOT()

    LET fatal.error.exit( in.err ) BE		// Error exit routine
    $(
	LET io.err = FAULT(ERRORCODE)
	SELECTOUTPUT(MSTREAM)
	WRITEF("*NFATAL ERROR - Cannot open %S file - %S*N", in.err -> "input", "output", io.err )
	FINISH
    $)

    mylexstr := FINDINPUT( "1|FROM|.lexicon" )	// Input file open
    IF mylexstr = 0 THEN fatal.error.exit( TRUE )
    MOVECAP( K.N0 , slot )			// Save filename just mylexstr case

    newlexstr := FINDOUTPUT( "2|TO|/A" )	// Output file open
    IF newlexstr = 0 THEN fatal.error.exit( FALSE )
    using.anon.file := EQSTRING( K.N0 , "/A" )

    UNLESS EXTRAITEMS() DO			// Warn about rubbish items on command line
    $(
	LET o = OUTPUT()
	LET s = GETSLOT()
	MOVECAP( K.N0 , s )
	SELECTOUTPUT(MSTREAM)
	WRITEF("*N******Warning - unrecognized items on command line - %S*N",s)
	FREESLOT( s )
	UNLESS o = 0 DO SELECTOUTPUT( o )
    $)

    sysin := FINDINPUT( "/M" )			// Open terminal input stream
    IF sysin = 0 THEN fatal.error.exit( TRUE )
    SYSOUT := MSTREAM
$>CAP1

    word1 := word1 + 2
    word2 := word2 + 2
    word1!-1, word1!-2 := FALSE, word3
    word2!-1, word2!-2 := FALSE, word4
    linelength := MAXLINELENGTH

    $(
	LET com = ?
	Selectinput( mylexstr )
	readmylexword( word1 )
	IF word1%0 = 0 THEN BREAK

	Selectoutput( SYSOUT )
	Writes(word1)
	IF word1!-1 THEN Writef("=%S",word1!-2)
	Wrch(' ')

$<CAP1	WRCH('*E')	$>CAP1

	Selectinput( SYSIN )
	com := capitalch( RDCH() ) REPEATUNTIL 'A' <= com <= 'Z'
	Selectoutput( newlexstr )
	SWITCHON Capitalch( com ) INTO
	$(
	    CASE 'Q':
$<PDPRSX
			Deleteoutput()
$>PDPRSX
			FINISH

	    CASE 'Y':	Writemylexword( word1 )

	    CASE 'N':	ENDCASE

	    CASE 'S':	WHILE RDCH()=' ' DO LOOP
			Unrdch()
			Readstring( word2, '*S' )
			Selectinput( mylexstr )
			UNTIL comparestring( word1, word2 ) = 0 DO
			$(
			    Writemylexword( word1 )
			    Readmylexword( word1 )
			    IF word1%0 = 0 THEN
			    $(
				Selectoutput( SYSOUT )
				WRITES("*NEnd of file reached*N")
				BREAK
			    $)
			$)
			Writemylexword( word1 )
			ENDCASE
	$)
    $) REPEAT

$<CAP1
    s := GETSLOT()				// just in case
    SELECTINPUT( mylexstr )			// Close off files
    ENDREAD()
    SELECTOUTPUT( newlexstr )
    ENDWRITE()
    IF using.anon.file THEN			// Rename if using anon
    $(
	LET rc = ?
	MOVECAP( K.N0 , s )
	rc := PRESERVE( s , slot , DEFAULT.SEG.AM )
	IF rc < 0 THEN
	$(
	    SELECTOUTPUT( MSTREAM )
	    WRITEF("*NCannot update lexicon - %S*N",FAULT(rc))
	$)
    $)
    FREESLOT( s )
    FREESLOT( slot )
$>CAP1
$)
