$<PDPRSX
NEEDS "IOERROR"
GET "LIBHDR"
GET "SPEHDR"
$>PDPRSX

$<CAP1
GET "LIBHDR"
GET ".progs.spehdr"
$>CAP1

STATIC
$(
	word.count = 0
$)

/* Amalgamates LEXICON with a new file to create a new LEXICON */

LET start() BE
$(
    LET new = ?
    LET lex = ?

    LET word1 = VEC wordsperword + 3
    LET word2 = VEC wordsperword + 3
    LET word3 = VEC wordsperword
    LET word4 = VEC wordsperword

$<PDPRSX
	LET cm = FINDCML("LMG")
	LET file = VEC 50

	Selectinput(cm)
	Readstring(file, '*E')
	IF terminator < 0 THEN FINISH
	new := Findinfile(file)
	lex := Findinfile("LEXICON")
	newlexstr := Findoutfile("LEXICON")
$>PDPRSX

$<CAP1
	LET using.anon.file = ?
	LET filename = GETSLOT()		// Slot for o/p filename if needed

	lex := findinfile("1")			// 1st input file
	MOVECAP( K.N0 , filename )		// Saved just in case
	new := findinfile("2")			// 2nd input file
	newlexstr := findoutfile("3|TO|/A")	// output file, anon if back to 1st
	using.anon.file := EQSTRING( K.N0 , "/A" )

	UNLESS EXTRAITEMS() DO			// Warn about rubbish on command line
	$(
	    LET o = OUTPUT()
	    LET s = GETSLOT()
	    MOVECAP( K.N0 , s )
	    SELECTOUTPUT(MSTREAM)
	    WRITEF("*N******Warning - unrecognized items on command line - %S*N",s)
	    FREESLOT( s )
	    UNLESS o = 0 DO SELECTOUTPUT( o )
	$)

$>CAP1

    linelength := maxlinelength
    word1 := word1 + 3
    word2 := word2 + 3
    word1!-1, word1!-2 := FALSE, word3
    word2!-1, word2!-2 := FALSE, word4


	Selectoutput(newlexstr)

	word1!-3, word2!-3 := 0, 0

	read.word( new, word1 )
	read.word( lex, word2 )

	$(
		LET cmp = ?
		SWITCHON (word1!-3)*2 + word2!-3 INTO
		$(
		  CASE 0:			// have one of each
			cmp := comparestring( word2, word1 )
			IF cmp <= 0
				THEN new.word( lex, word2 )
			TEST cmp > 0
				THEN new.word( new, word1 )
				ELSE IF cmp=0
					THEN read.word( new, word1 )
			ENDCASE
		  CASE 1:			// no lex word
			new.word( new, word1 )
			ENDCASE
		  CASE 2:			// no new word
			new.word( lex, word2 )
			ENDCASE
		  CASE 3:			// neither
			BREAK
		$)
	$) REPEAT

$<PDPRSX
	Selectinput( lex )
	TEST Endwrite() >=0 THEN Deleteinput() ELSE Endread()
	Selectoutput(Sysout)
$>PDPRSX

$<CAP1
	SELECTINPUT( lex  )			// Close off inputs
	ENDREAD()
	SELECTINPUT( new )
	ENDREAD()
	TEST using.anon.file
	THEN					// Rename anon file to 1st input file
	$(
	    LET rc = ?
	    LET slot = GETSLOT()
	    ENDWRITE()
	    MOVECAP( K.N0 , slot )
	    rc := PRESERVE( slot , filename , DEFAULT.SEG.AM )
	    IF rc < 0 THEN
	    $(
		LET pres.err = FAULT(ERRORCODE)
		SELECTOUTPUT(MSTREAM)
		WRITEF("*NCannot update lexicon - %S - %S*N", filename, pres.err)
	    $)
	    FREESLOT(slot)
	$)
	ELSE ENDWRITE()
	FREESLOT( filename )
	SELECTOUTPUT(MSTREAM)
$>CAP1

	WRITEF("%N words in the new lexicon*N",word.count)
$)

AND read.word( stream, v ) BE
$(
	mylexstr := stream
	readmylexword( v )
	IF Terminator<0 THEN v!-3 := 1
$)

AND new.word( stream, v ) BE
$(
	writemylexword( v )
	read.word( stream, v )
	word.count +:= 1
$)

AND findfile( file, op) = VALOF
$(
    LET s = op( file )

$<PDPRSX
    IF s<0 THEN
    $(
	Selectoutput( Sysout )
	Writef("Can't open %S file",op = FINDOUTPUT -> "output", "input")
	Writef(IOerror(s),s,file)
	Newline()
	FINISH
    $)
$>PDPRSX

$<CAP1
    IF s=0 THEN
    $(						// Deal with error in findI/O
	LET find.error = FAULT(ERRORCODE)
	SELECTOUTPUT(MSTREAM)
	WRITEF("*N******FATAL ERROR - failed to open %S for %S - %S*N",
		file, op = FINDOUTPUT -> "output", "input", find.error)
	FINISH
    $)
$>CAP1

    RESULTIS s
$)

AND findoutfile( file ) = findfile( file, FINDOUTPUT)

AND findinfile( file ) = findfile( file, FINDINPUT )
