
// File BCPL1_TRNSRC

// BCPL compiler - phase 1 - translation routines

// Copyright (C) R.D. Eager  University of Kent   MCMLXXXIV


GET "BCPL1_TRNHDR"

LET nextparam() = VALOF
$( paramnumber := paramnumber + 1
   RESULTIS paramnumber
$)

AND transreport(n, x) BE
   report(trnmessage(n), 0, compiling_line, trninfo, x)

AND trninfo(x) BE
$( plist(x, 0, 4)
   newline()
   newline()
$)

AND trnmessage(n) = VALOF SWITCHON n INTO
   $( DEFAULT:  selectoutput(journal)
                writef("*N** Compiler error %N; ", n)
                writes("please notify software staff*N")
                writef("Error is near line %N*N", compiling_line)
                plist(currentbranch, 0, treeprintmax)
                newline()
                stop(1002)

      CASE 01: RESULTIS "Too many CASEs (use K flag to allow more)"
      CASE 02: RESULTIS "Use of BREAK or LOOP outwith a loop"
      CASE 03: RESULTIS "Use of RESULTIS outwith a VALOF block"
      CASE 04: RESULTIS "Use of CASE, ENDCASE or DEFAULT outwith a SWITCHON"
      CASE 05: RESULTIS "Two CASEs with same constant"
      CASE 06: RESULTIS "Too many GLOBALs (use G flag to allow more)"
      CASE 07: RESULTIS "Name declared twice"
      CASE 08: RESULTIS "Too many names declared (use D flag to allow more)"
      CASE 09: RESULTIS "Use of undeclared name"
      CASE 10: RESULTIS "Dynamic non-local variable used"
      CASE 11: RESULTIS "Error in constant expression"
      CASE 12: RESULTIS "LHS and RHS do not match"
      CASE 13: RESULTIS "L-type expression expected"
      CASE 14: RESULTIS "CODE command not followed by string"
      CASE 15: RESULTIS "Vector declared with negative length"
      CASE 16: RESULTIS "EXTERNAL name used in incorrect context"
      CASE 17: RESULTIS "Invalid number in selector component"
      CASE 18: RESULTIS "Selector expected"
      CASE 19: RESULTIS "Misuse of selector"
      CASE 20: RESULTIS "Attempted division by zero in constant expression"
      CASE 21: RESULTIS "Use of CASE or DEFAULT within an inner block"
      CASE 22: RESULTIS "More than one DEFAULT label in same SWITCHON"
   $)

STATIC $( root = ?; hold_transreport = 0 $)

LET compileae(x) BE
$( root := x
   aptovec(cae, dvect + globdeclt + 2*caset + 4)   // Extra 4 to simulate real BCPL vectors
$)

AND cae(vector, size) BE
$( LET a = vector
   LET d = a + dvect + 1
   LET k = d + globdeclt + 1
   LET l = k + caset + 1

   abort_p, abort_l := level(), caeabort

   dvec, dvecs, dvece, dvecp := a, 3, 3, 3
   dvec!0, dvec!1, dvec!2 := 0, 0, 0

   IF globlist_ THEN
      globdecl, globdecls := d, 0

   casek, casel, casep, caseb := k, l, 0, -1
   endcaselabel, defaultlabel := 0, 0
   case_legal_ := FALSE

   resultlabel, breaklabel, looplabel := -1, -1, -1

   compiling_line, currentbranch := 1, root

   // Ensure that compiler is reusable after break-in

   TEST hold_transreport = 0 THEN hold_transreport := transreport
   OR transreport := hold_transreport

   ocount, paramnumber, tpending := 0, 0, 0

   UNLESS root = 0 DO
   $( LET t = h1!root
      UNLESS t = s.section \/ t = s.needs BREAK
      out1(t)
      outstring(h2!root + h2)
      root := h3!root
   $) REPEAT

   setssp(savespacesize)
   transblock(root)
   out1(s.finish)
   TEST globlist_ THEN
   $( out2(s.global, globdecls/2)

      FOR i = 0 TO globdecls - 2 BY 2 DO
      $( outn(globdecl!i)
         outl(globdecl!(i + 1))
      $)
   $)
   OR out1(s.segend)

caeabort:
   selectoutput(ocode)
   endocode()
$)

AND setssp(n) BE
$( ssp := n
   out2(s.stack, ssp)
$)

 .

GET "BCPL1_TRNHDR"

LET trans(x) BE
$( LET sw_ = FALSE

   IF x = 0 RETURN
   currentbranch := x

   SWITCHON h1!x INTO
   $( DEFAULT: transreport(60, x); BREAK

      CASE s.let:
      $( LET a, b, s, s1 = dvece, dvecs, ssp, 0
         AND h2x, h3x, h4x = h2!x, h3!x, h4!x
         AND v = vecssp
         AND ocl = case_legal_

         case_legal_ := FALSE
         compiling_line := h4x
         declnames(h2x)
         compiling_line := h4x     // So doubly declared names are reported OK
         checkdistinct(b)
         vecssp, s1 := ssp, ssp
         ssp := s
         transdef(h2x, h3x NE 0)
         UNLESS ssp = s1 DO transreport(12, x)
         UNLESS ssp = vecssp DO setssp(vecssp)
         out1(s.store)
         transblock(h3x)
         vecssp := v
         setssp(s)
         dvece, dvecs := a, b
         case_legal_ := ocl
         BREAK
      $)

      CASE s.static:
      CASE s.global:
      CASE s.manifest:
      CASE s.external:
      $( LET a, b, s = dvece, dvecs, ssp
         AND op = h1!x
         AND list = h2!x
         LET p = list + 2
         AND ocl = case_legal_

         case_legal_ := FALSE

         compiling_line := h4!x

         FOR i = 0 TO h2!list - 1 BY 2 DO
         $( LET name = p!i
            AND value = p!(i+1)

            SWITCHON op INTO
            $( CASE s.static:
               $( LET m = nextparam()

                  addname(name, s.label, m)
                  compdatalab(m, name + 2)
                  out2(s.itemn, evalconst(value))
                  ENDCASE
               $)

               CASE s.external:
                  addname(name, s.external, value)   // 'value' is either an 's.name' or an 's.string' node
                  ENDCASE

               CASE s.global:
                  addname(name, s.global, evalconst(value))
                  ENDCASE

               CASE s.manifest:
               TEST NOT smallnumber(value) & h1!value = s.slctr THEN
               $( LET size = evalselectorconst(h2!value)
                  AND shift = evalselectorconst(h3!value)
                  AND offset = evalselectorconst(h4!value)

                  UNLESS 0 LE size LE target_bitsperword &
                         0 LE shift LE target_bitsperword - 1 &
                         minselectoroffset LE offset LE maxselectoroffset DO
                     $( transreport(17, list)
                        size, shift, offset := 0, 0, 0
                     $)

                  IF size = 0 THEN size := target_bitsperword - shift
                  UNLESS (size + shift) LE target_bitsperword DO transreport(17, list)

                  h2!value, h3!value, h4!value := size, shift, offset
                  addname(name, s.slctr, value)
               $)
               OR addname(name, s.number, evalconst(value))
               ENDCASE

               DEFAULT:
                  transreport(58, currentbranch)
            $)
            dvece := dvecs   // Add new name to current environment
         $)

         checkdistinct(b)
         transblock(h3!x)
         dvece, dvecs, ssp := a, b, s
         case_legal_ := ocl
         BREAK
      $)

      CASE s.ass:
         assign(h2!x, h3!x)
         BREAK

      CASE s.rtap:
      $( LET s = ssp
         AND h2x, h3x = h2!x, h3!x

         IF h1!h2x = s.name THEN
         $( LET t = cellwithname(h2x)

            IF dvec!(t + 1) = s.external THEN
            $( setssp(ssp)
               out1(s.prcl); ssp := ssp + precallsize
               loadlist(h3x)
               out2(s.rtcall, s)
               $( LET a = dvec!(t + 2)

                  outstring(a + (h1!a = s.string -> 1, 2))
               $)
               ssp := s
               BREAK
            $)
         $)

         ssp := ssp + savespacesize
         out2(s.mark, ssp)
         loadlist(h3x)
         load(h2x)
         out2(s.rtap, s)
         ssp := s
         BREAK
      $)

      CASE s.goto:
         load(h2!x)
         out1(s.goto)
         ssp := ssp - 1
         BREAK

      CASE s.colon:
         complabx(h4!x)
         setssp(ssp)
         trans(h3!x)
         BREAK

      CASE s.unless: sw_ := TRUE
      CASE s.if:
      $( LET h2x, h3x = h2!x, h3!x

         IF isconst(h2x) & nolabels(h3x) THEN
         $( UNLESS constval = sw_ DO trans(h3x)
            BREAK
         $)

/*       $( LET m = h1!h3x
 *
 *          IF m = s.loop \/ m = s.break \/ m = s.endcase THEN
 *          $( tpending, tsense_ := h2x, sw_
 *             trans(h3x)
 *             BREAK
 *          $)
 *       $)
 */
         $( LET l = nextparam()

            jumpcond(h2x, sw_, l, ssp)
            trans(h3x)
            complab(l)
            BREAK
         $)
      $)

      CASE s.test:
      $( LET h2x, h3x, h4x = h2!x, h3!x, h4!x

         IF isconst(h2x) & nolabels(h3x) & nolabels(h4x) DO
         $( trans(constval -> h3x, h4x)
            BREAK
         $)

/*       $( LET m = h1!h3x
 *          IF m = s.loop \/ m = s.break \/ m = s.endcase THEN
 *          $( tpending, tsense_ := h2x, FALSE
 *             trans(h3x)
 *             x := h4x
 *             LOOP
 *          $)
 *       $)
 */
         $( LET l, m = nextparam(), nextparam()

            jumpcond(h2x, FALSE, l, ssp)
            trans(h3x)
            compjump(m)
            complab(l)
            trans(h4x)
            complab(m)
            BREAK
         $)
      $)

      CASE s.loop: sw_ := TRUE
      CASE s.break:
         exitjump(sw_ -> @looplabel, @breaklabel, loopbreaklabel_ssp, 2)
         BREAK

      CASE s.return:
         out1(s.rtrn)
         BREAK

      CASE s.finish:
         out1(s.finish)
         BREAK

      CASE s.resultis:
         IF resultlabel < 0 THEN transreport(3, x)
         load(h2!x)
         out3p(s.res, resultlabel_ssp, resultlabel)
         ssp := ssp - 1
         BREAK

      CASE s.code:
      $( LET b = h2!x

         UNLESS h1!b = s.string DO transreport(14, x)
         out1(s.mc)
         outstring(h2 + b)
         BREAK
      $)

      CASE s.while: sw_ := TRUE
      CASE s.until:
      $( LET l, m = nextparam(), nextparam()
         LET bl, ll = breaklabel, looplabel
         LET lbl_ssp = loopbreaklabel_ssp

         loopbreaklabel_ssp := ssp
         breaklabel, looplabel := 0, m

         compjump(m)
         complabr(l)
         trans(h3!x)
         complab(m)
         jumpcond(h2!x, sw_, l, ssp)
         complab(breaklabel)
         breaklabel, looplabel := bl, ll
         loopbreaklabel_ssp := lbl_ssp
         BREAK
      $)

      CASE s.repeatwhile: sw_ := TRUE
      CASE s.repeatuntil:
      CASE s.repeat:
      $( LET l, bl, ll = nextparam(), breaklabel, looplabel
         LET lbl_ssp = loopbreaklabel_ssp

         loopbreaklabel_ssp := ssp
         breaklabel, looplabel := 0, 0
         complabr(l)
         TEST h1!x = s.repeat THEN
         $( looplabel := l
            trans(h2!x)
            compjump(l)
         $)
         OR
         $( trans(h2!x)
            complab(looplabel)
            jumpcond(h3!x, sw_, l, ssp)
         $)
         complab(breaklabel)
         breaklabel, looplabel := bl, ll
         loopbreaklabel_ssp := lbl_ssp
         BREAK
      $)

      CASE s.case:
      $( LET l, k = nextparam(), evalconst(h2!x)

         IF casep >= caset THEN transreport(1, x)
         TEST caseb < 0 THEN transreport(4, x)
         OR UNLESS case_legal_ DO transreport(21, x)
         FOR i = caseb TO casep - 1 DO
            IF casek!i = k THEN transreport(5, x)
         IF casep < caset THEN
         $( casek!casep := k
            casel!casep := l
            casep := casep + 1
         $)
         complabx(l)
         trans(h3!x)
         BREAK
      $)

      CASE s.default:
         TEST caseb < 0 THEN transreport(4, x)
         OR UNLESS case_legal_ DO transreport(21, x)
         UNLESS defaultlabel = 0 DO transreport(22, x)
         defaultlabel := nextparam()
         complabx(defaultlabel)
         trans(h2!x)
         BREAK

      CASE s.endcase:
         exitjump(@endcaselabel, endcaselabel_ssp, 4)
         BREAK

      CASE s.switchon:
         transswitch(x)
         BREAK

      CASE s.for:
         transfor(x)
         BREAK

      CASE s.seqlist:
         FOR y = x + 2 TO x + h2!x + 1 BY 2 DO
         $( compiling_line := h1!y
            trans(h2!y)
         $)
         BREAK
   $)
$) REPEAT

AND exitjump(p, label_ssp, n) BE
$( LET l = !p
   AND save_ssp = ssp

   IF l < 0 THEN transreport(n, currentbranch)
   IF l = 0 THEN
   $( l := nextparam()
      !p := l
   $)
   TEST tpending = 0 THEN
   $( out2(s.stack, label_ssp)
      compjump(l)
   $)
   OR
   $( jumpcond(tpending, NOT tsense_, l, label_ssp)
      tpending := 0
   $)
   setssp(save_ssp)
$)

 .

GET "BCPL1_TRNHDR"

STATIC $( statdefs_ = ? $)

LET declnames(x) BE
$( UNTIL x = 0 DO
   $( SWITCHON h1!x INTO
      $( DEFAULT:
            transreport(63, currentbranch)
            BREAK

         CASE s.vecdef:CASE s.valdef:
            decldyn(h2!x)
            BREAK

         CASE s.rtdef:CASE s.fndef:
            h5!x := declstat(h2!x)
            BREAK

         CASE s.and:
            declnames(h2!x)
            compiling_line := h4!x
            x := h3!x
            LOOP
      $)
   $)
$)


AND decldyn(x) BE
$( UNTIL x = 0 DO
   $( SWITCHON h1!x INTO
      $( CASE s.name:
            addname(x, s.local, ssp)
            ssp := ssp + 1
            BREAK

         CASE s.comma:
            addname(h2!x, s.local, ssp)
            ssp := ssp + 1
            x := h3!x
            LOOP

         CASE s.commalist:
            FOR h = 2 TO h2!x + 1 DO decldyn(h!x)
            BREAK

         DEFAULT:
            transreport(62, x)
      $)
   $)
$)

AND declstat(x) = VALOF
$( LET t = cellwithname(x)
   AND l = nextparam()

   TEST dvec!(t+1) = s.global THEN
   $( LET n = dvec!(t+2)

      addname(x, s.global, n)

      TEST globlist_ THEN
      $( TEST globdecls GE globdeclt THEN
            transreport(6, x)
         OR
         $( globdecl!globdecls := n
            globdecl!(globdecls+1) := l
            globdecls := globdecls + 2
         $)
      $)
      OR out3p(s.setgl, n, l)
   $)
   OR
   $( LET m = nextparam()

      addname(x, s.label, m)
      compdatalab(m, "")
      out2p(s.iteml, l)
   $)
   RESULTIS l
$)

AND transblock(x) BE
$( LET b = dvecs

   scanlabels(x)
   checkdistinct(b)
   trans(x)
$)

AND checkdistinct(e) BE
$( UNTIL e = dvecs DO
   $( LET p = e + 3
      AND n = dvec!e

      WHILE p < dvecs DO
      $( IF dvec!p = n THEN transreport(7, n)
         p := p + 3
      $)
      e := e + 3
   $)
   dvece := dvecs
$)

AND addname(n, p, a) BE
$( TEST dvecs GE dvect THEN
   $( reportcount := reportmax
      transreport(8, currentbranch)
   $)
   OR
   $( dvec!dvecs, dvec!(dvecs+1), dvec!(dvecs+2) := n, p, a
      dvecs := dvecs + 3
   $)
$)

AND cellwithname(n) = VALOF
$( LET x = dvec + dvece
   AND y = dvec

   x := x - 3 REPEATUNTIL !x = n \/ x = y

   RESULTIS x - y
$)

AND scanlabels(x) BE
$( UNTIL x = 0 DO
   $( LET h2x = h2!x

      SWITCHON h1!x INTO
      $( CASE s.colon:
            h4!x := declstat(h2x)

         CASE s.if:CASE s.unless:CASE s.while:CASE s.until:
         CASE s.switchon:CASE s.case:
            ENDCASE

         CASE s.test:
            scanlabels(h4!x)
            ENDCASE

         CASE s.repeat:
         CASE s.repeatwhile:CASE s.repeatuntil:CASE s.default:
            x := h2x
            LOOP

         CASE s.seqlist:
            FOR h = 3 TO h2!x + 2 BY 2 DO scanlabels(h!x)

         DEFAULT:
            BREAK
      $)
      x := h3!x
   $)
$)

AND transdef(x, d_) BE
$( statdefs_ := FALSE
   transdyndefs(x)
   IF statdefs_ THEN
   $( LET l, s = nextparam(), ssp
      IF d_ THEN compjump(l)
      transstatdefs(x)
      setssp(s)
      IF d_ THEN complab(l)
   $)
$)

AND transdyndefs(x) BE
$( SWITCHON h1!x INTO
   $( CASE s.and:
         transdyndefs(h2!x)
         compiling_line := h4!x
         x := h3!x
         LOOP

      CASE s.vecdef:
      $( LET n = evalconst(h3!x)

         IF n < 0 THEN transreport(15, x)
         out2(s.llp,vecssp+(backstack_ -> n, 0))   // Stack may run backwards
         ssp := ssp + 1
         vecssp := vecssp + 1 + n
         BREAK
      $)

      CASE s.rtdef:CASE s.fndef:
         statdefs_ := TRUE
         BREAK

      CASE s.valdef:
         loadlist(h3!x)   // Drop through

      DEFAULT:
         BREAK
   $)
$) REPEAT

AND transstatdefs(x) BE
$( WHILE h1!x = s.and DO
   $( transstatdefs(h2!x)
      compiling_line := h4!x
      x := h3!x
   $)

   IF h1!x = s.fndef \/ h1!x = s.rtdef THEN
   $( LET a, b, c = dvece, dvecs, dvecp
      AND bl, ll = breaklabel, looplabel
      AND rl, cb = resultlabel, caseb
      AND h4x = h4!x

      breaklabel, looplabel := -1, -1
      resultlabel, caseb := -1, -1

      compentry(h2!x, h5!x)
      ssp := savespacesize

      dvecp := dvecs
      decldyn(h3!x)
      checkdistinct(b)

      out2(s.save, ssp)

      TEST h1!x = s.fndef THEN
      $( load(h4x)
         out1(s.fnrn)
      $)
      OR
      $( transblock(h4x)
         out1(s.rtrn)
      $)

      out2(s.endproc, 0)   // Zero parameter for now

      breaklabel, looplabel := bl, ll
      resultlabel, caseb := rl, cb
      dvece, dvecs, dvecp := a, b, c
   $)
$)

 .

GET "BCPL1_TRNHDR"

LET jumpcond(x, b_, l, new_ssp) BE
$( LET sw_ = b_

   UNLESS smallnumber(x) DO SWITCHON h1!x INTO
   $( CASE s.false: b_ := NOT b_
      CASE s.true:
         IF b_ THEN $( /* setssp(new_ssp); */ compjump(l) $)
         RETURN

      CASE s.not:
         jumpcond(h2!x, NOT b_, l, new_ssp)
         RETURN

      CASE s.logand: sw_ := NOT sw_
      CASE s.logor:
         TEST sw_ THEN
         $( jumpcond(h2!x, b_, l, new_ssp)
            jumpcond(h3!x, b_, l, new_ssp)
         $)
         OR
         $( LET m = nextparam()

            jumpcond(h2!x, NOT b_, m, new_ssp)
            jumpcond(h3!x, b_, l, new_ssp)
            complab(m)
         $)
         RETURN
   $)

   load(x)
   out2p(b_ -> s.jt, s.jf, l)
   setssp(ssp-1)   /* added */

/* $( LET s = ssp - 1
 *
 *    setssp(new_ssp+1)
 *    out2p(b_ -> s.jt, s.jf, l)
 *    setssp(s)
 * $)
 */
$)

AND transswitch(x) BE
$( LET p, b, dl = casep, caseb, defaultlabel
   AND ecl = endcaselabel
   AND ecl_ssp = endcaselabel_ssp
   AND l = nextparam()
   AND ocl = case_legal_

   case_legal_ := TRUE
   endcaselabel := nextparam()
   endcaselabel_ssp := ssp
   caseb := casep

   compjump(l)
   defaultlabel := 0
   trans(h3!x)
   compjump(endcaselabel)

   complab(l)
   case_legal_ := ocl
   load(h2!x)
   IF defaultlabel = 0 THEN defaultlabel := endcaselabel
   out3p(s.switchon, casep-p, defaultlabel)

   FOR i = caseb TO casep - 1 DO
   $( outn(casek!i)
      outl(casel!i)
   $)

   ssp := ssp - 1
   complab(endcaselabel)
   endcaselabel := ecl
   endcaselabel_ssp := ecl_ssp
   casep, caseb, defaultlabel := p, b, dl
$)

AND transfor(x) BE
$( LET a, b = dvece, dvecs
   AND l, m = nextparam(), 0
   AND bl, ll = breaklabel, looplabel
   AND lbl_ssp = 0
   AND s = ssp
   AND h3x, h4x, h5x = h3!x, h4!x, h5!x
   LET h3number_ = smallnumber(h3x) \/ h1!h3x = s.number -> TRUE, FALSE
   LET h3value = smallnumber(h3x) -> h3x, h1!h3x = s.number -> h2!h3x, 0
   LET k, n, step = s.ln, smallnumber(h4x) -> h4x, h2!h4x, h5x = 0 -> 1, evalconst(h5x)
   AND ocl = case_legal_

   case_legal_ := FALSE

   addname(h2!x, s.local, s)
   dvece := dvecs
   load(h3!x)

   UNLESS smallnumber(h4x) \/ h1!h4x = s.number DO
   $( k, n := s.lp, ssp
      load(h4x)
   $)

   out1(s.store)
   UNLESS h3number_ & k = s.ln & ((step > 0 & h3value LE n) \/ (step < 0 & h3value GE n)) DO
   $( m := nextparam()
      compjump(m)
   $)
   lbl_ssp := loopbreaklabel_ssp
   loopbreaklabel_ssp := ssp
   breaklabel, looplabel := 0, 0
   complabr(l)
   transblock(h6!x)
   complab(looplabel)
   out2(s.lp, s); out2(s.ln, step); out1(s.plus); out2(s.sp, s)
   complab(m)
   out2(s.lp, s); out2(k, n)
   TEST step < 0 THEN
   $( out1(s.ge)
      out2p(s.jt, l)
   $)
   OR out2p(s.endfor, l)

   complab(breaklabel)
   breaklabel, looplabel, ssp := bl, ll, s
   loopbreaklabel_ssp := lbl_ssp
   setssp(ssp)
   dvece, dvecs := a, b

   case_legal_ := ocl
$)

 .

GET "BCPL1_TRNHDR"

LET load(node) BE
$( LET org_node = node
   IF fold_const_ THEN fold(node, @org_node)
   loadx(org_node)
$)

AND loadx(x) BE
$( TEST x = 0 THEN
      loadzero(62)
   OR TEST smallnumber(x) THEN
   $( out2(s.ln, x)
      ssp := ssp + 1
   $)
   OR
   $( LET op = h1!x

      SWITCHON op INTO
      $( DEFAULT:
            loadzero(61)
            ENDCASE

         CASE s.slctr:
            loadzero(19)
            ENDCASE

         CASE s.div:CASE s.rem:CASE s.minus:
         CASE s.ls:CASE s.gr:CASE s.le:CASE s.ge:
         CASE s.lshift:CASE s.rshift:
            load(h2!x)
            load(h3!x)
            out1(op)
            ssp := ssp - 1
            ENDCASE

         CASE s.slctap:
            load(h3!x)
            select(h2!x, s.slctap)
            ENDCASE

         CASE s.vecap:CASE s.mult:CASE s.plus:CASE s.eq:CASE s.ne:
         CASE s.logand:CASE s.logor:CASE s.eqv:CASE s.neqv:
         $( LET a, b = h2!x, h3!x
            IF smallnumber(a) \/ h1!a = s.name \/ h1!a = s.number THEN a, b := h3!x, h2!x
            load(a)
            load(b)
            IF op = s.vecap THEN
            $( out1(s.plus)
               op := s.rv
            $)
            out1(op)
            ssp := ssp - 1
            ENDCASE
         $)

         CASE s.byteap:
            load(h2!x)
            load(h3!x)
            out1(s.getbyte)
            ssp := ssp - 1
            ENDCASE

         CASE s.neg:CASE s.not:CASE s.abs:CASE s.rv:
            load(h2!x)
            out1(op)
            ENDCASE

         CASE s.true:CASE s.false:CASE s.query:
            out1(op)
            ssp := ssp + 1
            ENDCASE

         CASE s.lv:
            loadlv(h2!x)
            ENDCASE

         CASE s.number:
            out2(s.ln, h2!x)
            ssp := ssp + 1
            ENDCASE

         CASE s.string:
            out1(s.lstr)
            outstring(h2 + x)
            ssp := ssp + 1
            ENDCASE

         CASE s.name:
            transname(x, s.lp, s.lg, s.ll, s.ln)
            ssp := ssp + 1
            ENDCASE

         CASE s.valof:
         $( LET rl = resultlabel
            AND rl_ssp = resultlabel_ssp
            AND a, b = dvecs, dvece

            resultlabel := nextparam()
            resultlabel_ssp := ssp
            transblock(h2!x)
            complab(resultlabel)
            out2(s.rstack, ssp)
            ssp := ssp + 1
            dvecs, dvece := a, b
            resultlabel := rl
            resultlabel_ssp := rl_ssp
            ENDCASE
         $)

         CASE s.fnap:
         $( LET s = ssp
            AND h2x = h2!x

            IF h1!h2x = s.name THEN
            $( LET t = cellwithname(h2x)

               IF dvec!(t + 1) = s.external THEN
               $( setssp(ssp)
                  out1(s.prcl); ssp := ssp + precallsize
                  loadlist(h3!x)
                  out2(s.fncall, s)
                  $( LET a = dvec!(t + 2)
                     outstring(a + (h1!a = s.string -> 1, 2))
                  $)
                  ssp := s + 1
                  ENDCASE
               $)
            $)

            ssp := ssp + savespacesize
            out2(s.mark, ssp)
            loadlist(h3!x)
            load(h2!x)
            out2(s.fnap, s)
            ssp := s + 1
            ENDCASE
         $)

         CASE s.cond:
            IF isconst(h2!x) THEN
            $( load((constval -> h3, h4)!x)
               ENDCASE
            $)

            $( LET l, m = nextparam(), nextparam()
               AND s = ssp

               jumpcond(h2!x, FALSE, m, ssp)
               load(h3!x)
               compjump(l)
               setssp(s)
               complab(m)
               load(h4!x)
               complab(l)
               ENDCASE
            $)

         CASE s.table:
         $( LET m = nextparam()
            AND h2x = h2!x
            AND p, n = 0, 0

            compdatalab(m, "")
            out2p(s.lll, m)
            ssp := ssp + 1
            UNLESS smallnumber(x) DO
            $( TEST h1!h2x = s.comma THEN p, n := h2x + 1, 2
               OR IF h1!h2x = s.commalist THEN p, n := h2x + 2, h2!h2x
               UNLESS p = 0 DO
               $( FOR h = 0 TO n - 1 DO out2(s.itemn, evalconst(h!p))
                  ENDCASE
               $)
            $)
            out2(s.itemn, evalconst(h2x))
            ENDCASE
         $)
      $)
   $)
$)

AND loadlv(x) BE
$( LET org_x = x

   IF fold_const_ THEN fold(x, @org_x)
   loadlvx(org_x)
$)

AND loadlvx(x) BE
$( IF x = 0 \/ smallnumber(x) GOTO err

   SWITCHON h1!x INTO
   $( DEFAULT:
      err:
         loadzero(13)
         ENDCASE

      CASE s.name:
         transname(x, s.llp, s.llg, s.lll, 0)
         ssp := ssp + 1
         ENDCASE

      CASE s.rv:
         load(h2!x)
         ENDCASE

      CASE s.vecap:
      $( LET a, b = h2!x, h3!x

         IF smallnumber(a) \/ h1!a = s.name \/ h1!a = s.number DO a, b := h3!x, h2!x
         load(a)
         load(b)
         out1(s.plus)
         ssp := ssp - 1
      $)
   $)
$)

AND loadzero(n) BE
$( transreport(n, currentbranch)
   out2(s.ln, 0)
   ssp := ssp + 1
$)

AND loadlist(x) BE UNLESS x = 0 DO
$( UNLESS smallnumber(x) DO
   $( LET p, n = 0, ?

      TEST h1!x = s.comma THEN p, n := x + 1, 2
      OR IF h1!x = s.commalist THEN p, n := x + h3, h2!x

      UNLESS p = 0 DO
      $( FOR h = 0 TO n - 1 DO load(h!p)
         RETURN
      $)
   $)
   load(x)
$)

 .

GET "BCPL1_TRNHDR"

LET evalconst(x) = VALOF
$( LET op = ?
   AND rand1, rand2, rand3 = ?, ?, ?

   IF x = 0 THEN
   $( transreport(11, currentbranch)
      RESULTIS 0
   $)

   IF smallnumber(x) RESULTIS x

   op := h1!x

   SWITCHON op INTO
   $( DEFAULT:         transreport(11, x)
                       RESULTIS 0

      CASE s.name:     $( LET t = cellwithname(x)

                          IF dvec!(t + 1) = s.number RESULTIS dvec!(t + 2)
                          transreport(11, x)
                          RESULTIS 0
                       $)

      CASE s.number:   RESULTIS h2!x
      CASE s.true:     RESULTIS TRUE
      CASE s.false:    RESULTIS FALSE
      CASE s.query:    RESULTIS 0

      CASE s.cond:     rand3 := evalconst(h4!x)

      CASE s.mult:
      CASE s.div:
      CASE s.rem:
      CASE s.plus:
      CASE s.minus:
      CASE s.logand:
      CASE s.logor:
      CASE s.eqv:
      CASE s.neqv:
      CASE s.lshift:
      CASE s.rshift:

      CASE s.ls:
      CASE s.le:
      CASE s.gr:
      CASE s.ge:
      CASE s.eq:
      CASE s.ne:       rand2 := evalconst(h3!x)

      CASE s.neg:
      CASE s.not:
      CASE s.abs:      rand1 := evalconst(h2!x)
   $)

   SWITCHON op INTO
   $( CASE s.neg:      RESULTIS - rand1
      CASE s.not:      RESULTIS NOT rand1
      CASE s.abs:      RESULTIS ABS rand1

      CASE s.mult:     RESULTIS rand1 * rand2

      CASE s.div:
      CASE s.rem:      IF rand2 = 0 THEN
                       $( transreport(20, x)
                          RESULTIS FALSE
                       $)
                       TEST op = s.div THEN
                          RESULTIS rand1 / rand2
                       OR
                          RESULTIS rand1 REM rand2
      CASE s.plus:     RESULTIS rand1 + rand2
      CASE s.minus:    RESULTIS rand1 - rand2
      CASE s.logand:   RESULTIS rand1 & rand2
      CASE s.logor:    RESULTIS rand1 \/ rand2
      CASE s.eqv:      RESULTIS rand1 EQV rand2
      CASE s.neqv:     RESULTIS rand1 NEQV rand2
      CASE s.lshift:   RESULTIS rand1 << rand2
      CASE s.rshift:   RESULTIS rand1 >> rand2

      CASE s.ls:       RESULTIS rand1 LS rand2
      CASE s.le:       RESULTIS rand1 LE rand2
      CASE s.gr:       RESULTIS rand1 GR rand2
      CASE s.ge:       RESULTIS rand1 GE rand2
      CASE s.eq:       RESULTIS rand1 EQ rand2
      CASE s.ne:       RESULTIS rand1 NE rand2

      CASE s.cond:     RESULTIS rand1 -> rand2, rand3
   $)
$)


AND assign(x, y) BE
$( TEST x = 0 \/ smallnumber(x) \/ y = 0 THEN
      transreport(12, currentbranch)
   OR
   $( SWITCHON h1!x INTO
      $( CASE s.comma:
         CASE s.commalist:
            IF smallnumber(y) \/ h1!x NE h1!y THEN
            $( transreport(12, currentbranch)
               ENDCASE
            $)
            $( LET l, n = h2, 2

               IF h1!x = s.commalist THEN
               $( l, n := h3, h2!x
                  UNLESS h2!y = n DO
                  $( transreport(12, currentbranch)
                     ENDCASE
                  $)
               $)
               FOR h = l TO l + n - 1 DO assign(h!x, h!y)
            $)
            ENDCASE

         CASE s.name:
         CASE s.rv:CASE s.vecap:CASE s.cond:
         CASE s.byteap:
         CASE s.slctap:
            IF NOT smallnumber(y) & h1!y = s.comma THEN
            $( transreport(12, currentbranch)
               ENDCASE
            $)
            load(y)
            SWITCHON h1!x INTO
            $( CASE s.name:
                  transname(x, s.sp, s.sg, s.sl, 0)
                  ssp := ssp - 1
                  ENDCASE

               CASE s.rv:CASE s.vecap:CASE s.cond:
                  loadlv(x)
                  out1(s.stind)
                  ssp := ssp - 2
                  ENDCASE

               CASE s.byteap:
                  load(h2!x)
                  load(h3!x)
                  out1(s.putbyte)
                  ssp := ssp - 3
                  ENDCASE

               CASE s.slctap:
                  load(h3!x)
                  select(h2!x, s.slctst)
                  ssp := ssp - 2
                  ENDCASE
            $)
            ENDCASE

         DEFAULT:
            transreport(13, currentbranch)
      $)
   $)
$)

AND transname(x, p, g, l, n) BE
$( LET t = cellwithname(x)
   LET k, a = dvec!(t + 1), dvec!(t + 2)

   TEST t = 0 THEN
   $( transreport(9, x)
      out2(g, 0)
      addname(x, s.global, 0)
   $)
   OR
   $( SWITCHON k INTO
      $( CASE s.local:
            IF t < dvecp THEN transreport(10, x)
            out2(p, a)
            ENDCASE

         CASE s.global:
            out2(g, a)
            ENDCASE

         CASE s.label:
            out2p(l, a)
            ENDCASE

         CASE s.slctr:
            transreport(19, x)
            ENDCASE

         CASE s.external:
            transreport(16, x)
            ENDCASE

         CASE s.number:
            IF n = 0 THEN
            $( transreport(13, x)
               n := p
            $)
            out2(n, a)
      $)
   $)
$)

AND nolabels(x) = VALOF
$( IF x = 0 RESULTIS TRUE
   SWITCHON h1!x INTO
   $( DEFAULT:
         RESULTIS TRUE

      CASE s.colon:
      CASE s.case:
      CASE s.default:
         RESULTIS FALSE

      CASE s.if:
      CASE s.unless:
      CASE s.while:
      CASE s.until:
      CASE s.switchon:
         x := h3!x
         LOOP

      CASE s.repeat:
      CASE s.repeatwhile:
      CASE s.repeatuntil:
         x := h2!x
         LOOP

      CASE s.test:
         RESULTIS nolabels(h3!x) & nolabels(h4!x)
   $)
$) REPEAT

AND isconst(x) = VALOF
$( STATIC $( nc.p = ?; nc.l = ? $)
   LET tr() BE longjump(nc.p, nc.l)
   LET rtr = transreport

   transreport := tr
   nc.p, nc.l := level(), errinconst
   constval := evalconst(x)
   transreport := rtr
   RESULTIS TRUE

errinconst:
   transreport := rtr
   RESULTIS FALSE
$)

 .

/* Segment to 'fold' constants at compile time.  M.A.Smith University of
Kent at Canterbury 1976 */

GET "BCPL1_TRNHDR"

LET seek_item(node, op, litorg) = VALOF
/*  Seeks  a  branch  with a literal on it in op chain.  Returns TRUE if
finds literal - address of pointer in 'litorg'.  */
$( UNLESS NOT smallnumber(node) & h1!node = op RESULTIS FALSE
   type_manifest(@h2!node); type_manifest(@h3!node)

   $( LET l_node, r_node = h2!node, h3!node

      UNLESS (smallnumber(l_node) \/ h1!l_node = s.number) &
             (smallnumber(r_node) \/ h1!r_node = s.number) DO
      $( IF smallnumber(l_node) \/ h1!l_node = s.number THEN
         $( !litorg := @h2!node
            RESULTIS TRUE
         $)
         IF smallnumber(r_node) \/ h1!r_node = s.number THEN
         $( !litorg := @h3!node
            RESULTIS TRUE
         $)
      $)
      RESULTIS seek_item(l_node, op, litorg) -> TRUE, seek_item(r_node, op, litorg)
   $)
$)

AND recast_subtree(node, org_node) BE
/* Try and bring literals together under same node; tree is "recast" (no
ambiguity is introduced).
   i.e     A+1+B+2       becomes       A+B+1+2
*/
$( LET l_node, r_node = h2!node, h3!node
   AND litorg, litnode = ?, ?

   type_manifest(@h2!node); type_manifest(@h3!node)
   // UNLESS (smallnumber(l_node) \/ h1!l_node = s.number) &
   //        (smallnumber(r_node) \/ h1!r_node = s.number) RETURN

   TEST smallnumber(l_node) \/ h1!l_node = s.number THEN
   $( UNLESS seek_item(r_node, h1!node, @litorg) RETURN
      !org_node := r_node            // Unchain op node
      litnode := !litorg
      !litorg := node                // Chain in op node
      h3!node := litnode
   $)
   OR IF smallnumber(r_node) \/ h1!r_node = s.number THEN
   $( UNLESS seek_item(l_node, h1!node, @litorg) RETURN
      !org_node := l_node            // Unchain op node
      litnode := !litorg
      !litorg := node                // Chain in op node
      h2!node := litnode
   $)
$)

AND type_manifest(a_node) BE UNLESS smallnumber(!a_node) DO
/* If type MANIFEST, then changes to 's.number' with value  of  MANIFEST
constant.  */
$( IF h1!(!a_node) = s.name THEN
   $( LET t = cellwithname(!a_node)

      IF dvec!(t + 1) = s.number THEN   // Create new node, as same name may be used elsewhere
      $( LET value = dvec!(t + 2)

         !a_node := value = 0 -> zeronode,
                    smallnumber(value) -> value,
                    list2(s.number, value)
      $)
   $)
$)

AND literal_val(node, res) = VALOF
/*  Return  in  'res'  the  value  of  'node',  and  return result TRUE.
Otherwise returns result FALSE.  */
$( TEST smallnumber(node) THEN
      !res := node
   OR
      SWITCHON h1!node INTO
      $( DEFAULT         :                     RESULTIS FALSE
         CASE s.number   : !res := h2!node ;   ENDCASE
         CASE s.true     : !res := TRUE    ;   ENDCASE
         CASE s.false    : !res := FALSE   ;   ENDCASE
      $)
      RESULTIS TRUE
$)

AND fold(node, org_node) BE
/* Folds operations between literals in the syntax tree.
   Operations folded:     +  -  *  /  REM  <<  >>  &  \/ ABS
*/
$( LET size, tryfoldmonadic_, tryfolddiadic_ = ?, FALSE, FALSE
   LET left, right, no_left, no_right = ?, ?, ?, ?

   IF node = 0 \/ smallnumber(node) RETURN

   SWITCHON h1!node INTO
   $( CASE s.mult:CASE s.div:CASE s.rem:CASE s.plus:CASE s.minus:
      CASE s.lshift:CASE s.rshift:CASE s.logand:CASE s.logor:
         tryfolddiadic_ := TRUE

      CASE s.vecap:
      CASE s.eq:CASE s.ne:CASE s.ls:CASE s.gr:CASE s.le:CASE s.ge:
      CASE s.eqv:CASE s.neqv:
         size := 3; ENDCASE

      CASE s.neg:CASE s.not:CASE s.abs:
         tryfoldmonadic_ := TRUE

      CASE s.lv:CASE s.rv:
         size := 2; ENDCASE

      DEFAULT:
         RETURN

   $)

   SWITCHON h1!node INTO
   $( CASE s.plus: CASE s.mult: CASE s.logand: CASE s.logor:
         recast_subtree(node, org_node)
         node := !org_node   // It may have changed
         ENDCASE

      DEFAULT:
         type_manifest(@h2!node)
         IF size > 2 THEN type_manifest(@h3!node)
   $)

   FOR i = 2 TO size DO
   $( LET subtree = node + i - 1
      fold(h1!subtree, @h1!subtree)
   $)

   IF h1!node = s.vecap THEN   // Convert E!0 to !E
   $( LET l, r = h2!node, h3!node

      IF NOT smallnumber(l) & (h1!l = s.number) & (h2!l = 0) THEN
      $( h2!node, h3!node := r, l
         l, r := h2!node, h3!node
      $)

      IF NOT smallnumber(r) & (h1!r = s.number) & (h2!r = 0) THEN
         h1!node := s.rv
      RETURN
   $)

   IF tryfolddiadic_ THEN
   $( left,right := h2!node, h3!node

      IF literal_val(left, @no_left) & literal_val(right, @no_right) THEN
      $( LET res = VALOF
         $( SWITCHON h1!node INTO
            $( CASE s.plus  : RESULTIS no_left + no_right
               CASE s.minus : RESULTIS no_left - no_right
               CASE s.mult  : RESULTIS no_left * no_right
               CASE s.div   :
               CASE s.rem   : IF no_right = 0 THEN
                              $( transreport(20, node)
                                 RESULTIS 0
                              $)
                              TEST h1!node = s.div THEN RESULTIS no_left / no_right
                              OR RESULTIS no_left REM no_right
               CASE s.lshift: RESULTIS no_left << no_right
               CASE s.rshift: RESULTIS no_left >> no_right
               CASE s.logand: RESULTIS no_left & no_right
               CASE s.logor : RESULTIS no_left | no_right
            $)
         $)
         h1!node, h2!node :=  s.number, res
      $)
   $)

   IF tryfoldmonadic_ THEN
   $( left := h2!node
      IF literal_val(left, @no_left) THEN
      $( LET res = VALOF
         SWITCHON h1!node INTO
         $( CASE s.neg: RESULTIS   - no_left
            CASE s.not: RESULTIS NOT no_left
            CASE s.abs: RESULTIS ABS no_left
         $)
         h1!node, h2!node := s.number, res
      $)
   $)
$)

 .

GET "BCPL1_TRNHDR"

LET complab(l) BE UNLESS l = 0 DO out2p(s.lab, l)

AND complabr(l) BE UNLESS l = 0 DO out2p(s.labr, l)

AND complabx(l) BE UNLESS l = 0 DO out2p(s.labx, l)

AND compentry(n, l) BE
$( LET s = @n!2

   out3p(s.entry, s%0, l)
   FOR i = 1 TO s%0 DO out1(charcode(s%i))
   wrc('*S')
$)

AND compdatalab(l, name) BE
$( out2p(s.datalab, l)
   outstring(name)
$)

AND compjump(l) BE out2p(s.jump, l)

AND out1(x) BE
$( wrpn(x); wrc('*S')
$)

AND out2(x, y) BE
$( wrpn(x); wrc('*S')
   wrn(y); wrc('*S')
$)

AND out2p(x, y) BE
$( wrpn(x); outl(y)
$)

AND out3p(x, y, z) BE
$( wrpn(x); wrc('*S')
   wrn(y); outl(z)
$)

AND out4(op, x, y, z) BE
$( wrpn(op); wrc('*S')
   wrn(x); wrc('*S')
   wrn(y); wrc('*S')
   wrn(z); wrc('*S')
$)

AND outn(n) BE wrn(n)

AND outl(x) BE
$( wrc('*S')
   wrc('L'); wrpn(x); wrc('*S')
$)

AND outstring(s) BE
$( LET n = s%0
   out1(n)
   FOR i = 1 TO n DO out1(s%i)
$)

AND wrn(n) BE
$( IF n < 0 THEN
   $( wrc('-')
      n := -n
      IF n < 0 THEN   // Overflow
      $( LET ndiv10 = (n>>1)/5

         wrpn(ndiv10)
         n := n - ndiv10*10
      $)
   $)
   wrpn(n)
$)

AND wrpn(n) BE
$( IF n > 9 THEN wrpn(n/10)
   wrc(n REM 10 + '0')
$)

AND endocode() BE
$( wrch('*N')
   ocount := 0
$)

AND wrc(ch) BE
$( ocount := ocount + 1
   IF ocount > 72 & ch = '*S' THEN
   $( wrch('*N')
      ocount := 0
      RETURN
   $)
   wrch(ch)
$)

AND select(x, type) BE
$( SWITCHON h1!x INTO
   $( CASE s.slctr:
      $( LET size = evalselectorconst(h2!x)
         AND shift = evalselectorconst(h3!x)
         AND offset = evalselectorconst(h4!x)

         UNLESS 0 LE size LE target_bitsperword &
                0 LE shift LE target_bitsperword - 1 &
                minselectoroffset LE offset LE maxselectoroffset DO
                $( transreport(17, x)
                   size, shift, offset := 0, 0, 0
                $)

         IF size = 0 THEN size := target_bitsperword - shift
         UNLESS (size + shift) LE target_bitsperword DO
            transreport(17, x)

         selout(type, size, shift, offset)
         ENDCASE
      $)

      CASE s.name:
      $( LET t = cellwithname(x)
         LET a = dvec!(t + 2)

         UNLESS dvec!(t + 1) = s.slctr DO
         $( transreport(18, x)
            RETURN
         $)

         selout(type, h2!a, h3!a, h4!a)
         ENDCASE
      $)

      DEFAULT:
         transreport(59, x)
   $)
$)

AND selout(type, size, shift, offset) BE
$( TEST size = target_bitsperword & shift = 0 THEN   // Simple indexing
   $( UNLESS offset = 0 DO
      $( out2(s.ln, offset)
         out1(s.plus)
      $)
      out1(type = s.slctap -> s.rv, s.stind)
   $)
   OR
      out4(type, size, shift, offset)
$)

AND evalselectorconst(x) = (x = 0 -> 0, evalconst(x))

// End of file BCPL1_TRNSRC

