
// File BCPL2_BCPL2HDR

// Header file for BCPL code generator for ICL 2900 under EMAS

// Copyright (C) R.D. Eager   University of Kent   MCMLXXXV


GET "LIBHDR"

MANIFEST $( debugging_ = FALSE $)   // Set to TRUE during development and testing

// Variables

GLOBAL $(
globsize                     : 100   // Number of globals in program
worksize                     : 101   // Size of work area (kb)
tracing_                     : 102   // Controls whether tracing code is to be generated
profiling_                   : 103   // Controls whether profiling code is to be generated
mainprog                     : 104   // Controls whether entry point is a 'main program'
codelist_                    : 105   // Controls listing of code produced
ocode                        : 106   // Name of user program OCODE file
locode                       : 107   // Name of BCPL library OCODE file
dynamic                      : 108   // Controls dynamic loading of external references
debug                        : 109   // Controls inclusion of interactive debugging code
use_stack_                   : 110   // Controls use of on-stack workspace in compiled program
parmx                        : 111   // Controls whether strings go into GLA or SST
supportname                  : 112   // Name of main external support procedure (BCPL string)
preludename                  : 113   // Name of external 'prelude' procedure (BCPL string)
ontrapname                   : 114   // Name of external contingency handling routine (BCPL string)
comments                     : 115   // Number of comments to user
hwwork                       : 116   // High water mark for usage of work area
errorstream                  : 117   // True iff a separate output stream for errors has been specified
checking_                    : 118   // Controls checking for unassigned variables
compiler_                    : 119   // TRUE iff called from phase 1

codemax                      : 120   // Points to last word usable for code or IILs
labmap                       : 121   // Base of static label bitmap
globmap                      : 122   // Base of global initialisation bitmap
labl                         : 123   // Base of vector of 'static' label code addresses
labk                         : 124   // Base of vector of 'static' label code offsets
labv                         : 125   // Base of vector of label addresses
codev                        : 126   // Base of code image for current BCPL segment
iilv                         : 127   // Base of vector of IILs

size1                        : 130   // Code size             \
size2                        : 131   // GLA size               |
size3                        : 132   // PLT size               |
size4                        : 133   // SST size               |   Used for LPUT
size5                        : 134   // UST size               |    - MUST be kept together
size6                        : 135   // INITCMN size           |
size7                        : 136   // INITSTK size           |
totalsize                    : 137   // Total of SIZE1-SIZE7  /

incode_                      : 140   // TRUE iff current point in code can be reached at runtime
ssp                          : 141   // Simulated stack pointer
ssf                          : 142   // Real value of stack front in simulation
tempv                        : 143   // Base of simulated portion of stack
pendingop                    : 144   // Pending OCODE operation
op                           : 145   // Current OCODE operation
arg1                         : 146   // Top item on simulated stack
arg2                         : 147   // Next-to-top item on simulated stack
mlabv                        : 148   // Base of vector of switch label addresses
switch_prefix                : 149   // Unique letter used in each set of switch labels
acc_v                        : 150   // \
acc_a                        : 151   //  | Slave locations for ACC
acc_k                        : 152   // /
b_v                          : 153   // \
b_a                          : 154   //  | Slave locations for B
b_k                          : 155   // /
dr_a                         : 156   // Flag giving current contents of DR
static_chain                 : 157   // Current end of STATIC name chain
iilva                        : 158   // Base of vector of IIL chain pointers
datap                        : 159   // Points to next free word in GLA (word offset from base of GLA)
iilp                         : 160   // Number of IILs allocated
globaln                      : 161   // Number of GLOBALs to be initialised in current segment
labkp                        : 162   // Points to next free entry in LABK
codelength                   : 163   // Length of code area for current BCPL segment, in bytes
sdatap                       : 164   // Points to next free word in SST (word offset)
databuf                      : 165   // Address of LPUT buffer for GLA items
sdatabuf                     : 166   // Address of LPUT buffer for SST items
datacount                    : 167   // Current number of items in LPUT buffer for GLA
sdatacount                   : 168   // Current number of items in LPUT buffer for SST
real_rdch                    : 169   // Copy of entry point to library RDCH function
ocode_conad                  : 170   // Connect address of current OCODE file
ocode_ptr                    : 171   // Offset of next byte in current OCODE input file
code_heading_done_           : 172   // TRUE iff code listing header has been printed
$)

// Routines

GLOBAL $(
plantl                       : 180
list_iils                    : 181
clear_globmap                : 182
complab                      : 183
loadlvp                      : 184
branch                       : 185
clear_slaves                 : 186
regusedby                    : 187
cgswitch                     : 188
fixup_iils                   : 189
setlabbit                    : 190
small                        : 191
medium                       : 192
const                        : 193
clear_labmap                 : 194
movetor                      : 195
getword                      : 196
putword                      : 197
asf                          : 198
comp                         : 199
cggoto                       : 200
movetoanyr                   : 201
invop                        : 202
accop                        : 203
bop                          : 204
numberis                     : 205
slave                        : 206
unslave                      : 207
slaved                       : 208
isfree                       : 209
mbranch                      : 210
mcomplab                     : 211
loadlv                       : 212
cgen                         : 213
ioerror                      : 214
trans                        : 215
report                       : 216
comment                      : 217
other                        : 218
gencode                      : 219
readop                       : 220
readl                        : 221
initstack                    : 222
findglaentry                 : 223
cgselect                     : 224
resetdr                      : 225
cgpendingop                  : 226
loadt                        : 227
store                        : 228
cgapply                      : 229
freereg                      : 230
storein                      : 231
storei                       : 232
cgbranch                     : 233
dump_code                    : 234
lput                         : 235
e_wrch                       : 236
readnum                      : 237
sdata                        : 238
flush_data                   : 239
flush_sdata                  : 240
cgrv                         : 241
stack                        : 242
data                         : 243
cgstring                     : 244
cgcode                       : 245
cgentry                      : 246
plant_profile                : 247
set_sf                       : 248
plant                        : 249
plantcopy                    : 250
loadlvc                      : 251
writeaddress                 : 252
cgputbyte                    : 253
code_heading                 : 254
movecontor                   : 255
$)

MANIFEST $(   // Subsystem error codes
e.ift   = 267   // Invalid file type
$)

// Selectors for items on simulated stack

MANIFEST $(
h1    = 0                            // Type of item
h2    = 1                            // Offset of item
h3    = 2                            // SSP for item
$)

// Types of item on simulated stack and in register slaves

MANIFEST $(
k.ctb       = 0                      // Item in data segment
k.loc       = 1                      // Local variable
k.numb      = 2                      // Constant
k.reg       = 3                      // Item in a register
k.st        = 4                      // Item on top of stack
k.svctbword = 5                      // Item is word address in CTB plus a constant
k.lnb       = 6                      // Item is value in LNB plus a constant
k.stack     = 7                      // Item on stack - not local variable
k.none      = 8                      // Item not one of above
k.svsstword = 9                      // Item is word address of SST plus a constant
$)

// Types of register

MANIFEST $(
r.null   = -1                        // Pseudo-register
r.acc    = 0                         // ACC
r.b      = 1                         // B
$)

// Tunable MANIFESTs

MANIFEST $(
max.labels          = 600            // Maximum number of compiler-generated labels
max.staticlabels    = 200            // Maximum number of static cells containing code addresses
maxswitchlabels     = 300            // Maximum number of CASE labels in a SWITCHON
svsize              = 80             // Size of system vector
tempsize            = 3              // Size of an item in simulated stack
tempvsize           = 100            // Maximum number of items on simulated stack
tracebuffersize     = 64             // Size of trace buffer
databufsize         = 128            // Size (in words) of LPUT buffers for GLA/SST items
language.code       = 9              // Language code for BCPL
$)

// Offsets of items in GLA

MANIFEST $(
g.entry0            =  0             // Main entry descriptor (type and bound)
g.entry1            =  1             // Main entry descriptor (address)
g.ust               =  2             // Address of UST
g.sst               =  3             // Address of SST
g.compiler          =  4             // Compiler word
g.cont0             =  8             // Contingency handler entry descriptor (type and bound)
g.cont1             =  9             // Contingency handler entry descriptor (address)
g.support0          = 10             // Desc to external support procedure
g.prelude0          = 12             // Desc to external 'prelude' procedure
g.ontrap0           = 14             // Desc to external contingency handling procedure
svswsupport         = 23             // Entry to SWITCHON support code
svtbs               = 26             // Size of trace buffer
svinw               = 34             // Unbounded, scaled word descriptor
svinb               = 36             // Unbounded, scaled byte descriptor
svtrace             = 48             // Descriptor to trace buffer
svstatchain         = 51             // Head of STATIC name chain
svgs                = 52             // Word descriptor to system vector
svtrentry           = 57             // Trace entry point
svctbword           = 62             // Word address of system vector
svsstword           = 65             // Word address of SST
svwork              = svsize         // Workspace for compiled code and run-time support
$)

// Offsets of items in global vector

MANIFEST $(
gv.stop          =  4
gv.profile       =  6
gv.globalsize    =  7
gv.stackvecs     = 89
gv.abort         = 94
$)

// Codes of areas in object file

MANIFEST $(
a.code    = 1   // Code area
a.gla     = 2   // General linkage area
a.plt     = 3   // PLT area
a.sst     = 4   // Shareable symbol table area
a.ust     = 5   // Unshareable symbol table area
a.initcmn = 6   // Initialised common area
a.initstk = 7   // Initialised stack area
$)

// OCODE operations

MANIFEST $(
s.none           = -1  // Pseudo-operation
s.end            = 0
s.true           = 4
s.false          = 5
s.rv             = 8
s.fnap           = 10
s.mult           = 11
s.div            = 12
s.rem            = 13
s.plus           = 14
s.minus          = 15
s.query          = 16
s.neg            = 17
s.abs            = 19
s.eq             = 20
s.ne             = 21
s.ls             = 22
s.gr             = 23
s.le             = 24
s.ge             = 25
s.not            = 30
s.lshift         = 31
s.rshift         = 32
s.logand         = 33
s.logor          = 34
s.eqv            = 35
s.neqv           = 36
s.lp             = 40
s.lg             = 41
s.ln             = 42
s.lstr           = 43
s.ll             = 44
s.llp            = 45
s.llg            = 46
s.lll            = 47
s.needs          = 48
s.section        = 49
s.rtap           = 51
s.goto           = 52
s.finish         = 68
s.switchon       = 70
s.global         = 76
s.mc             = 77
s.sp             = 80
s.sg             = 81
s.sl             = 82
s.stind          = 83
s.slctap         = 84
s.jump           = 85
s.jt             = 86
s.jf             = 87
s.endfor         = 88
s.labx           = 89
s.lab            = 90
s.stack          = 91
s.store          = 92
s.rstack         = 93
s.entry          = 94
s.save           = 95
s.fnrn           = 96
s.rtrn           = 97
s.res            = 98
s.datalab        = 100
s.iteml          = 101
s.itemn          = 102
s.endproc        = 103
s.prcl           = 104   // 2900-specific; used to implement EXTERNALs
s.rtcall         = 105   // 2900-specific; used to implement EXTERNALs
s.fncall         = 106   // 2900-specific; used to implement EXTERNALs
s.slctst         = 107
s.labr           = 108
s.mark           = 109
s.getbyte        = 120
s.putbyte        = 121
$)

// Opcodes

MANIFEST $(
i.adb     = #x20000000
i.and     = #x8a000000
i.asf     = #x6e000000
i.call    = #x1e000000
i.cpb     = #x26000000
i.exit    = #x38000000
i.iad     = #xe0000000
i.icp     = #xe6000000
i.idv     = #xaa000000
i.imdv    = #xae000000
i.imy     = #xea000000
i.inca    = #x14000000
i.irdv    = #xac000000
i.irsb    = #xe4000000
i.isb     = #xe2000000
i.j       = #x1a000000
i.jccf    = #x03e00000   // Jump instruction that can't be 'shortened'
i.je      = #x03000000
i.jg      = #x02400000
i.jge     = #x03400000
i.jl      = #x02800000
i.jle     = #x03800000
i.jlk     = #x1c000000
i.jn      = #x04c00000
i.jnb     = #x05c00000
i.jne     = #x02e00000
i.jnn     = #x06c00000
i.jnnb    = #x07c00000
i.jnp     = #x06a00000
i.jnpb    = #x07a00000
i.jnz     = #x06800000
i.jnzb    = #x07800000
i.jp      = #x04a00000
i.jpb     = #x05a00000
i.jz      = #x04800000
i.jzb     = #x05800000
i.lab     = #x00000000   // Pseudo-op (normally illegal instruction)
i.lb      = #x7a000000
i.lct     = #x30000000
i.ld      = #x78000000
i.ldrl    = #x70000000
i.lln     = #x7c000000
i.lsd     = #x64000000
i.lsq     = #x66000000
i.lss     = #x62000000
i.lxn     = #x7e000000
i.myb     = #x2a000000
i.neq     = #x8e000000
i.or      = #x8c000000
i.prcl    = #x18000000
i.raln    = #x6c000000
i.rot     = #xca000000
i.sbb     = #x22000000
i.shs     = #xcc000000
i.sl      = #x40000000
i.slb     = #x52000000
i.slsd    = #x44000000
i.slsq    = #x46000000
i.slss    = #x42000000
i.st      = #x48000000
i.stb     = #x5a000000
i.stct    = #x36000000
i.std     = #x58000000
i.stln    = #x5c000000
i.stsf    = #x5e000000
i.stxn    = #x4c000000
i.uad     = #xc0000000
i.usb     = #xc2000000
i.ush     = #xc8000000
$)

// Opcode variants

MANIFEST $(
v.b                 = 0
v.c                 = 1
v.d                 = 2
v.dt                = 3
v.ix                = 4
v.l                 = 5
v.lab               = 6    // Pseudo-variant
v.md                = 7
v.nil               = 8    // Pseudo-variant (minimum size literal)
v.p                 = 9
v.t                 = 10
v.x                 = 11
v.dl                = 12
v.dc                = 13
v.dp                = 14
v.mlab              = 15   // Pseudo-variant
v.mic               = 16
v.ic                = 17
v.nilf              = 18   // Pseudo-variant (guaranteed 18-bit literal)
$)

// Miscellaneous constants

MANIFEST $(
bitsperbyte         = bitsperword/bytesperword
$)

// End of file BCPL2_BCPL2HDR

