 
// File BCPL2TEST2
 
// Test program for BCPL codegenerator (selectors and byte operators)
 
// Copyright R.D. Eager UKC   MCMLXXIX
 
 
GET "LIBHDR"
 
MANIFEST $(
byte0  = SLCT 8:24:0
byte1  = SLCT 8:16:0
byte2  = SLCT 8:8:0
byte3  = SLCT 8:0:0
byte4  = SLCT 8:24:1
byte5  = SLCT 8:16:1
byte6  = SLCT 8:8:1
byte7  = SLCT 8:0:1
byte8  = SLCT 8:24:2
byte9  = SLCT 8:16:2
byte10 = SLCT 8:8:2
 
s1 = SLCT 16:0:0
s2 = SLCT 16:16:0
s3 = SLCT 16:0:1
s4 = SLCT 7:9:1
s5 = SLCT 16:0:2
s6 = SLCT 3:4:2
s7 = SLCT 2:30:2
 
sm1 = SLCT 16:0:-1
sm2 = SLCT 16:16:-1
sm3 = SLCT 16:0:-2
sm4 = SLCT 16:16:-2
sm5 = SLCT 2:30:-1
sm6 = SLCT 3:4:-2
$)
 
GLOBAL $(
a : 100; b : 101; c : 102
f : 103; g : 104; h : 105
failcount : 106
testcount : 107
testno    : 108
quiet     : 109
$)
 
LET t(x, y) = VALOF
   $( testno := testno + 1
      testcount := testcount + 1
      IF x=y & quiet RESULTIS y
      writef("%I3 %I6 ", testno, y)
      TEST x=y
         THEN writes("Ok*N")
         ELSE $( writef("Failed %X8(%N) %X8(%N)*N", x, x, y, y)
                 failcount := failcount + 1  $)
      RESULTIS y  $)
 
LET start() BE
$( writef("Tester(2) entered %S %S*N*N",
            tod([TABLE 0, 0, 0]), date([TABLE 0, 0, 0]))
 
   // First, initialise certain variables
 
   testno, testcount, failcount := 0, 0, 0
   a, b, c := #XABCDEF01, #X01234567, #XBBBBBBCB
   f, g, h := @a, @b, @c
 
   quiet := getbyte(param, 0) > 0 & getbyte(param, 1) = 'Q'
 
   // Test byte selections
 
   t(byte0::f, #XAB)
   t(byte1::f, #XCD)
   t(byte2::f, #XEF)
   t(byte3::f, #X01)
   byte0 of f := #X9999FF
   t(a, #XFFCDEF01)
   byte1 of f := #X111111CC
   t(a, #XFFCCEF01)
   byte2 of f := #XFF00FF11
   t(a, #XFFCC1101)
   byte3 of f := #X8899
   t(a, #XFFCC1199)
 
   a := #XABCDEF01
 
   t(byte4::f, byte0::g)
   t(byte5::f, byte1::g)
   t(byte6::f, byte2::g)
   t(byte7::f, byte3::g)
   t(byte8::f, byte4::g)
   t(byte9::f, byte1::h)
   byte8 of f := #X7722
   t(c, #X22BBBBCB)
   byte10 of f := #X9933
   t(c, #X22BB33CB)
 
   // Test general selectors
 
   testno := 100
 
   a, b, c := #XABCDEF01, #X01234567, #XBBBBBBCB
 
   t(s1::f, #XEF01)
   t(s2::f, #XABCD)
   t(s3::f, #X4567)
   t(s4::f, #X22)
   s1 of f := #X5555FFFF
   t(a, #XABCDFFFF)
   a := #XABCDEF01
   s2 of f := #X7777
   t(a, #X7777EF01)
   s3 of f := #X9999
   t(b, #X01239999)
   s4 of f := #XAA
   t(b, #X01235599)
   s6 of f := 1
   t(c, #XBBBBBB9B)
   t(s7::f, 2)
 
   a, b, c := #XABCD1234, #X00110011, #XABCD1234
   t(s1::f, s5::f)
   t(sm1::h,#X11)
   t(sm2::h,#X11)
   t(sm3::h,#X1234)
   t(sm4::h,#XABCD)

   // Test for fault where selector operand is already in a register

   $( LET x, y = ?, ?

      a := #XABCDEF01

   l: // Clear register slaving

      x := f   // To set slave
      y := byte0 of x
      t(y,#XAB)
   $)

   // Test selector expressions

   a := #X01020104
   b := -1
   IF byte0 of f = byte2 of f THEN b := 0
   t(b, 0)
   b := 0
   IF byte0 of f < byte1 of f THEN b := -1
   t(b, -1)
   b := 0
   IF byte3 of f > byte1 of f THEN b := 1
   t(b, 1)
 
   // Test byte indexing

   testno := 200
   a := "ABCDEFGHI"
   b := "CDEFGHIAB"

   t(a%1, b%8)
   t(a%0, b%0)
   t(a%3, b%2 - ('E' - 'D'))

   c := 5
   $( LET d = 2
      AND e = 4

      t(a%d, b%(b%0))
      t(a%c = b%3, TRUE)
      t(a%c = b%2, FALSE)

      a%1 := 'X'
      a%(e - d) := 'Y'
      t(a%1, a%d - ('Y' - 'X'))
      a := a - 3
      t((a + 3)%0, b%0)
      a := a + 3

      byte1 of a := 'A'   // Restore
      byte2 of a := 'B'

   l:   // Clear register slaving

      t(t(a%3, b%1) - t(a%3, b%1), 0)
   $)

   b%2 := 1
   b%4 := 2
   t(b%(b%(b%4)), 'C')

   c := @a * bytesperword
   a := 0
   0%c := 7
   t(a, #x07000000)
   0%c := 0
   t(a, 0)
   a := 0
   0%(c + 1) := 42
   t(a, #x002a0000)

   writef("*N%N tests completed, %N failure(s)*N*N",
           testcount, failcount)
$)
 
// End of file BCPL2TEST2
 
