 
// File BCPLRTS_TESTSRC
 
// Test program for BCPL run-time system (EMAS version)
 
// Copyright R.D. Eager   University of Kent   MCMLXXXII
 
 
SECTION "TESTRTS"
 
GET "LIBHDR"
 
MANIFEST $( SVBASE = -80 $)   // Base of system vector relative to global 0
GLOBAL $( RTSVERSION : SVBASE+29 $)   // Version no of run-time system
 
 
MANIFEST $(
SIZE       = 1000   // Test for APTOVEC
STOPCODE   = 7777   // Test for STOP(N)
RESCODE    = 4444   // Also for APTOVEC
A.         = ('A' << 24) \/ ('A' << 16) \/ ('A' << 8) \/ 'A'
$)
 
STATIC $( P.LAB = ?; P.LEVEL = ? $)
 
LET START() BE
$( LET A, B, C, D, E = 0, 0, 0, 0, 0
   AND T = (TABLE 0, 1, 2, 3, 4, 5)
   AND VV = VEC 2
   AND ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
 
   WRITES("*NTest program for BCPL run-time system*N")
   WRITEF("*NVersion number under test: E%N.%N*N*N",
       RTSVERSION/100, RTSVERSION REM 100)
 
   WRITEF("Parameter string = *'%S*'*N", PARAM)
 
   WRITEF("COMREG << 2 = X%X8*N", COMREG << 2)
 
   WRITEF("User name = *'%S*'*N", USERNAME)
   WRITEF("Job  name = *'%S*'*N", JOBNAME)
   WRITEF("EBTOAS << 2 = X%X8*N", EBTOAS << 2)
   WRITEF("ASTOEB << 2 = X%X8*N", ASTOEB << 2)
   WRITEF("Job is running in the %Sground*N", FOREGROUND -> "fore", "back")
 
   WRITEF("STACKBASE = X%X8, ", STACKBASE)
   WRITEF("LEVEL() = X%X8*N", LEVEL())
 
   WRITEF("COMREG(22) = X%X8*N", COMREG!22)
   WRITEF("COMREG(23) = X%X8*N", COMREG!23)
 
   WRITEF("SYSIN   strp = %N*N", SYSIN)
   WRITEF("SYSOUT  strp = %N*N", SYSOUT)
   WRITEF("JOURNAL strp = %N*N", JOURNAL)
 
   WRITEF("Testing program mask...*N")
   (SLCT 8:0:0)::(@A) := -1
   WRITES("OK*N*N")
 
   WRITES("On entry...*N")
   WRITEF("INPUT()  = %N*N", INPUT())
   WRITEF("OUTPUT() = %N*N", OUTPUT())
 
   WRITES("Testing indexing...*N")
   FOR I = 0 TO 5 DO WRITEN(T!I)
   WRITES(" should be 012345")
   NEWLINE(); NEWLINE()
 
   A := FINDINPUT(".IN")
   WRITEF("FINDINPUT(*".IN*") => %N*N", A)
   IF A > 0 THEN
   $( SELECTINPUT(A)
      $( LET C = RDCH()
         IF C = '*N' \/ C < 0 BREAK
         WRCH(C)
      $) REPEAT
      ENDREAD()
   $)
   NEWLINE(); NEWLINE()
 
   SELECTOUTPUT(JOURNAL)
   WRITES("This was output to the JOURNAL stream*N*N")
 
   SELECTOUTPUT(SYSOUT)
   WRITES("Testing tabs...*N")
   FOR I = 1 TO 40 DO WRCH((I REM 10) + '0')
   NEWLINE()
   WRITES("A*TB*TC*TD*N*N")
 
   WRITES("Testing prompts...*N")
   SELECTINPUT(SYSIN)
   PROMPT("Input prompt:")
   $( LET C = RDCH()
      IF C = '*N' \/ C < 0 BREAK
      WRCH(C)
   $) REPEAT
   NEWLINE(); NEWLINE()
 
   WRITES("Testing UNRDCH on .IN...*N")
   A := FINDINPUT(".IN")
   SELECTINPUT(A)
   UNRDCH()
   WRITEF("First (unread) char = X%X2*N", RDCH())
   B := RDCH()
   UNRDCH()
   WRITEF("Next one...*NX%X2 sb X%X2*N", B, RDCH())
   B := RDCH() REPEATUNTIL B = '*N'   // Flush line
   ENDREAD()
   NEWLINE(); NEWLINE()
 
   A := FINDINPUT(".NULL")
   WRITEF("FINDINPUT(*".NULL*") => %N*N", A)
   SELECTINPUT(A)
   WRITEF("Result from input on .NULL = %N*N", RDCH())
   IF A > 0 THEN ENDREAD()
   NEWLINE(); NEWLINE()
 
   A := FINDOUTPUT(".OUT")
   WRITEF("FINDOUTPUT(*".OUT*") => %N*N", A)
   SELECTOUTPUT(A)
   WRITES("Line written on .OUT")
   A := WRCH('*N')
   ENDWRITE()
   SELECTOUTPUT(SYSOUT)
   WRITEF("Result from write = %N*N", A)
   NEWLINE(); NEWLINE()
 
   WRITES("Incomplete line on SYSOUT")
   ENDWRITE()
   SELECTOUTPUT(SYSOUT)
   WRITES("Incomplete line should have appeared by now*N")
   NEWLINE(); NEWLINE()
 
   A := FINDOUTPUT(".null")
   WRITEF("FINDOUTPUT(*".null*") => %N*N", A)
   SELECTOUTPUT(A)
   WRITES("Line written on .NULL")
   A := WRCH('*N')
   ENDWRITE()
   SELECTOUTPUT(SYSOUT)
   WRITEF("Result from write = %N*N", A)
   NEWLINE(); NEWLINE()
 
   A := FINDOUTPUT(".TEMP")
   WRITEF("FINDOUTPUT(*".TEMP*") => %N*N", A)
   SELECTOUTPUT(A)
   WRITES("Line written on .TEMP*N")
   A := ENDTOINPUT()
   SELECTOUTPUT(SYSOUT)
   WRITEF("ENDTOINPUT() => %N*N", A)
   IF A > 0 THEN
   $( SELECTINPUT(A)
      $( A := RDCH()
         IF A = '*N' \/ A < 0 BREAK
         WRCH(A)
      $) REPEAT
      ENDREAD()
   $)
   NEWLINE()
   WRITEF("Termination code = %N*N", A)
   NEWLINE(); NEWLINE()

   WRITES("Testing file expansion...*N")
   A := FINDOUTPUT("T#EXP")
   WRITEF("FINDOUTPUT(*"T#EXP*") => %N*N", A)
   IF A > 0 THEN
   $( SELECTOUTPUT(A)
      FOR I = 1 TO 17000 DO
      $( A := WRCH('+')
         IF A < 0 BREAK
      $)
      ENDWRITE()
      SELECTOUTPUT(SYSOUT)
      WRITEF("Termination code = %N*N", A)
   $)
   NEWLINE(); NEWLINE()
 
   B := ".LP"
   A := FINDOUTPUT(B)
   WRITEF("FINDOUTPUT(*".LP*") => %N*N", A)
   SELECTOUTPUT(A)
   WRITES("Line 1 on printer*N")
   FOR I = 1 TO 132 DO WRCH('+')
   NEWLINE()
   WRITES("Line 3 (last) on printer*N")
   ENDWRITE()
   SELECTOUTPUT(SYSOUT)
   FOR I = 0 TO 3 DO
      IF GETBYTE(B, I) NE GETBYTE(".LP", I) THEN
      $( WRITES("*N++++++ Device name corrupted by FINDOUTPUT ++++++*N")
         BREAK
      $)
   NEWLINE(); NEWLINE()
 
   A := FINDOUTPUT(".ZZ")
   WRITEF("FINDOUTPUT(*".ZZ*") => %N*N", A)
   NEWLINE(); NEWLINE()
 
   A := FINDOUTPUT(".")
   WRITEF("FINDOUTPUT(*".*") => %N*N", A)
   NEWLINE(); NEWLINE()
 
   A := FINDINPUT("")
   WRITEF("FINDINPUT(*"*") => %N*N", A)
   NEWLINE(); NEWLINE()
 
   A := FINDOUTPUT("")
   WRITEF("FINDOUTPUT(*"*") => %N*N", A)
   NEWLINE(); NEWLINE()
 
   A := FINDOUTPUT("XXX-Mod")
   WRITEF("FINDOUTPUT(*"XXX-Mod*") => %N*N", A)
   SELECTOUTPUT(A)
   WRITES("Line written on XXX*NLine 2*N")
   ENDWRITE()
   SELECTOUTPUT(SYSOUT)
   NEWLINE(); NEWLINE()
 
   A := FINDOUTPUT("YYY-MOD")
   WRITEF("FINDOUTPUT(*"YYY-MOD*") => %N*N", A)
   SELECTOUTPUT(A)
   WRITES("Written on file YYY*N")
   ENDWRITE()
   SELECTOUTPUT(SYSOUT)
   NEWLINE(); NEWLINE()
 
   A := FINDOUTPUT("-MOD")
   WRITEF("FINDOUTPUT(*"-MOD*") => %N*N", A)
   NEWLINE(); NEWLINE()
 
   // Check for running out of SCBs
 
   $( LET A = FINDOUTPUT(".TEMP")
      LET B = FINDOUTPUT(".TEMP")
      LET C = FINDOUTPUT(".TEMP")
      LET D = FINDOUTPUT(".TEMP")
      LET E = FINDOUTPUT(".TEMP")
      LET F = FINDOUTPUT(".TEMP")
 
      WRITES("Trying to open six streams at once...*N")
      WRITEF("Six strps = %N, %N, %N, %N, %N, %N*N", A, B, C, D, E, F)
 
      SELECTOUTPUT(A); ENDWRITE()
      SELECTOUTPUT(B); ENDWRITE()
      SELECTOUTPUT(C); ENDWRITE()
      SELECTOUTPUT(D); ENDWRITE()
      SELECTOUTPUT(E); ENDWRITE()
      SELECTOUTPUT(F); ENDWRITE()
 
      SELECTOUTPUT(SYSOUT)
   $)
 
   A := SELECTINPUT(SYSIN)
   WRITEF("SELECTINPUT(SYSIN) => %N*N", A)
   A := ENDREAD()
   WRITEF("ENDREAD() => %N*N", A)
   A := SELECTINPUT(SYSIN)
   WRITEF("SELECTINPUT(SYSIN) => %N*N", A)
   NEWLINE(); NEWLINE()
 
   A := SELECTOUTPUT(SYSOUT)
   WRITEF("SELECTOUTPUT(SYSOUT) => %N*N", A)
   A := ENDWRITE()
   WRITEF("ENDWRITE() => %N*N", A)
   A := SELECTOUTPUT(SYSOUT)
   WRITEF("SELECTOUTPUT(SYSOUT) => %N*N", A)
   NEWLINE(); NEWLINE()
   WRITEF("INPUT()  => %N*N", INPUT())
   WRITEF("OUTPUT() => %N*N", OUTPUT())
 
   SELECTOUTPUT(0)
   SELECTINPUT(0)
   B := OUTPUT()
   SELECTOUTPUT(SYSOUT)
   WRITES("After illegal selections...*N")
   A := INPUT()
   WRITEF("INPUT()  => %N*N", A)
   WRITEF("OUTPUT() => %N*N", B)
   NEWLINE(); NEWLINE()
 
   A := SELECTOUTPUT(SYSIN)
   SELECTOUTPUT(SYSOUT)
   WRITEF("SELECTOUTPUT(SYSIN) => %N*N", A)
   A := SELECTINPUT(SYSOUT)
   WRITEF("SELECTINPUT(SYSOUT) => %N*N", A)
 
   A := FINDINPUT("TESTHDR")
   WRITEF("FINDINPUT(*"TESTHDR*") => %N*N", A)
   WRITEF("GETCONAD(<TESTHDR>) => %X8*N", GETCONAD(A))
   UNLESS A < 0 DO
   $( SELECTINPUT(A)
      $( C := RDCH()
         IF C < 0 BREAK
         WRCH(C)
      $) REPEAT
      ENDREAD()
      SELECTINPUT(SYSIN)
      WRITEF("Termination code = %N*N", C)
   $)
   NEWLINE(); NEWLINE()
 
   WRITEF("FINDINPUT(*"NOTHERE*") => %N*N", FINDINPUT("NOTHERE"))
   NEWLINE(); NEWLINE()
 
   WRITES("Testing record I/O on files...*N")
   C := FINDINPUT("TESTDATA")
   WRITEF("FINDINPUT(*"TESTDATA*") => %N*N", C)
   A := FINDOUTPUT("T#C")
   WRITEF("FINDOUTPUT(*"T#C*") => %N*N", A)
   IF A GE 0 THEN SELECTOUTPUT(A)
   IF C GE 0 THEN SELECTINPUT(C)
   UNLESS A < 0 \/ C < 0 DO
   $( LET V = VEC 10
      C := READREC(V, 40)
      IF C < 0 BREAK
      WRITES("Record read in...*N")
      WRCH('@')
      FOR I = 0 TO C - 1 DO
         WRCH(GETBYTE(V, I))
      NEWLINE(); WRCH('@')
      WRITES("*NShould be same as...*N")
      WRCH('@')
      WRITEREC(V, C)
      NEWLINE(); WRCH('@')
      WRITES("*N...or...*N")
      WRCH('@')
      C := WRITESEG(V, C)
      NEWLINE(); WRCH('@')
      NEWLINE()
      IF C < 0 BREAK
   $) REPEAT
   ENDREAD()
   ENDWRITE()
   SELECTOUTPUT(SYSOUT)
   WRITEF("Termination code = %N should be -154*N*N*N", C)

   WRITES("Testing record I/O on channels...*N")
   SELECTINPUT(SYSIN); SELECTOUTPUT(SYSOUT)
   $( LET V = VEC 10
      C := READREC(V, 40)
      IF C < 0 BREAK
      WRITES("Record read in...*N")
      WRCH('@')
      FOR I = 0 TO C - 1 DO
         WRCH(GETBYTE(V, I))
      NEWLINE()
      WRCH('@')
      WRITES("*NShould be same as...*N")
      WRCH('@')
      WRITEREC(V, C)
      WRCH('@')
      WRITES("*N...or...*N")
      WRCH('@')
      C := WRITESEG(V, C)
      NEWLINE()
      WRCH('@')
      NEWLINE()
      IF C < 0 BREAK
   $) REPEAT
   WRITEF("Termination code = %N*N*N*N", C)

   WRITES("Testing record I/O on .null...*N")
   C := FINDINPUT(".null")
   SELECTINPUT(C)
   WRITEF("FINDINPUT(*".null*") => %N*N", C)
   $( LET V = VEC 10
      C := READREC(V, 40)
      WRITEF("Result code on read = %N*N", C)
   $)
   ENDREAD()
   C := FINDOUTPUT(".NULL")
   WRITEF("FINDOUTPUT(*".NULL*") => %N*N", C)
   $( LET V = TABLE A., A., A.
      SELECTOUTPUT(C)
      C := WRITEREC(V, 12)
      A := WRITESEG(A, 12)
      ENDWRITE()
   $)
   SELECTINPUT(SYSIN); SELECTOUTPUT(SYSOUT)
   WRITEF("Result codes from writes are %N and %N*N", C, A)
 
   NEWLINE(); NEWLINE()
 
   C := FINDINPUT("TESTHDR")
   WRITEF("FINDINPUT(*"TESTHDR*") => %N*N", C)
   SELECTINPUT(C); TRANSFER(); ENDREAD()
   NEWLINE(); NEWLINE()
 
   A := FINDOUTPUT("WWW")
   WRITEF("FINDOUTPUT(WWW) => %N*N", A)
   SELECTOUTPUT(A)
   A := "HELLOGOODBYE*N"
   WRITEREC(A, 14)
   WRITES("LINE 2*NLINE 3*N")
   ENDWRITE()
   SELECTOUTPUT(SYSOUT)
 
   WRITES("Testing REWIND...*N")
   A := FINDINPUT("WWW")
   WRITEF("FINDINPUT(WWW) => %N*N", A)
   IF A > 0 THEN
   $( SELECTINPUT(A)
      $( LET C = RDCH()
         IF C = '*N' \/ C < 0 BREAK
         WRCH(C)
      $) REPEAT
      NEWLINE()
      $( LET C = RDCH()
         IF C = '*N' \/ C < 0 BREAK
         WRCH(C)
      $) REPEAT
      NEWLINE()
   $)
   A := REWIND()
   WRITEF("REWIND() => %N*N", A)
   IF A > 0 THEN
   $( LET C = 0
      SELECTINPUT(A)
      $( C := RDCH()
         IF C = '*N' \/ C < 0 BREAK
         WRCH(C)
      $) REPEAT
      NEWLINE()
      $( C := RDCH()
         IF C = '*N' \/ C < 0 BREAK
         WRCH(C)
      $) REPEAT
      NEWLINE()
      WRITEF("Termination code = %N*N", C)
      ENDREAD()
   $)
   NEWLINE(); NEWLINE()
 
   SELECTINPUT(SYSIN)
   WRITEF("Testing REWIND on SYSIN...*N")
   A := REWIND()
   WRITEF("Result = %N*N", A)
   NEWLINE(); NEWLINE()
 
   SELECTINPUT(0)
   WRITEF("Testing REWIND when no selection...*N")
   A := REWIND()
   WRITEF("Result = %N*N", A)
   NEWLINE(); NEWLINE()
 
   WRITEF("Testing REWIND on .NULL...*N")
   A := FINDINPUT(".NULL")
   SELECTINPUT(A)
   WRITEF("First byte = %N*N", RDCH())
   A := REWIND()
   WRITEF("REWIND() => %N*N", A)
   SELECTINPUT(A)
   WRITEF("Next byte = %N*N", RDCH())
   ENDREAD()
   NEWLINE(); NEWLINE()
 
   WRITES("Testing ENDTOINPUT...*N")
   A := FINDOUTPUT("SSS")
   WRITEF("FINDOUTPUT(SSS) => %N*N", A)
   SELECTOUTPUT(A)
   WRITES("ON FILE SSS*N")
   WRITES("AND A SECOND LINE*N")
   WRITES("AND A THIRD...*N")
   A := ENDTOINPUT()
   SELECTOUTPUT(SYSOUT)
   WRITEF("ENDTOINPUT() => %N*N", A)
   IF A > 0 THEN
   $( SELECTINPUT(A)
      $( A := RDCH()
         IF A = '*N' \/ A < 0 BREAK
         WRCH(A)
      $) REPEAT
      ENDREAD()
      NEWLINE()
      WRITEF("Termination code = %N*N", A)
   $)
   NEWLINE(); NEWLINE()
 
   SELECTOUTPUT(SYSOUT)
   WRITES("Testing ENDTOINPUT on SYSOUT...*N")
   A := ENDTOINPUT()
   SELECTOUTPUT(SYSOUT)
   WRITEF("Result = %N*N", A)
   NEWLINE(); NEWLINE()
 
   WRITES("Testing ENDTOINPUT on JOURNAL...*N")
   SELECTOUTPUT(JOURNAL)
   A := ENDTOINPUT()
   SELECTOUTPUT(SYSOUT)
   WRITEF("Result = %N*N", A)
   NEWLINE(); NEWLINE()
 
   WRITES("Testing ENDTOINPUT on .LP...*N")
   B := FINDOUTPUT(".LP")
   SELECTOUTPUT(B)
   A := ENDTOINPUT()
   SELECTOUTPUT(SYSOUT)
   WRITEF("Result = %N*N", A)
   SELECTOUTPUT(B)
   ENDWRITE()
   SELECTOUTPUT(SYSOUT)
   NEWLINE(); NEWLINE()
 
   WRITES("Testing ENDTOINPUT on .NULL...*N")
   B := FINDOUTPUT(".NULL")
   SELECTOUTPUT(B)
   A := ENDTOINPUT()
   WRITEF("Result = %C%X4*N", A < 0 -> '-', '*S', ABS(A))
   SELECTOUTPUT(B)
   ENDWRITE()
   SELECTINPUT(B)
   SELECTOUTPUT(SYSOUT)
   WRITEF("Next byte = %N*N", RDCH())
   ENDREAD()
   NEWLINE(); NEWLINE()
 
   WRITES("Testing UNRDCH()...*N")
   A := FINDINPUT("T#CHARS")
   IF A > 0 THEN
   $( SELECTINPUT(A)
      B := RDCH()
      UNRDCH()
      C := RDCH()
      WRITEF("%C sb %C*N", B, C)
      ENDREAD()
   $)
   A := FINDINPUT("T#CHARS")
   IF A > 0 THEN
   $( SELECTINPUT(A)
      UNRDCH()
      WRITEF("First char = X%X2*N", RDCH())
      ENDREAD()
   $)
   NEWLINE(); NEWLINE()
 
   WRITES("Testing SEEK...*N")
   A := FINDINPUT("T#SEEK")
   IF A > 0 THEN
   $( SELECTINPUT(A)
      B := RDCH()
      B := RDCH()
      WRITEF("SEEK(1) => %N*N", SEEK(1))
      C := RDCH()
      WRITEF("%C sb %C*N", B, C)
      ENDREAD()
   $)
   SELECTINPUT(SYSIN)
   WRITES("Testing SEEK on SYSIN...*N")
   WRITEF("SEEK(1) => %N*N", SEEK(1))
   NEWLINE(); NEWLINE()

   WRITES("Testing RENAMEFILE...*N")
   A := RENAMEFILE("NOTHERE", "X")
   WRITEF("RENAMEFILE(*"NOTHERE*", *"X*") => %N*N", A)
   A := RENAMEFILE("$$$", "X")
   WRITEF("RENAMEFILE(*"$$$*", *"X*") => %N*N", A)
   A := RENAMEFILE("T#A", "$$$")
   WRITEF("RENAMEFILE(*"T#A*", *"$$$*") => %N*N", A)
   A := RENAMEFILE("T#A", "T#B")
   WRITEF("RENAMEFILE(*"T#A*", *"T#B*") => %N*N", A)
   NEWLINE(); NEWLINE()
 
   WRITES("Testing DELETEFILE...*N")
   A := DELETEFILE("ZYX")
   WRITEF("Result = %N when file exists*N", A)
   A := DELETEFILE("NOTHERE")
   WRITEF("Result = %N when file does not exist*N", A)
   NEWLINE(); NEWLINE()
 
   WRITEF("GETCONAD(SYSIN) => %N*N", GETCONAD(SYSIN))
   A := GETCONAD(999)
   WRITEF("GETCONAD(999) => %N*N", A)
   NEWLINE(); NEWLINE()
 
   WRITES("Testing CHANGESIZE...*N")
   A := FINDOUTPUT("T#BIG")
   WRITEF("FINDOUTPUT(*"T#BIG*") => %N*N", A)
   SELECTOUTPUT(A)
   B := GETCONAD(A)
   IF A > 0 THEN
      FOR I = 0 TO 8 DO B!I := I \/ (I << 4) \/ (I << 8) \/ (I << 12)
   A := CHANGESIZE(32768)
   ENDWRITE()
   SELECTOUTPUT(SYSOUT)
   WRITEF("CHANGESIZE(32768) => %N*N*N*N", A)

   IF FOREGROUND THEN
   $( WRITES("Testing INTERRUPT...*N")
      $( LET V = VEC 3
         LET A = INTERRUPT(V)
         IF GETBYTE(A, 0) = 0 LOOP
         WRITEF("String = *'%S*'*N", A)
         BREAK
      $) REPEAT
   $)
 
   WRITEF("Date = *'%S*'*N", DATE(VV))
   WRITEF("Time = *'%S*'*N", TIMEOFDAY(VV))
   NEWLINE()
 
   WRITES("SWITCHON test...*N")
   SWITCHON 3 INTO
   $( DEFAULT: CASE 1: WRITES("ERROR******** *N")
      ENDCASE
      CASE 3: WRITES("OK*N")
   $)
   NEWLINE()
 
   WRITEF("DIRMESSAGE(%N) => *'%S*'*N", 32, DIRMESSAGE(32))
   WRITEF("SSMESSAGE(%N,%S) => *'%S*'*N", 218, "FRED", SSMESSAGE(218, "FRED"))
   NEWLINE(); NEWLINE()
 
   WRITES("Testing APTOVEC...*N*N")
   B := STACKVECS
   $( WRITEF("Size = %N, level = %X8, vector %S*N", SIZE, LEVEL(), STACKVECS -> "on stack", "in file")
      A := APTOVEC(MAIN, SIZE)
      WRITEF("Result should be %N*N", RESCODE)
      WRITEF("Result = %N, level = %X8*N", A, LEVEL())
      NEWLINE()
      STACKVECS := NOT STACKVECS
   $) REPEATUNTIL STACKVECS = B
   NEWLINE()
 
   WRITES("Testing VALIDATE...*N")
   PERM(-1, 4)
   PERM(START >> 2, 4)
   PERM(WRITES >> 2, 4)
   PERM(ASTOEB, 4)
   PERM(@VV, 4)
   PERM(@VV, 64)
   PERM(@VV, 32768)
   PERM(@VV, 65536)
   PERM(@VV, 131072)
   PERM(@VV, 220000)
   PERM(@VV, 262140)
   NEWLINE(); NEWLINE()
 
   WRITES("Testing MOVE...*N")
   $( LET V1 = VEC 20
      AND V2 = VEC 20
 
      FOR I = 0 TO 20 DO
         V1!I, V2!I := (I REM 10) + '0', 0
 
      MOVE(21*BYTESPERWORD, V1 << 2, V2 << 2)
 
      FOR I = 0 TO 20 DO WRCH(V1!I)
      WRITES(" should be ")
      FOR I = 0 TO 20 DO WRCH(V2!I)
      NEWLINE()
   $)
   NEWLINE(); NEWLINE()
 
   WRITES("Testing TRANSLATE...*N")
   WRITES(ALPHABET); NEWLINE()
   TRANSLATE((ALPHABET << 2) + 1, 26, ASTOEB)
   FOR I = 1 TO 26 DO WRITEF("%X2 ", GETBYTE(ALPHABET, I))
   NEWLINE()
   TRANSLATE((ALPHABET << 2) + 1, 26, EBTOAS)
   WRITES(ALPHABET); NEWLINE()
   NEWLINE(); NEWLINE()
 
   WRITES("Testing LONGJUMP...*N")
   P.LAB := RA; P.LEVEL := LEVEL()
   LJTA()
RA:WRITES("OK*N")
   P.LAB := RB
   APTOVEC(LJTB, 1000)
RB:WRITES("OK*N")
   NEWLINE(); NEWLINE()
 
   WRITES("Testing PACKSTRING...*N")
   A := (TABLE 4, 'A', 'B', 'C', 'D')
   $( LET V = VEC 1
      B := PACKSTRING(A, V)
      WRITEF("%S should be ABCD*N", V)
      WRITEF("%N should be 1*N", B)
      A!0 := 0
      B := PACKSTRING(A, V)
      WRITEF("X%X8 should be X00000000*N", V!0)
      WRITEF("%N should be 0*N", B)
   $)
   NEWLINE(); NEWLINE()
 
   WRITES("Testing UNPACKSTRING...*N")
   A := "WXYZ"
   $( LET V = VEC 4
      UNPACKSTRING(A, V)
      FOR I = 1 TO 4 DO
         WRCH(V!I)
      WRITEF(" should be %S*N", A)
      WRITEF("%N should be 4*N", V!0)
      UNPACKSTRING("", V)
      WRITEF("%N should be 0*N", V!0)
   $)
   NEWLINE(); NEWLINE()
 
   WRITES("Testing NEWPAGE()...*N")
   NEWPAGE()

   WRITEF("COMREG(24) should contain X%X8*N", STOPCODE)
 
 
   [FOREGROUND -> STOP, ABORT](STOPCODE)
$)
 
AND MAIN(V, S) = VALOF
$( LET R = ?
   WRITES("MAIN entered*N")
   WRITEF("Vector at %X8, size = %N*N", V*BYTESPERWORD, S)
   FOR I = 0 TO S DO V!I := #X18181818   // Fill vector to check for corruption
   WRITES("Down again*N")
   R := APTOVEC(MAIN2, SIZE - 1)
   WRITES("Returned from nested call")
   NEWLINE()
   WRITEF("Result = %N*N", R)
   RESULTIS RESCODE
$)
 
AND MAIN2(V, S) = VALOF
$( LET R = ?
   WRITES("MAIN2 entered*N")
   WRITEF("Vector at %X8, size = %N*N", V*BYTESPERWORD, S)
   WRITES("Down again*N")
   R := APTOVEC(MAIN3, SIZE - 2)
   WRITES("Returned from nested nested call*N")
   WRITEF("Result = %N*N", R)
   RESULTIS 4
$)
 
AND MAIN3(V, S) = VALOF
$( LET R = ?
   WRITES("MAIN3 entered*N")
   WRITEF("Vector at %X8, size = %N*N", V*BYTESPERWORD, S)
   WRITES("Down again*N")
   R := APTOVEC(MAIN4, SIZE - 3)
   WRITES("Returned from nested nested nested call*N")
   WRITEF("Result = %N*N", R)
   RESULTIS 5
$)
 
AND MAIN4(V, S) = VALOF
$( LET R = ?
   WRITES("MAIN4 entered*N")
   WRITEF("Vector at %X8, size = %N*N", V*BYTESPERWORD, S)
   WRITES("Down again*N")
   R := APTOVEC(MAIN5, SIZE - 4)
   WRITES("Returned from nested nested nested nested call*N")
   WRITEF("Result = %N*N", R)
   RESULTIS 6
$)
 
AND MAIN5(V, S) = VALOF
$( LET R = ?
   WRITES("MAIN5 entered*N")
   WRITEF("Vector at %X8, size = %N*N", V*BYTESPERWORD, S)
   WRITES("Down again*N")
   R := APTOVEC(MAIN6, SIZE - 5)
   WRITES("Returned from nested nested nested nested nested call*N")
   WRITEF("Result = %N*N", R)
   RESULTIS 7
$)
 
AND MAIN6(V, S) = VALOF
$( WRITES("MAIN6 entered*N")
   WRITEF("Vector at %X8, size = %N*N", V*BYTESPERWORD, S)
   RESULTIS 8
$)
 
AND PERM(ADDR, LEN) BE
$( LET BA = ADDR << 2
   WRITEF("%X8 => %S (%N bytes)*N", BA, VALOF SWITCHON VALIDATE(ADDR, LEN) INTO
      $( CASE 0:  RESULTIS "RW"
         CASE 1:  RESULTIS "RO"
         CASE 2:  RESULTIS "WO"
         CASE 3:  RESULTIS "NA"
         DEFAULT: RESULTIS "Error"
      $), LEN    )
$)
 
AND LJTA() BE
$( WRITES("Testing simple case...*N")
   LONGJUMP(P.LEVEL, P.LAB)
   !0 := 0   // Force a crash - we're in trouble!
$)
 
AND LJTB(V, S) = VALOF
$( WRITEF("Vector at %X8*N", V*BYTESPERWORD)
   WRITES("Testing complex case...*N")
   LONGJUMP(P.LEVEL, P.LAB)
   !0 := 0   // Force a crash
$)
 
AND TRANSFER() BE
$( LET C = ?
   IF INPUT() < 0 RETURN
   $( C := RDCH()
      IF C < 0 RETURN
      WRCH(C)
   $) REPEAT
$)
 
// End of file BCPLRTS_TESTSRC
 
