 
// File BCPLX_BCPLXSRC
 
// Version:  E2.3 - also alter MANIFESTs below
 
// Cross-reference utility for BCPL programs - EMAS version
 
// Adapted from University of Cambridge program
// Copyright (C) R.D. Eager UKC  MCMLXXXIV
 
 
// History:
//  E1.0   - Initial EMAS version.
//  E1.1   - Workspace   size   now  specified  in  bytes,  rather  than
//           kilobytes.
//  E1.2   - Default user for GET files removed to separate file.
//  E1.3   - Addition of '{' and '}' as alternatives to '$(' and '$)'.
//         - Underline now allowed in identifiers, in addition to dot.
//  E2.0   - Addition of ABS operator.
//  E2.1   - Lower case identifiers now converted to upper case.
//         - Calls to  GETBYTE  and  PUTBYTE  replaced  by  use  of  '%'
//           operator.
//  E2.2   - Correction  to  error which omitted 'type' flags on listing
//           (error introduced in E2.1).
//  E2.3   - Addition of '?' facility to print parameter keywords.
//  E2.4   - Correction to handle #x, #o and #b (in lower case).
//         - Correction  so  that  continuation  lines  in  routine  and
//           function formal parameter lists are handled correctly.
 
SECTION "ICL9CEZBCPLX"

 
MANIFEST $(   // Alter these if changes are made
version = 2   // Major version number
edit    = 4   // Edit number within major version
$)
 
 
/* Stop codes:-
    0 - Normal termination
1-999 - Corresponding Subsystem error
 1000 - Parameter error
 1001 - Program too large
*/
 
 
GET "BCPLX_BCPLXHDR"
 
MANIFEST $( keymax = 6 $)   // Number of keywords
 
LET start() BE
$( LET v1 = VEC maxstrlength/bytesperword
   AND v2 = VEC maxstrlength + 1
   AND v3 = VEC getsize*5 + 1   // For 'GET' streams
   AND keys = VEC keymax
   AND defaults = VEC keymax
   AND options = VEC maxstrlength/bytesperword + 2*keymax
   AND listing = ?
   AND size = ?
 
   wordv, charv := v1, v2
   getv, getp, gett := v3, 0, getsize*5 + 1
 
   // Get definition of default user for GET files

   GET "BCPLX_LIBUSER"

   keys!0 := keymax
   keys!1 := "SOURCE"      ; defaults!1 := 0
   keys!2 := "LISTING"     ; defaults!2 := 0
   keys!3 := "PATTERN"     ; defaults!3 := ""
   keys!4 := "SIZE"        ; defaults!4 := "60000"
   keys!5 := "ALL"         ; defaults!5 := "NO"
   keys!6 := "GETFILES"    ; defaults!6 := "10"
 
   IF param%0 = 1 & param%1 = '?' THEN
   $( writes("Parameters are:-*N")
      FOR i = 1 TO keymax DO
      $( writef("%S=", keys!i)
         IF defaults!i NE 0 THEN writes(defaults!i)
         IF i NE keymax THEN wrch(',')
      $)
      stop(0)
   $)

   writef("*NBCPL cross-reference program - version E%N.%N*N", version, edit)
 
   paramdecode(keys, options)
 
   IF options!0 < 0 THEN
   $( LET mes = VALOF SWITCHON options!0 INTO
      $( CASE par.err:  RESULTIS "Illegal parameter format"
         CASE par.amb:  RESULTIS "Ambiguous keyword"
         CASE par.unk:  RESULTIS "Keyword not recognised"
         CASE par.xs :  RESULTIS "Too many parameters"
         CASE par.dup:  RESULTIS "A parameter has been duplicated"
         CASE par.mis:  RESULTIS "Missing keyword"
         DEFAULT:       RESULTIS ""
      $)
      paramerr(mes)
   $)
 
   FOR i = 1 TO keymax DO
      IF options!i = 0 DO options!i := defaults!i
 
   warnings_ := FALSE
 
   pattern := options!3
 
   all_refs_ := VALOF
   $( TEST matchstrings(options!5, "YES") THEN RESULTIS TRUE
      OR UNLESS matchstrings(options!5, "NO") DO
      $( writes("*NWarning - illegal value for *'ALL*' parameter - *'NO*' assumed*N")
         warnings_ := TRUE
      $)
      RESULTIS FALSE
   $)
 
   UNLESS VALOF
   $( LET l = pattern%0
      LET alpha(c) = 'A' LE c LE 'Z' \/
                     'a' LE c LE 'z' \/
                      c = '**'
      AND numeric(c) = '0' LE c LE '9' \/
                       c = '.'
 
      IF l = 0 RESULTIS TRUE
 
      UNLESS alpha(pattern%1) RESULTIS FALSE
      FOR i = 2 TO l DO
      $( LET c = pattern%i
 
         UNLESS alpha(c) \/ numeric(c) RESULTIS FALSE
      $)
      RESULTIS TRUE
   $)
   DO
      paramerr("Illegal format for *'PATTERN*' parameter")
 
   matchall_ := pattern%0 = 0
 
   size := strtonum(options!4)
   UNLESS 4096 LE size LE 196608 DO
      paramerr("Illegal value for *'SIZE*' parameter")
 
   getfiles := strtonum(options!6)
   UNLESS 0 LE getfiles LE 99 DO
      paramerr("Illegal value for *'GETFILES*' parameter")
 
   real_rdch := rdch
 
   compiler_ := matchstrings(options!1, ".COMPILER")   // If called direct from BCPL1
 
   TEST compiler_ THEN
   $( IF comreg!46 = 0 THEN
         paramerr("Compiler source is not a file")
      listing := sysout
      sourcestream := -1   // Dummy value
      errorstream := comreg!40 GE 0
   $)
   OR
   $( sourcestream := findinput(options!1)
      IF sourcestream < 0 THEN
         ioerror(sourcestream, options!1)
      comreg!46 := getconad(sourcestream) << 2
 
      IF options!2 = 0 THEN options!2 := ".LP"
      listing := findoutput(options!2)
      IF listing < 0 THEN
         ioerror(listing, options!2)
      errorstream := FALSE
   $)
 
   selectoutput(listing)
 
   TEST comreg!46 NE 0 THEN
   $( rdch := con_rdch   // Use special input routine
      sourceconad := comreg!46 >> 2
      source_ptr := sourceconad!1   // Length of header
   $)
   OR
   $( sourceconad := 0
      sourcestream := sysin
      prompt("BCPLXREF: ")
   $)
 
   $( LET dv = VEC 2
      AND tv = VEC 2
      AND heading = "Cross-reference listing of file *'%S*' - on %S at %S"
      AND length, pad = ?, ?
 
      IF compiler_ THEN heading := "Cross-reference listing"
 
      length := heading%0
      UNLESS compiler_ DO
         length := length + (options!1)%0 + 10
 
      pad := (linesize - length)/2
 
      writes("*P*N*N")
      FOR i = 1 TO pad DO wrch('*S')
      writef(heading, options!1, date(dv), tod(tv))
      UNLESS compiler_ DO
         writef("*T    E%N.%N", version, edit)
      newline()
      FOR i = 1 TO pad DO wrch('*S')
      FOR i = 1 TO length DO wrch('-')
      writes("*N*N*N")
   $)
 
   stop(aptovec(xref, size/bytesperword + getfiles*(fsize + 1)))
$)
 
AND paramerr(mes) BE
$( selectoutput(journal)
   writef("*NBCPLXREF fails - %S*N", mes)
   stop(1000)
$)
 
AND ioerror(ecode, file) BE
$( EXTERNAL $( s_setfname : "S#SETFNAME" $)
 
   LET mes = VEC maxstrlength/bytesperword + 1
 
   FOR i = 0 TO file%0 DO
      mes%i := file%i
 
   s_setfname(#X18000100, mes << 2)
 
   stop(ABS(ecode))
$)
 
AND con_rdch() = VALOF   // Special routine to read from connected source file
$( LET c = ?
 
   IF source_ptr GE !sourceconad RESULTIS endstreamch
 
   c := sourceconad%source_ptr
   source_ptr := source_ptr + 1
   RESULTIS c
$)

AND iocp(ep, n) BE
$( EXTERNAL $( s_iocp : "S#IOCP" $)
   s_iocp(ep, n)
$)

AND e_wrch(c) = VALOF    // Write to error stream
$( LET o = comreg!23     // Current output channel

   iocp(9, comreg!40)    // SELECT OUTPUT(errors)
   iocp(5, c)            // PRINTCH(C)
   iocp(9, o)            // SELECT OUTPUT(O)

   RESULTIS 0
$)

AND xref(v, size) = VALOF
$( LET type = s.null
 
   getnamev := v
   v := v + getfiles
 
   FOR i = 0 TO getfiles - 1 DO
   $( getnamev!i := v
      v := v + fsize
   $)
 
   getfile_max_reached_ := FALSE
 
   treevec, treep := v, v + size - getfiles*(fsize + 1)
 
   nametree := 0
   nlpending_ := FALSE
   fileno, nextfile := 0, 0
   linecount := 1
 
   declsyswords()
 
   rch()
   nextsymb()
 
   UNTIL symb = s.end DO SWITCHON symb INTO
   $( CASE s.global:
      CASE s.static:
      CASE s.manifest:
      CASE s.external:
         type := symb
         oldtype := symb
 
      DEFAULT:
         nextsymb()
         LOOP
 
      CASE s.and:
         symb := s.let
 
      CASE s.case:
      CASE s.for:
      CASE s.let:
         type := symb
         nextsymb()
         LOOP
 
      CASE s.rsect:
         type, oldtype := s.null, s.null
         nextsymb()
         LOOP
 
      CASE s.semicol:
         type := oldtype
         nextsymb()
         LOOP
 
      CASE s.colon:
      CASE s.be:
      CASE s.eq:
         type := s.null
         nextsymb()
         LOOP
 
      CASE s.name:
      $( LET t = type
         LET name = wordnode
         nextsymb()
         TEST symb = s.colon THEN t := type = s.null -> s.lab,
                                       type = s.case -> s.null, type
         OR IF type = s.case THEN t := s.null
         IF type = s.let THEN t := symb = s.lparen -> s.proc, s.let
         word := name + 4
         IF matchall_ \/ match(1, 1) DO addref(t, name)
         LOOP
      $)
   $)
 
   UNLESS nextfile = 0 DO writes("*N*N")
 
   prtree(nametree)
 
   writef("*NSpace used: %N bytes*N", (v + size - treep)*bytesperword)
 
   RESULTIS 0
$)
 
AND error(mess) BE
$( LET o_wrch = wrch
   AND s = "%S near line %N*N*N"
   AND o = output()
 
   warnings_ := TRUE

   UNLESS compiler_ DO selectoutput(sysout)

   FOR i = 0 TO 1 DO
   $( writes("*N** ")
      writef(s, mess, linecount)
      UNLESS errorstream BREAK
      wrch := e_wrch
   $)
   wrch := o_wrch   // Restore previous output
   selectoutput(o)
$)
 
AND nextsymb() BE
$( symb := s.null
   IF nlpending_ THEN
   $( linecount := linecount + 1
      nlpending_ := FALSE
   $)
 
   SWITCHON ch INTO
 
   $( CASE '*P':
      CASE '*N': nlpending_ := TRUE
                 rch()
                 symb:=s.semicol
                 RETURN
 
      CASE '*T':
      CASE '*S': rch() REPEATWHILE ch='*S'
                 LOOP
 
      CASE '0':CASE '1':CASE '2':CASE '3':CASE '4':
      CASE '5':CASE '6':CASE '7':CASE '8':CASE '9':
           readnumb(10)
           RETURN
 
      CASE 'a':CASE 'b':CASE 'c':CASE 'd':CASE 'e':
      CASE 'f':CASE 'g':CASE 'h':CASE 'i':CASE 'j':
      CASE 'k':CASE 'l':CASE 'm':CASE 'n':CASE 'o':
      CASE 'p':CASE 'q':CASE 'r':CASE 's':CASE 't':
      CASE 'u':CASE 'v':CASE 'w':CASE 'x':CASE 'y':
      CASE 'z':
         ch := ch - 'a' + 'A'   // Convert to upper case

      CASE 'A':CASE 'B':CASE 'C':CASE 'D':CASE 'E':
      CASE 'F':CASE 'G':CASE 'H':CASE 'I':CASE 'J':
      CASE 'K':CASE 'L':CASE 'M':CASE 'N':CASE 'O':
      CASE 'P':CASE 'Q':CASE 'R':CASE 'S':CASE 'T':
      CASE 'U':CASE 'V':CASE 'W':CASE 'X':CASE 'Y':
      CASE 'Z':
           rdtag(ch)
           symb := lookupword()
           UNLESS symb=s.get RETURN
           performget()
           LOOP
 
      CASE '$': rch()
                symb := s.null
                IF ch=')' DO symb := s.rsect
                TEST ch='(' \/ ch=')'
                  THEN rdtag('$')
                  ELSE rch()
                RETURN
 
      CASE '{':
      CASE '}':  symb := ch = '{' -> s.null, s.rsect
                 rdtag('$')
                 RETURN

      CASE '[':
      CASE '(': symb := s.lparen
                rch()
                RETURN
 
      CASE '=': symb := s.eq
                rch()
                RETURN
 
      CASE '#':
         $( LET radix = 8
            rch()
            IF ch='B' \/ ch='b' DO radix := 2
            IF ch='O' \/ ch='o' DO radix := 8
            IF ch='X' \/ ch='x' DO radix := 16
            UNLESS 'O'<=ch<='7' DO rch()
            readnumb(radix)
            RETURN  $)
 
      CASE '/':
           rch()
           IF ch='\' DO $( rch(); LOOP  $)
           IF ch='/' DO
              $( rch() REPEATUNTIL ch='*N' \/ ch=endstreamch
                 LOOP  $)
 
           UNLESS ch='**' RETURN
 
           $( rch()
              IF ch='**' DO
                 $( rch() REPEATWHILE ch='**'
                    IF ch='/' BREAK  $)
              IF ch='*N' DO linecount := linecount+1
           $) REPEATUNTIL ch=endstreamch
 
           rch()
           LOOP
 
 
      CASE '|':
           rch()
           IF ch = '|' DO
              $( rch() REPEATUNTIL ch='*N' \/ ch=endstreamch
                 LOOP $)
 
           UNLESS ch='**' RETURN
 
           $( rch()
              IF ch='**' DO
               $( rch() REPEATWHILE ch='**'
                  IF ch = '|' BREAK $)
              IF ch='*N' DO linecount:=linecount+1
           $) REPEATUNTIL ch=endstreamch
 
           rch()
           LOOP
 
      CASE '<':
      CASE '>':
      CASE '\': rch()
                IF ch='=' DO rch()
                RETURN
 
      CASE '-': rch()
                IF ch='>' DO rch()
                RETURN
 
      CASE ';': symb:=s.semicol
                rch()
                RETURN
 
      CASE ':': rch()
                IF ch='=' DO $( rch(); RETURN  $)
                IF ch=':' DO $( rch(); RETURN  $)
                symb := s.colon
                RETURN
 
      CASE ',': rch() REPEATWHILE ch='*S' \/ ch='*T'
                IF ch='*N' \/ ch='*P' THEN
                $( nlpending_ := TRUE
                   rch()
                $)
                RETURN

      CASE '*"':rch()
                charv!0 := 0
                FOR i = 1 TO maxstrlength DO
                $( IF ch='*"' BREAK
                   charv!0 := i
                   charv!i := rdstrch()
                $)
                UNLESS ch = '*"' DO
                $( error("String too long")
                   UNTIL (ch = '*N') \/ (ch = endstreamch) DO ch := rdch()
                $)
                wordsize := packstring(charv, wordv)
                symb := s.string
                rch()
                RETURN
 
      CASE '*'':rch()
                rdstrch()
                rch()
                RETURN
 
 
      CASE '.': UNLESS getp=0 DO ch := endstreamch
      DEFAULT:  UNLESS ch=endstreamch DO
                $( rch()
                   RETURN
                $)
                IF getp=0 DO
                $( symb := s.end
                   RETURN
                $)
                endread()
                getp := getp - 5
                sourcestream := getv!getp
                selectinput(sourcestream)
                linecount := getv!(getp + 1) >> 7
                fileno := getv!(getp + 1) & #177
                source_ptr := getv!(getp + 2)
                sourceconad := getv!(getp + 3)
                ch := getv!(getp + 4)
                IF sourceconad = 0 THEN
                   rdch := real_rdch   // Primary input is not a file
                LOOP
   $)
$) REPEAT
 
AND lookupword() = VALOF
$( LET p = @nametree
 
   wordnode := !p
 
   UNTIL wordnode = 0 DO
   $( LET cmp = cmpstr(wordv, wordnode + 4)
      IF cmp = 0 RESULTIS !wordnode
      p := wordnode + (cmp < 0 -> 1, 2)
      wordnode := !p
   $)
 
   wordnode := newvec(wordsize + 4)
   wordnode!0, wordnode!1 := s.name, 0
   wordnode!2, wordnode!3 := 0, 0
   FOR i = 0 TO wordsize DO wordnode!(i + 4) := wordv!i
 
   !p := wordnode
   RESULTIS s.name
$)
 
AND cmpstr(s1, s2) = VALOF
$( LET len1, len2 = s1%0, s2%0
   FOR i = 1 TO len1 DO
   $( LET ch1, ch2 = s1%i, s2%i
      IF (i > len2) \/ (ch1 > ch2) RESULTIS 1
      IF ch1 < ch2 RESULTIS -1
   $)
   IF len1 < len2 RESULTIS -1
   RESULTIS 0
$)
 
AND declsyswords() BE
$( ptr := TABLE
      0,s.and,
      s.be,0,0,
      s.case,0,
      0,0,
      s.eq,0,0,0,s.external,
      0,s.for,0,
      0,0,0,s.global,s.get,
      0,0,
      s.let,0,0,0,0,0,0,0,
      s.manifest,
      0,0,0,0,
      0,0,
      0,0,0,0,0,
      0,0,0,
      0,0,s.static,0,
      0,0,0,0,0,
      0,0,
      0,0,
      0
 
    d("ABS/AND/*
      *BE/BREAK/BY/*
      *CASE/CODE/*
      *DO/DEFAULT/*
      *EQ/EQV/ELSE/ENDCASE/EXTERNAL/*
      *FALSE/FOR/FINISH/*
      *GOTO/GE/GR/GLOBAL/GET/*
      *IF/INTO/*
      *LET/LV/LE/LS/LOGOR/LOGAND/LOOP/LSHIFT//")
 
    d("MANIFEST/*
      *NEEDS/NE/NOT/NEQV/*
      *OF/OR/*
      *RESULTIS/RETURN/REM/RSHIFT/RV/*
      *REPEAT/REPEATWHILE/REPEATUNTIL/*
      *SECTION/SWITCHON/STATIC/SLCT/*
      *TO/TEST/TRUE/THEN/TABLE/*
      *UNTIL/UNLESS/*
      *VEC/VALOF/*
      *WHILE//")
 
$)
 
AND d(words) BE
$( LET i, length = 1, 0
 
   $( LET ch = words%i
      TEST ch='/' THEN
      $( IF length = 0 RETURN
         charv!0 := length
         wordsize := packstring(charv, wordv)
         lookupword()
         !wordnode := !ptr
         ptr := ptr + 1
         length := 0
      $)
      OR
      $( length := length + 1
         charv!length := ch
      $)
      i := i + 1
   $) REPEAT
$)
 
 .
 
 
GET "BCPLX_BCPLXHDR"
 
 
LET rch() BE ch := rdch()
 
AND rdtag(char1) BE
$( LET n = 1
   charv!1 := char1
 
   $( rch()
      UNLESS 'A'<=ch<='Z' \/
             'a'<=ch<='z' \/
             '0'<=ch<='9' \/
              ch='_' \/
              ch='.' BREAK
      IF 'a' LE ch LE 'z' THEN ch := ch - 'a' + 'A'
      n := n + 1
      charv!n := ch
   $) REPEAT
 
   charv!0 := n
   wordsize := packstring(charv, wordv)
$)
 
AND performget() BE
$( nextsymb()
 
   UNLESS symb = s.string DO
   $( error("String expected")
      RETURN
   $)
 
   IF getp GE gett THEN
   $( error("*NGET file *'%S*' nested too deep", wordv)
      RETURN
   $)
 
   IF getfile_max_reached_ RETURN
 
   IF nextfile GE getfiles THEN
   $( error("Warning - too many GET files")
      getfile_max_reached_ := TRUE
      RETURN
   $)
 
   FOR i = 0 TO nextfile DO
      IF cmpstr(wordv, getnamev!i) = 0 RETURN   // File already seen
 
   FOR i = 0 TO wordv%0 DO
      (getnamev!nextfile)%i := wordv%i
 
   nextfile := nextfile + 1
 
   getv!getp := sourcestream
   getv!(getp + 1) := (linecount << 7) + fileno
   getv!(getp + 2) := source_ptr
   getv!(getp + 3) := sourceconad
   getv!(getp + 4) := ch
   getp := getp + 5
   linecount := 1
   sourcestream := findinput(wordv)
   IF sourcestream = -e.fnf THEN   // File not found - try in library
   $( LET ulen = libuser%0
      AND v = VEC maxstrlength/bytesperword + 1

      FOR i = 1 TO ulen DO
         v%i := libuser%i

      FOR i = 1 TO wordv%0 DO
         v%(ulen + i) := wordv%i

      v%0 := ulen + wordv%0

      sourcestream := findinput(v)
   $)
   IF sourcestream < 0 THEN ioerror(sourcestream, wordv)
   selectinput(sourcestream)
   rdch := con_rdch   // In case primary input is not a file
   sourceconad := getconad(sourcestream)
   IF sourceconad LE 0 \/ sourceconad!3 NE 3 THEN
      ioerror(e.ift, wordv)   // Not a character file
   source_ptr := sourceconad!1   // Length of header
 
   IF nextfile = 1 THEN
   $( writes("*T*T  GET file summary*N*N")
      writes("*T*TNumber*T*TName*N*N")
   $)
 
   writef("*T*T%I4*T     %S*N", nextfile, wordv)
 
   fileno := nextfile
   rch()
$)
 
AND readnumb(radix) BE UNTIL value(ch)>=radix DO rch()
 
AND value(ch) = '0'<=ch<='9' -> ch-'0',
                'a'<=ch<='f' -> ch-'a'+10,
                'A'<=ch<='F' -> ch-'A'+10,
                100
 
AND rdstrch() = VALOF
$( LET k = ch
 
   rch()
 
   IF k = '*N' THEN
      error("Incorrect use of newline in string")
 
   IF k = '**' THEN
   $( IF ch = '*N' \/ ch = '*S' \/ ch = '*T' DO
      $( $( IF ch = '*N' THEN linecount := linecount + 1
            rch()
         $) REPEATWHILE ch = '*N' \/ ch = '*S' \/ ch = '*T'
         rch()
         RESULTIS rdstrch()
      $)
 
      rch()
   $)
 
   RESULTIS k
$)
 
AND newvec(n) = VALOF
$( treep := treep - n - 1
   IF treep LE treevec DO
   $( error("Program too large")
      stop(1001)
   $)
   RESULTIS treep
$)
 
AND list2(x, y) = VALOF
$( LET p = newvec(1)
   p!0, p!1 := x, y
   RESULTIS p
$)
 
AND addref(type, name) BE
$( LET p = name + 3
   UNTIL !p = 0 DO p := !p
   !p := list2(0, (linecount << 11) + (fileno << 4) + type)
$)
 
AND prtree(t) BE UNLESS t=0 DO
$( prtree(t!1)
   wrnameinfo(t)
   prtree(t!2)  $)
 
AND wrnameinfo(t) BE IF !t = s.name DO
$( LET n = t + 4
   LET l = t!3
   AND chp = n%0 + 6
   AND declared_, used_ = FALSE, FALSE
 
   UNTIL l = 0 DO
   $( TEST ((l!1) & #XF) NE s.null THEN declared_ := TRUE OR used_ := TRUE
      l := !l
   $)
 
   IF NOT used_ THEN UNLESS all_refs_ RETURN
   writef(" %C  %S ", (NOT used_ -> 'N', (declared_ -> '*S', 'U')), n)
 
   UNTIL chp REM 9 = 4 & chp GE 18 DO
   $( wrch('*S')
      chp := chp + 1
   $)
 
   l := t!3
   UNTIL l = 0 DO
   $( LET a = l!1
      LET ln, f, t = a >> 11, (a >> 4) & #X7F, a & #XF
 
      IF chp GE linesize - 9 DO
      $( writes("*N                     ")
         chp := 18
      $)
      writed(ln, 6)
      TEST t = s.null THEN wrch(f = 0 -> '*S', ':')
      OR wrch("VPLGMSFE"%t)
      TEST f = 0 THEN writes("*S*S") OR writed(f,2)
      chp := chp + 9
      l := !l
   $)
 
   newline()
$)
 
AND match(p,s) =  s > word%0 -> (p > pattern%0 -> TRUE,
                  pattern%p = '**' -> match(p + 1, s),
                                                FALSE),
                  p > pattern%0 -> FALSE,
                  pattern%p = '**' -> (match(p + 1, s) -> TRUE,
                  match(p, s + 1)),
                  (pattern%p = word%s)  -> match(p + 1, s + 1),
                  FALSE
 
.
 
 
// Parameter decoder
 
GET "BCPLX_BCPLXHDR"
 
STATIC $( parptr = ?; parleng = ? $)
 
LET paramdecode(keys, pars) BE
$( LET pmax, pnum = keys!0, 1
   LET wksp, pn = pars + pmax + 1, ?
   FOR i = 0 TO pmax DO pars!i := 0
   parptr := 0
   parleng := param%0
   $( LET c = getpar(wksp)
      pn := (c NE '=') -> pnum, VALOF
      $( LET n = findkey(keys, wksp)
         c := getpar(wksp)
         RESULTIS n
      $)
      pars!0 := VALOF
      $( LET l = wksp%0
         IF c = '='          RESULTIS par.err
         IF pn = -1          RESULTIS par.amb
         IF pn = -2          RESULTIS par.mis
         IF pn = 0           RESULTIS par.unk
         IF pn > pmax        RESULTIS par.xs
         IF l = 0            RESULTIS par.ok
         IF pars!pn NE 0     RESULTIS par.dup
         pars!pn := wksp
         wksp := wksp + l/bytesperword + 1
         RESULTIS par.ok
      $)
      UNLESS pars!0 = par.ok RETURN
      IF c = endstreamch RETURN
      pnum := pnum + 1
   $) REPEAT
$)
 
AND getpar(wksp) = VALOF
$( LET c, spcnt = ?, 0
   AND inpr, length = FALSE, 0
 
   $( c := getch(param)
      SWITCHON c INTO
      $( CASE endstreamch:
         CASE ',':
         CASE '=':
            wksp%0 := length
            RESULTIS c
 
         CASE '*S':
            spcnt := spcnt + 1
            ENDCASE
 
         DEFAULT:
            TEST inpr THEN
               FOR i = 1 TO spcnt DO
               $( length := length + 1
                  wksp%length := '*S'
               $)
            OR
               inpr := TRUE
            spcnt := 0
            length := length + 1
            wksp%length := c
      $)
   $) REPEAT
$)
 
AND findkey(keys, wksp) = VALOF
$( LET f = 0
 
   IF wksp%0 = 0 RESULTIS -2   // Missing keyword
   FOR i = 1 TO keys!0 DO
   $( IF matchstrings(wksp, keys!i) DO
      $( UNLESS f = 0 RESULTIS -1
         f := i
      $)
   $)
   RESULTIS f
$)
 
AND matchstrings(a, b) = VALOF
$( LET l = a%0
   IF b%0 < l RESULTIS FALSE
   FOR i = 1 TO l DO
      UNLESS a%i = b%i RESULTIS FALSE
   RESULTIS TRUE
$)
 
AND strtonum(str) = VALOF
$( LET base, num, minus = 10, 0, FALSE
   parptr := 0
   parleng := str%0
 
   TEST getch(str) = '-' THEN minus := TRUE
   OR parptr := parptr - 1
 
   TEST getch(str) = '#' THEN
   SWITCHON getch(str) INTO
   $( CASE 'X':  base := 16
                 ENDCASE
      CASE 'B':  base := 2
                 ENDCASE
      DEFAULT :  parptr := parptr - 1
      CASE 'O':  base := 8
   $)
   OR parptr := parptr - 1
   $( LET n = getnum(str)
      IF n GE base BREAK
      num := num * base + n
   $) REPEAT
   RESULTIS minus -> -num, num
$)
 
AND getnum(str) = VALOF
$( LET c = getch(str)
   RESULTIS ('0' LE c LE '9') -> c - '0',
            ('A' LE c LE 'F') -> c - 'A' + 10, 99   // 99 is greater than
                                                    // the maximum base
$)
 
AND getch(str) = VALOF
$( parptr := parptr + 1
   RESULTIS parptr > parleng ->
   endstreamch, str%parptr
$)
 
// End of file BCPLX_BCPLXSRC
 
