 
// File OLIBTSRC
 
// Version: E1.21
 
// BCPL part of standard BCPL library for ICL 2900 under EMAS
//  - version with diagnostic routines
 
// Copyright R.D. Eager   University of Kent   MCMLXXXIV
 
 
// History:
//  E1.0   - Initial EMAS version.
//  E1.1   - 'svdrtop' moved to word offset 55 in system vector.
//         - Correction to output format in 'mapstatics'.
//         - PPC renamed FPC in register dump.
//  E1.2   - Modifications to cater for new 80-word system vector.
//         - Conversion for function names in SST instead of GLA.
//  E1.3   - Conversion for STATIC names in SST instead of GLA.
//  E1.4   - Addition  of  terminal  buffer  clearing  code for class 65
//           (breakin) contingencies.
//         - Addition of code to handle internally generated errors such
//           as 'unassigned variable'.
//  E1.5   - 'writeoct',  'writehex',  'writes',   'writeo',   'writeh',
//           'writen',  'newline',  'newpage', 'readn', 'packstring' and
//           'unpackstring' commented out; machine code versions  within
//           run-time system are used.
//         - Addition  of  code  to  scan to end of the OBEY file, after
//           breakin during an OBEY.
//  E1.6   - Modification to message printed out after a contingency.
//  E1.7   - Removal of 'console' routine (now in run-time system).
//         - Correction to code for scanning to end of OBEY  file  after
//           breakin.
//  E1.8   - Debugging  routines  modified to use word address of SST as
//           given in system vector.
//  E1.9   - Correction to profile-printing code; scaling for  histogram
//           could produce null histogram!
//  E1.10  - Improvement  to  code for scanning to end of OBEY file; now
//           uses 'endobey' routine in run-time system.
//  E1.11  - Interim modification to 'backtrace', to ignore negative items
//           found in trace buffer.
//  E1.12  - 'writef' altered  to  accept  lower  case  equivalents  for
//           format characters.
//  E1.13  - 'tod' references altered to 'timeofday'.
//  E1.14  - Modified  to accept single-character INT: messages in lower
//           case.
//  E1.15  - Addition of '%$' to 'writef'.
//  E1.16  - Debugging  output  now uses a 'secret' copy of 'wrch'; this
//           allows users to plug 'wrch' with  a  private  version,  yet
//           still  get  diagnostic  output even if that private version
//           does not work.
//  E1.17  - Improved  version  of  'readnumber';  will  read   'minint'
//           correctly.
//  E1.18  - Addition of 'getvec' and 'freevec'.
//  E1.19  - Addition of 'move' to specific names in 'name_from_link'.
//  E1.20  - Corrections to '!atsf' adjustment in 'name_from_link'.
//  E1.21  - Alteration to 'mapcode' call for case of zero PC.
 
 
// Standard library routines
 
GET "LIBHDR"
 
LET writed(n, d) BE
$( LET t = VEC 10
   AND i, k = 0, n
 
   IF (n NE 0) & ((n << 1) = 0) THEN
   $( writes("-2147483648")
      RETURN
   $)
   IF n < 0 THEN d, k := d - 1, -n
   $( t!i := k REM 10
      k := k / 10
      i := i + 1
   $) REPEATUNTIL k = 0
   FOR j = i + 1 TO d DO wrch('*S')
   IF n < 0 DO wrch('-')
   FOR j = i - 1 TO 0 BY -1 DO wrch(t!j + '0')
$)
 
LET readnumber(radix) = VALOF
$( LET sum, neg_, sign = 0, FALSE, +1
 
   $( terminator := rdch()
      SWITCHON terminator INTO
      $( CASE '-' : neg_ := TRUE
         CASE '+' : terminator := rdch()
         DEFAULT  : BREAK
         CASE '*S':
         CASE '*T':
         CASE '*C':
         CASE '*N':
         CASE '*P':
      $)
   $) REPEAT
 
   $( LET c = '0' LE terminator LE '9' -> terminator - '0',
              'a' LE terminator LE 'z' -> terminator - 'a' + 10,
              'A' LE terminator LE 'Z' -> terminator - 'A' + 10,
                                          100
      IF c GE radix RESULTIS sum
      sum := sum*radix + c*sign
      IF neg_ & sum NE 0 THEN
      $( sum := -sum
         sign := -1
         neg_ := FALSE
      $)
      terminator := rdch()
   $) REPEAT
$)
 
AND writef(format, a, b, c, d, e, f, g, h, i, j, k) BE
$( LET t = @a
 
   FOR p = 1 TO format%0 DO
   $( LET k = format%p
 
      TEST k = '%' THEN
      $( LET q, n = !t, 0
         AND type = format%(p + 1)
         AND f = ?
 
         p := p + 1
         SWITCHON type INTO
         $( DEFAULT  :  wrch(type); ENDCASE
 
            CASE 's' :
            CASE 'S' :  f := writes;   GOTO l
            CASE 'c' :
            CASE 'C' :  f := wrch;     GOTO l
            CASE 'o' :
            CASE 'O' :  f := writeoct; GOTO m
            CASE 'x' :
            CASE 'X' :  f := writehex; GOTO m
            CASE 'i' :
            CASE 'I' :  f := writed;   GOTO m
            CASE 'n' :
            CASE 'N' :  f := writed;   GOTO l
                   m :  p := p + 1
                        n := format%p
                        IF 'a' LE n LE 'z' THEN n := n - 'a' + 'A'
                        n := '0' LE n LE '9' -> n - '0', n - 'A' + 10
                   l :  f(q, n)
            CASE '$' :  t := t + 1
         $)
      $)
      OR wrch(k)
   $)
$)
 
/*
AND writeoct(n, p) BE
$( IF p > 1 THEN writeoct(n >> 3, p - 1)
   wrch((n & #7) + '0')
$)
 
AND writehex(n, p) BE
$( LET m = n &#17
   IF p > 1 THEN writehex(n >> 4, p - 1)
   wrch(m + (m < 10 -> '0', 'A' - 10))
$)
 
AND writes(s) BE FOR i = 1 to s%0 DO wrch(s%i)
 
AND writeo(n) BE writeoct(n, 11)
 
AND writeh(n) BE writehex(n, 8)
 
AND writen(n) BE writed(n, 0)
 
AND newline() BE wrch('*N')
 
AND newpage() BE wrch('*P')
 
AND readn() = readnumber(10)
 
AND packstring(v, s) = VALOF
$( LET last_word = !v/bytesperword
 
   s!last_word := 0
   FOR i = 0 to !v DO s%i := v!i
   RESULTIS last_word
$)
 
AND unpackstring(s, v) BE
   FOR i = 0 TO s%0 DO v!i := s%i
*/
 
 .
 
GET "LIBHDR"
 
// Debugging and store allocation routines
 
MANIFEST $(
unassigned    = #x81818181           // 'Unassigned variable' pattern
$)
 
MANIFEST $(
sv.size            = 80              // Size of system vector
sv.base            = -sv.size        // Global offset of base of system vector
$)
 
MANIFEST $(   // Opcodes in compiled program
jlk.call           = #x1d940000      // JLK for standard routine call
jlk.trace          = #x1d940039      // JLK for call to trace routine (alter if 'svtrentry' is moved)
lss.instruction    = #x63800000      // Standard LSS opcode (long form)
lb.b.instruction   = #x7b9c0000      // Dummy instruction marking profile code
lb.count           = #x7b940000      // Instruction loading profile count
$)
 
GLOBAL $(   // Items in system vector
svsstbase          : sv.base+03      // Base of shared symbol table (byte address)
svwrch             : sv.base+21      // Secret copy of 'wrch'
low_code           : sv.base+24      // Lower bound of code area (byte address)
high_code          : sv.base+25      // Upper bound of code area (byte address)
tracebuffersize    : sv.base+26      // Size of trace buffer (in words)
sverrflag_         : sv.base+27      // TRUE iff handling contingency
svlibcodeend       : sv.base+28      // Upper bound of library code
svjournal          : sv.base+31      // Stream pointer for terminal/job journal stream
tracebuf           : sv.base+49      // Byte address of trace buffer
svstatchain        : sv.base+51      // Head of STATIC name chain
svdrtop            : sv.base+55      // Upper half of program link
tracepointer       : sv.base+56      // Trace buffer pointer (offset)
svtrentry          : sv.base+57      // Trace entry point
svctbword          : sv.base+62      // Word address of system vector
svlibcode          : sv.base+64      // Lower bound of library code (byte address)
svsstword          : sv.base+65      // Word address of SST
svgvsupport        : sv.base+68      // Entry to 'getvec' support code
$)
 
MANIFEST $(   // Types of internally generated 'abort' calls
ab.unassigned   =  -1   // Use of unassigned variable
$)
 
MANIFEST $(
quantum      = 32*1024   // In words
sizebits     = #xfffffffe
freebit      = 1
$)

STATIC $( blklist = ?; user_wrch = ? $)
 
LET contingency(class, subclass, dumpseg) BE
$( LET v1 = VEC 2
   AND v2 = VEC 2
   AND dummy = ?
   AND special = FALSE
   AND mes = "Program failure"
   AND obey = b_uinfi(2) = 3
 
   discard.id()   // Re-allow interrupts

   TEST wrch = svwrch THEN user_wrch := 0
   OR
   $( user_wrch := wrch
      wrch := svwrch                    // Ensure we get diagnostic output
   $)

   IF class = 65 THEN    // Breakin contingency
   $( selectoutput(journal)
 
      console(7, @dummy, @dummy)   // Kill output
 
      IF subclass = 'C' \/ subclass = 'c' THEN
         console(8, @dummy, @dummy)   // Kill input
 
      IF obey THEN endobey()   // Scan to end of OBEY file

      TEST subclass = 'Q' \/ subclass = 'q' THEN
      $( special := TRUE
         mes := "Termination requested"
      $)
      OR
      $( writes("Breakin - exit*N")
         stop(-1)
      $)
   $)
 
   IF class = 64 THEN   // Run out of time
   $( special := TRUE
      mes := "CPU time exceeded"
   $)

   sverrflag_ := TRUE
 
   selectoutput(sysout)
 
   writef("*N*N%S on %S at %S*N", mes, date(v1), timeofday(v2))

   UNLESS special DO
   $( writef("*NContingency class %N, subclass X%X8*N*N", class, subclass)
      mapregs(dumpseg)
      IF dumpseg!2 = 0 THEN   // Jump to zero
         find_cause(dumpseg!16)
   $)
 
   backtrace()
 
   postmortem(dumpseg!0 >> 2, dumpseg!4 >> 2, dumpseg!1, dumpseg!2)   // LNB and SF (as word addresses), PSR, PC
 
   mapglobals(1, globalsize)
 
   mapstatics()
 
   UNLESS special DO
      mapcode(dumpseg!2 NE 0 -> dumpseg!2, dumpseg!16)
 
   mapstore()
 
   UNLESS userpostmortem = 0 DO userpostmortem(0)
 
   stop(-1)
$)
 
AND backtrace() BE
$( LET trb = tracebuf >> 2   // Derive word address
   LET trp = tracepointer + trb   // Absolute pointer
   LET otrp = trp   // Copy
   AND trmk = 0
   AND linesize = ?
   LET cols_left = ?
 
   IF tracebuf = 0 RETURN   // No trace buffer present
   FOR i = 0 TO tracebuffersize - 1 DO
      trmk := trmk LOGOR trb!i   // See if there's anything traced
   IF trmk = 0 RETURN   // No - give up
 
   /* Tracing is turned off by the simple expedient of reducing the
      trace entry point by two; the trace routine is preceded by five
      return instructions, so this may be done five times in safety.
      (note that 'abort' does this as well, so that the 'writef', etc. at
      the start of 'abort' do not get traced)
   */
 
   UNLESS sverrflag_ DO svtrentry := svtrentry - 2   // Turn off tracing unless called from CONTINGENCY
 
   linesize := output_width(72, 132, 132)
   cols_left := linesize
 
   writes("*N*NFunction trace:*N*N")
 
   $( trp := trp - 1   // Move to next item
      IF trp < trb THEN trp := trp + tracebuffersize   // Wrap around
      IF !trp = 0 LOOP   // Empty entry
      IF !trp < 0 LOOP   // Ignore negative entries pro tem
      $( LET pt = !trp + svsstword   // Relocate pointer
         LET size = pt%0 + 8   // Length of string plus the arrow
         IF size > linesize THEN size := linesize   // Do the best we can
         IF size > cols_left THEN
         $( newline()
            cols_left := linesize
         $)
         write_function_name(pt, 1, size)
         writes("   <-   ")
         cols_left := cols_left - size
      $)
   $) REPEATUNTIL trp = otrp   // Gone all the way round
 
   newline(); newline()
 
   UNLESS sverrflag_ DO svtrentry := svtrentry + 2   // Restore tracing if necessary
$)
 
AND postmortem(lnb, sf, psr, pc) BE    // LNB and SF are word addresses
$( UNLESS sverrflag_ DO
   $( lnb := level() >> 2
      sf := lnb + 2   // Pretend POSTMORTEM has no locals
      psr := svdrtop
      pc := postmortem   // As good a value as any
   $)
 
   $( LET stack_seg_no = ?
      AND progacr = (svdrtop >> 20) & #xf
      AND items_per_line = output_width(6, 11, 11)
      AND no_online = ?
      AND max = output_width(40, 100, 100)
      AND atsf = @sf
 
      writes("*N*NPostmortem of the stack:*N")
 
      UNLESS ((psr >> 20) & #xf) GE progacr DO   // PSR at failure
      $( LET link_pc = ?

         writes("*N<System call in progress> called from*N")

         UNTIL (((lnb!1 >> 20) & #xf) GE progacr) \/ (lnb LE (stackbase >> 2)) DO   // Out from Supervisor/Director
         $( sf := lnb
            link_pc := lnb!2
            lnb := lnb!0 >> 2
         $)
         UNTIL in_library(link_pc) \/ in_program(link_pc) \/ (lnb LE (stackbase >> 2)) DO   // Out from Subsystem, etc.
         $( sf := lnb
            link_pc := lnb!2
            lnb := lnb!0 >> 2
         $)
      $)
 
      stack_seg_no := lnb >> 16
 
      /* Failures in the machine code 'getbyte' and 'putbyte' are fairly frequent;
         unfortunately, these routines use a non-standard entry sequence in
         order to speed them up. They are thus treated as special cases here;
         a failure in a routine in the machine code library, which has not
         executed the full entry sequence (and thus has SF pointing 62 words
         above LNB) is taken to be a failure in 'getbyte' or 'putbyte'; the full
         entry sequence is 'completed', in simulation, in the variables SF and
         LNB; the postmortem then proceeds normally.
      */
 
      IF (sf - lnb = 62) & in_library(pc) THEN
      $( lnb!0, lnb!1 := lnb!60, lnb!61
         sf := sf - 58   // Assume that two parameters are present
         IF address_from_link(lnb) = putbyte THEN
            sf := sf + 1   // PUTBYTE actually has 3 parameters
      $)
 
      WHILE lnb GE (stackbase >> 2) DO
      $( IF (lnb >> 16) NE stack_seg_no THEN   // Not in local stack segment
         $( writes("Stack is irretrievably corrupt*N")
            RETURN
         $)
         writes("*NFunction <")
         write_function_name(name_from_link(lnb, atsf), 1, max)
         writef("> with %S", sf LE lnb + 2 -> "no locals", "locals:-")
         no_online := 0
 
         FOR i = 2 TO sf - lnb - 1 DO
         $( IF no_online = 0 THEN
            $( no_online := items_per_line
               newline()
            $)
            IF i > 21 DO   // Only print up to first 20 locals
            $( writes(". . . .")
               BREAK
            $)
            no_online := no_online - 1
            write_value(lnb!i)
         $)
         writef("*Ncalled from location X%X8 in*N", lnb!0)
         sf := lnb
         lnb := lnb!1 >> 2
      $)
      writes("*NEntry sequence*N*N")
   $)
$)
 
AND mapglobals(first, last) BE
$( LET atstart  = @start - 1
 
   writef("*N*NValues set in GLOBAL vector, from %N to %N:*N", first, last)
 
   $( LET items_per_line = output_width(4, 7, 7)
      AND no_online = 0
 
      FOR i = first TO last DO
      $( LET value = atstart!i
 
         IF i = (@wrch-@start+1) & user_wrch NE 0 THEN
            value := user_wrch

         UNLESS value = 0 DO
         $( IF no_online = 0 THEN
            $( no_online := items_per_line
               newline()
            $)
            no_online := no_online - 1
 
            writef("G%I3,", i)
            write_value(value)
         $)
      $)
   $)
   newline(); newline()
$)
 
AND mapstatics() BE
$( IF svstatchain = -1 RETURN   // Program compiled without any STATIC names
 
   $( LET items_per_line = output_width(2, 4, 4)
      AND no_online = 0
      AND chain = svsstword!svstatchain   // Word offset in SST of first STATIC name
      AND size = ?
      AND name = ?
 
      UNLESS chain = 0 DO
         writef("*N*NValues of STATIC variables:*N")
 
      UNTIL chain = 0 DO
      $( IF no_online = 0 THEN
         $( no_online := items_per_line
            newline()
         $)
         no_online := no_online - 1
 
         chain := chain + svsstword   // Get address of next STATIC name
         name := chain + 1
         size := name%0/bytesperword + 1   // Size of name entry
 
         write_function_name(name, 16, 16)
         wrch('=')
         write_value(svctbword!(chain!(size + 1)))
         UNLESS no_online = 0 DO writes("    ")
 
         chain := !chain
      $)
   $)
   newline(); newline()
$)
 
AND mapregs(dumpseg) BE
$( writes("Machine registers:*N")
   FOR i = 0 TO 17 DO
   $( LET s = VALOF SWITCHON i INTO
      $( CASE 00:  RESULTIS "LNB"
         CASE 01:  RESULTIS "PSR"
         CASE 02:  RESULTIS "PC"
         CASE 03:  RESULTIS "SSR"
         CASE 04:  RESULTIS "SF"
         CASE 05:  RESULTIS "IT"
         CASE 06:  RESULTIS "IC"
         CASE 07:  RESULTIS "CTB"
         CASE 08:  RESULTIS "XNB"
         CASE 09:  RESULTIS "B"
         CASE 10:  RESULTIS "DR"
         CASE 11:  RESULTIS 0
         CASE 12:  RESULTIS "ACC"
         CASE 13:
         CASE 14:
         CASE 15:  RESULTIS 0
         CASE 16:  RESULTIS "FPC"
         CASE 17:  RESULTIS "IMP"
      $)
 
      UNLESS s = 0 DO writef("*N*T%S*T", s)
      writef("%X8*S*S", dumpseg!i)
   $)
   newline(); newline()
$)

AND find_cause(fpc) BE
$( LET x = validate((fpc & #xfffffffc) >> 2, 4)

   UNLESS 0 LE x LE 1 RETURN   // Failing PC is invalid

   x := getword(fpc, 0)
   IF x = 0 RETURN   // Failing PC outside code area

   UNLESS (x & #xfffc0000) = jlk.call RETURN   // Failed to find routine call

   x := (x & #x3ffff) - sv.size   // Number of global being called
   IF x < 0 RETURN   // Call to trace support or similar

   writes("*N*NPossibly caused by jump to ")
   TEST x LE globalsize THEN
      writef("undefined global number %N*N*N", x)
   OR
      writes("corrupt routine entry point, label or STATIC*N*N")
$)
 
AND mapcode(pc) BE
$( LET p = pc >> 2   // Failing PC as a word address
 
   writes("*N*NDump of surrounding code:*N*N")
 
   FOR i = p - 6 TO p + 6 DO
   $( LET mark = (i = p) -> "********", "    "
 
      SWITCHON validate(i, 4) INTO
      $( CASE 0:
         CASE 1:
            writef("%X8:    %S  %X8  %S*N", i << 2, mark, !i, mark)
            ENDCASE
         DEFAULT:
            writef("%X8 is not a valid address*N", i << 2)
      $)
   $)
   newline(); newline()
$)
 
AND write_value(value) BE
$( TEST low_code LE value LE high_code THEN   // Address in program code
   $( TEST is_function(value) THEN
      $( LET name = name_from_entry_point(value)
         TEST name = 0 THEN writef("*S%X8***S*S", value)
         OR
         $( wrch('*S')
            write_function_name(name, 8, 8)
            writes("*S*S*S")
         $)
      $)
      OR
         writef("*S%X8***S*S", value)   // Probably a label
   $)
   OR
   $( TEST in_library(value) THEN       // Address in library code
         writef("*S%X8*****S", value)   // Probably a routine in machine code library
      OR
         writef("*S%X8*S*S*S", value)   // Some other value
   $)
$)
 
AND mapstore() BE
$( LET max = output_width(62, 122, 122)
 
   IF svstatchain = -1 RETURN   // Program compiled without any names
 
   writes("*N*NMap of program code area:*N*N")
 
   TEST profile THEN
   $( LET factor = output_width(49, 109, 109)
      AND hwcount = VALOF
      $( LET h = 0
         FOR ca = low_code TO high_code - 8 BY 2 DO
         $( LET n = getword(ca, 0)
 
            IF (n & #xffff0000) = lb.b.instruction THEN
            $( n := getword(ca, 2)
               IF (n & #xfffc0000) = lb.count THEN
               $( LET c = svctbword!(n & #x0003ffff)
                  IF h < c THEN h := c
               $)
            $)
         $)
         RESULTIS h
      $)
 
      FOR ca = low_code TO high_code - 8 BY 2 DO
      $( IF is_function(ca) THEN
         $( LET name = name_from_entry_point(ca)
            IF name = 0 LOOP
            writef("*N%X8*S*S", ca)
            write_function_name(name, 1, max)
            newline()
            LOOP
         $)
 
         $( LET n = getword(ca, 0)
            IF (n & #xffff0000) = lb.b.instruction THEN
            $( n := getword(ca, 2)
               IF (n & #xfffc0000) = lb.count THEN
               $( LET c = svctbword!(n & #x0003ffff)
                  writef("%X8*S%IB*S|*S", ca, c)
                  FOR i = 1 TO c*factor/hwcount DO wrch('**')
                  newline()
               $)
            $)
         $)
      $)
   $)
   OR
   $( FOR ca = low_code TO high_code - 8 BY 2 DO   // Scan the code area
         IF is_function(ca) THEN
         $( LET name = name_from_entry_point(ca)
            IF name = 0 LOOP
            writef("%X8  ", ca)
            write_function_name(name, 1, max)
            newline()
         $)
      newline()
   $)
   newline()
$)
 
AND abort(n) BE
$( LET v1 = VEC 2
   AND v2 = VEC 2
   AND mes = ?
 
   svtrentry := svtrentry - 2   // Turn off tracing
 
   SWITCHON n INTO
   $( CASE ab.unassigned:
         mes := "*NUnassigned variable"
         ENDCASE
 
      DEFAULT:
         mes := "*NBCPL Abort - User code = %N"
         ENDCASE
   $)
   writef(mes, n)
   writef(", on %S at %S*N", date(v1), timeofday(v2))
 
   backtrace()
   postmortem()   // Need no params since SVERRFLAG is FALSE
   mapglobals(1, globalsize)
   mapstatics()
   mapstore()
   UNLESS userpostmortem = 0 DO userpostmortem(n)
 
   IF n NE 0 THEN stop(n)
 
   svtrentry := svtrentry + 2   // Restore tracing
$)
 
AND write_function_name(address, min, max) BE
$( LET l = address%0
   LET j = (l < max) -> l, max
 
   FOR i = 1 TO j DO wrch(address%i)
   FOR i = j + 1 TO min DO wrch('*S')
$)
 
AND name_from_link(atlink, atsf) = VALOF
$( LET entry_point = address_from_link(atlink)
   LET name = ?
 
   // Check for special cases in machine code library
 
   IF entry_point = getbyte RESULTIS "GETBYTE"
   IF entry_point = putbyte RESULTIS "PUTBYTE"
   IF entry_point = move THEN
   $( !atsf := !atsf - 2   // Hide private locals
      RESULTIS "MOVE"
   $)
   IF entry_point = translate RESULTIS "TRANSLATE"
   IF entry_point = aptovec THEN
   $( !atsf := !atsf - 5   // Hide private locals of APTOVEC
      RESULTIS "APTOVEC"
   $)
 
 
   name := entry_point = 0 -> 0, name_from_entry_point(entry_point)
   RESULTIS name = 0 -> "????????", name
$)
 
AND address_from_link(atlink) = VALOF
$( LET call_instruction = getword(!atlink, -4)
 
   /* Check for a call to global 0; this occurs in a call from the code
      of APTOVEC in the machine code library. In this case, the routine
      address is obtained from the first parameter to APTOVEC, at its
      LNB + 2.
   */
 
   IF call_instruction = (jlk.call + sv.size) THEN   // Call to global 0
   $( LET oldlnb = atlink!1 >> 2
      RESULTIS oldlnb!2
   $)
 
   UNLESS (call_instruction & #xfffc0000) = jlk.call RESULTIS 0
   RESULTIS !((call_instruction & #x0003ffff) + svctbword)
$)
 
AND name_from_entry_point(ep) = VALOF
$( LET tracecall = ?
 
   tracecall := getword(ep, 4)
 
   UNLESS tracecall = jlk.trace RESULTIS 0
   $( LET nameload = getword(ep, 0)
 
      UNLESS (nameload & #xff800000) = lss.instruction RESULTIS 0
      RESULTIS (nameload & #x007fffff) + (svsstbase >> 2)
   $)
$)
 
AND is_function(address) = VALOF
$( LET tracecall = getword(address, 4)
   RESULTIS tracecall = jlk.trace
$)
 
AND getword(address, offset) = VALOF
$( LET a = address + offset
 
   UNLESS (low_code LE a LE high_code) \/ in_library(a) RESULTIS 0   // Not in code area
 
   RESULTIS (0%a       << 24) +
            (0%(a + 1) << 16) +
            (0%(a + 2) << 08) +
            (0%(a + 3))
$)
 
AND in_library(addr) = svlibcode LE addr LE svlibcodeend

AND in_program(addr) = low_code LE addr LE high_code
 
AND output_width(fjob, bjob, file) = VALOF
$( LET out = output()
   AND itwidth = b_uinfi(15)
 
   IF itwidth GE 132 THEN fjob := bjob
   RESULTIS getconad(out) > 0 -> file, foreground -> fjob, bjob
$)

AND b_uinfi(n) = VALOF
$( EXTERNAL $( uinfi $)
   RESULTIS uinfi(n)
$)
 
AND getvec(n) = VALOF   // Called once only - then redirected to getblk
$( LET p = svgvsupport(0)   // Create workfile

   IF p < 0 RESULTIS 0
   p := (p >> 2) + 1   // Convert to BCPL address - ignore first word to preserve even size
   blklist, p!0, p!(quantum - 2) := p, (quantum - 2) \/ freebit, 0
   getvec := getblk   // The real space allocation routine
   RESULTIS getvec(n)
$)

AND getblk(n) = VALOF   // The real 'getvec'
$( LET p, q = 0, blklist

   n := n + 2   // Allow for secret word and zeroth word

   n := (n + 1) & sizebits   // Round to multiple of 2

   $( p := q

      // Chain through used blocks, looking for an unused one

      WHILE (!p & freebit) = 0 DO
      $( TEST !p = 0 THEN   // No space left - try to get more
         $( LET x = svgvsupport(1)   // Extend file

            IF x < 0 RESULTIS 0
            !p := quantum \/ freebit
            p!quantum := 0
            RESULTIS getvec(n - 2)
         $)
         OR
            p := p + !p
      $)

      q := p   // Chain to the end of this free area
      UNTIL (!q & freebit) = 0 DO
         q := q + (!q & NOT freebit)
   $) REPEATUNTIL q - p GE n   // Exit if large enough block found

   // Split block unless it is an exact fit

   UNLESS p + n = q DO
      p!n := (q - p - n) \/ freebit

   !p := n

   RESULTIS p + 1   // Return pointer, avoiding secret word
$)

AND freevec(p) BE
$( p := p - 1   // Point to true start of block

   !p := !p \/ freebit
$)

// End of file OLIBTSRC

